/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

/*
This class defines the "communication binder" object.
It is part of the skeleton client code.
It exchanges messages between the client and other server kernels.
It is controlled exclusively by BrokerInterface (see brokeriface.h).
The only binding implemented at this moment is the "thisInstace"
loopback, therefore there is no authentication and handshake protocol.
*/

#ifndef __CommBinder__
#define __CommBinder__

#include <accounts.h>
#include <qstring.h>
#include <qcstring.h>
#include <qobject.h>
#include <commframe.h>
#include <qstring.h>

class CommBinder : public QObject
{
	Q_OBJECT
	public:
		// builds the communication binder object
		CommBinder();
		
		// deletes the communication binder object; all active connections are closed
		~CommBinder();
	
		static CommBinder *thisInstance();
	
		// comm method, request-reply (with frame exchange); false indicates comm failure
		bool send(QString binding, CommFrame &inFrame, CommFrame &outFrame);
				
		// comm method, request-only (no frame exchange); false indicates comm failure
		bool send(QString binding, CommFrame &inFrame);
		
		// comm method, request-only (no frame exchange)
		void receive(CommFrame &inFrame);
		
		void receive(CommFrame &inFrame, CommFrame &outFrame);
		
		// error handling
		QString lastError();
		
		// connection handling (active only on loopback at this moment)
		bool connect(QString binding);
		bool disconnect(QString binding);
		bool connected(QString binding);
		QStringList activeConnections();
	signals:
		void messageReceived(CommFrame &);
	private:
		void initLoopback();
		bool socketSend(QString binding, CommFrame &inFrame, CommFrame &outFrame);
		bool socketSend(QString binding, CommFrame &inFrame);	
		bool callSend(CommFrame &inFrame, CommFrame &outFrame);
		bool callSend(CommFrame &inFrame);
			
		QString err;
		Q_UINT64 lastSeqTag, lastTransactionTag;
};

#endif
