/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */
 
#include <vobject.h>
#include <qstring.h>
#include <qcstring.h>
#include <brokeriface.h>
#include <vfolder.h>
#include <templateview.h>
#include <qstringlist.h>
#include <qlist.h>
#include <clientvfs.h>
#include <vreference.h>

VObject::VObject(QString _path):VReference()
{
	int k=_path.findRev("/");
	if(k>-1) _id=_path.mid(k+1);
	else _id=_path;

	local=0;
	autoDelLocal=true;
	
	_folder=ClientVFS::thisInstance()->folderRef(_path.left(_path.findRev("/")));
	if(_folder)
		_folder->addObject(this);
}

VObject::VObject(QString _path, QByteArray &_data):VReference()
{
	int k=_path.findRev("/");
	if(k>-1) _id=_path.mid(k+1);
	else _id=_path;

	local=0;
	autoDelLocal=true;
	
	_folder=ClientVFS::thisInstance()->folderRef(_path.left(_path.findRev("/")));
	if(_folder)
		_folder->addObject(this);
}

VObject::~VObject()
{
	if(local && autoDelLocal)
		delete local;
	if(_folder)
		_folder->removeObjectRef(this);
}

QString VObject::name()
{
	return _id;
}

QString VObject::path()
{
	if(_folder) return _folder->path()+"/"+_id;
	else return _id;
}

QString VObject::url()
{
	return type()+":/"+path();
}

QString VObject::type()
{
	if(_folder)
		return _folder->type();
	return QString("unknown");
}

QString VObject::serverPath()
{
	if(_folder)
		return _folder->serverPath()+"/"+_id;
	return QString::null;
}

QString VObject::binding()
{
	if(_folder)
		return _folder->binding();
	return QString::null;
}

QByteArray VObject::data()
{
	QByteArray tdata;
	QString _path=path();
	if(!_path.isNull())
	{
		bool res=BrokerInterface::thisInstance()->getObjectData(_path, tdata);
		
		if(!res)
		{
			printf("vobject: getData failed, reason given by server: %s\n", (const char *)BrokerInterface::thisInstance()->regetLastError());
		}		
	}
	return tdata;
}

bool VObject::setData(const QByteArray &newData)
{
	bool res=false;
	QString _path=path();
	
	if(!_path.isNull())
	{
		// temporary
		res=BrokerInterface::thisInstance()->setObjectData(_path, newData);
		
		if(!res)
		{
			printf("vobject: setData failed, reason given by server: %s\n", (const char *)BrokerInterface::thisInstance()->regetLastError());
		}
	}
	
	return res;
}

void VObject::setLocalImpl(void *obj)
{
	local=obj;
}

void *VObject::localImpl()
{
	return local;
}

void VObject::autoDeleteLocal(bool mode)
{
	autoDelLocal=mode;
}

VFolder *VObject::parentFolder()
{
	return _folder;
}

QString VObject::parentObject()
{
	return BrokerInterface::thisInstance()->parent(path());
}

bool VObject::setParentObject(QString parentObj)
{
	return BrokerInterface::thisInstance()->setParent(path(), parentObj);
}

QStringList VObject::relatedList()
{
	return BrokerInterface::thisInstance()->related(path());
}

bool VObject::setRelatedList(QStringList rList)
{
	return BrokerInterface::thisInstance()->setRelated(path(), rList);
}

QByteArray VObject::_stream()
{
	return QByteArray();
}

void VObject::_narrow(const QByteArray &)
{
}

bool VObject::save()
{
	return setData(_stream());
}

bool VObject::sync()
{
	_narrow(data());
	
	// here we should check the BrokerInterface for errors
	
	return true;
}

bool VObject::getProperty(QString query, Any &property)
{
	return false;
}

bool VObject::setProperty(QString query, Any &property)
{
	return false;
}

QueryProcessor::QueryType VObject::queryType(QString query)
{
	return QueryProcessor::InvalidQuery;
}

