/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <mailbox.h>
#include <qfile.h>
#include <qtextstream.h>

MailBox::MailBox(bool indexed_mode):QObject()
{
  messages=0;
  separator="From ";
  mode=indexed_mode;
}

MailBox::~MailBox()
{
}

void MailBox::setSeparator(QCString separator_string)
{
  separator=separator_string;
}

int MailBox::connect(QCString filename, bool del)
{
  QFile mbox(filename);
  
  printf("Getting mailbox size..\n");
  
  // if the mailbox size is 0 we have no messages to read
  if(mbox.size()==0)
  {
    printf("Empty mailbox!\n");
    return 0;
  }
  
  // open mailbox
  mbox.open(IO_ReadOnly);
  int newp, p=0; //percent completed
  
  if(!mbox.isOpen())
  {
    printf("Failed to open mailbox.\n");
    status=-1;
    return -1;
  }
  
  // parse mailbox
  QCString line, msg;
  QTextStream text(&mbox);

  if(mode)
  {  
    while(!text.atEnd())
    {
      line=(const char *)text.readLine();

      if((newp=mbox.at()*100/mbox.size())!=p)
      {
        p=newp;
        emit(percentCompleted(p));
      }

      if(line.left(separator.length())==separator)
      {
        if(!msg.isEmpty())
        {
          msglist.append(msg);
          messages++;
          emit(messagesFound(messages));
          msg.truncate(0);
        }
      }
      else
        msg+=line;
        msg+='\n';
    }
    if(!msg.isEmpty())
    {
      msglist.append(msg);
      messages++;
      emit(messagesFound(messages));
    }
  }
  else
  {
    while(!text.atEnd())
    {
      line=(const char *)text.readLine();

      if((newp=mbox.at()*100/mbox.size())!=p)
      {
        p=newp;
        emit(percentCompleted(p));
      }

      if(line.left(separator.length())==separator)
      {
        if(!msg.isEmpty())
        {
          emit(dataAvailable(msg));
          msg.truncate(0);
        }
      }
      else
        msg+=line;
        msg+='\n';
    }
    if(!msg.isEmpty())
    {
      emit(dataAvailable(msg));
    }
  }
  
  mbox.close(); 
  
  if(del) 
  {
    bool e=mbox.open(IO_Truncate);
    mbox.close();
    if(e) 
    {
      status=-1;
      return -1;
    }
  }
  status=0;
  return messages;
}

QCString MailBox::operator[](int i)
{
  if(i<0||i>messages) return 0;
  return msglist.at(i);
}

int MailBox::count()
{
  return messages;
}

int MailBox::error()
{
  return status;
}




