/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/** Changed by Eugen C. <eug@thekompany.com> - 05 July 2001 */

#include <stdio.h>
#include <stdlib.h>
#include <setupwizard.h>
#include <videotoolbox.h>
#include <definedmessages.h>

#define DEBUG_SETUP

extern VideoToolBox vtb;

extern bool processScript(QWidget *parent, QStringList &script);

SetupWizardDialog::SetupWizardDialog(QWidget *parent, const char *name):
	QMainWindow(parent,name, WType_Modal | WStyle_Dialog | WStyle_StaysOnTop)
{
	vtb.centerWindow(this);
	QFont font("Helvetica",12, QFont::Normal);
	font.setPixelSize(12);
	setFont(font);
	
	// set up the titles :)
	titles.append("Welcome");
	titles.append("License Agreement");
	titles.append("Choose Directory");
	titles.append("Existent Directory");
	titles.append("Personal Information");
	titles.append("Mail Options");
	titles.append("Local Mail");
	titles.append("POP3 Mail");
	titles.append("IMAP Mail");
	titles.append("SMTP Details");
	titles.append("Plug In Support");
	titles.append("Setup Summary");
	titles.append("Congratulations");
	titles.append("Cancelled");
	// setup the picture
	vtb.setUpFonts(QFont("helvetica", 18, QFont::Bold));
	int dx, dy;
	dx=dy=10;
	setFixedSize(90+20+500, 300+20);
	setCaption(name);
	picture=vtb.setUpLabelBgPixmap(this, "","logo", 90, 300, &dx, &dy);
	dx+=90;
	top=vtb.setUpLabelBgPixmap(this, titles[0], "blue-degradee", width()-dx-10, vtb.fontHeight()-4,	&dx, &dy);
	dx=105;
	dy+=vtb.fontHeight()+vtb.offsetY();
	vtb.setUpFonts(QFont("helvetica", 12, QFont::Bold));
	int h=height()-dy-10;
	int w=width()-10-105;
	frames=new QWidgetStack(this);
	frames->setGeometry(105, dy, w, h);
	f1=new WelcomeFrame(frames,			 "f1", 0, 0, frames->width(), frames->height(), 0);
	f2=new LicenseFrame(frames,			 "f2", 0, 0, frames->width(), frames->height(), 1);
	f3=new ChooseDirFrame(frames,		 "f3", 0, 0, frames->width(), frames->height(), 2);
	f4=new ExistsFrame(frames,			 "f4", 0, 0, frames->width(), frames->height(), 3);
	f5=new IdentityFrame(frames,		 "f4", 0, 0, frames->width(), frames->height(), 4);
	f6=new MailOptionsFrame(frames,	 "f6", 0, 0, frames->width(), frames->height(), 5);
	f7=new LocalMailFrame(frames,		 "f7", 0, 0, frames->width(), frames->height(), 6);
	f8=new Pop3MailFrame(frames,		 "f8", 0, 0, frames->width(), frames->height(), 7);
	f9=new IMAPMailFrame(frames,		 "f8", 0, 0, frames->width(), frames->height(), 8);
	f10=new SMTPFrame(frames,				"f10", 0, 0, frames->width(), frames->height(), 9);
	f11=new PlugInFrame(frames,	  	"f11", 0, 0, frames->width(), frames->height(),10);
	f12=new SummaryFrame(frames,		"f12", 0, 0, frames->width(), frames->height(),11);
	f13=new CongratsFrame(frames,		"f13", 0, 0, frames->width(), frames->height(),12);
	f14=new TooBadFrame(frames,			"f14", 0, 0, frames->width(), frames->height(),13);
	frames->addWidget(f1,0);
	frames->addWidget(f2,1);
	frames->addWidget(f3,2);
	frames->addWidget(f4,3);
	frames->addWidget(f5,4);
	frames->addWidget(f6,5);
	frames->addWidget(f7,6);
	frames->addWidget(f8,7);
	frames->addWidget(f9,8);
	frames->addWidget(f10,9);
	frames->addWidget(f11,10);
	frames->addWidget(f12,11);
	frames->addWidget(f13,12);
	frames->addWidget(f14,13);
	frames->raiseWidget(0);
	connect(f1, SIGNAL(result(int,int,QStringList)),
		this, SLOT(processor(int,int,QStringList)));
	connect(f2, SIGNAL(result(int,int,QStringList)),
		this, SLOT(processor(int,int,QStringList)));
	connect(f3, SIGNAL(result(int,int,QStringList)),
		this, SLOT(processor(int,int,QStringList)));
	connect(f4, SIGNAL(result(int,int,QStringList)),
		this, SLOT(processor(int,int,QStringList)));
	connect(f5, SIGNAL(result(int,int,QStringList)),
		this, SLOT(processor(int,int,QStringList)));
	connect(f6, SIGNAL(result(int,int,QStringList)),
		this, SLOT(processor(int,int,QStringList)));
	connect(f7, SIGNAL(result(int,int,QStringList)),
		this, SLOT(processor(int,int,QStringList)));
	connect(f8, SIGNAL(result(int,int,QStringList)),
		this, SLOT(processor(int,int,QStringList)));
	connect(f9, SIGNAL(result(int,int,QStringList)),
		this, SLOT(processor(int,int,QStringList)));
	connect(f10, SIGNAL(result(int,int,QStringList)),
		this, SLOT(processor(int,int,QStringList)));
	connect(f11, SIGNAL(result(int,int,QStringList)),
		this, SLOT(processor(int,int,QStringList)));
	connect(f12, SIGNAL(result(int,int,QStringList)),
		this, SLOT(processor(int,int,QStringList)));
	connect(f14, SIGNAL(result(int,int,QStringList)),
		this, SLOT(processor(int,int,QStringList)));
}	

void SetupWizardDialog::processor(int message, int frameNo, QStringList group)
{
#ifdef DEBUG_SETUP
	printf(" Frame: %d\n",frameNo);
#endif
	switch(message)
	{
		case CancelMessage:
			printf(" Mess canceled: %d\n", frameNo);
			if(frameNo!=13)
			{
				top->setText(titles[13]);
				frames->raiseWidget(13);
			}
			else
			{
				fprintf(stderr,"\n\nSetup cancelled by user.\n\n");
				exit(0);
			}
			break;
		case ContinueMessage:
			script+=group;
			stack.append(frameNo);
			switch (frameNo)
			{
				case 1:
					// This is license frame....
					if(group[group.count()-1].find("No")!=-1)
						frameNo=13;
					else
						frameNo++;
					break;
				case 2:
					// Check for "exists=yes" in script
					// if "No" then just skip the next frame and jump to the identity
					if(group[group.count()-1].find("No")!=-1)
						frameNo++;
					frameNo++;
					break;
					// Laur, we actually need the whole configuration even if the directories already exists
// 				case 3:
// 					if(group[group.count()-1].find("Yes")!=-1)
// 						frameNo=9;
// 					else
// 						frameNo++;
// 					break;
				case 5:
					// if we don't have a local mailbox
					if(group[group.count()-1].find("pop3",0,false)!=-1)
						frameNo+=2;
					else if(group[group.count()-1].find("imap",0,false)!=-1)
						frameNo+=3;
					else
						frameNo++;
					break;
				case 6:
					frameNo+=3;
					break;
				case 7:
					frameNo+=2;
					break;
//<<<<<<< setupwizard.cpp
//				case 11:
//=======
				case 11:
//>>>>>>> 1.7
#ifdef DEBUG_SETUP
					printf("Processing the script...\n");
#endif
					if(processScript(this,script))
					{
						frameNo++;
					}
					else
					{
						// an error ocurred processing the configuration data
						printf("Setup failed\n");
						exit(0);
					}
					break;
//				case 11:
//					emit sendConfig(script);
//					close();
//					frameNo++;
//					return;
				case 13:
//					frameNo++;
					close();
				default:
					frameNo++;
			}
			if(frameNo==11)
				f12->setResult(script);
			top->setText(titles[frameNo]);
			frames->raiseWidget(frameNo);
			break;
		case BackMessage:
			{
				printf("<<<<<<<<<<<<<<<<< %d\n",stack.count());
				int fr=stack[stack.count()-1];
				stack.remove(stack.at(stack.count()-1));
				if(fr>=0)
				{
					frames->raiseWidget(fr);
					top->setText(titles[fr]);
				}
				while(script.count())
				{
					QString s=script[script.count()-1];
#ifdef DEBUG_SETUP
					printf("Removing: %s\n",(const char *)s);
#endif
					script.remove(s);
					if(((const char *)s)[0]=='[')
						return;
				}
			}
	}
#ifdef DEBUG_SETUP
	printf("\n");
	for(int i=0;i<script.count();i++)
	{
		printf("%2d:\t%s\n",i, (const char *)script[i]);
	}
#endif
}

