/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __NoteWindow__
#define __NoteWindow__

#include <qmultilinedit.h>
#include <qstring.h>
#include <qevent.h>
#include <qdatetime.h>
#include <qlabel.h>
#include <ebutton.h>
#include <qframe.h>
#include <qpoint.h>
#include <qpopupmenu.h>
#include <qfont.h>
#include <qcolor.h>
#include <noteview.h>
#include <templateview.h>
#include <noteobj.h>
#include <qframe.h>
#include <textfitter.h>
#include <noteedit.h>

class NoteWindow : public QFrame, public TemplateView
{
	Q_OBJECT
	public:
			NoteWindow(NoteObject *item);
			~NoteWindow();
			void update();
 	private:
			bool eventFilter(QObject *o, QEvent *ev);
 			void resizeEvent(QResizeEvent *e);
			void setNoteColor(const QString &color);
	private slots:
			void setTitle();
			void cut();
			void copy();
			void paste();
			void selectAllText();
			void setYellow();
			void setBlue();
			void setRed();
			void setGreen();
			void printNote();
			void showPopup();
			void updateText();
	private:
			QWidget *top;
			QLabel *label;
			EButton *cl_button;
			NoteEdit *edit_box;
			bool dragging, resizing;
 		  QPoint pointerOffset, resizeOffset;
			QFrame *hline;
			QLabel *date_line;
			QLabel *resize_pix;
			QLabel *icon;
			QPopupMenu *popupMenu, *colorPopup;
};

#endif
