/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <stdio.h>
#include <objectslist.h>

/************************ Object details stuff ******************/
#ifdef IDSTRING
	#undef IDSTRING
#endif
#define IDSTRING	"ObjectDetails: "

ObjectDetails::ObjectDetails(MetaObject *mo, int uid, int l, int ni, int puid)
{
	if(!mo) printf(IDSTRING"Void object. This should *NOT* happen.\n");
	if(!l==-1) printf(IDSTRING"Invalid level. This should *NOT* happen.\n");
	if(!uid==-1) printf(IDSTRING"Invalid UID. This should *NOT* happen.\n");
	setObject(mo);
	setLevel(l);
	setUID(uid);
	setNestIndex(ni);
	setParentUID(puid);
}



#ifdef IDSTRING
	#undef IDSTRING
#endif
#define IDSTRING	"ObjectList: "

#define DEBUG_OL
//#define DEBUG_OL_2

#define NotImplemented(str)	printf(IDSTRING"\"%s\" not implemented.\n",str)

int ObjectsList::localUID=0;

void ObjectsList::init(QTextStream &str)
{
	QString line;
	QString object="";
	int count=0;
	while(!str.atEnd())
	{
		line=str.readLine().stripWhiteSpace();
		if(!line.isEmpty())
		{
			object.append(line+"\n");
#ifdef DEBUG_OL_2
			printf(IDSTRING" %s\n",(const char *)line);
#endif
			if(line.find("BEGIN",0,false)==0) count++;
			if(line.find("END",0,false)==0) count--;
			if(count==0)
			{
				addObject(object);
				object="";
			}
		}
	}
	if(!object.isEmpty() && count==0)
		addObject(object);
}


ObjectsList::ObjectsList(MetaObject *mo=NULL)
{
	elements.clear();
	if(!mo)
	{
#ifdef DEBUG_OL
		printf(IDSTRING"Initializing without any object (MetaObject=NULL).\n");
#endif
		return;
	}
	addObject(mo);
}

ObjectsList::ObjectsList(QString list)
{
	if(list.isEmpty())
	{
#ifdef DEBUG_OL
		printf(IDSTRING"Initializing without any object (QString=NULL).\n");
#endif
		return;
	}
	QTextStream stream(&list, IO_ReadOnly);
	init(stream);
}
ObjectsList::~ObjectsList()
{
	for(int i=0;i<elements.count();i++)
		if(elements[i]->getParentUID()==-1)
		{
			printf(IDSTRING"Deleting %p\n",elements[i]->getObject());
			delete elements[i];
		}
	elements.clear();
}
void ObjectsList::addObject(MetaObject *mo, int level, int idx, int puid)
{
	int childNo=mo->getChildrenNo();
	int UID=getLocalUID();
	elements.append(new ObjectDetails(mo,UID,level,idx,puid));
#ifdef DEBUG_OL
			printf(IDSTRING"Level: %d. Added object %p with %d children\n",
				level, mo, childNo);
#endif
	if(childNo)
	{
		for(int i=0;i<childNo;i++)
		{
#ifdef DEBUG_OL_2
			printf(IDSTRING"Child %03d.%03d\n",level+1,i);
#endif
			addObject((*mo)[i],level+1,i,UID);
		}
	}
}


void ObjectsList::addObject(QString objstr)
{
	MetaObject *mo;
	mo=new MetaObject(objstr);
	addObject(mo);
}


bool ObjectsList::deleteObject(int objectUID)
{
	int index=-1;
	for(int i=0;i<elements.count();i++)
		if(elements[i]->getUID()==objectUID)
		{
			index=i; i=elements.count();
		}
	if(index>=0 && index<elements.count())
	{
		bool result=indexedOperation(objectUID,DELETE_OP,index);
		delete (*(elements[index]->getObject()))[elements[index]->getNestIndex()];
		elements.remove(elements.at(index));
		return result;
	}
	return false;
}

// This has to return the UIDs of the metaobjects!
QValueList<int> ObjectsList::nameQuery(QString name)
{
	QValueList<int> matches;
	for(int i=0;i<elements.count();i++)
	{
#ifdef DEBUG_OL
		printf(IDSTRING" %d <%s>\n",
			i,(const char *)elements[i]->getObject()->getName());
#endif
		if(elements[i]->getObject()->getName().find(name,0,false)!=-1)
			matches.append(elements[i]->getUID());
	}
	return matches;
}
QString ObjectsList::recompose()
{
	QString result="";
	for(int i=0;i<elements.count();i++)
		if(elements[i]->getParentUID()==-1)
		{
			result.append(elements[i]->getObject()->recompose());
			result.append("\n");
		}
	return result;
}
MetaObject *ObjectsList::operator[] (int uid)
{
	for(int i=0;i<elements.count();i++)
		if(uid==elements[i]->getUID()) return elements[i]->getObject();
	return NULL;
}

bool ObjectsList::indexedOperation(int parent, int operation, int offset)
{
	QValueList<int> matches;
	MetaObject *mop;
	mop=elements[parent]->getObject();
	for(int i=offset;i<elements.count();i++)
	{
		if(elements[i]->getParentUID()==parent)
		{
#ifdef DEBUG_OL
			printf(" %d has %d as parent\n",i,parent);
#endif
			matches.append(i);
			indexedOperation(i, operation);
		}
	}
	switch (operation)
	{
		case DELETE_OP:
			for(int i=0;i<matches.count();i++)
			{
				printf(IDSTRING"deleting...\n");
				elements.remove(elements.at(matches[i]));
			}
			break;
		default:
			printf(IDSTRING"Unknown operation. Ignoring.\n");
	}
	printf(IDSTRING" %d elements left in the objects collection...\n",
		elements.count());
	for(int i=0;i<elements.count();i++)
		printf(IDSTRING"----- [%d] = %p, %d, %d\n",
			i,elements[i]->getObject(), elements[i]->getUID(),
			elements[i]->getNestIndex());
}




