/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

/* 	THIS FILE HAS BEEN TESTED FOR MEMORY LEAKS WITH 1000000 ITERATIONS
 * 	Laur (1999)
 */

#include <stdio.h>
#include <string.h>
#include <qstring.h>
#include <qstringlist.h>
#include <miscfunctions.h>
#include <metaquality.h>


#define IDSTRING	"Quality: "

//#define DEBUG_QUALITY

// function for parsing a comma separated text and 
// adding the content to an object
void Quality::parseContent(QString content, QStringList &list)
{
	QString item;
	if(content.isEmpty()) 
	{
#ifdef DEBUG_QUALITY
		printf(IDSTRING"parseContent: Nothing to process\n");
#endif
		return;
	}
#ifdef DEBUG_QUALITY
	printf(IDSTRING"parseContent <%s>\n",(const char *)content);
#endif
	QStringList sep;
	// adding a prefix which invalidates the quality...
	sep.append("\\");
	list=enhancedSplit(content,',',sep);
	return;
}
void Quality::parseQuality(QString quality, QStringList &list)
{
	int eqpos=quality.find('=');
	if(eqpos!=-1)
	{
		(*objectName)=quality.left(eqpos);
		parseContent(quality.mid(eqpos+1,quality.length()-eqpos),list);
	}
	else
	{
		(*objectName)=quality;
	}
}

// init: function for the constructors
// it allocates the empty objects 
void Quality::init()
{
	objectName=new QString;
	objectContent= new QStringList;
}

// default constructor: initializes the qualitiy (empty objects)	
Quality::Quality()
{
	init();
}

// constructor 2: creates an object off a quality
Quality::Quality(const QString &quality)
{
	init();
	parseQuality(quality,*objectContent);
}

// constructor 3: creates an object off a name and a content (list)
Quality::Quality(QString name, const QString &content)
{
	init();
	setName(name);
	parseContent(content,*objectContent);
}

// copy (duplicate) constructor
Quality::Quality(const Quality &_q)
{
	init();
	(*objectName)=_q.name();
	(*objectContent)=_q.content();
}

// destructor!
Quality::~Quality()
{
	if(objectName) delete objectName;
	if(objectContent) delete objectContent;
}

// sets a new name
int 	Quality::setName(QString newName)
{
	if(objectName)
	{
		(*objectName)=newName;
		return 1;
	}
	return 0;
}

// appends a content (multiple "TYPE"s, emails...)
int 	Quality::appendContent(QString additionalContent)
{
	parseContent(additionalContent, *objectContent);
	return 1;
}

// empties the content
int 	Quality::clearContent()
{
	objectContent->clear();
	return 1;
}
int 	Quality::replaceContent(QString newContent)
{
	clearContent();
	parseContent(newContent, *objectContent);
	return 1;
}

// tests the object to see if it contains the content
// its useful in query situations like:
// "Phone;TYPE=work, mobile..."
// "Phone;TYPE=home, mobile..."
// and we want to select the object with "home" and not the other one.
bool 	Quality::hasContent(QString probedContent)
{
	if(objectContent->contains(probedContent)!=0) return TRUE;
	return FALSE;
}

bool Quality::checkContents(QString presentContent, QString excludedContent)
{
	QStringList checking;
	if(!presentContent.isEmpty())
	{
		parseContent(presentContent,checking);
		for(unsigned i=0;i<checking.count();i++)
		{
#ifdef DEBUG_QUALITY
			printf(IDSTRING"checkContents: checking \"%s\"\n",
					(const char *)checking[i]);
#endif
			if(hasContent(checking[i])==FALSE) return FALSE;
		}
	}
	if(!excludedContent.isEmpty())
	{
		checking.clear();
		parseContent(excludedContent,checking);
		for(unsigned i=0;i<checking.count();i++)
		{
#ifdef DEBUG_QUALITY
			printf(IDSTRING"checkContents: checking \"%s\"\n",
					(const char *)checking[i]);
#endif
			if(hasContent(checking[i])==TRUE) return FALSE;
		}
	}
	return TRUE;
}

Quality Quality::operator=(Quality &_q)
{
	(*objectName)=_q.name();
	(*objectContent)=_q.content();
	return *this;
}

void Quality::show()
{
	if(objectName && !objectName->isEmpty())
		printf(IDSTRING" Name: [%s]\n",(const char *)(*objectName));
	if(objectContent && objectContent->count())
	{
		for(unsigned i=0;i<objectContent->count();i++)
			printf(IDSTRING" Content[%02d]: <%s>\n",
					i,(const char*)(*objectContent)[i]);
	}
}

QString Quality::oldContent()
{
	static QString text;
	if(objectContent->count())
	{
		text=(*objectContent)[0];
	}
	else
	{
		text="";
		return text;
	}
	for(unsigned i=1;i<objectContent->count();i++)
	{
		text.append(", ");
		text.append((*objectContent)[i]);
	}
	return text;
}

QString Quality::recompose()
{
	static QString text;
	text=*objectName;
	if(objectContent->count())
	{
		text+="=";
		text+=oldContent();
	}
	return text;
}




