/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef HAS_VFREEBUSY
	#define HAS_VFREEBUSY

#include <qvaluelist.h>
#include <qstringlist.h>
#include <toolbox.h>
#include <metaobject.h>
/*
 *	VFreeBusy
 *	This class is used to generate/process free/busy iCalendar 
 * components. It contains a function "act" which is not yet implemented.
 *
 */
class VFreeBusy
{
public:
	enum PeriodsType { Free=0, Busy, Unavailable, Tentative };
private:
	QValueList<Period> free, busy, busyUnavailable, busyTentative;
	MetaObject *mObj;
	Toolbox::Method met;
	QStringList attendees;
	QStringList contacts;
	QDateTime dtEnd;
	QDateTime dtStart;
	QDateTime dtStamp;
	QString organizer;
	long duration;					// requested duration in seconds
	QString id;
	QString requestStatus;
	QString url;
	
	void parseFreeBusyLine(MetaLine *line);
	void parseAttendees();
	void parseOrganizer();
	void parseDT();
	void parseID();
	void parseDuration();
	void parseURL();
	void parseRequestStatus();
public:
	/**
	 *	This is the constructor. Its role is to parse the metaobject given as
	 * parameter in order to get the appropriate structures.
	 *	@param mo	a pointer to the source MeatObject
	 *	@param method	the method (PUBLISH, REQUEST, REPLY)
	 */
	VFreeBusy(MetaObject *mo, Toolbox::Method method);
	/**
	 *	@return a list of time intervals according to the type requested
	 *	@param	type Type which can be {VFreeBusy::Free, VFreeBusy::Busy,
	 * VFreeBusy::Unavailable, VFreeBusy::Tentative}
	 */
	QValueList<Period> getFreeBusy(PeriodsType type);
	/**
	 *	@return a list of attendees. This is more or less useless because
	 * the attendees are build and used with the freebusy request dialog (form).
	 * The attendees have mostly informative purpose: Who else is participating
	 * to that meeting...
	 */
	QStringList getAttendees() { return attendees; }
	/**
	 *	@return the DTSTART field value as a QDateTime.
	 */
	QDateTime getDTStart() { return dtStart; }
	/**
	 *	@return the DTSTAMP field value as a QDateTime. Used by some timers
	 * eventually (or to see if is too old...)
	 */
	QDateTime getDTStamp() { return dtStamp; }
	/**
	 *	@return the DTEND field value as a QDateTime.
	 */
	QDateTime getDTEnd() { return dtEnd; }
	/**
	 *	@return the ORGANIZER (an e-mail address)
	 */
	QString getOrganizer() { return organizer; }
	/**
	 *	@return the duration. If a (meeting) request is received, then we have to
	 * see what duration the sender is looking for, so when the reply is sent, to
	 * contain time chunks bigger than this.
	 */
	long getDuration() { return duration; }
	/**
	 *	@return the URL (an URI)
	 */
	QString getURL() { return url; }
	/**
	 *	@returns the REQUEST-STATUS content. This has to be parsed by ReqStatus
	 * class in order to obtain something useful.
	 */
	QString getRequsetStatus() { return requestStatus; }
	/**
	 *	<br>The behaviour of a VFreeBusy component is:<br>
	 *	<ul>
	 *	<li>method is <code>REQUEST</code>:<br>
	 *	  The object contains only the begin/end of the interest busy time,
	 *	 identifier, organizer, stamp, attendees and duration.
	 *		<ul>
	 *			<li><code>organizer</code> - whoever did the request</li>
	 *			<li<code>>stamp</code> - when the request has been sent</li>
	 *			<li><code>attendees</code> - the others to whom the request has
	 *					been sent</li>
	 *			<li><code>identifier</code> - unique id to be used in the reply</li>
	 *			<li><code>duration</code> - how long has to be the free period</li>
	 *		</ul>
	 *	</li>
	 *	<li>method is <code>REPLY</code>:<br>
	 *		The project contains only busy times, attendee, start/end, stamp,
	 *	 organizer, uid.
	 *		<ul>
	 *			<li><code>attendee</code> - whoever did the original request
	 *		(and the e-mail recipient in the same time)</li>
	 *			<li><code>stamp</code> - when the reply has been sent</li>
	 *			<li><code>organizer</code> - the reply sender</li>
	 *			<li><code>uid</code> - unique id (the same as in the request)</li>
	 *		</ul>
	 *	</li>
	 *	<li>method is <code>PUBLISH</code>:<br>
	 *		This is a sort of broadcast of a free/busy... time. It contains the
	 *	 start/end dates, multiple free/busy periods, organizer.
	 *		<ul>
	 *			<li><code>FREEBUSY</code> - the specific stuff containing a FREE,
	 *		 BUSY, BUSY-UNAVAILABLE, BUSY-TENTATIVE lists.</li>
	 *			<li><code>organizer</code> - the message originator</li>
	 *		</ul>
	 *		<br> In this case, the "act" method will require a list of valid e-mail
	 *	addresses to whom the publication should be sent.
	 *	</li>
	 *	</ul>
	 */
	void act();
};


#endif








