/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <vfolderattribute.h>
#include <vattribute.h>
#include <vfolder.h>
#include <qstring.h>
#include <qcstring.h>
#include <stdio.h>

VFolderAttribute::VFolderAttribute(QString id):VAttribute(id)
{
}

VFolderAttribute::VFolderAttribute(QString id, QByteArray &_data):VAttribute(id, _data)
{
}

void VFolderAttribute::_narrow(const QByteArray &data)
{
	QDataStream inStream(data, IO_ReadOnly);

	if(data.size())
	{		
		// unstream the byte array
		QString _type;
		inStream>>_type>>owner>>device>>dtype>>rtype>>size>>lmodified>>active>>flags>>items>>recent>>folders;
	}
	else
	{
		printf("warning: vattribute %s attempted to unstream an empty block, bailing out\n", (const char *)path());
	}
}

QByteArray VFolderAttribute::_stream()
{
	QByteArray data;
	QDataStream outStream(data, IO_WriteOnly);
	
	// stream the attribute
	outStream<<"folderattribute"<<owner<<device<<dtype<<rtype<<size<<lmodified<<active<<flags<<items<<recent<<folders;
	
	return data;
}

bool VFolderAttribute::getProperty(const QString &query, Any &property)
{
	if(query=="items")
	{
		property=Any(items);
		return true;
	}
	if(query=="recent")
	{
		property=Any(recent);
		return true;
	}
	if(query=="folders")
	{
		property=Any(folders);
		return true;
	}
	
	return VAttribute::getProperty(query, property);
}

bool VFolderAttribute::setProperty(const QString &query, Any &property)
{
	return VAttribute::setProperty(query, property);
}

QueryProcessor::QueryType VFolderAttribute::queryType(const QString &query)
{
	if(query=="items" || query=="recent" || query=="folders") 
		return QueryProcessor::ReadOnlyQuery;
	
	return VAttribute::queryType(query);
}
