/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <clientnotifier.h>
#include <commframe.h>
#include <commbinder.h>
#include <clientvfs.h>
#include <commands.h>
#include <conversions.h>

ClientNotifier *ClientNotifier::inst;

ClientNotifier *ClientNotifier::thisInstance()
{
	return inst?inst:(inst=new ClientNotifier());
}

ClientNotifier::ClientNotifier()
{
	// debug
	// printf("Client notifier instance activated, waiting for next message...\n");
	
	// connect to incoming messages
	connect(CommBinder::thisInstance(), SIGNAL(messageReceived(CommFrame &)), this, SLOT(processEvent(CommFrame &)));
}

void ClientNotifier::processEvent(CommFrame &inFrame)
{
	if(inFrame.commandCode==MagellanComm::ObjectCreated)
	{
		// debug
		// printf("VInstance created on server, updating the VFS structure...\n");
		
		QStringList paths=_narrowQStringList(inFrame.extraData);
		
		for(QStringList::Iterator it=paths.begin(); it!=paths.end(); it++)
		{
  		ClientVFS::thisInstance()->createVInstance((*it));
  		emit createVInstance((*it));
		}
	}
	else if(inFrame.commandCode==MagellanComm::ObjectsCreated)
	{
		// debug
		// printf("VInstance created on server, updating the VFS structure...\n");
		
		QStringList paths=_narrowQStringList(inFrame.extraData);
		
		ClientVFS::thisInstance()->createVInstances(paths);
		emit createVInstances(paths);
	}
	else if(inFrame.commandCode==MagellanComm::ObjectChanged)
	{
		// debug
		// printf("VInstance changed content on server, updating the VFS structure...\n");
		
		QStringList paths=_narrowQStringList(inFrame.extraData);
		
		for(QStringList::Iterator it=paths.begin(); it!=paths.end(); it++)
		{
  		ClientVFS::thisInstance()->updateVInstance((*it));
  		emit updateVInstance((*it));
		}
	}
	else if(inFrame.commandCode==MagellanComm::ObjectDeleted)
	{
		QStringList paths=_narrowQStringList(inFrame.extraData);
		
		for(QStringList::Iterator it=paths.begin(); it!=paths.end(); it++)
		{
  		ClientVFS::thisInstance()->deleteVInstance((*it));
  		emit deleteVInstance((*it));
    }
	}
	else if(inFrame.commandCode==MagellanComm::FolderCreated)
	{
		QStringList params=_narrowQStringList(inFrame.extraData);
		if( 5<=params.count() )
		{
 		  ClientVFS::thisInstance()->createFolder(params[0], params[1], params[2], params[3], params[4]);
//  		emit createVFolder(params[0]+"/"+params[1]);
		}
	}
	else if(inFrame.commandCode==MagellanComm::FolderDeleted)
	{
		QStringList params=_narrowQStringList(inFrame.extraData);
		if( 3<=params.count() )
		{
 		  ClientVFS::thisInstance()->deleteFolder(params[0], params[1], params[2]);
//  		emit deleteeVFolder(params[0]+"/"+params[1]);
		}
	}
	else if(inFrame.commandCode==MagellanComm::FolderPurged)
	{
		QStringList paths=_narrowQStringList(inFrame.extraData);
		
		for(QStringList::Iterator it=paths.begin(); it!=paths.end(); it++)
  		emit purgeVFolder((*it));
	}
	else if(inFrame.commandCode==MagellanComm::HierarchyChanged)
	{
		QStringList paths=_narrowQStringList(inFrame.extraData);
		
		for(QStringList::Iterator it=paths.begin(); it!=paths.end(); it++)
  		emit updateHierarchy((*it));
	}
	else if(inFrame.commandCode==MagellanComm::IOProgress)
	{
		QStringList paths=_narrowQStringList(inFrame.extraData);
		
		for(QStringList::Iterator it=paths.begin(); it!=paths.end(); it++)
  		emit showProgress((*it));
	}
	else
	{
		printf("Warning: unknown message received from server, discarding...\n");
	}
}





