/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __UI_Binder__
#define __UI_Binder__

#include <templateview.h>
#include <qstring.h>
#include <qstringlist.h>
#include <vfolder.h>

class UI_Binder
{
	public:
		UI_Binder();

		// returns the view pointer of the currently selected folder
		TemplateView *getCurrentFolder();
		// sets the selected folder to "view", if not null; returns false if "view" does not exist as a registered view (i.e. with ViewTree)
		bool setCurrentFolder(TemplateView *view);

		// returns the address list of the selected objects in the specified view (current folder if null)		
		QStringList getSelection(TemplateView *view=0);
		// selects the items specified by the given address list; invalid addresses are ignored; returns false if the view is invalid
		bool setSelection(QStringList selection, TemplateView *view=0);
		
		// returns the address of the current item in the specified view, or QString::null if there is no current item 
		QString getCurrentItem(TemplateView *view=0);
		// sets the item specified by the given address as current in the given view (or clears the selection flag on all items if the address is QString::null); returns false if the view is invalid
		bool setCurrentItem(QString item=QString::null, TemplateView *view=0);
};

#endif










