/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <mailwidget.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlistview.h>
#include <qlabel.h>
#include <qheader.h>
#include <stdio.h>
#include <mailwidgetbase.h>
#include <cardclasses.h>
#include <etoolbarbutton.h>
#include <carddialog.h>

#define IDSTRING "MailWidget: "

// stuff defined for accessing the toolbar button.
#define Dialog ((CardDialog *)parentWidget()->parentWidget()->parentWidget()->parentWidget())
#define sendMailButton (Dialog->sendMailButton)

MailWidget::MailWidget(QPushButton *parentButton, CardListEmails *mails, QWidget *parent, const char *name) : 
	MailWidgetBase(parent, name,WType_Popup | WDestructiveClose)
{
	_button=parentButton;
	setItems(mails);
	mailsList->header()->hide();
}

CardListEmails *MailWidget::items() { return _items; }

void MailWidget::setItems(CardListEmails *mails)
{
	_items=mails;
	if(!_items)
		return;
	// get the default mail in the editor
	if(items()->emails().count()==0)
	{
		removeButton->setEnabled(false);
		replaceButton->setEnabled(false);
		defaultButton->setEnabled(false);
		return; // no e-mails
	}
	mailsList->clear();
	if(items()->defaultEmail()==-1)
		items()->setDefaultEmail(0);
	mailEdit->setText(items()->emails()[items()->defaultEmail()]);
	for(int i=0;i<items()->emails().count();i++)
	{
		QListViewItem *item= new QListViewItem(mailsList);
		item->setText(0,items()->emails()[i]);
		if(i==items()->defaultEmail())
			item->setPixmap(0, *defaultLabel->pixmap());
		else
			item->setPixmap(0, *emptyLabel->pixmap());
#ifdef DEBUG_MAILWIDGET
		printf(" Adding item <%s>...\n", (const char *)items()->emails()[i]);
#endif
		mailsList->insertItem(item);
	}
	if(items()->emails().count()==1)
	{
		defaultButton->setEnabled(false);
		if(items()->defaultEmail()!=0) items()->setDefaultEmail(0);
	}
	if(_button)
		_button->setText(items()->emails()[items()->defaultEmail()]);
}

void MailWidget::addPressed()
{
	if(!items())
	{
		printf(IDSTRING"Trace please: no (null) data structure for mails)\n");
		return;
	}
	// check if is not inthere
	if(mailEdit->text().stripWhiteSpace().isEmpty())
		return;
	if(items()->emails().grep(mailEdit->text(),false).count()==0)
	{
		// adding, but not default
		QListViewItem *item= new QListViewItem(mailsList);
		item->setText(0, mailEdit->text());
		if(items()->emails().count()==0)
		{
			sendMailButton->setDisabled(false);
			item->setPixmap(0, *defaultLabel->pixmap());
			removeButton->setEnabled(true);
			defaultButton->setEnabled(false);
			replaceButton->setEnabled(false);
			items()->addEmail(mailEdit->text(),true);
			if(_button)
				_button->setText(mailEdit->text());
		}
		else
		{
			item->setPixmap(0, *emptyLabel->pixmap());
			defaultButton->setEnabled(true);
			replaceButton->setEnabled(true);
			items()->addEmail(mailEdit->text(),false);
		}
		mailsList->insertItem(item);
		mailEdit->setText("");
	}
}

void MailWidget::finishPressed()
{
	close();
}

void MailWidget::removePressed()
{
	if(!items())
	{
		printf(IDSTRING"Trace please: no (null) data structure for mails.\n");
		return;
	}
	if(items()->emails().count()==0)
		return;
	QListViewItem *i=mailsList->selectedItem();
	QString str=i->text(0);
	int count=items()->emails().findIndex(str);
	delete i;
	items()->emails().remove(str);
#ifdef DEBUG_MAILWIDGET
	printf(" %d %d\n", count,items()->defaultEmail());
#endif
	if(count==items()->defaultEmail())
		items()->setDefaultEmail(0);
	setItems(items());
	switch(items()->emails().count())
	{
		case 1:
			defaultButton->setEnabled(false);
			replaceButton->setEnabled(true);
			break;
		case 0:
			defaultButton->setEnabled(false);
			removeButton->setEnabled(false);
			replaceButton->setEnabled(false);
			// disabling the send mail button if we don't have any e-mails
			sendMailButton->setDisabled(true);
			if(_button)
				_button->setText("No e-mail");
	}
}

void MailWidget::replacePressed()
{
	if(!items())
	{
		printf(IDSTRING"Trace please: no (null) data structure for mails)\n");
		return;
	}
	if(mailEdit->text().stripWhiteSpace().isEmpty() || mailsList->currentItem()==0)
		return;
	items()->emails()[items()->emails().findIndex(mailsList->currentItem()->text(0))]=mailEdit->text();
	mailsList->currentItem()->setText(0,mailEdit->text());
	if(items()->emails().findIndex(mailsList->currentItem()->text(0)) == items()->defaultEmail() && _button)
		_button->setText(mailEdit->text());
}

void MailWidget::defaultPressed()
{
	if(!items())
	{
		printf(IDSTRING"Trace please: no (null) data structure for mails)\n");
		return;
	}
	if(mailsList->currentItem()==0)
		return;
	items()->setDefaultEmail(items()->emails().findIndex(mailsList->currentItem()->text(0)));
	if(_button)
		_button->setText(mailsList->currentItem()->text(0));
	setItems(items());
}

void MailWidget::selectionChanged(QListViewItem *i)
{
	if(!items())
	{
		printf(IDSTRING"Trace please: no (null) data structure for mails)\n");
		return;
	}
	if(!i) return;
	mailEdit->setText(i->text(0));
}

