/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */
#define DATADIR

#include <kiconloader.h>
#include <qfontdialog.h>

#include <videotoolbox.h>
#include <notessetupwidget.h>
#include <genericeditdialog.h>

extern VideoToolBox vtb;

#define IDSTRING "NotesSetupWidget: "

NotesSetupWidget::NotesSetupWidget(QWidget *p, QString *c, QFont *f, QSize *s,
	QString n) : QFrame(p, n, 0)
{
	if(!c) color="yellow"; else color = *c;
	if(!f) font=QFont("helvetica", 12, QFont::Normal); else font = *f;
	if(!s) size=QSize(40, 40); else size = *s;
	setupWidget();
}
QFont NotesSetupWidget::getFont()
{
	return font;
}
QColor NotesSetupWidget::getColor()
{
	return color;
}
QSize NotesSetupWidget::getSize()
{
	return size;
}

void NotesSetupWidget::sizeButtonPressed()
{
	QStringList titles;
	QStringList values;
	QStringList types;
	QString text;
	titles.append("Width:");
	values.append(text.sprintf("%d",size.width()));
	types.append("int");
	titles.append("Height:");
	values.append(text.sprintf("%d",size.height()));
	types.append("int");
	GenericEditDialog *ged;
	ged=new GenericEditDialog(this, "Size:");
	ged->hide();
	ged->setUpDialog(titles, values, types, 60);
	ged->setCaption("Select size:");
	ged->show();
	connect(ged, SIGNAL(end(QStringList)),
		this, SLOT(sizeDialogEnded(QStringList)));
}
void NotesSetupWidget::sizeDialogEnded(QStringList values)
{
	size.setWidth(values[0].toInt());
	size.setHeight(values[1].toInt());
	if(size.width()<40) size.setWidth(40);
	if(size.height()<40) size.setHeight(40);
	if(size.width()>400) size.setWidth(400);
	if(size.height()>400) size.setHeight(400);
	QString text;
	sizeButton->setText(text.sprintf("%d x %d", size.width(), size.height()));
}

void NotesSetupWidget::colorButtonPressed()
{
	ColorsDialog *cd;
	cd= new ColorsDialog(this,"colors","yellow");
	cd->setCaption("Select size:");
	cd->show();
	connect(cd,SIGNAL(done(QString)), this, SLOT(colorDialogEnded(QString)));
}
void NotesSetupWidget::colorDialogEnded(QString col)
{
	color=col;
	colorButton->setText(QString("     ")+color);
	if(color=="yellow")
	{
		colorButton->setNormalBgColor(QColor(255, 255, 140));
		colorButton->setFocusBgColor(QColor(255, 255, 140));
		colorButton->setClickedBgColor(QColor(255, 255, 140));
	}
	if(color=="red")
	{
		colorButton->setNormalBgColor(QColor(255, 206, 206));
		colorButton->setFocusBgColor(QColor(255, 206, 206));
		colorButton->setClickedBgColor(QColor(255, 206, 206));
	}
	if(color=="green")
	{
		colorButton->setNormalBgColor(QColor(187, 255, 173));
		colorButton->setFocusBgColor(QColor(187, 255, 173));
		colorButton->setClickedBgColor(QColor(187, 255, 173));
	}
	if(color=="blue")
	{
		colorButton->setNormalBgColor(QColor(214, 245, 255));
		colorButton->setFocusBgColor(QColor(214, 245, 255));
		colorButton->setClickedBgColor(QColor(214, 245, 255));
	}
}
void NotesSetupWidget::fontButtonPressed()
{
	bool ok;
	font=QFontDialog::getFont(&ok, font);
	printf(IDSTRING"Font family: <%s> size: <%d>\n",
		(const char *)font.family(), font.pointSize());
	if(ok)
	{
		fontButton->setTextFont(font);
		QString str;
		fontButton->setText(QString(" ")+
				font.family()+
				str.sprintf(" %dpt",font.pointSize()));
	}
}

void NotesSetupWidget::setupWidget()
{
	int WIN_SIZE;
	QString name;
	int dx,dy;
	dx=dy=0;
	#define offset 180
	QFont f("helvetica", 18, QFont::Bold);
	vtb.setUpFonts(f);
	titleLabel=vtb.setUpLabelBgPixmap(this, " Notes",
		DATADIR"xpm/general/degradee.xpm", width()-dx, vtb.fontHeight()-4,
		&dx, &dy);
	dy+=vtb.fontHeight()+vtb.offsetY();
	dx=10;
	f=QFont("helvetica", 12, QFont::Normal);
	vtb.setUpFonts(f);
	int align=vtb.stringLength("Choose the default color:");
	/* THE SIZE SECTION */
	sizeLabel=vtb.setUpLabelSize(this, "Choose the default size:", align,
		&dx, &dy);
	sizeButton=vtb.setUpEButton(this, f,
		DATADIR"xpm/general/size-icon.xpm",
		DATADIR"xpm/general/size-icon.xpm",
		DATADIR"xpm/general/size-icon.xpm",
		QFrame::Raised | QFrame::Panel,
		QFrame::Raised | QFrame::Panel,
		QFrame::Sunken | QFrame::Panel,
		"     40 x 40",
		dx, dy,  offset, vtb.fontHeight());	
	dy+=vtb.fontHeight()+vtb.offsetY();
	dx=10;
	frame1=new QFrame(this);
	frame1->setGeometry(dx,dy+(vtb.fontHeight()+vtb.offsetY()-2)/2,
		width()-dx-dx,2);
	frame1->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	dy+=vtb.fontHeight()+vtb.offsetY();
	dx=10;
	connect(sizeButton,SIGNAL(clicked()), this, SLOT(sizeButtonPressed()));
	/* THE COLOR SECTION */
	colorLabel=vtb.setUpLabelSize(this, "Choose the default color:", align,
		&dx, &dy);
	colorButton=vtb.setUpEButton(this, f,
		DATADIR"xpm/general/color-icon.xpm",
		DATADIR"xpm/general/color-icon.xpm",
		DATADIR"xpm/general/color-icon.xpm",
		QFrame::Raised | QFrame::Panel,
		QFrame::Raised | QFrame::Panel,
		QFrame::Sunken | QFrame::Panel,
		"     Color",
		dx, dy,  offset, vtb.fontHeight());
	colorDialogEnded(color);
	dy+=vtb.fontHeight()+vtb.offsetY();
	dx=10;
	frame2=new QFrame(this);
	frame2->setGeometry(dx,dy+(vtb.fontHeight()+vtb.offsetY()-2)/2,
		width()-dx-dx,2);
	frame2->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	dy+=vtb.fontHeight()+vtb.offsetY();
	dx=10;
	connect(colorButton,SIGNAL(clicked()), this, SLOT(colorButtonPressed()));
	/* THE FONT SECTION */
	fontLabel=vtb.setUpLabelSize(this, "Choose the default color:", align,
		&dx, &dy);
	fontButton=vtb.setUpEButton(this, f,
		DATADIR"xpm/general/font-icon.xpm",
		DATADIR"xpm/general/font-icon.xpm",
		DATADIR"xpm/general/font-icon.xpm",
		QFrame::Raised | QFrame::Panel,
		QFrame::Raised | QFrame::Panel,
		QFrame::Sunken | QFrame::Panel,
		"Helvetica 12pt",
		dx, dy,  offset, vtb.fontHeight());	
	dy+=vtb.fontHeight()+vtb.offsetY();
	dx=10;
//	frame1=new QFrame(this);
//	frame1->setGeometry(dx,dy+(vtb.fontHeight()+vtb.offsetY()-2)/2,
//		width()-dx-dx,2);
//	frame1->setFrameStyle(QFrame::HLine | QFrame::Sunken);
//	dy+=vtb.fontHeight()+vtb.offsetY();
//	dx=10;
	connect(fontButton,SIGNAL(clicked()), this, SLOT(fontButtonPressed()));
}

/****************************************************************************/
/* The color setup dialog                                                   */
/****************************************************************************/
ColorsDialog::ColorsDialog(QWidget *parent, QString name, QString deColor) :
	QMainWindow(parent, name, WType_Modal | WStyle_Dialog) 
{
	color=oldColor=deColor;
	int dx=10, dy=10;
	setFixedSize(220,5*vtb.fontHeight()+4*vtb.offsetY()+20);
	red= vtb.setUpToggleButton(this, QFont("helvetica", 12, QFont::Normal),
		"", "", "",
		QFrame::Raised | QFrame::Panel,
		QFrame::Raised | QFrame::Panel,
		QFrame::Sunken | QFrame::Panel,
		QColor(255, 206, 206),QColor(255, 206, 206),
		"", dx, dy, 200, vtb.fontHeight(),
		color.lower()=="red");
	dy+=vtb.fontHeight()+vtb.offsetY();
	green= vtb.setUpToggleButton(this, QFont("helvetica", 12, QFont::Normal),
		"", "", "",
		QFrame::Raised | QFrame::Panel,
		QFrame::Raised | QFrame::Panel,
		QFrame::Sunken | QFrame::Panel,
		QColor(187, 255, 173),QColor(187, 255, 173),
		"", dx, dy, 200, vtb.fontHeight(),
		color.lower()=="green");
	dy+=vtb.fontHeight()+vtb.offsetY();
	blue= vtb.setUpToggleButton(this, QFont("helvetica", 12, QFont::Normal),
		"", "", "",
		QFrame::Raised | QFrame::Panel,
		QFrame::Raised | QFrame::Panel,
		QFrame::Sunken | QFrame::Panel,
		QColor(214, 245, 255),QColor(214, 245, 255),
		"", dx, dy, 200, vtb.fontHeight(),
		color.lower()=="blue");
	dy+=vtb.fontHeight()+vtb.offsetY();
	yellow= vtb.setUpToggleButton(this, QFont("helvetica", 12, QFont::Normal),
		"", "", "",
		QFrame::Raised | QFrame::Panel,
		QFrame::Raised | QFrame::Panel,
		QFrame::Sunken | QFrame::Panel,
		QColor(255, 255, 140),QColor(255, 255, 140),
		"", dx, dy, 200, vtb.fontHeight(),
		color.lower()=="yellow");
	dy+=vtb.fontHeight()+vtb.offsetY();
	cancel=new QPushButton(this);
	cancel->setText("&Cancel");
	cancel->setGeometry(width()-90,dy,80,vtb.fontHeight());
	connect(cancel,SIGNAL(clicked()), this, SLOT(cancelClicked()));
	connect(red,SIGNAL(signalToggled(bool)), this, SLOT(redClicked(bool)));
	connect(green,SIGNAL(signalToggled(bool)), this, SLOT(greenClicked(bool)));
	connect(blue,SIGNAL(signalToggled(bool)), this, SLOT(blueClicked(bool)));
	connect(yellow,SIGNAL(signalToggled(bool)), this, SLOT(yellowClicked(bool)));
}

void ColorsDialog::redClicked(bool b)
{
	emit done("red");
	close();
}
void ColorsDialog::greenClicked(bool b)
{
	emit done("green");
	close();
}
void ColorsDialog::blueClicked(bool b)
{
	emit done("blue");
	close();
}
void ColorsDialog::yellowClicked(bool b)
{
	emit done("yellow");
	close();
}
void ColorsDialog::cancelClicked()
{
	emit done(oldColor);
	close();
}





