/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#define mybg QColor(0, 0, 0)
#define myfg QColor(255, 255, 255)

#include <qframe.h>
#include <qpixmap.h>
#include <qlabel.h>
#include <qstring.h>
#include <qlayout.h>

#include <kiconloader.h>

#include <stdio.h>
#include <esplash.h>
#include <epixbar.h>

ESplash::ESplash(QString imagename)
	:QFrame(0, 0, WStyle_Customize|WStyle_NoBorder|WStyle_StaysOnTop)
{
	pix=BarIcon(imagename);
	int h, w;
	setBackgroundColor(QColor(0,0,0));
	h=pix.height()+1;
	w=pix.width();
	img= new QLabel(this);
	img->setPixmap(pix);
	img->setGeometry(1,1,pix.width(), pix.height());
/* XXX Disabled text banner on splash screen for TPR
	text = new QLabel(this);
	text->setBackgroundColor("white");
	QFont f("Helvetica", 10);
	text->setFont(f);
	text->setGeometry(1,h-1,w,13);
	h+=12;
*/
	l= new QLabel(this);
	l->setBackgroundColor("white");
	epb= new EPixBar(l);
	epb->setBackgroundColor(QColor("white"));
	epb->setGeometry(1,0,150,150);
	epb->setWidthMargin(2);
									
	epb->loadWidget(BarIcon("other-ui-small-empty"),
									BarIcon("other-ui-small-full"),
									BarIcon("other-ui-big-empty"),
									BarIcon("other-ui-big-full"));

	epb->loadWidget(BarIcon("tools-small-empty"),
									BarIcon("tools-small-full"),
									BarIcon("tools-big-empty"),
									BarIcon("tools-big-full"));
									
	epb->loadWidget(BarIcon("addressbook-small-empty"),
									BarIcon("addressbook-small-full"),
									BarIcon("addressbook-big-empty"),
									BarIcon("addressbook-big-full"));
									
	epb->loadWidget(BarIcon("mainwidget-small-empty"),
									BarIcon("mainwidget-small-full"),
									BarIcon("mainwidget-big-empty"),
									BarIcon("mainwidget-big-full"));

	epb->loadWidget(BarIcon("views-small-empty"),
									BarIcon("views-small-full"),
									BarIcon("views-big-empty"),
									BarIcon("views-big-full"));

	epb->loadWidget(BarIcon("toolbars-small-empty"),
									BarIcon("toolbars-small-full"),
									BarIcon("toolbars-big-empty"),
									BarIcon("toolbars-big-full"));
	epb->setStyle(EPixBar::FixedSize | 
								EPixBar::PixmapProgress |
								EPixBar::SmallProgress);
	l->setGeometry(1,h,w,epb->height());
	epb->move((l->width()-epb->width())/2,0);
	h+=epb->height();
	setFixedSize(w+2,h+1);
	l->show();
	epb->show();
	//text->show();
}

void ESplash::tick(QString txt)
{
#ifdef DEBUG_ESPLASH
	printf("Ticking...\n");
#endif
	epb->tick();
/* Disabled text banner for TPR
	if(txt!=QString::null)
		text->setText(QString("  ") + txt);
*/
}
void ESplash::setTicks(int t, int pos=-1)
{
	epb->setTicker(t,pos);
}

void ESplash::clearTick(int pos=-1)
{
	epb->reset(pos);
}

void ESplash::setActive(int pos=-1, bool act=false)
{
	epb->setActive(pos,act);
}

bool ESplash::active()
{
	return epb->active();
}

int ESplash::getTicks(int pos=-1)
{
	return epb->getTicks(pos);
}
