#ifndef __TextProcessor__
#define __TextProcessor__

#include <qstring.h>
#include <qstringlist.h>
#include <qvaluelist.h>
#include <metaformatcontrol.h>

class TextProcessor
{
	public:
		// quote text, given text and quote sequence
		static QString quoteText(QString &, const QString &);

		// unquote text, given text and quote sequence list
		static QString unquoteText(QString &, const QStringList &);

		// indent text using given number of spaces
		static QString indentText(QString &, int spaces=1);

		// unindent text using given number of spaces
		static QString unindentText(QString &, int spaces=1);

		// indent text using given number of tabs
		static QString indentTabText(QString &, int tabs=1);

		// unindent text using given number of tabs
		static QString unindentTabText(QString &, int tabs=1);

		// metaformat text for reply detection, given control object
		static QString metaFormat(QString, const MetaFormatControl &);
	private:
		// (internal) maximum sequence of transformations that can be applied on given text
		static QStringList depth(QString, const QStringList &);
	
		// (internal) strips text, given list of transformations
		static QString strip(QString, const QStringList &);
};

#endif
