/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __URLManager__
#define __URLManager__

#include <qstring.h>
#include <qstringlist.h>
#include <mailer.h>
#include <datacollection.h>
#include <localmailfolder.h>

class URLManager
{
  public:
    URLManager();
    virtual ~URLManager();
    
    // URL handling methods
    bool isFolder(QString url);          // true if the url is an existent folder
    bool exists(QString url);            // true if the url is an existent folder or object
    QString parent(QString url);         // returns the logical parent of a folder or object
    QString folder(QString url);         // returns the folder parent of a folder or object
    QStringList children(QString url);   // returns the list of child objects
		QStringList related(QString url);
    int type(QString url);               // returns the object major type, based on its url
    int subtype(QString url);            // returns the object fine type
		
		// set methods
		bool setRelated(QString url, QStringList rList);
		bool setParent(QString url, QString parentUrl);
    
    // data handling methods
    DataCollection *folderReference(QString url);  // returns a reference to the required folder (except for mail folders)
    ObjectReference *objectReference(QString url); // returns a reference to the required object (except for mail objects)
    MailFolder *mailfolderReference(QString url); // returns a reference to the required mail folder
    IndexClass *indexReference(QString url);           // returns a reference to the required mail

    // string URL handling methods
    QString path(QString url);
    QString object(QString url);
    QString folderpath(QString url);
};

#endif








