/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <stdio.h>
#include <icalendar.h>
#include <qfile.h>

#ifdef IDSTRING
	#undef IDSTRING
#endif

#define IDSTRING "ICal: "
#define MAXLINESIZE 100

#define DEBUG_ICALENDAR

ICalendarContainer::ICalendarContainer(QString filename)
{
	printf(IDSTRING"Entering constructor %s\n", (const char *)filename);
	appendObjects(filename);
}

ICalendarContainer::~ICalendarContainer()
{
//	#warning The destructor should delete all the V* objects
}

	
int ICalendarContainer::appendObjects(QString filename)
{
	if(filename.isEmpty())
	{
		printf(IDSTRING"Warning: Empty file. Not loading.\n");
		return 0;
	}
	QFile source(filename);
	if(source.open(IO_Translate | IO_ReadWrite)==false)
	{
		printf(IDSTRING"Warning: Could not open file \"%s\". Not loading.\n",
			(const char *)filename);
		return 0;
	}
	QString line;
	QString buffer;
	QString strippedLine;
	int flag=0;
	int counter=0;
	while (!source.atEnd())
	{
		int size=source.readLine(line,MAXLINESIZE);
		strippedLine=line.stripWhiteSpace();
		if(size && !strippedLine.isEmpty())
		{
			// check if I have a "BEGIN:"
			if(strippedLine.find("begin:",0,false)==0)
				flag++;
			if(flag)
				buffer.append(line);
			// i have encountered an "END:"
			if(strippedLine.find("end:",0,false)==0)
				flag--;
			if(flag==0)
			{
				printf(IDSTRING"To add the object ot the list if necessary\n");
#ifdef DEBUG_ICALENDAR
				printf("Object:----\n%s------\n",(const char *) buffer);
#endif				
				buffer="";
			}
		}
	}
#ifdef DEBUG_ICALENDAR
	printf(IDSTRING"%d objects appendend to the list,\n",counter);
#endif				
	return counter;
}
bool ICalendarContainer::appendObject(QString data)
{
}
int ICalendarContainer::objectQuery(QString identification)
{
}





