#ifndef MAILFILTERDIALOG_H
#define MAILFILTERDIALOG_H

#include <qlist.h>
#include <qvariant.h>
#include <qdialog.h>

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QComboBox;
class QLineEdit;
class QListBox;
class QListBoxItem;
class QWidgetStack;
class QPushButton;
class QToolButton;
class KConfig;

class FilterEl {
public:
        FilterEl(QString r1f,QString r1fun,QString r1con,QString rl,
                 QString r2f,QString r2fun,QString r2con,
                 QString a1,QString a2,QString a3,QString a4,QString a5,
                 QString p1,QString p2,QString p3,QString p4,QString p5)
        : rule1field(r1f),rule1function(r1fun),rule1context(r1con),rulelogic(rl),
          rule2field(r2f),rule2function(r2fun),rule2context(r2con),
          action1(a1),action2(a2),action3(a3),action4(a4),action5(a5),
          actionparam1(p1),actionparam2(p2),actionparam3(p3),actionparam4(p4),actionparam5(p5)
        {}

public:
        int ind;
        QString rule1field;
        QString rule1function;
        QString rule1context;

        QString rulelogic;

        QString rule2field;
        QString rule2function;
        QString rule2context;

        QString action1;
        QString action2;
        QString action3;
        QString action4;
        QString action5;
        QString actionparam1;
        QString actionparam2;
        QString actionparam3;
        QString actionparam4;
        QString actionparam5;
};

class MailFilterDialog : public QDialog
{
    Q_OBJECT

public:
    MailFilterDialog( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~MailFilterDialog();

    virtual void load();
    virtual void sync();

    void setAcCombo(QComboBox *,QComboBox *);
    QStringList getFolderList();

public slots:
    void slotNew();
    void slotDelete();
    void slotUp();
    void slotDown();
    void slotUpdate();
    void setCombo(QComboBox *box,QString text);
    void slotChanged();
    void slotAc1Changed();
    void slotAc2Changed();
    void slotAc3Changed();
    void slotAc4Changed();
    void slotAc5Changed();

public:
    int lastind;
    QList<FilterEl> filterList;

    QWidgetStack *wstack1;
    QWidgetStack *wstack2;
    QWidgetStack *wstack3;
    QWidgetStack *wstack4;
    QWidgetStack *wstack5;

    QComboBox *acel1;
    QComboBox *acel2;
    QComboBox *acel3;
    QComboBox *acel4;
    QComboBox *acel5;

    QListBox* list;
/*
    QPushButton* buttonNew;
    QPushButton* buttonUp;
    QPushButton* buttonDelete;
    QPushButton* buttonDown;
*/
    QToolButton* buttonNew;
    QToolButton* buttonUp;
    QToolButton* buttonDelete;
    QToolButton* buttonDown;

    QPushButton* buttonOk;
    QPushButton* buttonCancel;
    QLineEdit* comboContext1;
    QComboBox* comboField1;
    QComboBox* comboFunction2;
    QComboBox* comboLogic;
    QLineEdit* comboContext2;
    QComboBox* comboField2;
    QComboBox* comboFunction1;
    QComboBox* comboAction5;
    QComboBox* comboAction4;
    QComboBox* comboAction3;
    QComboBox* comboAction2;
    QComboBox* comboAction1;

protected:
    QGridLayout* MailFilterDialogLayout;
    QGridLayout* leftLayout;
    QHBoxLayout* bottomLayout;
    QGridLayout* rightTopLayout;
    QGridLayout* rightBottomLayout;
private:
    QStringList longFoldersList(QString folder);
};

#endif // MAILFILTERDIALOG_H

