/**
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <qdatetime.h>
#include <qstring.h>

#ifndef HAS_TOOLBOX_H
	#define HAS_TOOLBOX_H
	
//#warning Someone to verify if the times are correct.
//#warning All of them are in seconds.

#define TOOLBOX_SECOND		1
#define TOOLBOX_MINUTE		60
#define TOOLBOX_HOUR			3600
#define TOOLBOX_DAY				86400
#define TOOLBOX_WEEK			604800
#define TOOLBOX_YEAR			31536000

typedef struct Period
{
	QDateTime	start;
	long length;
	bool isFinished;
} Period;

/**
 *	This class is a collection of various methods (from miscfunctions)
 */
class Toolbox
{
public:
	enum IntervalType { DefaultTime=0, BeforeTime, AfterTime };
	enum Method { Publish=0, Request, Reply, Add, 
		Cancel, Refresh, Counter, DeclineCounter };
	enum TimeZone { UnknownTimeZone=0,
			UTCTimeZone };
	static const TimeZone GMTTimeZone=UTCTimeZone;
	static const TimeZone ZULUTimeZone=UTCTimeZone;

	QDateTime getDateTime(const QString &str, TimeZone &tz);
	QDateTime getDateTime(const QString &datetime, QString &tz);
	//QDateTime getDateTime(QString str);
	long getDateTimeOffset(const QString &str,IntervalType &offsetType);
	long getTimeOffset(const QString &str);
	QString extractNumbers(const QString &str, int pos);
	int getDays(long seconds);
	int getHours(long seconds);
	int getMinutes(long seconds);
	int getSeconds(long seconds);
	//set (converts xxxxx in seconds
	long setDays(int days);
	long setHours(int hours);
	long setMinutes(int minutes);
	long setSeconds(int seconds);
	Period parseString(const QString &period);
};


#endif
