/***************************************************************************
 *   Copyright (C) 2004 by Teemu Rytilahti                                 *
 *   tpr@d5k.net                                                           *
 *                                                                         *
 *   Licensed under GPL.                                                   *
 ***************************************************************************/

#ifndef KONQFEEDICON_H
#define KONQFEEDICON_H

#include <qguardedptr.h>
#include <kparts/plugin.h>
#include <kpopupmenu.h>
#include "feeddetector.h"
#include "pluginbase.h"

/**
@author Teemu Rytilahti
*/
class KURLLabel;
class KHTMLPart;
class QStringList;

namespace KParts {
    class StatusBarExtension;
}

namespace Akregator {
class KonqFeedIcon : public KParts::Plugin, PluginBase
{
    Q_OBJECT
public:
    KonqFeedIcon(QObject *parent, const char *name, const QStringList &);

    ~KonqFeedIcon();

private:
    /**
    * Tells you if there is feed(s) on the page.
    * @return true when there is feed(s) available
    */
    bool feedFound();

    QGuardedPtr<KHTMLPart> m_part;
    KURLLabel *m_feedIcon;
    KParts::StatusBarExtension *m_statusBarEx;
    FeedDetectorEntryList m_feedList;
    QGuardedPtr<KPopupMenu> m_menu;

private slots:
    void waitPartToLoad();
    void contextMenu();
    void addFeedIcon();
    void removeFeedIcon();
    void addFeeds();
    void addFeed(int id);
};

}
#endif
