# ---------------------------------------------------------------------------
# - t_7002.als                                                              -
# - aleph:net library test module                                           -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2001 amaury darsch                                   -
# ---------------------------------------------------------------------------

# @info   tcp server test module
# @author amaury darsch

# get the library
interp:library "aleph-net"
interp:library "aleph-sys"

# create a tcp server and loop to accept connection
const run-tcp-server nil {
  # create a tcp server on port 8000
  try {
    const srv (aleph:net:TcpServer 8000)
    # mark the server as created
    cv:mark
    # wait for a connection
    const s (srv:accept)
    # write a greeting string and close the connection
    s:writeln "hello world"
    # close this socket
    s:close
  } (aleph:sys:exit 1)
}

# create a condition variable
const cv (Condvar)
# run the tcp server in a daemon thread
daemon (run-tcp-server)
cv:wait-unlock

# create a tcp client object
const clt (aleph:net:TcpClient "localhost" 8000)
# read line and check greeting
assert "hello world" (clt:readln)
# close this client
clt:close
