// ---------------------------------------------------------------------------
// - Cookie.hpp                                                              -
// - aleph:www library - http cookie class definition                        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2001 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_COOKIE_HPP
#define  ALEPH_COOKIE_HPP

#ifndef  ALEPH_STRING_HPP
#include "String.hpp"
#endif

namespace aleph {

  /// The Cookie class is a simple class that defines a cookie to be sent
  /// to an http client. A cookie is a key/name pair associated with a 
  /// domain and an expiration date. Once the cookie is defined, it can
  /// be added to an html page.
  /// @author amaury darsch

  class Cookie : public Object {
  private:
    /// the cookie name
    String d_name;
    /// the value
    String d_value;
    /// the cookie path
    String d_path;
    /// the cookie domain
    String d_domain;
    /// the cookie comment
    String d_comment;
    /// the maximum age
    long d_mage;
    /// the secure flag
    bool d_secure;

  public:
    /// create a default cookie
    /// @param name the cookie name
    /// @param value the cookie value
    Cookie (const String& name, const String& value);

    /// create a default cookie with a maximum age
    /// @param name the cookie name
    /// @param value the cookie value
    /// @param mage the maximum age
    Cookie (const String& name, const String& value, long mage);

    /// @return the class name
    String repr (void) const;

    /// @return a hhtp cookie string representation
    String tostring (void) const;

    /// set the cookie name
    /// @param name the cookie name
    void setname (const String& name);

    /// @return the cookie name
    String getname (void) const;

    /// set the cookie value
    /// @param value the cookie value
    void setvalue (const String& value);

    /// @return the cookie value
    String getvalue (void) const;

    /// set the cookie maximum age
    /// @param mage the cookie maximum age
    void setmage (const long mage);

    /// @return the cookie maximum age
    long getmage (void) const;

    /// set the cookie path
    /// @param path the cookie path
    void setpath (const String& path);

    /// @return the cookie path
    String getpath (void) const;

    /// set the cookie domain
    /// @param domain the cookie domain
    void setdomain (const String& domain);

    /// @return the cookie domain
    String getdomain (void) const;

    /// set the cookie comment
    /// @param comment the cookie comment
    void setcomment (const String& comment);

    /// @return the cookie comment
    String getcomment (void) const;

    /// set the cookie secure flag
    /// @param comment the cookie comment
    void setsecure (const bool flag);

    /// @return the cookie secure flag
    bool getsecure (void) const;

    /// generate a new cookie
    /// @param argv the argument vector
    static Object* mknew (Vector* argv);

    /// apply this cookie with a set of arguments and a quark
    /// @param robj  robj the current runnable
    /// @param nset  the current nameset    
    /// @param quark the quark to apply these arguments
    /// @param argv  the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, const long quark,
                   Vector* argv);

  private:
    // make the copy constructor private
    Cookie (const Cookie&);
    // make the assignment operator private
    Cookie& operator = (const Cookie&);
  };
}

#endif
