// ---------------------------------------------------------------------------
// - Aodopts.hpp                                                             -
// - aleph object database - options class definition                        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_AODOPTS_HPP
#define  ALEPH_AODOPTS_HPP

#ifndef  ALEPH_STRVEC_HPP
#include "Strvec.hpp"
#endif

namespace aleph {

  /// The Aodopts class is the class used by the aleph object database
  /// shell interface. The instance is simply created with the standard 
  /// main program arguments.
  /// @author amaury darsch

  class Aodopts {
  private:
    /// the argument list
    Strvec d_argv;
    /// the paths list
    Strvec d_path;
    /// the initial file name
    String d_fname;
    /// the assert flag
    bool d_assert;

  public:
    /// create a new option class from the main arguments
    /// @param argc the number of arguments
    /// @param argv the argument array
    Aodopts (int argc, char** argv);

    /// @return the string vector of arguments
    const Strvec& getargs (void) const;

    /// @return the string vector of paths
    const Strvec& getpath (void) const;

    /// @return the assert flag
    bool getassert (void) const;

    /// @return the optional file name
    String getfname (void) const;

  private:
    // make the copy constructor private
    Aodopts (const Aodopts&);
    // make the assignment operator private
    Aodopts& operator = (const Aodopts&);
  };
}

#endif
