//
// Althea.h  --  The main class, from which everything is accessed
// -- created  4/16/00   updated 4/19/00
//////////////////////////////////////////////////

#ifndef ALTHEA_H
#define ALTHEA_H
namespace std {};
using namespace std;

#include <gtk/gtk.h>
#include <list>
#include <iostream.h>
#include "Server.h"
#include "Addressbook.h"
#include "Configuration.h"

class Filter
{
 public:
 string field;
 string filter_string;
 string folder;
 Filter( string t_field, string t_filter_string, string t_folder )
   {
     field = t_field;
     filter_string=t_filter_string;
     folder=t_folder;
   };
};






class Althea
{
private:
    list<Server> server_list;
    Addressbook address_book;
    GtkWidget *folder_list;
    GtkWidget *message_list;
    GtkWidget *config_server_list;
    GtkWidget *config_filter_list;
    GtkWidget *message_text;
    GtkWidget *main_window;    
    Configuration *config;
    Server *current_server;
    Server *config_current_server;
    Filter *config_current_filter;
    Folder *current_folder;
    Message *current_message;
    char verbose;
    GtkWidget *attach_list;

    
public:
    list<Filter> filter_list;
    GtkWidget *register_window;
    list<GtkWidget *> promptwindows;
    // Copying
    void Althea_to_config ();
    void config_to_Althea ();
    // Accessors
    int get_Num_Servers();
    Server * get_Server( const string & name);
    Server * get_Server( int index );
    GtkWidget *get_folder_list();
    GtkWidget *get_message_list();
    GtkWidget *get_Server_Config_List();
    GtkWidget *get_Filter_Config_List();
    GtkWidget *get_attach_list();
    GtkWidget *get_message_text();
    GtkWidget *get_main_window();
    Configuration *get_config();
    Server * get_Current_Server();
    Server * get_Config_Current_Server();
    Filter * get_Config_Current_Filter();
    Folder * get_Current_Folder();
    Message * get_Current_Message();
    char get_Verbose();    
    bool is_Current_Server();
    bool is_Current_Folder();
    bool is_Current_Message();
    list<Server> get_Server_List();


    // Mutators
    void set_Server_List (list<Server> serverlist);
    void set_folder_list( GtkWidget *folder_list );
    void set_attach_list( GtkWidget *attach_list );
    void set_message_list( GtkWidget *message_list );
    void set_Server_Config_List( GtkWidget *server_config_list );
    void set_Filter_Config_List( GtkWidget *filter_config_list );
    void set_message_text( GtkWidget *message_text );
    void set_main_window( GtkWidget *main_window );
    void set_config( Configuration * );
    void set_Current_Server( Server * );
    void set_Config_Current_Server( Server * );
    void set_Config_Current_Filter( Filter * );
    void set_Current_Folder( Folder * );
    void set_Current_Message( Message * );
    void set_Verbose( char );
    
    // List-related functions
    void add_Server( const Server & S);
    void add_Filter( const Filter & F);
    void delete_Server( const string & name);
    void delete_Filter( const string & name);

    // Debugging purposes only
    void display( );
    void display_filters();

};

#endif    







