//
//  about_window.cpp  --  generate an "about" window
//  -- created 5/23/00  updated 5/23/00
///////////////////////////////////////////////

#include "about_window.h"

GtkWidget*
create_about_window (void)
{
  GtkWidget *about_window;
  GtkWidget *vbox1;
  GtkWidget *pixmap1;
  GtkWidget *version;
  GtkWidget *ok_button;

  about_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (about_window), "about_window", about_window);
  gtk_window_set_title (GTK_WINDOW (about_window), "About Althea");
  gtk_window_set_default_size (GTK_WINDOW (about_window), 300, 300);
  gtk_window_set_policy (GTK_WINDOW (about_window), FALSE, FALSE, FALSE);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (about_window), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (about_window), vbox1);

  pixmap1 = create_pixmap (about_window, "althea.xpm");
  gtk_widget_ref (pixmap1);
  gtk_object_set_data_full (GTK_OBJECT (about_window), "pixmap1", pixmap1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pixmap1);
  gtk_box_pack_start (GTK_BOX (vbox1), pixmap1, TRUE, TRUE, 0);
  gtk_misc_set_padding (GTK_MISC (pixmap1), 2, 0);
  
  string version_string = *new string();
  version_string = "Version ";
  version_string += VERSION;
  version = gtk_label_new (version_string.c_str());
  gtk_widget_ref (version);
  gtk_object_set_data_full (GTK_OBJECT (about_window), "version", version,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (version);
  gtk_box_pack_start (GTK_BOX (vbox1), version, FALSE, FALSE, 0);

  ok_button = gtk_button_new_with_label ("Ok");
  gtk_widget_ref (ok_button);
  gtk_object_set_data_full (GTK_OBJECT (about_window), "ok_button", ok_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (ok_button);
  gtk_box_pack_start (GTK_BOX (vbox1), ok_button, FALSE, FALSE, 0);

  gtk_signal_connect_object( GTK_OBJECT (ok_button), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy), 
                             GTK_OBJECT (about_window) );
                             
  gtk_widget_grab_focus (ok_button);

  return about_window;
}

