# C.3 What determines the distribution between labour and capital?

In short, class struggle determines the distribution of income between classes
(As Proudhon put it, the expression _"the relations of profits to wages"_
means _"the war between labour and capital."_ [**System of Economical
Contradictions**, p. 130]). This, in turn, is dependent on the balance of
power within any given economy at any given time.

Given our analysis of the source of surplus value in [section
C.2.2](secC2.html#secc22), this should come as no surprise. Given the central
role of labour in creating both goods (things with value) and surplus value,
production prices determine market prices. This means that market prices are
governed, however indirectly, by what goes on in production. In any company,
wages determine a large percentage of the production costs. Looking at other
costs (such as raw materials), again wages play a large role in determining
their price. Obviously the division of a commodity's price into costs and
profits is not a fixed ratio, which mean that prices are the result of complex
interactions of wage levels and productivity. Within the limits of a given
situation, the class struggle between employers and employees over wages,
working conditions and benefits determines the degree of exploitation within a
society and so the distribution of income, i.e. the relative amount of money
which goes to labour (i.e. wages) and capital (surplus value).

To quote libertarian socialist Cornelius Castoriadis:

> _ "Far from being completely dominated by the will of the capitalist and
forced to increase indefinitely the yield of labour, production is determined
just as much by the workers' individual and collective resistance to such
increases. The extraction of 'use value form labour power' is not a technical
operation; it is a process of bitter struggle in which half the time, so to
speak, the capitalists turn out to be losers.  
>  _

>

> _"The same thing holds true for living standards, i.e., real wage levels.
From its beginnings, the working class has fought to reduce the length of the
workday and to raise wage levels. It is this struggle that has determined how
these levels have risen and fallen over the years . . . _

>

> _"Neither the actual labour rendered during an hour of labour time nor the
wage received in exchange for this work can be determined by any kind of
'objective' law, norm, or calculation . . . What we are saying does not mean
that specifically economic or even 'objective' factors play no real in
determining wage levels. Quite the contrary. At any given instant, the class
struggle comes into play only within a given economic -- and, more generally,
objective -- framework, and it acts not only directly but also through the
intermediary of a series of partial 'economic mechanisms.' To give only one
example among thousands, an economic victory for workers in one sector has a
ripple effect on overall wage levels, not only because it can encourage other
workers to be more combative, but also because sectors with lower wage levels
will experience greater difficulties recruiting manpower. None of these
mechanisms, however, can effectively act on its own and have its own
significance if taken separately from the class struggle. And the economic
context itself is always gradually affected one way or another by this
struggle."_ [**Political and Social Writings**, vol. 2, p. 248]

The essential point is that the extraction of surplus value from workers is
not a simple technical operation, as implied by the neo-classical perspective
(and, ironically, classical Marxism as Castoriadis explains in his classic
work _"Modern Capitalism and Revolution"_ [**Op. Cit.**, pp. 226-343]). As
noted previously, unlike the extraction of so many joules from a ton of coal,
extracting surplus value ("use value") from labour power involves conflict
between people, between classes. Labour power is unlike all other commodities
- it is and remains inseparably embodied in human beings. This means that the
division of profits and wages in a company and in the economy as a whole is
dependent upon and modified by the actions of workers (and capitalists), both
as individuals and as a class. It is this struggle which, ultimately, drives
the capitalist economy, it is this conflict between the human and commodity
aspects of labour power that ultimately brings capitalism into repeated crisis
(see [section C.7](secC7.html)).

From this perspective, the neo-classical argument that a factor in production
(labour, capital or land) receives an income share that indicates its
productive power "at the margin" is false. Rather, it is a question of power
-- and the willingness to use it. As Christopher Eaton Gunn points out, the
neo-classical argument _"take[s] no account of power -- of politics, conflict,
and bargaining -- as more likely indicators of relative shares of income in
the real world."_ [**Workers' Self-Management in the United States**, p. 185]
Ultimately, working class struggle is an _"indispensable means of raising
their standard of living or defending their attained advantages against the
concerted measures of the employers."_ It is _"not only a means for the
defence of immediate economic interests, it is also a continuous schooling for
their powers of resistance, showing them every day that every last right has
to be won by unceasing struggle against the existing system."_ [Rocker,
**Anarcho-Syndicalism**, p. 78]

If the power of labour is increasing, its share in income will tend to
increase and, obviously, if the power of labour decreased it would fall. And
the history of the post-war economy supports such an analysis, with labour in
the advanced countries share of income falling from 68% in the 1970s to 65.1%
in 1995 (in the EU, it fell from 69.2% to 62%). In the USA, labour's share of
income in the manufacturing sector fell from 74.8% to 70.6% over the 1979-89
period, reversing the rise in labour's share that occurred over the 1950s,
1960s and 1970s. The reversal in labour's share occurred at the same time as
labour's power was undercut by right-wing governments who have pursued
business friendly "free market" policies to combat "inflation" (an euphemism
for working class militancy and resistance) by undermining working class power
and organisation by generating high unemployment.

Thus, for many anarchists, the relative power between labour and capital
determines the distribution of income between them. In periods of full
employment or growing workplace organisation and solidarity, workers wages
will tend to rise faster. In periods where there is high unemployment and
weaker unions and less direct action, labour's share will fall. From this
analysis anarchists support collective organisation and action in order to
increase the power of labour and ensure we receive more of the value we
produce.

The neo-classical notion that rising productivity allows for increasing wages
is one that has suffered numerous shocks since the early 1970s. Usually wage
increases lag behind productivity. For example, during Thatcher's reign of
freer markets, productivity rose by 4.2%, 1.4% higher than the increase in
real earnings between 1980-88. Under Reagan, productivity increased by 3.3%,
accompanied by a fall of 0.8% in real earnings. Remember, though, these are
averages and hide the actual increases in pay differentials between workers
and managers. To take one example, the real wages for employed single men
between 1978 and 1984 in the UK rose by 1.8% for the bottom 10% of that group,
for the highest 10%, it was a massive 18.4%. The average rise (10.1%) hides
the vast differences between top and bottom. In addition, these figures ignore
the starting point of these rises -- the often massive differences in wages
between employees (compare the earnings of the CEO of McDonalds and one of its
cleaners). In other words, 2.8% of nearly nothing is still nearly nothing!

Looking at the USA again, we find that workers who are paid by the hour (the
majority of employees) saw their average pay peak in 1973. Since then, it had
declined substantially and stood at its mid-1960s level in 1992. For over 80
per cent of the US workforce (production and non-supervisory workers), real
wages have fallen by 19.2 per cent for weekly earnings and 13.4 per cent for
hourly earnings between 1973 and 1994. Productivity had risen by 23.2 per
cent. Combined with this drop in real wages in the USA, we have seen an
increase in hours worked. In order to maintain their current standard of
living, working class people have turned to both debt and longer working
hours. Since 1979, the annual hours worked by middle-income families rose from
3 020 to 3 206 in 1989, 3 287 in 1996 and 3 335 in 1997. In Mexico we find a
similar process. Between 1980 and 1992, productivity rose by 48 per cent while
salaries (adjusted for inflation) fell by 21 per cent.

Between 1989 to 1997, productivity increased by 9.7% in the USA while median
compensation decreased by 4.2%. In addition, median family working hours grew
by 4% (or three weeks of full-time work) while its income increased by only
0.6 % (in other words, increases in working hours helped to create this slight
growth). If the wages of workers were related to their productivity, as argued
by neo-classical economics, you would expect wages to increase as productivity
rose, rather than fall. However, if wages are related to economic power, then
this fall is to be expected. This explains the desire for "flexible" labour
markets, where workers' bargaining power is eroded and so more income can go
to profits rather than wages.

It is amazing how far the US in 2005, the paradigm for neo-liberalism, is from
the predictions of neo-classical economic textbooks. Since the 1970s, there
has only been one period of sustained good times for working people, the late
1990s. Before and after this period, there has been wage stagnation (between
2000 and 2004, for example, the real median family income **fell** by 3%).
While the real income of households in the lowest fifth grew by 6.1% between
1979 and 2000, the top fifth saw an increase of 70% and the average income of
the top 1% grew by 184%. This rising inequality was fuelled by the expansion
of income from capital and an increased concentration of capital income in the
top 1% (who received 57.5% of all capital income in 2003, compared to 37.8% in
1979). This reflected the increased share of income flowing to corporate
profits (profits rates in 2005 were the highest in 36 years). If the pre-tax
return to capital had remained at its 1979 level, then hourly compensation
would have been 5% higher. In 2005 dollars, this represents an annual transfer
of $235 billion from labour to capital. [Lawrence Mishel, Jered Bernstein, and
Sylvia Allegretto, **The State of Working America 2006/7**, pp. 2-3]

Labour's share of income in the corporate sector fell from 82.1% in 179 to
81.1% in 1989, and then to 79.1% in 2005. However, this fall is even worse for
labour as labour income _"includes the pay of Chief Executive Officers (CEOs),
thereby overstating the income share going to 'workers' and understating
'profits,' since the bonuses and stock options given CEOs are more akin to
profits than wages"_ and so _"some of the profits are showing up in CEO
paychecks and are counted as worker pay."_ [**Op. Cit.**, p. 83 and p. 84]

Unsurprisingly, there has been a _"stunning disconnect between the rapid
productivity growth and pay growth,"_ along with a _"tremendous widening of
the wage gap between those at the top of the wage scale, particularly
corporate chief executive officers [CEO], and other wage earners."_ Between
1979 and 1995, wages _"were stagnant or fell for the bottom 60% of wage
earners"_ and grew by 5% for the 80th percentile. Between 1992 and 2005, saw
median CEO pay rise by 186.2% while the media worker saw only a 7.2% rise in
their wages. Wealth inequality was even worse, with the wealth share of the
bottom 80% shrinking by 3.8 percentage points (which was gained by the top 5%
of households). Using the official standard of poverty, 11.3% of Americans
were in poverty in 2000, rising to 12.7% in 2004 (_"This is the first time
that poverty rose through each of the first three years of a recovery"_).
However, the official poverty line is hopelessly out of date (for a family of
four it was 48% of median family income in 1960, in 2006 it is 29%). Using a
threshold of twice the official value sees an increase in poverty from 29.3%
to 31.2% [**Op. Cit.**, p. 4, p. 5, p. 7, p. 9 and p. 11]

Of course, it will be argued that only in a perfectly competitive market (or,
more realistically, a truly "free" one) will wages increase in-line with
productivity. However, you would expect that a regime of **freer** markets
would make things better, not worse. This has not happened. The neo-classical
argument that unions, struggling over wages and working conditions will harm
workers in the "long run" has been dramatically refuted since the 1970s -- the
decline of the labour movement in the USA has been marked by falling wages,
not rising ones, for example. Despite of rising productivity, wealth has
**not** "trickled down" -- rather it has flooded up (a situation only
surprising to those who believe economic textbooks or what politicians say).
In fact, between 1947 and 1973, the median family income rose by 103.9% while
productivity rose by 103.7% and so wages and productivity went hand-in-hand.
Since the mid-1970s this close mapping broke down. From 1973 to 2005,
productivity rose by 75.5% while income increased by a mere 21.8%, less than
one-third the rate of productivity (from 2000 to 2004, productivity rose by
14% while family income fell by 2.9%). This wedge is the source of rising
inequality, with the upper classes claiming most of the income growth. [**Op.
Cit.**, p. 46]

All of which refutes those apologists for capitalism who cite the empirical
fact that, in a modern capitalist economy, a large majority of all income goes
to "labour," with profit, interest and rent adding up to something under
twenty percent of the total. Of course, even if surplus value were less than
20% of a workers' output, this does not change its exploitative nature (just
as, for the capitalist apologist, taxation does not stop being "theft" just
because it is around 10% of all income). However, this value for profit,
interest and rent is based on a statistical sleight-of-hand, as "worker" is
defined as including everyone who has a salary in a company, including
managers and CEOs. The large incomes which many managers and all CEOs receive
would, of course, ensure that a large majority of all income does go to
"labour." Thus this "fact" ignores the role of most managers as de facto
capitalists and their income represents a slice of surplus value rather than
wages. This sleight-of-hand also obscures the results of this distribution for
while the 70% of "labour" income goes into many hands, the 20% representing
surplus value goes into the hands of a few. So even if we ignore the issue of
CEO "wages", the fact is that a substantial amount of money is going into the
hands of a small minority which will, obviously, skew income, wealth and
economic power away from the vast majority.

To get a better picture of the nature of exploitation within modern capitalism
we have to compare workers wages to their productivity. According to the World
Bank, in 1966, US manufacturing wages were equal to 46% of the value-added in
production (value-added is the difference between selling price and the costs
of raw materials and other inputs to the production process). In 1990, that
figure had fallen to 36% and by 1993, to 35%. Figures from the 1992 Economic
Census of the US Census Bureau indicate it had reached 19.76% (39.24% if we
take the **total** payroll which includes managers and so on). In the US
construction industry, wages were 35.4% of value added in 1992 (with total
payroll, 50.18%). Therefore the argument that because a large percentage of
income goes to "labour" capitalism is fine hides the realities of that system
and the exploitation its hierarchical nature creates.

Overall, since the 1970s working class America has seen stagnating income,
rising working hours and falling social (i.e. income-class) mobility while, at
the same time, productivity has been rising and inequality soaring. While this
may come as a surprise (or be considered a paradox by capitalist economics, a
paradox usually to be justified and rationalised id acknowledged at all)
anarchists consider this to be a striking confirmation of their analysis.
Unsurprisingly, in a hierarchical system those at the top do better than those
at the bottom. The system is set up so that the majority enrich the minority.
That is way anarchists argue that workplace organisation and resistance is
essential to maintain -- and even increase -- labour's income. For if the
share of income between labour and capital depends on their relative power --
and it does -- then only the actions of workers themselves can improve their
situation and determine the distribution of the value they create.

This analysis obviously applied **within** classes as well. At any time, there
is a given amount of unpaid labour in circulation in the form of goods or
services representing more added value than workers were paid for. This given
sum of unpaid labour (surplus value) represents a total over which the
different capitalists, landlords and bankers fight over. Each company tries to
maximise its share of that total, and if a company does realise an above-
average share, it means that some other companies receive less than average.

The key to distribution within the capitalist class is, as between that class
and the working class, power. Looking at what is normally, although somewhat
inaccurately, called monopoly this is obvious. The larger the company with
respect to its market, the more likely it is to obtain a larger share of the
available surplus, for reasons discussed later (see [section
C.5](secC5.html)). While this represents a distribution of surplus value
**between** capitalists based on market power, the important thing to note
here is that while companies compete on the market to realise their share of
the total surplus (unpaid labour) the **source** of these profits does not lie
in the market, but in production. One cannot buy what does not exist and if
one gains, another loses.

Market power also plays a key role in producing inflation, which has its roots
in the ability of firms to pass cost increases to consumers in the form of
higher prices. This represents a distribution of income from lenders to
borrowers, i.e. from finance capital to industrial capital and labour to
capital (as capital "borrows" labour, i.e. the workers are paid **after** they
have produced goods for their bosses). How able capitalists are to pass on
costs to the general population depends on how able they are to withstand
competition from other companies, i.e. how much they dominate their market and
can act as a price setter. Of course, inflation is not the only possible
outcome of rising costs (such as wage rises). It is always possible to reduce
profits or increase the productivity of labour (i.e. increase the rate of
exploitation). The former is rarely raised as a possibility, as the underlying
assumption seems to be that profits are sacrosanct, and the latter is
dependent, of course, on the balance of forces within the economy.

In the next section, we discuss why capitalism is marked by big business and
what this concentrated market power means to the capitalist economy.

[‹ C.2 Why is capitalism exploitative?](/afaq/secC2.html "Go to previous page"
) [up](/afaq/secCcon.html "Go to parent page" ) [C.4 Why does the market
become dominated by Big Business? ›](/afaq/secC4.html "Go to next page" )

