# I.4 How could an anarchist economy function?

This is an important question facing all opponents of a given system -- what
will you replace it with? We can say, of course, that it is pointless to make
blueprints of how a future anarchist society will work as the future will be
created by everyone, not just the few anarchists and libertarian socialists
who write books and FAQs. This is very true, we cannot predict what a free
society will actually be like or develop and we have no intention to do so
here. However, this reply (whatever its other merits) ignores a key point,
people need to have some idea of what anarchism aims for before they decide to
spend their lives trying to create it.

So, how would an anarchist system function? That depends on the economic ideas
people have. A mutualist economy will function differently than a communist
one, for example, but they will have similar features. As Rudolf Rocker put
it:

> _"Common to all Anarchists is the desire to free society of all political
and social coercive institutions which stand in the way of development of a
free humanity. In this sense Mutualism, Collectivism and Communism are not to
be regarded as closed systems permitting no further development, but merely as
economic assumptions as to the means of safeguarding a free community. There
will even probably be in society of the future different forms of economic co-
operation operating side by side, since any social progress must be associated
with that free experiment and practical testing out for which in a society of
free communities there will be afforded every opportunity."_ [**Anarcho-
Syndicalism**, p. 9]

So given the common ideals and aims of anarchists, it is unsurprising that the
economic systems we suggest have common features such as workers' self-
management, federation, free agreement and so on (as discussed in [last
section](secI3.html)). For all anarchists, the _"task for a modern industrial
society is to achieve what is now technically realisable, namely, a society
which is really based on free voluntary participation of people who produce
and create, live their lives freely within institutions they control, and with
limited hierarchical structures, possibly none at all."_ [Noam Chomsky, quoted
by Albert and Hahnel, **Looking Forward**, p. 62]

This achieved by means of _"voluntary association that will organise labour,
and be the manufacturer and distributor of necessary commodities"_ and this
_"**is to make what is useful. The individual is to make what is
beautiful.**"_ [Oscar Wilde, **The Soul of Man Under Socialism**, p. 1183] For
example, the machine _"will supersede hand-work in the manufacture of plain
goods. But at the same time, hand-work very probably will extend its domain in
the artistic finishing of many things which are made entirely in the
factory."_ [Peter Kropotkin, **Fields, Factories and Workplaces Tomorrow**, p.
152] Murray Bookchin, decades later, argued for the same idea: _"the machine
will remove the toil from the productive process, leaving its artistic
completion to man."_ [**Post-Scarcity Anarchism**, p. 134]

The aim would be to maximise the time available for individuals to express and
development their individuality, including in production. As Stirner put it,
the _"organisation of labour touches only such labours as others can do for
us. . . the rest remain egoistic, because no one can in your stead elaborate
your musical compositions, carry out your projects of painting, etc.; nobody
can replace Raphael's labours. The latter are labours of a unique person,
which only he is competent to achieve."_ Criticising the authoritarian
socialists of his time, Stirner went on to ask _"for whom is time to be gained
[by association]? For what does man require more time than is necessary to
refresh his wearied powers of labour? Here Communism is silent."_ He then
answers his own question by arguing it is gained for the individual _"[t]o
take comfort in himself as unique, after he has done his part as man!"_ [**The
Ego and Its Own**, p. 268 and p. 269] Which is exactly what libertarian
communists argue:

> _"[We] recognise that man [sic!] has other needs besides food, and as the
strength of Anarchy lies precisely in that it understands **all** human
faculties and **all** passions, and ignores none, we shall . . . contrive to
satisfy all his intellectual and artistic needs . . . the man [or woman] who
will have done the four or five hours of . . . work that are necessary for his
existence, will have before him five or six hours which his will seek to
employ according to tastes . . . _

> _"He will discharge his task in the field, the factory, and so on, which he
owes to society as his contribution to the general production. And he will
employ the second half of his day, his week, or his year, to satisfy his
artistic or scientific needs, or his hobbies."_ [Kropotkin, **Conquest of
Bread**, pp. 110-1]

Thus, while **authoritarian** Communism ignores the unique individual (and
that was the only kind of Communism existing when Stirner wrote his classic
book) **libertarian** communists agree with Stirner and are not silent. Like
him, they consider the whole point of organising labour is to provide the
means of providing the individual with the time and resources required to
express their individuality. In other words, to pursue _"labours of a unique
person."_ Thus all anarchists base their arguments for a free society on how
it will benefit actual individuals, rather than abstracts or amorphous
collectives (such as "society"). Hence chapter 9 of **The Conquest of Bread**,
_"The Need for Luxury"_ and, for that matter, chapter 10, _"Agreeable Work."_

In other words, anarchists desire to organise voluntary workers associations
which will try to ensure a minimisation of mindless labour in order to
maximise the time available for creative activity both inside and outside
"work." This is to be achieved by free co-operation between equals, which is
seen as being based on self-interest. After all, while capitalist ideology may
proclaim that competition is an expression of self-interest it, in fact,
results in the majority of people sacrificing themselves for the benefits of
the few who own and control society. The time you sell to a boss in return for
them ordering you about and keeping the product of your labour is time you
never get back. Anarchists aim to end a system which crushes individuality and
create one in which solidarity and co-operation allow us time to enjoy life
and to gain the benefits of our labour ourselves. Mutual Aid, in other words,
results in a better life than mutual struggle and so _"the **association for
struggle** will be a much more effective support for civilisation, progress,
and evolution than is the **struggle for existence** with its savage daily
competitions."_ [Luigi Geallani, **The End of Anarchism**, p. 26]

In the place of the rat race of capitalism, economic activity in an anarchist
society would be one of the means to humanise and individualise ourselves and
society, to move from **surviving** to **living.** Productive activity should
become a means of self-expression, of joy, of art, rather than something we
have to do to survive. Ultimately, "work" should become more akin to play or a
hobby than the current alienated activity. The priorities of life should be
towards individual self-fulfilment and humanising society rather than
_"running society as an adjunct to the market,"_ to use Polanyi's expression,
and turning ourselves into commodities on the labour market. Thus anarchists
agree with John Stuart Mill:

> _"I confess I am not charmed with an ideal of life held out by those who
think that the normal state of human beings is that of struggling to get on;
that the trampling, crushing, elbowing, and treading on each other's heels,
which form the existing type of social life, are the most desirable lot of
human kind, or anything but the disagreeable symptoms of one of the phases of
industrial progress."_ [**Collected Works**, vol. III, p. 754]

The aim of anarchism is far more than the end of inequality. Hence Proudhon's
comment that socialism's _"underlying dogma"_ is that the _"objective of
socialism is the liberation of the proletariat and the eradication of
poverty."_ This emancipation would be achieved by ending _"wage-labour"_ via
_"democratically organised workers' associations."_ [**Property is Theft!**,
p. 372 and p. 377] Or, to use Kropotkin's expression, _"well-being for all"_
\-- physical, mental, emotional and ethical! Indeed, by concentrating on just
poverty and ignoring the emancipation of the proletariat, the real aims of
socialism are obscured:

> _"The 'right to well-being' means the possibility of living like human
beings, and of bringing up children to be members of a society better than
ours, whilst the 'right to work' only means the right to be a wage-slave, a
drudge, ruled over and exploited by the middle class of the future. The right
to well-being is the Social Revolution, the right to work means nothing but
the Treadmill of Commercialism. It is high time for the worker to assert his
right to the common inheritance, and to enter into possession of it."_
[Kropotkin, **Op. Cit.**, p. 44]

So, while refusing to define exactly how an anarchist system will work, we
will explore the implications of how the anarchist principles and ideals
outlined above could be put into practice. Bear in mind that this is just a
possible framework for a system which has few historical examples to draw
upon. This means that we can only indicate the general outlines of what an
anarchist society could be like. Those seeking blue-prints and exactness
should look elsewhere. In all likelihood, the framework we present will be
modified and changed (even ignored) in light of the real experiences and
problems people will face when creating a new society.

We should point out that there may be a tendency for some to compare this
framework with the **theory** of capitalism (i.e. perfectly functioning "free"
markets or quasi-perfect ones) as opposed to its reality. A perfectly working
capitalist system only exists in text books and in the heads of ideologues who
take the theory as reality. No system is perfect, particularly capitalism, and
to compare "perfect" text-book capitalism with any real system is a pointless
task. As we discussed in depth in [section C](secCcon.html), capitalist
economics does not even describe the reality of capitalism so why think it
would enlighten discussion of post-capitalist systems? What hope does it have
of understanding post-capitalist systems which reject its proprietary
despotism and inequalities? As anarchists aim for a qualitative change in our
economic relationships, we can safely say that its economic dynamics will
reflect the specific forms it will develop rather than those produced by a
class-ridden hierarchical system like capitalism and the a-historic
individualistic abstractions invented to defend it!

So any attempt to apply the notions developed from theorising about (or, more
correctly, justifying and rationalising) capitalism to anarchism will fail to
capture the dynamics of a non-capitalist system. John Crump stressed this
point in his discussion of Japanese anarchism between the World Wars:

> _"When considering the feasibility of the social system advocated by the
pure anarchists, we need to be clear about the criteria against which it
should be measured. It would, for example, be unreasonable to demand that it
be assessed against such yardsticks of a capitalist economy as annual rate of
growth, balance of trade and so forth . . . evaluating anarchist communism by
means of the criteria which have been devised to measure capitalism's
performance does not make sense . . . capitalism would be . . . baffled if it
were demanded that it assess its operations against the performance indicators
to which pure anarchists attached most importance, such as personal liberty,
communal solidarity and the individual's unconditional right to free
consumption. Faced with such demands, capitalism would either admit that these
were not yardsticks against which it could sensibly measure itself or it would
have to resort to the type of grotesque ideological subterfuges which it often
employs, such as identifying human liberty with the market and therefore with
wage slavery . . . The pure anarchists' confidence in the alternative society
they advocated derived not from an expectation that it would
**quantitatively** outperform capitalism in terms of GNP, productivity or
similar capitalist criteria. On the contrary, their enthusiasm for anarchist
communism flowed from their understanding that it would be **qualitatively**
different from capitalism. Of course, this is not to say that the pure
anarchists were indifferent to questions of production and distribution . . .
they certainly believed that anarchist communism would provide economic well-
being for all. But neither were they prepared to give priority to narrowly
conceived economic expansion, to neglect individual liberty and communal
solidarity, as capitalism regularly does."_ [**Hatta Shuzo and Pure Anarchism
in Interwar Japan**, pp. 191-3]

Finally, anarchists are well aware that transforming how an economy works does
not happen overnight. As discussed in [section I.2.2](secI2.html#seci22), we
have long rejected the idea of instantaneous social transformation and argued
that revolution will take time to develop and change the legacy of centuries
of class and hierarchical society. This transformation and the resulting
changes in people and surroundings can only be achieved by the full
participation of all in overcoming the (many) problems a free society will
face and the new ways of relating to each other liberation implies. A free
people will find their own practical solutions to their problems, for _"there
will be all sorts of practical difficulties to overcome, but the [libertarian
socialist] system is simplicity itself compared with the monster of
centralised State control, which sets such an inhuman distance between the
worker and the administrator that there is room for a thousand difficulties to
intervene."_ [Herbert Read, **Anarchy and Order**, p. 49] Thus, for
anarchists, the _"enthusiasm generated by the revolution, the energies
liberated, and the inventiveness stimulated by it must be given full freedom
and scope to find creative channels."_ [Alexander Berkman, **What is
Anarchism?**, p. 223] As such, the ideas within this section of our FAQ are
merely suggestions, possibilities.

## I.4.1 What is the point of economic activity in anarchy?

The basic point of economic activity is an anarchist society is to ensure, to
use Kropotkin's expression, **_"well-being for all"_**. Rather than toil to
make the rich richer, people in a free society would work together to _"ensure
to society as a whole its life and further development."_ Such an economy
would be based upon _"giving society the greatest amount of useful products
with the least waste of human energy"_, to meet _"the needs of mankind"_.
[**The Conquest of Bread**, p. 43, p. 144 and p. 175] Needless to say, today
we must also add: with the least disruption of nature.

In terms of needs, it should be stressed that these are not limited to just
material goods (important as they may be, particularly to those currently
living in poverty). Needs also extend to having meaningful work which you
control, pleasant and ecologically viable surroundings, the ability to express
oneself freely within and outwith work, and a host of other things associated
with the quality of life rather than merely survival. Anarchism seeks to
transform economic activity rather than merely liberate it by self-management
(important as that is).

Therefore, for anarchists, _"[r]eal wealth consists of things of utility and
beauty, in things that help create strong, beautiful bodies and surroundings
inspiring to live in."_ Anarchism's _"goal is the freest possible expression
of all the latent powers of the individual"_ and this _"is only possible in a
state of society where man [sic!] is free to choose the mode of work, the
conditions of work, and the freedom to work. One whom making a table, the
building of a house, or the tilling of the soil is what the painting is to the
artist and the discovery to the scientist -- the result of inspiration, of
intense longing, and deep interest in work as a creative force."_ [Emma
Goldman, **Red Emma Speaks**, p. 67 and p. 68]

So the point of economic activity in an anarchist society is to produce as and
when required and not, as under capitalism, to organise production for the
sake of production in order to make profits for the few. Production, to use
Kropotkin's words, is to become _"the mere servant of consumption; it must
mould itself on the wants of the consumer, not dictate to him [or her]
conditions."_ [**Act For Yourselves**, p. 57] This should **not** be taken to
imply that anarchism seeks production for the sake of production in order to
meet all the needs of all. Far from it, as such a regime would, to quote
Malatesta, involve _"employing **all** of one's strength in producing things,
because taken literally, this would mean working until one is exhausted, which
would mean that by maximising the satisfaction of human needs we destroy
humanity."_ In other words, a free society would take into account the wants
of the producers (and the planet we live on) when meeting the wants of
consumers. Thus, there would be a balance sought. _"What we would like,"_
continued Malatesta, _"is for everybody to live in the best possible way: so
that everybody with a minimum amount of effort will obtain maximum
satisfaction."_ [**At the Café**, p. 61]

So while the basic aim of economic activity in an anarchist society is,
obviously, producing wealth -- i.e., satisfying individual needs -- without
enriching capitalists or other parasites in the process, it is far more than
that. Yes, an anarchist society will aim to create society in which everyone
will have a standard of living suitable for a fully human life. Yes, it will
aim to eliminate poverty, inequality, individual want and social waste and
squalor, but it aims for far more than that. It aims to create free
individuals who express their individuality within and outwith "work." After
all, what is the most important thing that comes out of a workplace? Pro-
capitalists may say profits, others the finished commodity or good. In fact,
the most important thing that comes out of a workplace is the **worker.** What
happens to us in the workplace will have an impact on all aspects of our life
and so cannot be ignored.

To value "efficiency" above all else, as capitalism says it does (it, in fact,
values **profits** above all else and hinders developments like workers'
control which increase efficiency but harm power and profits), is to deny our
own humanity and individuality. Without an appreciation for grace and beauty
there is no pleasure in creating things and no pleasure in having them. Our
lives are made drearier rather than richer by "progress." How can a person
take pride in their work when skill and care are considered luxuries (if not
harmful to "efficiency" and, under capitalism, the profits and power of the
capitalist and manager)? We are not machines. We have a need for
craftspersonship and anarchism recognises this and takes it into account in
its vision of a free society. This means that, in an anarchist society,
economic activity is the process by which we produce what is useful but, in
addition, is also beautiful (to use Oscar Wilde's words) in a way that
empowers the individual. We anarchists charge capitalism with wasting human
energy and time due to its irrational nature and workings, energy that could
be spent creating what is beautiful (both in terms of individualities and
products of labour). Under capitalism we are _"toiling to live, that we may
live to toil."_ [William Morris, **Useful Work Versus Useless Toil**, p. 37]

In addition, we must stress that the aim of economic activity within an
anarchist society is **not** to create equality of outcome -- i.e. everyone
getting exactly the same goods. As we noted in [section
A.2.5](secA2.html#seca25), such a "vision" of "equality" attributed to
socialists by pro-capitalists indicates more the poverty of imagination and
ethics of the critics of socialism than a true account of socialist ideas.
Anarchists, like other genuine socialists, support **social** equality in
order to maximise freedom, including the freedom to choose between options to
satisfy ones needs. To treat people equally, as equals, means to respect their
desires and interests, to acknowledge their right to equal liberty. To make
people consume the same as everyone else does not respect the equality of all
to develop ones abilities as one sees fit. Socialism means equality of
opportunity to satisfy desires and interests, not the imposition of an
abstract minimum (or maximum) on unique individuals. To treat unique
individuals equally means to acknowledge that uniqueness, not to deny it.

Thus the **real** aim of economic activity within an anarchy is to ensure
_"that every human being should have the material and moral means to develop
his humanity."_ [Michael Bakunin, **The Political Philosophy of Bakunin**, p.
295] And you cannot develop your humanity if you cannot express yourself
freely. Needless to say, to treat unique people "equally" (i.e. identically)
is simply evil. You cannot, say, have a 70 year old woman do the same work in
order to receive the same income as a 20 year old man. No, anarchists do not
subscribe to such "equality," which is a product of the _"ethics of
mathematics"_ of capitalism and **not** of anarchist ideals. Such a scheme is
alien to a free society. The equality anarchists desire is a social equality,
based on control over the decisions that affect you. The aim of anarchist
economic activity, therefore, is to provide the goods required for _"equal
freedom for all, an equality of conditions such as to allow everyone to do as
they wish."_ [Errico Malatesta, **Errico Malatesta: His Life and Ideas**, p.
49] Thus anarchists _"demand not natural but social equality of individuals as
the condition for justice and the foundations of morality."_ [Bakunin, **Op.
Cit.**, p. 249]

Under capitalism, instead of humans controlling production, production
controls them. Anarchists want to change this and desire to create an economic
network which will allow the maximisation of an individual's free time in
order for them to express and develop their individuality (while creating what
is beautiful). So instead of aiming just to produce because the economy will
collapse if we did not, anarchists want to ensure that we produce what is
useful in a manner which liberates the individual and empowers them in all
aspects of their lives.

This desire means that anarchists reject the capitalist definition of
"efficiency." Anarchists would agree with Albert and Hahnel when they argue
that _"since people are conscious agents whose characteristics and therefore
preferences develop over time, to access long-term efficiency we must access
the impact of economic institutions on people's development."_ Capitalism, as
we have explained before, is highly inefficient in this light due to the
effects of hierarchy and the resulting marginalisation and disempowerment of
the majority of society. As they go on to note, _"self-management, solidarity,
and variety are all legitimate valuative criteria for judging economic
institutions . . . Asking whether particular institutions help people attain
self-management, variety, and solidarity is sensible."_ [**The Political
Economy of Participatory Economics**, p. 9]

In other words, anarchists think that any economic activity in a free society
is to do useful things in such a way that gives those doing it as much
pleasure as possible. The point of such activity is to express the
individuality of those doing it, and for that to happen they must control the
work process itself. Only by self-management can work become a means of
empowering the individual and developing his or her powers.

In a nutshell, to use the words of William Morris, useful work will replace
useless toil in an anarchist society.

## I.4.2 Why do anarchists desire to abolish work?

Anarchists desire to see humanity liberate itself from work. This may come as
a shock for many people and will do much to "prove" that anarchism is
essentially utopian. However, we think that such an abolition is not only
necessary, it is possible. This is because work as we know it today is one of
the major dangers to freedom we face.

If by freedom we mean self-government, then it is clear that being subjected
to hierarchy in the workplace subverts our abilities to think and judge for
ourselves. Like any skill, critical analysis and independent thought have to
be practised continually in order to remain at their full potential. So a
workplace environment with power structures undermines these abilities. This
was recognised by Adam Smith who argued that the _"understandings of the
greater part of men are necessarily formed by their ordinary employments."_
That being so, _"the man whose life is spent in performing a few simple
operations, of which the effects too are, perhaps, always the same, or nearly
the same, has no occasion to extend his understanding . . . and generally
becomes as stupid and ignorant as it is possible for a human creature to be .
. . But in every improved and civilised society this is the state into which
the labouring poor, that is the great body of the people, must necessarily
fall, unless government takes pains to prevent it."_ [quoted by Noam Chomsky,
**Year 501**, p. 18]

Smith's argument (usually ignored by those who claim to follow his ideas) is
backed up by extensive evidence. Different types of authority structures and
different technologies have different effects on those who work within them.
Carole Pateman notes that the evidence suggests that _"[o]nly certain work
situations were found to be conducive to the development of the psychological
characteristics"_ suitable for freedom, such as _"the feelings of personal
confidence and efficacy that underlay the sense of political efficacy."_
[**Participation and Democratic Theory**, p. 51] She quotes one expert who
argues that within capitalist companies based upon a highly rationalised work
environment and extensive division of labour, the worker has no control over
the pace or technique of his work, no room to exercise skill or leadership and
so they _"have practically no opportunity to solve problems and contribute
their own ideas."_ The worker, according to a psychological study, is
_"resigned to his lot . . . more dependent than independent . . . he lacks
confidence in himself . . . he is humble . . . the most prevalent feeling
states . . . seem to be fear and anxiety."_ [quoted by Pateman, **Op. Cit.**,
p. 51 and p. 52]

The evidence Pateman summarises shows that an individual's _"attitudes will
depend to a large degree on the authority structure of his [or her] work
environment"_, with workplaces which are more autocratic and with a higher
division of labour being worse for an individual's sense of self-esteem,
feelings of self-worth and autonomy. In workplaces where _"the worker has a
high degree of personal control over his [or her] work . . . and a very large
degree of freedom from external control"_ or is based on the _"collective
responsibility of a crew of employees"_ who _"had control over the pace and
method of getting the work done, and the work crews were largely internally
self-disciplining"_ a different social character is seen. [Pateman, **Op.
Cit.**, pp. 52-3] This was characterised by _"a strong sense of individualism
and autonomy, and a solid acceptance of citizenship in the large society"_ and
_"a highly developed feeling of self-esteem and a sense of self-worth and is
therefore ready to participate in the social and political institutions of the
community."_ Thus the _"nature of a man's work affects his social character
and personality"_ and that an _"industrial environment tends to breed a
distinct social type."_ [R. Blauner, quoted by Pateman, **Op. Cit.**, p. 52]

Thus, to quote Bob Black (who notes that Smith's comments against the division
of labour are his _"critique of work"_), the capitalist workplace turns us
into _"stultified submissives"_ and places us _"under the sort of surveillance
that ensures servility."_ For this reason anarchists desire, to use Bob
Black's phrase, _"the abolition of work."_ [**The Abolition of Work and other
essays**, p. 26, p. 22 and p. 19]

Work, in this context, does not mean any form of productive activity. Far from
it. Work (in the sense of doing necessary things or productive activity) will
always be with us. There is no getting away from it; crops need to be grown,
schools built, homes fixed, and so on. No, work in this context means any form
of labour in which the worker does not control his or her own activity. In
other words, **wage labour** in all its many forms.

A society based upon hierarchical relations in production will result in a
society within which the typical worker uses few of their abilities, exercise
little or no control over their work because they are governed by a boss
during working hours. This has been proved to lower the individual's self-
esteem and feelings of self-worth, as would be expected in any social
relationship that denied self-government. Capitalism is marked by an extreme
division of labour, particularly between mental and physical labour. It
reduces the worker to a mere machine operator, following the orders of his or
her boss. Therefore, a libertarian that does not support economic liberty
(i.e. self-management) is no libertarian at all.

Capitalism bases its rationale for itself on consumption and this results in a
viewpoint which minimises the importance of the time we spend in productive
activity. Anarchists consider that it is essential for individuals to use and
develop their unique attributes and capacities in all walks of life, to
maximise their powers. Therefore, the idea that "work" should be ignored in
favour of consumption is totally mad. Productive activity is an important way
of developing our inner-powers and expressing ourselves; in other words, be
creative. Capitalism's emphasis on consumption shows the poverty of that
system. As Alexander Berkman argued:

> _"We do not live by bread alone. True, existence is not possible without
opportunity to satisfy our physical needs. But the gratification of these by
no means constitutes all of life. Our present system of disinheriting
millions, made the belly the centre of the universe, so to speak. But in a
sensible society . . . [t]he feelings of human sympathy, of justice and right
would have a chance to develop, to be satisfied, to broaden and grow."_
[**What is Anarchism?**, pp. 152-3]

Therefore, capitalism is based on a constant process of alienated consumption,
as workers try to find the happiness associated within productive, creative,
self-managed activity in a place it does not exist -- on the shop shelves.
This can partly explain the rise of both mindless consumerism and the
continuation of religions, as individuals try to find meaning for their lives
and happiness, a meaning and happiness frustrated in wage labour and other
hierarchies.

Capitalism's impoverishment of the individual's spirit is hardly surprising.
As William Godwin argued, _"[t]he spirit of oppression, the spirit of
servility, and the spirit of fraud, these are the immediate growth of the
established administration of property. They are alike hostile to intellectual
and moral improvement."_ [**The Anarchist Reader**, p. 131] Any system based
on hierarchical relationships in work will result in a deadening of the
individual and in a willingness to defer to economic masters. Which is why
Anarchists desire to change this and create a society based upon freedom in
all aspects of life. Hence anarchists desire to abolish work, simply because
it restricts the liberty and distorts the individuality of those who have to
do it. To quote Emma Goldman:

> _"Anarchism aims to strip labour of its deadening, dulling aspect, of its
gloom and compulsion. It aims to make work an instrument of joy, of strength,
of colour, of real harmony, so that the poorest sort of a man should find in
work both recreation and hope."_ [**Anarchism and Other Essays**, p. 61]

Anarchists do not think that by getting rid of work we will not have to
produce necessary goods. Far from it. An anarchist society _"doesn't mean we
have to stop doing things. It does mean creating a new way of life based on
play; in other words, a ludic revolution . . . a collective adventure in
generalised joy and freely interdependent exuberance. Play isn't passive."_
The aim is _"to abolish work and replace it, insofar as it serves useful
purposes, with a multitude of new kinds of free activities. To abolish work
requires going at it from two directions, quantitative and qualitative."_ In
terms of the first, _"we need to cut down massively the amount of working
being done"_ (luckily, _"most work is useless or worse and we should simply
get rid of it"_). For the second, _"we have to take what useful work remains
and transform it into a pleasing variety of game-like and craft-like pastimes,
indistinguishable from other pleasurable pastimes, except that they happen to
yield useful end-products."_ [Bob Black, **Op. Cit.**, p. 17 and p. 28]

This means that in an anarchist society every effort would be made to reduce
boring, unpleasant activity to a minimum and ensure that whatever productive
activity is required to be done is as pleasant as possible and based upon
voluntary labour. However, it is important to remember Cornelius Castoriadis
point: _"Socialist society will be able to reduce the length of the working
day, and will have to do so, but this will not be the fundamental
preoccupation. Its first task will be to . . . transform the very nature of
work. The problem is not to leave more and more 'free' time to individuals --
which might well be **empty** time -- so that they may fill it at will with
'poetry' or the carving of wood. The problem is to make all time a time of
liberty and to allow concrete freedom to find expression in creative
activity."_ Essentially, the _"problem is to put poetry into work."_
[**Political and Social Writings**, vol. 2, p. 107]

This is why anarchists desire to abolish "work" (i.e., productive activity not
under control of the people doing it), to ensure that whatever productive
economic activity is required to be done is managed by those who do it. In
this way it can be liberated, transformed, and so become a means of self-
realisation and not a form of self-negation. In other words, anarchists want
to abolish work because _"[l]ife, the art of living, has become a dull
formula, flat and inert."_ [Berkman, **Op. Cit.**, p. 166] Anarchists want to
bring the spontaneity and joy of life back into productive activity and save
humanity from the dead hand of capital. Anarchists consider economic activity
as an expression of the human spirit, an expression of the innate human need
to express ourselves and to create. Capitalism distorts these needs and makes
economic activity a deadening experience by the division of labour and
hierarchy. We think that _"industry is not an end in itself, but should only
be a means to ensure to man his material subsistence and to make accessible to
him the blessings of a higher intellectual culture. Where industry is
everything and man is nothing begins the realm of a ruthless economic
despotism whose workings are no less disastrous than those of any political
despotism. The two mutually augment one another, and they are fed from the
same source."_ [Rudolph Rocker, **Anarcho-Syndicalism**, p. 2]

One last point on the abolition of work. May 1st -- International Workers' Day
-- was, as we discussed in [section A.5.2](secA5.html#seca52), created to
commemorate the Chicago Anarchist Martyrs. Anarchists then, as now, think that
it should be celebrated by strike action and mass demonstrations. In other
words, for anarchists, International Workers' Day should be a non-work day!
That sums up the anarchist position to work nicely -- that the celebration of
workers' day should be based on the rejection of work.

The collection of articles in **Why Work? Arguments for the Leisure Society**
(edited by Vernon Richards) is a useful starting place for libertarian
socialist perspectives on work.

## I.4.3 How do anarchists intend to abolish work?

Basically by workers' self-management of production and common ownership of
the means of production. It is hardly in the interests of those who do the
actual "work" to have bad working conditions, boring, repetitive labour, and
so on. Therefore, a key aspect of the liberation from work is to create a
self-managed society, _"a society in which everyone has equal means to develop
and that all are or can be at the same time intellectual and manual workers,
and the only differences remaining between men [and women] are those which
stem from the natural diversity of aptitudes, and that all jobs, all
functions, give an equal right to the enjoyment of social possibilities."_
[Errico Malatesta, **Anarchy**, p. 42]

Essential to this task is decentralisation and the use of appropriate
technology. Decentralisation is important to ensure that those who do work can
determine how to liberate it. A decentralised system will ensure that ordinary
people can identify areas for technological innovation and so understand the
need to get rid of certain kinds of work. Unless ordinary people understand
and control the introduction of technology, then they will never be fully
aware of the benefits of technology and resist advances which may be in their
best interests to introduce. This is the full meaning of appropriate
technology, namely the use of technology which those most affected feel to be
best in a given situation. Such technology may or may not be technologically
"advanced" but it will be of the kind which ordinary people can understand
and, most importantly, control.

The potential for rational use of technology can be seen from capitalism.
Under capitalism, technology is used to increase profits, to expand the
economy, not to liberate **all** individuals from useless toil (it does, of
course, liberate a few from such "activity"). As economist Juliet B. Schor
points out, productivity _"measures the goods and services that result from
each hour worked. When productivity rises, a worker can either produce the
current output in less time, or remain at work the same number of hours and
produce more."_ With rising productivity, we are presented with the
possibility of more free time. For example, since 1948 the level of
productivity of the American worker _"has more than doubled. In other words,
we could now produce our 1948 standard of living . . . . in less than half the
time it took that year. We could actually have chosen the four-hour day. Or a
working year of six months."_ [**The Overworked American**, p. 2]

And, remember, these figures include production in many areas of the economy
that would not exist in a free society -- state and capitalist bureaucracy,
weapons production for the military, property defence, the finance sector, and
so on. As Alexander Berkman argued, millions are _"engaged in trade, . . .
advertisers, and various other middlemen of the present system"_ along with
the armed forces and _"the great numbers employed in unnecessary and harmful
occupations, such as building warships, the manufacture of ammunition and
other military equipment"_ would be _"released for useful work by a
revolution."_ [**What is Anarchism**, pp. 224-5] So the working week will be
reduced simply because more people will be available for doing essential work.
Moreover, goods will be built to last and so much production will become
sensible and not governed by an insane desire to maximise profits at the
expense of everything else. In addition, this is not taking into account the
impact of a more just distribution of consumption in terms of living standards
and production, meaning that a standard of living produced by working half the
time would be far higher than that implied by Schor's 1948 baseline (not to
mention the advances in technology since then either!). In short, do not take
the 1948 date as implying a literal return to that period!

Moreover, a lower working week would see productivity rising. _"Thus,"_ as one
economist summarises, _"when the hours of labour were reduced, the better-
rested workers were often able to produce as much or more in the shorter hours
than they had previously in longer hours."_ Yet _"competition between
employers would make it unlikely that a working day of optimal length would be
established"_ under capitalism. In addition, _"more disposable time might
better contribute to people's well-being -- that is, to things such as trust,
health, learning, family life, self-reliance and citizenship"_. While this may
reduce such conventional economic measures as GDP, the fact is that such
measures are flawed. After all, _"an increase in GDP could represent a
diminution of free time accompanied by an increased output of goods and
services whose sole utility was either facilitating labour-market
participation or repairing some of the social damage that resulted from the
stress of overwork or neglect of non-market activity."_ [Tom Walker, _"Why
Economists dislike a Lump of Labor"_, pp. 279-91, **Review of Social
Economy**, vol. 65, No. 3, p. 286, pp. 287-8 and p. 288]

All this suggests the level of production for useful goods with a four-hour
working day would be much higher than the 1948 level or, of course, the
working day could be made even shorter. As such, we can easily combine a
decent standard of living with a significant reduction of the necessary
working time required to produce it. Once we realise that much work under
capitalism exists to manage aspects of the profit system or are produced as a
result of that system and the damage it does, we can see how a self-managed
society can give us more time for ourselves in addition to producing useful
goods (rather than working long and hard to produce surplus value for the
few).

However, anarchists do not see it as simply a case of reducing the hours of
work while keeping the remaining work as it is. That would be silly. We aim to
transform what useful productive activity is left. When self-management
becomes universal we will see the end of division of labour as mental and
physical work becomes unified and those who do the work also manage it. This
will allow _"the free exercise of **all** the faculties of man"_ both inside
and outside "work." [Peter Kropotkin, **The Conquest of Bread**, p. 148] The
aim of such a development would be to turn productive activity, as far as
possible, into an enjoyable experience. In the words of Murray Bookchin it is
the **quality** and **nature** of the work process that counts:

> _"If workers' councils and workers' management of production do not
transform the work into a joyful activity, free time into a marvellous
experience, and the workplace into a community, then they remain merely formal
structures, in fact, **class** structures. They perpetuate the limitations of
the proletariat as a product of bourgeois social conditions. Indeed, no
movement that raises the demand for workers' councils can be regarded as
revolutionary unless it tries to promote sweeping transformations in the
environment of the work place."_ [**Post-Scarcity Anarchism**, p. 88]

Work will become, primarily, the expression of a person's pleasure in what
they are doing and become like an art -- an expression of their creativity and
individuality. Work as an art will become expressed in the workplace as well
as the work process, with workplaces transformed and integrated into the local
community and environment (see [section I.4.15](secI4.html#seci415)). This
will obviously apply to work conducted in the home as well, otherwise the
_"revolution, intoxicated with the beautiful words, Liberty, Equality,
Solidarity, would not be a revolution if it maintained slavery at home. Half
[of] humanity subjected to the slavery of the hearth would still have to rebel
against the other half."_ [Kropotkin, **Op. Cit.**, p. 128]

In other words, anarchists desire _"to combine the best part (in fact, the
only good part) of work -- the production of use-values -- with the best of
play . . . its freedom and its fun, its voluntariness and its intrinsic
gratification"_. In short, the transformation of production (creating _"what
seems needful"_") into _"**productive play**_". [Bob Black, _"Smokestack
Lightning"_, **Friendly Fire**, p. 48 and p. 49]

Workers' self-management of production (see [section
I.3.2](secI3.html#seci32)) would be the means of achieving this. Only those
subject to a specific mode of working can be in a position to transform it and
their workplace into something fit for free individuals to create in. Only
those who know a workplace which would only exist in a hierarchical system
like capitalism can be in a position to decommission it safely and quickly.
The very basis of free association will ensure the abolition of work, as
individuals will apply for "work" they enjoy doing and so would be interested
in reducing "work" they did not want to do to a minimum. Therefore, an
anarchist society would abolish work by ensuring that those who do it actually
control it. _"Personal initiative will be encouraged and every tendency to
uniformity and centralisation combated."_ [Kropotkin, quoted by Martin Buber,
**Paths in Utopia**, p. 42]

All this does not imply that anarchists think that individuals will not seek
to "specialise" in one form of productive activity rather than another. Far
from it, people in a free society will pick activities which interest them as
the main focal point of their means of self-expression (after all, not
everyone enjoys the same games and pastimes so why expect the same of
productive play?). _"It is evident,"_ noted Kropotkin, _"that all men and
women cannot equally enjoy the pursuit of scientific work. The variety of
inclinations is such that some will find more pleasure in science, some others
in art, and others again in some of the numberless branches of the production
of wealth."_ This "division of work" is commonplace in humanity this natural
desire to do what interests you and what you are good at will be encouraged in
an anarchist society. As Kropotkin argued, anarchists _"fully recognise the
necessity of specialisation of knowledge, but we maintain that specialisation
must follow general education, and that general education must be given in
science and handicraft alike. To the division of society into brain workers
and manual workers we oppose the combination of both kinds of activities . . .
we advocate the **education integrale** [integral education], or complete
education, which means the disappearance of that pernicious division."_
Anarchists are, needless to say, aware that training and study are required to
qualify you to do some tasks and a free society would ensure that individuals
would achieve the necessary recognised levels before undertaking them (by
means of, say, professional bodies who organise a certification process).
Kropotkin was aware, however, that both individuals and society would benefit
from a diversity of activities and a strong general knowledge: _"But whatever
the occupations preferred by everyone, everyone will be the more useful in his
[or her] branch if he [or she] is in possession of a serious scientific
knowledge. And, whosoever he might be . . . he would be the gainer if he spent
a part of his life in the workshop or the farm (the workshop **and** the
farm), if he were in contact with humanity in its daily work, and had the
satisfaction of knowing that he himself discharges his duties as an
unprivileged producer of wealth."_ [**Fields, Factories and Workshops
Tomorrow**, p. 186, p. 172 and p. 186]

However, while specialisation would continue, the permanent division of
individuals into manual or brain workers would be eliminated. Individuals will
manage all aspects of the "work" required (for example, engineers will also
take part in self-managing their workplaces), a variety of activities would be
encouraged and the strict division of labour of capitalism will be abolished.
In other words, anarchists want to replace the division of labour by the
division of work. We must stress that we are not playing with words here. John
Crump presents a good summary of the ideas of the Japanese anarchist Hatta
Shuzo on this difference:

> _"[We must] recognise the distinction which Hatta made between the 'division
of labour' . . . and the 'division of work' . . . while Hatta believed that
the division of labour . . . was the cause of class divisions and
exploitation, he did not see anything sinister in the division of work . . .
On the contrary, Hatta believed that the division of work was a benign and
unavoidable feature of any productive process: 'it goes without saying that
within society, whatever the kind of production, there has to be a division of
work.' . . . [For] the dangers [of division of labour] to which Hatta [like
other anarchists like Proudhon and Kropotkin] drew attention did not arise
from a situation where, at any one time, different people were engaged in
different productive activities . . . What did spell danger, however, was
when, either individually or collectively, people permanently divided along
occupational lines . . . and gave rise to the disastrous consequences . . . .
[of] the degrading of labour to a mechanical function; the lack of
responsibility for, understanding of, or interest in other branches of
production; and the need for a superior administrative organ to co-ordinate
the various branches of production."_ [**Hatta Shuzo and Pure Anarchism in
Interwar Japan**, pp. 146-7]

As Kropotkin argued:

> _"while a **temporary** division of functions remains the surest guarantee
of success in each separate undertaking, the **permanent** division is doomed
to disappear, and to be substituted by a variety of pursuits -- intellectual,
industrial, and agricultural -- corresponding to the different capacities of
the individual, as well as to the variety of capacities within every human
aggregate."_ [**Op. Cit.**, p. 26]

As an aside, supporters of capitalism argue that **integrated** labour must be
more inefficient than **divided** labour as capitalist firms have not
introduced it. This is false for numerous reasons.

Firstly, we have to point out the inhuman logic of the assertion. After all,
few would argue in favour of slavery if it were, in fact, **more** productive
than wage labour but such is the logical conclusion of this argument. If
someone did argue that the only reason slavery was not the dominant mode of
labour simply because it was inefficient we would consider them as less than
human. Simply put, it is a sick ideology which happily sacrifices individuals
for the sake of slightly more products. Sadly, that is what many defenders of
capitalism do, ultimately, argue for.

Secondly, capitalist firms are not neutral structures but rather a system of
hierarchies, with entrenched interests and needs. Managers will only introduce
a work technique that maintains their power (and so their profits). As we
argue in [section J.5.12](secJ5.html#secj512), while experiments in workers'
participation see a rise in efficiency and productivity, managers stop them
simply because they recognise that workers' control undercuts their power by
empowering workers who then can fight for a greater slice of the value they
produce (not to mention come to the conclusion that while the boss needs them
to work, they don't need to boss to manage them!). So the lack of integrated
labour under capitalism simply means that it does not empower management nor
secure their profits and power, **not** that it is less efficient.

Thirdly, the attempts by managers and bosses to introduce "flexibility" by
eliminating unions suggests that integration **is** more efficient. After all,
one of the major complaints directed towards union contracts are that they
explicitly documented what workers could and could not do (for example, union
members would refuse to do work which was outside their agreed job
descriptions). This is usually classed as an example of the evil of
regulations. However, if we look at it from the viewpoint of contract and
division of labour, it exposes the inefficiency and inflexibility of both as a
means of co-operation. After all, what does this refusal actually mean? It
means that the worker refuses to do work that is not specified in his or her
contract! Their job description indicates what they have been contracted to do
and anything else has not been agreed upon in advance. The contract specifies
a clear, specified and agreed division of labour in a workplace between worker
and boss.

While being a wonderful example of a well-designed contract, managers
discovered that they could not operate their workplaces because of them.
Rather, they needed a general "do what you are told" contract (which of course
is hardly an example of contract reducing authority) and such a contract
**integrates** numerous work tasks into one. The managers diatribe against
union contracts suggests that production needs some form of integrated labour
to actually work (as well as showing the hypocrisy of the labour contract
under capitalism as labour "flexibility" simply means labour "commodification"
-- a machine does not question what its used for, the ideal under capitalism
is a similar unquestioning nature for labour). The union job description
indicates that production needs the integration of labour while demanding a
division of work. As Cornelius Castoriadis argued:

> _"Modern production has destroyed many traditional professional
qualifications. It has created automatic or semi-automatic machines. It has
thereby itself demolished its own traditional framework for the industrial
division of labour. It has given birth to a universal worker who is capable,
after a relatively short apprenticeship, of using most machines. Once one gets
beyond its class aspects, the 'posting' of workers to particular jobs in a big
modern factory corresponds less and less to a genuine division of **labour**
and more and more to a simple division of tasks. Workers are not allocated to
given areas of the productive process and then riveted to them because their
'occupational skills' invariably correspond to the 'skills required' by
management. They are placed there . . . just because a particular vacancy
happened to exist."_ [**Political and Economic Writings**, vol. 2, p. 117]

By replacing the division of labour with the division of work, a free society
will ensure that productive activity can be transformed into an enjoyable task
(or series of tasks). By integrating labour, all the capacities of the
producer can be expressed so eliminating a major source of alienation and
unhappiness in society. _"The main subject of social economy,"_ argued
Kropotkin, is _"the **economy** of energy required for the satisfaction of
**human needs.**"_ These needs obviously expressed both the needs of the
producers for empowering and interesting work and their need for a healthy and
balanced environment. Thus Kropotkin discussed the _"advantages"_ which could
be _"derive[d] from a combination of industrial pursuits with intensive
agriculture, and of brain work with manual work."_ The _"greatest sum total of
well-being can be obtained when a variety of agricultural, industrial and
intellectual pursuits are combined in each community; and that man [and woman]
shows his best when he is in a position to apply his usually-varied capacities
to several pursuits in the farm, the workshop, the factory, the study or the
studio, instead of being riveted for life to one of these pursuits only."_
[**Op. Cit.**, pp. 17-8] This means that _"[u]nder socialism, factories would
have no reason to accept the artificially rigid division of labour now
prevailing. There will be every reason to encourage a rotation of workers
**between shops and departments** and between production and office areas."_
The _"residues of capitalism's division of labour gradually will have to be
eliminated"_ as _"socialist society cannot survive unless it demolishes this
division."_ [Castoriadis, **Op. Cit.**, p. 117]

Anarchists think that a decentralised social system will allow "work" to be
abolished and economic activity humanised and made a means to an end (namely
producing useful things and liberated individuals). This would be achieved by,
as Rudolf Rocker puts it, the _"alliance of free groups of men and women based
on co-operative labour and a planned administration of things in the interest
of the community."_ However, as things are produced by people, it could be
suggested that this implies a _"planned administration of people"_ (although
few who suggest this danger apply it to capitalist firms which are like mini-
centrally planned states). This objection is false simply because anarchism
aims _"to reconstruct the economic life of the peoples from the ground up and
build it up anew in the spirit of Socialism"_ and, moreover, _"only the
producers themselves are fitted for this task, since they are the only value-
creating element in society out of which a new future can arise."_ Such a
reconstructed economic life would be based on anarchist principles, that is
_"based on the principles of federalism, a free combination from below
upwards, putting the right of self-determination of every member above
everything else and recognising only the organic agreement of all on the basis
of like interests and common convictions."_ [**Anarcho-Syndicalism**, p. 72,
p. 62 and p. 60]

In other words, those who produce also administer and so govern themselves in
free association (and it should be pointed out that any group of individuals
in association will make "plans" and "plan", the important question is who
does the planning and who does the work. Only in anarchy are both functions
united into the same people). The _"planned administration of things"_ would
be done by the producers **themselves,** in their independent groupings. This
would likely take the form (as we indicated in [section I.3](secI3.html)) of
confederations of syndicates who communicate information between themselves
and respond to changes in the production and distribution of products by
increasing or decreasing the required means of production in a co-operative
(i.e. _"planned"_) fashion. No "central planning" or "central planners"
governing the economy, just workers co-operating together as equals (as
Kropotkin argued, free socialism _"must result from thousands of separate
local actions, all directed towards the same aim. It cannot be dictated by a
central body: it must result from the numberless local needs and wants."_
[**Act for Yourselves**, p. 54]).

Now, any form of association requires agreement. Therefore, even a society
based on the communist-anarchist maxim _"from each according to their ability,
to each according to their need"_ will need to make agreements in order to
ensure co-operative ventures succeed. In other words, members of a co-
operative commonwealth would have to make and keep to their agreements between
themselves. This means that the members of a syndicate would agree joint
starting and finishing times, require notice if individuals want to change
"jobs" and so on within and between syndicates. Any joint effort requires some
degree of co-operation and agreement. Moreover, between syndicates, an
agreement would be reached (in all likelihood) that determined the minimum
working hours required by all members of society able to work. As Kropotkin
argued, a communist anarchist society would be based upon the such a minimum-
hour "contract" between its members:

> _"We undertake to give you the use of our houses, stores, streets, means of
transport, schools, museums, etc., on condition that, from twenty to forty-
five or fifty years of age, you consecrate four or five hours a day to some
work recognised as necessary to existence. Choose yourself the producing group
which you wish to join, or organise a new group, provided that it will
undertake to produce necessaries. And as for the remainder of your time,
combine together with whomsoever you like, for recreation, art, or science,
according to the bent of your taste . . . Twelve or fifteen hundred hours of
work a year . . . is all we ask of you. For that amount of work we guarantee
to you the free use of all that these groups produce, or will produce."_
[**The Conquest of Bread**, pp. 153-4]

With such work _"necessary to existence"_ being recognised by individuals and
expressed by demand for labour from productive syndicates. It is, of course,
up to the individual to decide which work he or she desires to perform from
the positions available in the various associations in existence. A union card
could be the means by which work hours would be recorded and access to the
common wealth of society ensured. And, of course, individuals and groups are
free to work alone and exchange the produce of their labour with others,
including the confederated syndicates, if they so desired. An anarchist
society will be as flexible as possible.

Therefore, we can imagine a social anarchist society being based on two basic
arrangements -- firstly, an agreed minimum working week of, say, 16 hours, in
a syndicate of your choice, plus any amount of hours doing "work" which you
feel like doing -- for example, art, scientific experimentation, DIY, playing
music, composing, gardening and so on. How that minimum working week was
actually organised would vary between workplace and commune, with work times,
flexi-time, job rotation and so on determined by each syndicate (for example,
one syndicate may work 8 hours a day for 2 days, another 4 hours a day for 4
days, one may use flexi-time, another more rigid starting and stopping times).
Needless to say, in response to consumption patterns, syndicates will have to
expand or reduce production and will have to attract volunteers to do the
necessary work as would syndicates whose work was considered dangerous or
unwanted. In such circumstances, volunteers could arrange doing a few hours of
such activity for more free time or it could be agreed that one hour of such
unwanted positions equals more hours in a more desired one (see [section
I.4.13](secI4.html#seci413) for more on this). Needless to say, the aim of
technological progress would be to eliminate unpleasant and unwanted tasks and
to reduce the basic working week more and more until the very concept of
necessary "work" and free time enjoyments is abolished. Anarchists are
convinced that the decentralisation of power within a free society would
unleash a wealth of innovation and ensure that unpleasant tasks are minimised
and fairly shared while required productive activity is made as pleasant and
enjoyable as possible.

It could be said that this sort of agreement is a restriction of liberty
because it is "man-made" (as opposed to the "natural law" of "supply and
demand"). This is a common defence of the non-capitalist market by
individualist anarchists against anarcho-communism, for example. However,
while in theory individualist-anarchists can claim that in their vision of
society, they don't care when, where, or how a person earns a living, as long
as they are not invasive about it the fact is that any economy is based on
interactions between individuals. The law of "supply and demand" easily, and
often, makes a mockery of the ideas that individuals can work as long as they
like - usually they end up working as long as required by market forces (i.e.
the actions of other individuals, but turned into a force outwith their
control, see [section I.1.3](secI1.html#seci13)). This means that individuals
do not work as long as they like, but as long as they have to in order to
survive. Knowing that "market forces" is the cause of long hours of work
hardly makes them any nicer.

And it seems strange to the communist-anarchist that certain free agreements
made between equals can be considered authoritarian while others are not. The
individualist-anarchist argument that social co-operation to reduce labour is
"authoritarian" while agreements between individuals on the market are not
seems illogical to social anarchists. They cannot see how it is better for
individuals to be pressured into working longer than they desire by "invisible
hands" than to come to an arrangement with others to manage their own affairs
to maximise their free time.

Therefore, free agreement between free and equal individuals is considered the
key to abolishing work, based upon decentralisation of power and the use of
appropriate technology.

## I.4.4 What economic decision making criteria could be used in anarchy?

Firstly, it should be noted that anarchists do not have any set idea about the
answer to this question. Most anarchists are communists, desiring to see the
end of money, but that does not mean they want to impose communism onto
people. Far from it, communism can only be truly libertarian if it is
organised from the bottom up. So, anarchists would agree with Kropotkin that
it is a case of not _"determining in advance what form of distribution the
producers should accept in their different groups -- whether the communist
solution, or labour checks, or equal salaries, or any other method"_ while
considering a given solution best in their opinion. [**Anarchism**, p. 166]
Free experimentation is a key aspect of anarchism.

While certain anarchists have certain preferences on the social system they
want to live in and so argue for that, they are aware that objective
circumstances and social desires will determine what is introduced during a
revolution (for example, while Kropotkin was a communist-anarchist and
considered it essential that a revolution proceed towards communism as quickly
as possible, he was aware that it was unlikely it would be introduced fully
immediately -- see [section I.2.2](secI2.html#seci22) for details). However,
we will outline some possible means of economic decision making criteria as
this question is an important one and so we will indicate what possible
solutions exist in different forms of anarchism.

In a mutualist or collectivist system, the answer is easy. Prices will exist
and be used as a means of making decisions (although, as Malatesta suggested,
such non-communist anarchies would _"seek a way to ensure that money truly
represents the useful work performed by its possessors"_ rather than, as
today, _"the means for living on the labour of others"_ [**Errico Malatesta:
His Life and Ideas**, p. 101 and p. 100]). Mutualism will be more market
orientated than collectivism, with collectivism being based on confederations
of collectives to respond to changes in demand (i.e. to determine investment
decisions and ensure that supply is kept in line with demand). Mutualism, with
its system of market based distribution around a network of co-operatives and
mutual banks, does not really need a further discussion as its basic
operations are the same as in any non-capitalist market system. Collectivism
and communism will have to be discussed in more detail. However, all systems
are based on workers' self-management and so the individuals directly affected
make the decisions concerning what to produce, when to do it, and how to do
it. In this way workers retain control of the product of their labour. It is
the social context of these decisions and what criteria workers use to make
their decisions that differ between anarchist schools of thought.

Although collectivism promotes the greatest autonomy for worker associations,
it should not be confused with a market economy as advocated by supporters of
mutualism or Individualist anarchism. The goods produced by the collectivised
factories and workshops are exchanged not according to highest price that can
be wrung from consumers, but according to their actual production costs. The
determination of these honest prices would be made by a _"Bank of Exchange"_
in each community (obviously an idea borrowed from Proudhon). These Banks
would represent the various producer confederations and consumer/citizen
groups in the community and would seek to negotiate these "honest" prices
(which would, in all likelihood, include "hidden" costs like pollution). These
agreements would be subject to ratification by the assemblies of those
involved.

As James Guillaume put it _"the value of the commodities having been
established in advance by a contractual agreement between the regional co-
operative federations and the various communes, who will also furnish
statistics to the Banks of Exchange. The Bank of Exchange will remit to the
producers negotiable vouchers representing the value of their products; these
vouchers will be accepted throughout the territory included in the federation
of communes."_ These vouchers would be related to hours worked, for example,
and when used as a guide for investment decisions could be supplemented with
cost-benefit analysis of the kind possibly used in a communist-anarchist
society (see below). Although this scheme bears a strong resemblance to
Proudhonian _"People's Banks,"_ it should be noted that the Banks of Exchange,
along with a _"Communal Statistical Commission,"_ are intended to have a
planning function as well to ensure that supply meets demand. This does not
imply a Stalinist-like command economy, but simple book keeping for _"each
Bank of Exchange makes sure in advance that these products are in demand [in
order to risk] nothing by immediately issuing payment vouchers to the
producers."_ [_"On Building the New Social Order"_, pp. 356-79, **Bakunin on
Anarchism**, p. 366 and p. 367] The workers syndicates would still determine
what orders to produce and each commune would be free to choose its suppliers.

As will be discussed in more depth later (see [section
I.4.8](secI4.html#seci48)) information about consumption patterns will be
recorded and used by workers to inform their production and investment
decisions. In addition, we can imagine that production syndicates would
encourage communes as well as consumer groups and co-operatives to participate
in making these decisions. This would ensure that produced goods reflect
consumer needs. Moreover, as conditions permit, the exchange functions of the
communal "banks" would (in all likelihood) be gradually replaced by the
distribution of goods in accordance with the needs of the consumers. In other
words, most supporters of collectivist anarchism see it as a temporary measure
before anarcho-communism could develop.

Communist anarchism would be similar to collectivism, i.e. a system of
confederations of collectives, communes and distribution centres (Communal
stores). However, in an anarcho-communist system, prices are not used. How
will economic decision making be done? One possible solution is as follows:

> _"As to decisions involving choices of a general nature, such as what forms
of energy to use, which of two or more materials to employ to produce a
particular good, whether to build a new factory, there is a . . . technique .
. . that could be [used] . . . 'cost-benefit analysis' . . . [I]n socialism a
points scheme for attributing relative importance to the various relevant
considerations could be used . . . The points attributed to these
considerations would be subjective, in the sense that this would depend on a
deliberate social decision rather than some objective standard, but this is
the case even under capitalism when a monetary value has to be attributed to
some such 'cost' or 'benefit' . . . In the sense that one of the aims of
socialism is precisely to rescue humankind from the capitalist fixation with
production time/money, cost-benefit analyses, as a means of taking into
account other factors, could therefore be said to be more appropriate for use
in socialism than under capitalism. Using points systems to attribute relative
importance in this way . . . [is] simply to employ a technique to facilitate
decision-making in particular concrete cases."_ [Adam Buick and John Crump,
**State Capitalism: The Wages System Under New Management**, pp. 138-139]

This points system would be the means by which producers and consumers would
be able to determine whether the use of a particular good is efficient or not.
Unlike prices, this cost-benefit analysis system would ensure that production
and consumption reflects social and ecological costs, awareness and
priorities. Moreover, this analysis would be a **guide** to decision making
and not a replacement of human decision making and evaluation. As Lewis
Mumford argued:

> _"it is plain that in the decision as to whether to build a bridge or a
tunnel there is a human question that should outweigh the question of
cheapness or mechanical feasibility: namely the number of lives that will be
lost in the actual building or the advisability of condemning a certain number
of men [and women] to spend their entire working days underground supervising
tunnel traffic . . . Similarly the social choice between silk and rayon is not
one that can be made simply on the different costs of production, or the
difference in quality between the fibres themselves: there also remains, to be
integrated in the decision, the question as to difference in working-pleasure
between tending silkworms and assisting in rayon production. What the product
contributes to the labourer is just as important as what the worker
contributes to the product. A well-managed society might alter the process of
motor car assemblage, at some loss of speed and cheapness, in order to produce
a more interesting routine for the worker: similarly, it would either go to
the expense of equipping dry-process cement making plants with dust removers
-- or replace the product itself with a less noxious substitute. When none of
these alternatives was available, it would drastically reduce the demand
itself to the lowest possible level."_ [**The Future of Technics and
Civilisation**, pp. 160-1]

Obviously, today, we would include ecological issues as well as human ones.
Any decision making process which disregards the quality of work or the effect
on the human and natural environment is a deranged one. However, this is how
capitalism operates, with the market rewarding capitalists and managers who
introduce de-humanising and ecologically harmful practices. Indeed, so biased
against labour and the environment is capitalism that many economists and pro-
capitalists argue that reducing "efficiency" by such social concerns (as
expressed by the passing laws related to labour rights and environmental
protection) is actually **harmful** to an economy, which is a total reversal
of common sense and human feelings (after all, surely the economy should
satisfy human needs and not sacrifice those needs to the economy?). The
argument is that consumption would suffer as resources (human and material)
would be diverted from more "efficient" productive activities and so reduce,
over all, our economic well-being. What this argument ignores is that
consumption does not exist in isolation from the rest of the economy. What we
want to consume is conditioned, in part, by the sort of person we are and that
is influenced by the kind of work we do, the kinds of social relationships we
have, whether we are happy with our work and life, and so on. If our work is
alienating and of low quality, then so will our consumption decisions. If our
work is subject to hierarchical control and servile in nature then we cannot
expect our consumption decisions to be totally rational -- indeed they may
become an attempt to find happiness via shopping, a self-defeating activity as
consumption cannot solve a problem created in production. Thus rampant
consumerism may be the result of capitalist "efficiency" and so the objection
against socially aware production is question begging.

Of course, as well as absolute scarcity, prices under capitalism also reflect
relative scarcity (while in the long term, market prices tend towards their
production price plus a mark-up based on the degree of monopoly in a market,
in the short term prices can change as a result of changes in supply and
demand). How a communist society could take into account such short term
changes and communicate them through out the economy is discussed in [section
I.4.5](secI4.html#seci45). Moreover, it is likely that they will factor in the
desirability of the work performed to indicate the potential waste in human
time involved in production (see [section I.4.13](secI4.html#seci413) for a
discussion of how this could be done). The logic behind this is simple, a
resource which people **like** to produce will be a better use of the scare
resource of an individual's time than one people hate producing. Another key
factor in making sensible decisions would be the relative scarcity of a good.
After all, it would make little sense when making a decision to use a good
which is in short supply over one which is much more abundant. Thus, while the
cost-benefit points system would show absolute costs (number of hours work
required, energy use, pollution, etc.) this would be complemented by
information about how scare a specific good is and the desirability of the
work required to produce it.

Therefore, a communist-anarchist society would be based around a network of
syndicates who communicate information between each other. Instead of the
price being communicated between workplaces as in capitalism, actual physical
data will be sent (the cost). This data is a summary of these (negative) use
values of the good (for example resources, labour time and energy used to
produce it, pollution details) as well as relative scarcity. With this
information a cost-benefit analysis will be conducted to determine which good
will be best to use in a given situation based upon mutually agreed common
values. These will be used to inform the decision on which goods to use, with
how well goods meet the requirements of production (the positive use-value)
being compared to their impact in terms of labour, resource use, pollution and
so forth (the negative use-values) along with their relative availability.

The data for a given workplace could be compared to the industry as a whole
(as confederations of syndicates would gather and produce such information --
see [section I.3.5](secI3.html#seci35)) in order to determine whether a
specific workplace will efficiently produce the required goods (this system
has the additional advantage of indicating which workplaces require investment
to bring them in line, or improve upon, the industrial average in terms of
working conditions, hours worked and so on). In addition, common rules of
thumb would possibly be agreed, such as agreements not to use scarce materials
unless there is no alternative (either ones that use a lot of labour, energy
and time to produce or those whose demand is currently exceeding supply
capacity).

Similarly, when ordering goods, the syndicate, commune or individual involved
will have to inform the syndicate why it is required in order to allow the
syndicate to determine if they desire to produce the good and to enable them
to prioritise the orders they receive. In this way, resource use can be guided
by social considerations and "unreasonable" requests ignored (for example, if
an individual states they "need" a ship-builders syndicate to build a ship for
their personal use, the ship-builders may not "need" to build it and instead
build ships for communal use, freely available for all to use in turn -- see
[section I.4.6](secI4.html#seci46)). However, in almost all cases of
individual consumption, no such information will be needed as communal stores
would order consumer goods in bulk as they do now. Hence the economy would be
a vast network of co-operating individuals and workplaces and the dispersed
knowledge which exists within any society can be put to good effect
(**better** effect than under capitalism because it does not hide social and
ecological costs in the way market prices do and co-operation will eliminate
the business cycle and its resulting social problems).

Therefore, production units in a social anarchist society, by virtue of their
autonomy within association, are aware of what is socially useful for them to
produce and, by virtue of their links with communes, also aware of the social
(human and ecological) cost of the resources they need to produce it. They can
combine this knowledge, reflecting overall social priorities, with their local
knowledge of the detailed circumstances of their workplaces and communities to
decide how they can best use their productive capacity. In this way the
division of knowledge within society can be used by the syndicates effectively
as well as overcoming the restrictions within knowledge communication imposed
by the price mechanism (see [section I.1.2](secI1.html#seci12)) and workplaces
hierarchies within capitalism (see [section I.1.1](secI1.html#seci11)).

Moreover, production units, by their association within confederations ensure
that there is effective communication between them. This results in a process
of negotiated co-ordination between equals (i.e. horizontal links and
agreements) for major investment decisions, thus bringing together supply and
demand and allowing the plans of the various units to be co-ordinated. By this
process of co-operation, production units can reduce duplicating effort and so
reduce the waste associated with over-investment (and so the irrationalities
of booms and slumps associated with the price mechanism, which does not
provide sufficient information to allow workplaces to efficiently co-ordinate
their plans).

When evaluating production methods we need to take into account as many social
and ecological costs as possible and these have to be evaluated. Which costs
will be taken into account, of course, be decided by those involved, as will
how important they are relative to each other (i.e. how they are weighted).
What factors to take into account and how to weigh them in the decision making
process will be evaluated and reviewed regularly so to ensure that it reflects
real costs and social concerns. As communist-anarchists consider it important
to encourage all to participate in the decisions that affect their lives, it
would be the role of communal confederations to determine the relative points
value of given inputs and outputs. In this way, **all** individuals in a
community determine how their society develops, so ensuring that economic
activity is responsible to social needs and takes into account the desires of
everyone affected by production. In this way consumption and production can be
harmonised with the needs of individuals as members of society and the
environment they live in. The industrial confederations would seek to ensure
that this information is recorded and communicated and (perhaps) formulating
industry-wide averages to aid decision-making by allowing syndicates and
communes to compare specific goods points to the typical value.

So which factors are to be used to inform decision-making would be agreed and
the information communicated between workplaces and communes so that consumers
of goods can evaluate their costs in terms of ecological impact, use of
resources and human labour. Any agreed values for the Cost-Benefit analysis
for inputs can be incorporated in the information associated with the outputs.
As such, a communist society would seek to base decisions on more than one
criteria, whether it is profits or (say) labour. The reasons for this should
be obvious, as one criteria rarely allows sensible decisions. Of course, to
some degree people already do this under capitalism but market forces and
inequality limit this ability (people will tend to buy cheaper products if
they need to make ends meet) while both the price mechanism and the self-
interest of companies ensure information about costs are hidden (for example,
few companies publically acknowledge their externalities and most spend vast
sums on advertising to greenwash their products).

In order to process the information on costs communicated in a libertarian
communist economy accounting tools can be created (such as a spreadsheet or
computer programme). These could take the decided factors as inputs and
returns a cost benefit analysis of the choices available. So while these
algorithmic procedures and guidelines can, and indeed should be, able to be
calculated by hand, it is likely that computers will be extensively used to
take input data and process it into a suitable format. Indeed, many capitalist
companies have software which records raw material inputs and finished product
into databases and spreadsheets. Such software could be the basis of a
libertarian communist decision making algorithm. Of course, currently such
data is submerged beneath money and does not take into account externalities
and the nature of the work involved (as would be the case in an anarchist
society). However, this does not limit their potential or deny that communist
use of such software can be used to inform decisions.

Therefore, the claim that communism cannot evaluate different production
methods due to lack of prices is inaccurate. Indeed, a look at the actual
capitalist market -- marked as it is by differences in bargaining and market
power, externalities and wage labour -- soon shows that the claims that prices
accurately reflect costs is simply not accurate. However, it may be such that
objective circumstances preclude the immediate introduction of libertarian
communism (as discussed in [section I.2.2](secI2.html#seci22), many communist
anarchists consider this likely). As such, there could be a transitional
period in which elements of mutualism, collectivism and communism co-exist
within a specific economy. It can easily be seen how a mutualist economy (the
usual initial product of a social revolution) could evolve into a collectivist
and then communist one. The market generated prices could initially be
complemented by the non-market information decided upon (for objective costs
and the scarcity index) and, overtime, replaced by this data as the main
decision making criteria by syndicates and communes.

One final point on this subject. What methods are used, which criteria picked,
which information is communicated and how it is processed, will be the
decision of a free people. This section was merely a suggestion of one
possibility of how a libertarian communist economy could make informed
decisions about production. It is not meant as a blue-print nor is it set-in-
stone.

## I.4.5 What about "supply and demand"?

Anarchists do not ignore the facts of life, namely that at a given moment
there is so much a certain good produced and so much of it is desired to be
consumed or used. Neither do we deny that different individuals have different
interests and tastes. However, this is not what is usually meant by "supply
and demand." Often in general economic debate, this formula is given a certain
mythical quality which ignores its underlying realities as well as some
unwholesome implications of the theory (for example, as discussed in [section
C.1.5](secC1.html#secc15) the market can very efficiently create famines by
exporting food to areas where there is demand for it). At the very least, the
_"the law of supply and demand"_ is not the "most efficient" means of
distribution in an unequal society as decisions are skewed in favour of the
rich.

As far as "supply and demand" in terms of allocating scare resources is
concerned, anarchists are well aware of the need to create and distribute
necessary goods to those who require them. The question is, in an anarchist
society, how do you know that valuable labour and materials are not being
wasted? How do people judge which tools are most appropriate? How do they
decide among different materials if they all meet the technical
specifications? How important are some goods than others? How important is
cellophane compared to vacuum-cleaner bags and so which one should be
produced?

It is answers like this that the supporters of the market claim that their
system answers. For individualist and mutualist anarchists, their non-
capitalist market would indicate such information by differences between
market price and cost price and individuals and co-operatives would react
accordingly. For communist and collectivist anarchists, who reject even non-
capitalist markets, the answer is less simple. As discussed in [section
I.1.3](secI1.html#seci13), these anarchists argue that although the market
does answer such questions it does so in irrational and dehumanising ways
(while this is particularly the case under capitalism, it cannot be assumed
this will disappear in a post-capitalist market). The question is: can
collectivist and communist anarchism answer such questions? Yes, they reply.

So collectivist and communist anarchists reject the market. This rejection
often implies, to some, central planning. As the market socialist David
Schweickart puts it, _"[i]f profit considerations do not dictate resource
usage and production techniques, then central direction must do so. If profit
is not the goal of a productive organisation, then physical output (use
values) must be."_ [**Against Capitalism**, p. 86] However, Schweickart is
wrong. Horizontal links need not be market based and co-operation between
individuals and groups need not be hierarchical. What is implied in this
comment is that there is just two ways to relate to others -- either by
prostitution (purely by cash) or by hierarchy (the way of the state, the army
or capitalist workplace). But people relate to each other in other ways, such
as friendship, love, solidarity, mutual aid and so on. Thus you can help or
associate with others without having to be ordered to do so or by being paid
cash to do so -- we do so all the time. You can work together because by so
doing you benefit yourself and the other person. This is the **real**
communist way, that of mutual aid and free agreement.

So Schweickart is ignoring the vast majority of relations in any society. For
example, love/attraction is a horizontal link between two autonomous
individuals and profit considerations do not enter into the relationship. Thus
anarchists argue that Schweickart's argument is flawed as it fails to
recognise that resource usage and production techniques can be organised in
terms of human need and free agreement between economic actors, without
profits or central command. This system does not mean that we all have to love
each other (an impossible wish). Rather, it means that we recognise that by
voluntarily co-operating as equals we ensure that we remain free individuals
and that we can gain the advantages of sharing resources and work (for
example, a reduced working day and week, self-managed work in safe and
hygienic working conditions and a free selection of the product of a whole
society). In other words, a self-interest which exceeds the narrow and
impoverished egotism of capitalist society.

Thus free agreement and horizontal links are not limited to market
transactions -- they develop for numerous reasons and anarchists recognise
this. As George Barrett argued:

> _"Let us imagine now that the great revolt of the workers has taken place,
that their direct action has made them masters of the situation. It is not
easy to see that some man in a street that grew hungry would soon draw a list
of the loaves that were needed, and take it to the bakery where the strikers
were in possession? Is there any difficulty in supposing that the necessary
amount would then be baked according to this list? By this time the bakers
would know what carts and delivery vans were needed to send the bread out to
the people, and if they let the carters and vanmen know of this, would these
not do their utmost to supply the vehicles . . . If . . . [the bakers needed]
more benches [to make bread] . . . the carpenters would supply them [and so
on] . . . So the endless continuity goes on -- a well-balanced interdependence
of parts guaranteed, because **need** is the motive force behind it all . . .
In the same way that each free individual has associated with his brothers
[and sisters] to produce bread, machinery, and all that is necessary for life,
driven by no other force than his desire for the full enjoyment of life, so
each institution is free and self-contained, and co-operates and enters into
agreements with other because by so doing it extends its own possibilities.
There is no centralised State exploiting or dictating, but the complete
structure is supported because each part is dependent on the whole . . . It
will be a society responsive to the wants of the people; it will supply their
everyday needs as quickly as it will respond to their highest aspirations. Its
changing forms will be the passing expressions of humanity."_ [**The Anarchist
Revolution**, pp. 17-19]

To make productive decisions we need to know what others need and information
in order to evaluate the alternative options available to us to satisfy that
need. Therefore, it is a question of distributing information between
producers and consumers, information which the market often hides (or actively
blocks) or distorts due to inequalities in resources (i.e. need does not count
in the market, _"effective demand"_ does and this skews the market in favour
of the wealthy). This information network has partly been discussed in the
[last section](secI4.html#seci44) where a method of comparison between
different materials, techniques and resources based upon use value was
discussed. In addition, the need to indicate the current fluctuations in
stocks, production and consumption has also to be factored in when making
decisions.

To indicate the relative changes in scarcity of a given good it will be
necessary to calculate what could be termed its _"scarcity index."_ This would
inform potential users of this good whether its demand is outstripping its
supply so that they may effectively adjust their decisions in light of the
decisions of others. This index could be, for example, a percentage figure
which indicates the relation of orders placed for a good to the amount
actually produced. For example, a good which has a demand higher than its
supply would have an index value of 101% or higher. This value would inform
potential users to start looking for substitutes for it or to economise on its
use. Such a scarcity figure would exist for each syndicate as well as
(possibly) a generalised figure for the industry as a whole on a regional,
"national", etc. level.

In this way, a specific good could be seen to be in high demand and so only
those producers who **really** required it would place orders for it (so
ensuring effective use of resources). Needless to say, stock levels and other
basic book-keeping techniques would be utilised in order to ensure a suitable
buffer level of a specific good existed. This may result in some excess supply
of goods being produced and used as stock to handle unexpected changes in the
aggregate demand for a good. Such a buffer system would work on an individual
workplace level and at a communal level. Syndicates would obviously have their
inventories, stores of raw materials and finished goods "on the shelf" which
can be used to meet unexpected increases in demand. Communal stores, hospitals
and so on would have their stores of supplies in case of unexpected
disruptions in supply.

This is a common practice even in capitalism, with differences between actual
demand and expected demand being absorbed by unintended stock changes. Firms
today also have spare capacity in order to meet such upsurges in demand. Such
policies of maintaining stocks and spare capacity will continue to the case
under anarchism. It is assumed that syndicates and their confederations will
wish to adjust capacity if they are aware of the need to do so. Hence, price
changes in response to changes in demand would not be necessary to provide the
information that such adjustments are required. This is because a _"change in
demand first becomes apparent as a change in the quantity being sold at
existing prices [or being consumed in a moneyless system] and is therefore
reflected in changes in stocks or orders. Such changes are perfectly good
indicators or signals that an imbalance between demand and current output has
developed. If a change in demand for its products proved to be permanent, a
production unit would find its stocks being run down and its order book
lengthening, or its stocks increasing and orders falling . . . Price changes
in response to changes in demand are therefore not necessary for the purpose
of providing information about the need to adjust capacity."_ [Pat Devine,
**Democracy and Economic Planning**, p. 242]

So syndicates, communes and their confederations will create buffer stocks of
goods to handle unforeseen changes in demand and supply. This sort of
inventory has also been used by capitalist countries like the USA to prevent
changes in market conditions for agricultural products and other strategic raw
materials producing wild spot-price movements and inflation. Post-Keynesian
economist Paul Davidson argued that the stability of commodity prices this
produced _"was an essential aspect of the unprecedented prosperous economic
growth of the world's economy"_ between 1945 and 1972. US President Nixon
dismantled these buffer zone programmes, resulting in _"violent commodity
price fluctuations"_ which had serious negative economic effects.
[**Controversies in Post-Keynesian Economics**, p. 114 and p. 115] Again, an
anarchist society is likely to utilise this sort of buffer system to iron out
short-term changes in supply and demand. By reducing short-term fluctuations
of the supply of commodities, bad investment decisions would be reduced as
syndicates would not be mislead, as is the case under capitalism, by market
prices being too high or too low at the time when the decisions where being
made (as discussed in [section I.1.5](secI1.html#seci15) such disequilibrium
prices convey misinformation which causes very substantial economic
distortions).

This, combined with cost-benefit analysis described in [section
I.4.4](secI4.html#seci44), would allow information about changes within a
moneyless economy to rapidly spread throughout the whole system and influence
all decision makers without the great majority knowing anything about the
original causes of these changes. This would allow a syndicate to ascertain
which good used up least resources and therefore left the most over for other
uses (i.e., relative costs or scarcity) as well as giving them information on
what resources were used to create it (i.e., the absolute costs involved) The
relevant information is communicated to all involved, without having to be
ordered by an "all-knowing" central body as in a Leninist centrally planned
economy. As argued in [section I.1.2](secI1.html#seci12), anarchists have long
realised that no centralised body could possibly be able to possess all the
information dispersed throughout the economy to organise production and if
such a body attempted to do so, the resulting bureaucracy would effectively
reduce and impoverish the amount of information available to decision makers
and so cause shortages and inefficiencies.

To get an idea how this system could work, let us take the example of a change
in the copper industry. Let us assume that a source of copper unexpectedly
fails or that the demand for copper increases. What would happen?

First, the initial difference would be a diminishing of stocks of copper which
each syndicate maintains to take into account unexpected changes in requests.
This would help buffer out short lived, changes in supply or requests. Second,
naturally, there is an increase in demand for copper for those syndicates
which are producing it. This immediately increases the **scarcity index** of
those firms and their product. For example, the index may rise from 95%
(indicating a slight over-production in respect to current demand) to 115%
(indicating that the demand for copper has risen in respect to the current
level of production). This change in the **scarcity index** (combined with
difficulties in finding copper producing syndicates which will accept their
orders) enters into the decision making algorithms of other syndicates. This,
in turn, results in changes in their plans. For example, the syndicates can
seek out other suppliers who have a lower scarcity index or substitutes for
copper may be used as they have become a more efficient resource to use.

In this way, requests for copper products fall and soon only reflect those
requests that really need copper (i.e., do not have realistic substitutes
available for it). This would result in the demand falling with respect to the
current supply (as indicated by requests from other syndicates and to maintain
buffer stock levels). Thus a general message has been sent across the economy
that copper has become (relatively) scarce and syndicate plans have changed in
light of this information. No central planner made these decisions nor was
money required to facilitate them. We have a decentralised, non-market system
based on the free distribution of products between self-governing
associations.

Looking at the wider picture, the question of how to respond to this change in
supply/requests for copper presents itself. The copper syndicate federation
and cross-industry syndicate federations have regular meetings and the
question of the changes in the copper situation present themselves and they
must consider how to response to these changes. Part of this is to determine
whether this change is likely to be short term or long term. A short term
change (say caused by a mine accident, for example) would not need new
investments to be planned. However, long term changes (say the new requests
are due to a new product being created by another syndicate or an existing
mine becoming exhausted) may need co-ordinated investment (we can expect
syndicates to make their own plans in light of changes, for example, by
investing in new machinery to produce copper more efficiently or to increase
production). If the expected changes of these plans approximately equal the
predicted long term changes, then the federation need not act. However, if
they do then investment in new copper mines or large scale new investment
across the industry may be required. The federation would propose such plans.

Needless to say, the future can be guessed, it cannot be accurately predicted.
Thus there may be over-investment in certain industries as expected changes do
not materialise. However, unlike capitalism, this would not result in an
economic crisis (with over-investment within capitalism, workplaces close due
to lack of profits, regardless of social need). All that would happen is that
some of the goods produced would not be used, some labour and resources would
be wasted and the syndicates would rationalise production, close down
relatively inefficient plant and concentrate production in the more efficient
ones. The sweeping economic crises of capitalism would be a thing of the past.

In summary, each syndicate receives its own orders and supplies and sends its
own produce out to specific consumers. Similarly, communal distribution
centres would order required goods from syndicates it determines. In this way
consumers can change to syndicates which respond to their needs and so
production units are aware of what it is socially useful for them to produce
as well as the social cost of the resources they need to produce it. In this
way a network of horizontal relations spread across society, with co-
ordination achieved by equality of association and not the hierarchy of the
corporate structure.

While anarchists are aware of the _"isolation paradox"_ (see [section
B.6](secB6.html)) this does not mean that we think the commune should make
decisions **for** people on what they are to consume. That would be a prison.
No, all anarchists agree that is up to the individual to determine their own
needs and for the collectives they join to determine social requirements like
parks, infrastructure improvements and so on. However, social anarchists think
that it would be beneficial to discuss the framework around which these
decisions would be made. This would mean, for example, that communes would
agree to produce eco-friendly products, reduce waste and generally make
decisions enriched by social interaction. Individuals would still decide which
sort goods they desire, based on what the collectives produce but these goods
would be based on a socially agreed agenda. In this way waste, pollution and
other _"externalities"_ of atomised consumption could be reduced. For example,
while it is rational for individuals to drive a car to work, collectively this
results in massive **irrationality** (for example, traffic jams, pollution,
illness, unpleasant social infrastructures). A sane society would discuss the
problems associated with car use and would agree to produce a fully integrated
public transport network which would reduce pollution, stress, illness, and so
on.

Therefore, while anarchists recognise individual tastes and desires, they are
also aware of the social impact of them and so try to create a social
environment where individuals can enrich their personal decisions with the
input of other people's ideas.

On a related subject, it is obvious that different syndicates would produce
slightly different goods, so ensuring that people have a choice. It is
doubtful that the current waste implied in multiple products from different
companies (sometimes the same multi-national corporation!) all doing the same
job would be continued in an anarchist society. However, production will be
_"variations on a theme"_ in order to ensure consumer choice and to allow the
producers to know what features consumers prefer. It would be impossible to
sit down beforehand and make a list of what features a good should have --
that assumes perfect knowledge and that technology is fairly constant. Both
these assumptions are of limited use in real life. Therefore, co-operatives
would produce goods with different features and production would change to
meet the demand these differences suggest (for example, factory A produces a
new CD player, and consumption patterns indicate that this is popular and so
the rest of the factories convert). This is in addition to R&amp;D experiments
and test populations. In this way consumer choice would be maintained, and
enhanced as people would be able to influence the decisions of the syndicates
as producers (in some cases) and through syndicate/commune dialogue.

Finally, it would be churlish, but essential, to note that capitalism only
equates supply and demand in the fantasy world of neo-classical economics. Any
**real** capitalist economy, as we discussed in [section
I.1.5](secI1.html#seci15) is marked by uncertainty and a tendency to over-
produce in the response to the higher profits caused by previously under-
producing goods, with resulting periods of crisis in which falling effective
demand sees a corresponding fall in supply. Not to mention the awkward fact
that real needs (demand) are not met simply because people are too poor to pay
for the goods (i.e., no effective demand). As such, to suggest that only non-
market systems have a problem ensuring demand and supply meet is mistaken.

To conclude, anarchists do not ignore _"supply and demand."_ Instead, they
recognise the limitations of the capitalist version of this truism and point
out that capitalism is based on **effective** demand which has no necessary
basis with efficient use of resources. Instead of the market, social
anarchists advocate a system based on horizontal links between producers which
effectively communicates information across society about the relative changes
in supply and demand which reflect actual needs of society and not bank
balances. The investment response to changes in supply and demand will be
discussed in [section I.4.8](secI4.html#seci48) while [section
I.4.13](secI4.html#seci413) will discuss the allocation of work tasks.

## I.4.6 Surely anarchist-communism would just lead to demand exceeding
supply?

While non-communist forms of anarchism relate consumption to work done, so
automatically relating demand to production, this is not the case in
communist-anarchism. In that system, distribution is according to need, not
deed. Given this, it is a common objection that libertarian communism would
lead to people wasting resources by taking more than they need.

Kropotkin, for example, stated that _"free communism . . . places the product
reaped or manufactured at the disposal of all, leaving to each the liberty to
consume them as he pleases in his own home."_ [**The Place of Anarchism in the
Evolution of Socialist Thought**, p. 7] But, some argue, what if an individual
says they "need" a luxury house or a personal yacht? Simply put, workers may
not "need" to produce it. As Tom Brown put it, _"such things are the product
of social labour . . . Under syndicalism . . . it is improbable that any
greedy, selfish person would be able to kid a shipyard full of workers to
build him a ship all for his own hoggish self. There would be steam luxury
yachts, but they would be enjoyed in common."_ [**Syndicalism**, p. 51]

Therefore, communist-anarchists are not blind to the fact that free access to
products is based upon the actual work of real individuals -- "society"
provides nothing, individuals working together do. This is reflected in the
classic statement of communism: _"From each according to their ability, to
each according to their needs."_ This must be considered as a whole as those
producing have needs and those receiving have abilities. The needs of both
consumer **and** producer have to be taken into account, and this suggests
that those producing have to feel the need to do so. This means that if no
syndicate or individual desires to produce a specific order then this order
can be classed as an "unreasonable" demand -- "unreasonable" in this context
meaning that no one freely agrees to produce it. Of course, individuals may
agree to barter services in order to get what they want produced if they
**really** want something but such acts in no way undermines a communist
society.

This also applies to the demand for goods which are scare and, as a result,
require substantial labour and resources to produce. In such circumstances,
the producers (either as a specific syndicate or in their confederations)
would refuse to supply such a "need" or communes and their confederations
would suggest that this would be waste of resources. Ultimately, a free
society would seek to avoid the irrationalities of capitalism where the drive
for profits results in production for the sake of production and consumption
for the sake of consumption and the many work longer and harder to meet the
demands of a (wealthy) few. A free people would evaluate the pros and cons of
any activity before doing it. As Malatesta put it:

> _"[A] communist society . . . is not, obviously, about an absolute right to
satisfy **all** of one's needs, because needs are infinite . . . so their
satisfaction is always limited by productive capacity; nor would it be useful
or just that the community in order to satisfy excessive needs, otherwise
called caprices, of a few individuals, should undertake work, out of
proportion to the utility being produced . . . What we would like is for
everybody to live in the best possible way: so that everybody with a minimum
amount of effort will obtain maximum satisfaction."_ [**At the Café**, pp.
60-1]

Communist-anarchists recognise that production, like consumption, must be
based on freedom. However, it has been argued that free access would lead to
waste as people take more than they would if they had to pay for it. This
objection is not as serious as it first appears. There are plenty of examples
within current society to indicate that free access will not lead to abuses.
Let us take a few examples. In public libraries people are free to sit and
read books all day but few, if any, actually do so. Neither do people always
take the maximum number of books out at a time. No, they use the library as
they need to and feel no need to maximise their use of the institution. Some
people never use the library, although it is free. In the case of water
supplies, it is clear that people do not leave taps on all day because water
is often supplied freely or for a fixed charge. Similarly with pavements,
people do not walk everywhere because to do so is free. In such cases
individuals use the resource as and when they need to. Equally, vegetarians do
not start eating meat when they visit their friend's parties just because the
buffet is free.

We can expect similar results as other resources become freely available. In
effect, this argument makes as much sense as arguing that individuals will
travel to stops **beyond** their destination if public transport is based on a
fixed charge! Obviously only an idiot would travel further than required in
order to get "value for money." However, for many the world seems to be made
up of such fools. Perhaps it would be advisable for such critics to hand out
political leaflets in the street. Even though the leaflets are free, crowds
rarely form around the person handing them out demanding as many copies of the
leaflet as possible. Rather, those interested in what the leaflets have to say
take them, the rest ignore them. If free access automatically resulted in
people taking more than they need then critics of free communism would be
puzzled by the lack of demand for what they were handing out!

Part of the problem is that capitalist economics has invented a fictional type
of person, **Homo Economicus,** whose wants are limitless: an individual who
always wants more and so whose needs could only satisfied if resources were
limitless too. Needless to say, such an individual has never existed. In
reality, wants are not limitless -- people have diverse tastes and rarely want
everything available nor want more of a good than that which satisfies their
need.

Communist Anarchists also argue that we cannot judge people's buying habits
under capitalism with their actions in a free society. After all, advertising
does not exist to meet people's needs but rather to create needs by making
people insecure about themselves. Simply put, advertising does not amplify
existing needs or sell the goods and services that people already want.
Advertising would not need to stoop to the level of manipulative adverts that
create false personalities for products and provide solutions for problems
that the advertisers themselves create if this were the case. Crude it may be,
but advertising is based on the creation of insecurities, preying on fears and
obscuring rational thought. In an alienated society in which people are
subject to hierarchical controls, feelings of insecurity and lack of control
and influence would be natural. It is these fears that advertising multiplies
-- if you cannot have real freedom, then at least you can buy something new.
Advertising is the key means of making people unhappy with what they have and
who they are. It is naive to claim that advertising has no effect on the
psyche of the receiver or that the market merely responds to the populace and
makes no attempt to shape their thoughts. If advertising did not work, firms
would not spend so much money on it! Advertising creates insecurities about
such matter-of-course things and so generates irrational urges to buy which
would not exist in a libertarian communist society.

However, there is a deeper point to be made here about consumerism. Capitalism
is based on hierarchy, not liberty. This leads to a weakening of individuality
as well as a loss of self-identity and sense of community. Both these senses
are a deep human need and consumerism is often a means by which people
overcome their alienation from their selves and others (religion, ideology and
drugs are other means of escape). Therefore the consumption within capitalism
reflects **its** values, not some abstract "human nature." As such, because a
firm or industry is making a profit satisfying "needs" within capitalism, it
does not follow that people in a free society would have similar wants (i.e.,
"demand" often does not exist independently of the surrounding society). As
Bob Black argues:

> _"what we want, what we are capable of wanting is relative to the forms of
social organisation. People 'want' fast food because they have to hurry back
to work, because processed supermarket food doesn't taste much better anyway,
because the nuclear family (for the dwindling minority who have even that to
go home to) is too small and too stressed to sustain much festivity in cooking
and eating -- and so forth. It is only people who can't get what they want who
resign themselves to want more of what they can get. Since we cannot be
friends and lovers, we wail for more candy."_ [**Friendly Fire**, p. 57]

Therefore, most anarchists think that consumerism is a product of a
hierarchical society within which people are alienated from themselves and the
means by which they can make themselves **really** happy (i.e. meaningful
relationships, liberty, self-managed productive activity, and so on).
Consumerism is a means of filling the spiritual hole capitalism creates within
us by denying our freedom and violating equality. This means that capitalism
produces individuals who define themselves by what they have, not who they
are. This leads to consumption for the sake of consumption, as people try to
make themselves happy by consuming more commodities. But, as Erich Fromm
pointed out, this cannot work for long and only leads to even more insecurity
(and so even more consumption):

> _"**If I am what I have and if what I have is lost, who then am I?** Nobody
but a defeated, deflated, pathetic testimony to a wrong way of living. Because
I **can** lose what I have, I am necessarily constantly worried that I
**shall** lose what I have."_ [**To Have Or To Be**, p. 111]

Such insecurity easily makes consumerism seem a "natural" way of life and so
make communism seem impossible. However, rampant consumerism is far more a
product of lack of meaningful freedom within an alienated society than a
"natural law" of human existence. In a society that encouraged and protected
individuality by non-hierarchical social relationships and organisations,
individuals would have a strong sense of self and so be less inclined to
mindlessly consume. As Fromm put it: _"If **I am what I am** and not what I
have, nobody can deprive me of or threaten my security and my sense of
identity. My centre is within myself."_ [**Op. Cit.**, p. 112] Such self-
centred individuals do not have to consume endlessly to build a sense of
security or happiness within themselves.

In other words, the well-developed individuality that an anarchist society
would develop would have less need to consume than the average person in a
capitalist one. This is not to suggest that life will be bare and without
luxuries in an anarchist society, far from it. A society based on the free
expression of individuality could be nothing but rich in wealth and diverse in
goods and experiences. What we are arguing here is that an anarchist-communist
society would not have to fear rampant consumerism making demand outstrip
supply constantly and always precisely because freedom will result in a non-
alienated society of well developed individuals.

It should not be forgotten that communism has two conditions, distribution
according to need **and** production according to ability. If the latter
condition is not met, if someone does not contribute to the goods available in
the libertarian communist society, then the former condition is not likely to
be tolerated and they would be asked to leave so reducing demand for goods.
The freedom to associate means being free **not** to associate. Thus a free
communist society would see goods being supplied as well as demanded. As
Malatesta argued:

> _"Basic to the anarchist system, before communism or any other forms of
social conviviality is the principle of the free compact; the rule of integral
communism -- 'from each according to his [or her] ability, to each according
to his [or her] need' -- applies only to those who accept it, including
naturally the conditions which make it practicable."_ [quoted by Camillo
Berneri, _"The Problem of Work"_, pp. 59-82, **Why Work?**, Vernon Richards
(ed.), p. 74]

So, as Malatesta suggested, it should be noted that communist-anarchists are
well aware that it is likely that free access to all goods and services cannot
be done immediately (see [section H.2.5](secH2.html#sech25) for details). As
Alexander Berkman summarised, _"when the social revolution attains the stage
where it can produce sufficient for all, then is adopted the Anarchist
principle of 'to each according to his [or her] needs' . . . But until it is
reached, the system of equal sharing . . . is imperative as the only just
method. It goes without saying, of course, that special consideration must be
given to the sick and the old, to children, and to women during and after
pregnancy."_ [**What is Anarchism?**, p. 216] Another possibility was
suggested by James Guillaume who argued that as long as a product was _"in
short supply it will to a certain extent have to be rationed. And the easiest
way to do this would be to **sell** these scarce products"_ but as production
grows then _"it will not be necessary to ration consumption. The practice of
selling, which was adopted as a sort of deterrent to immoderate consumption,
will be abolished"_ and goods _"will be distribute[d] . . . in accordance with
the needs of the consumers."_ [_"On Building the New Social Order"_, pp.
356-79, **Bakunin on Anarchism**, p. 368] Other possibilities may include
communes deciding that certain scarce goods are only available to those who do
the unpleasant work (such as collecting the rubbish) or that people have equal
access but the actual goods are shared and used for short periods of time (as
is currently the case with public libraries). As Situationist Ken Knabb
suggests after usefully discussing _"just some of the possibilities"_:
_"Experimenting with different methods, people will find out for themselves
what forms of ownership, exchange and reckoning are necessary."_ [**Public
Secrets**, p. 73]

Whether or not full communism **can** be introduced instantly is a moot point
amongst collectivist and communist anarchists, although most would like to see
society develop towards a communist goal eventually. Of course, for people
used to capitalism this may sound totally utopian. Possibly it is. However, as
Oscar Wilde said, a map of the world without Utopia on it is not worth having.
One thing is sure, if the developments we have outlined above fail to appear
and attempts at communism fail due to waste and demand exceeding supply then a
free society would make the necessary decisions and introduce some means of
limiting supply (such as, for example, labour notes, equal wages, and so on).
Rest assured, though, _"the difficulty will be solved and obstacles in the
shape of making necessary changes in the detailed working of the system of
production and its relation to consumption, will vanish before the ingenuity
of the myriad minds vitally concerned in overcoming them."_ [Charlotte M.
Wilson, **Anarchist Essays**, p. 21]

## I.4.7 What will stop producers ignoring consumers?

It is often claimed that without a market producers would ignore the needs of
consumers. Without the threat (and fear) of unemployment and destitution and
the promise of higher profits, producers would turn out shoddy goods. The
holders of this argument point to the example of the Soviet Union which was
notorious for terrible goods and a lack of consumer commodities.

Capitalism, in comparison to the old Soviet block, does, to some degree, make
the producers accountable to the consumers. If the producer ignores the
desires of the consumer then they will loose business to those who do not and
be forced, perhaps, out of business (large companies, of course, due to their
resources can hold out far longer than smaller ones). Thus we have the carrot
(profits) and the stick (fear of poverty) -- although, of course, the carrot
can be used as a stick against the consumer (no profit, no sale, no matter how
much the consumer may need it). Ignoring the obvious objection to this analogy
(namely we are human beings, **not** donkeys!) it does have contain an
important point. What will ensure that consumer needs are meet in an anarchist
society?

In an Individualist or Mutualist anarchist system, as it is based on a market,
producers would be subject to market forces and so have to meet consumers
needs. Collectivist-anarchism meets consumer needs in a similar way, as
producers would be accountable to consumers by the process of buying and
selling between co-operatives. As James Guillaume put it, the workers
associations would _"deposit their unconsumed commodities in the facilities
provided by the [communal] Bank of Exchange . . . The Bank of Exchange would
remit to the producers negotiable **vouchers** representing the value of their
products"_ (this value _"having been established in advance by a contractual
agreement between the regional co-operative federations and the various
communes"_). [_"On Building the New Social Order"_, pp. 356-79, **Bakunin on
Anarchism**, pp. 366] If the goods are not in demand then the producer
associations would not be able to sell the product of their labour to the Bank
of Exchange (or directly to other syndicates or communes) and so they would
adjust their output accordingly. Of course, there are problems with these
systems due to their basis in the market (as discussed in [section
I.1.3](secI1.html#seci13)), although these problems were recognised by
Proudhon who argued for an agricultural-industrial federation to protect self-
management from the negative effects of market forces (as noted in [section
I.3.5](secI3.html#seci35)).

While mutualist and collectivist anarchists can argue that producers would
respond to consumer needs otherwise they would not get an income, communist-
anarchists (as they seek a moneyless society) cannot argue their system would
reward producers in this way. So what mechanism exists to ensure that _"the
wants of all"_ are, in fact, met? How does anarcho-communism ensure that
production becomes _"the mere servant of consumption"_ and _"mould itself on
the wants of the consumer, not dictate to him conditions"_? [Peter Kropotkin,
**Act for Yourselves**, p. 57] Libertarian communists argue that in a **free**
communist society consumers' needs would be met. This is because of the
decentralised and federal nature of such a society.

So what is the mechanism which makes producers accountable to consumers in a
libertarian communist society? Firstly, communes would practice their power of
**_"exit"_** in the distributive network. If a syndicate was producing sub-
standard goods or refusing to change their output in the face of changing
consumer needs, then the communal stores would turn to those syndicates which
**were** producing the goods desired. The original syndicates would then be
producing for their own stocks, a pointless task and one few, if any, would
do. After all, people generally desire their work to have meaning, to be
useful. To just work, producing something no-one wanted would be such a
demoralising task that few, if any, sane people would do it (under capitalism
people put up with spirit destroying work as some income is better than none,
such an "incentive" would not exist in a free society).

As can be seen, **_"exit"_** would still exist in libertarian communism.
However, it could be argued that unresponsive or inefficient syndicates would
still exist, exploiting the rest of society by producing rubbish (or goods
which are of less than average quality) and consuming the products of other
people's labour, confident that without the fear of poverty and unemployment
they can continue to do this indefinitely. Without the market, it is argued,
some form of bureaucracy would be required (or develop) which would have the
power to punish such syndicates. Thus the state would continue in
"libertarian" communism, with the "higher" bodies using coercion against the
lower ones to ensure they meet consumer needs or produced enough.

While, at first glance, this appears to be a possible problem on closer
inspection it is flawed. This is because anarchism is based not only on
**_"exit"_** but also **_"voice"_**. Unlike capitalism, libertarian communism
is based on association and communication. Each syndicate and commune is in
free agreement and confederation with all the others. Thus, if a specific
syndicate was producing bad goods or not pulling its weight, then those in
contact with them would soon realise this. First, those unhappy with a
syndicate's work would appeal to them directly to get their act together. If
this did not work, then they would notify their disapproval by refusing to
associate with them in the future (i.e. they would use their power of
**_"exit"_** as well as refusing to provide the syndicate with any goods
**it** requires). They would also let society as a whole know (via the media)
as well as contacting consumer groups and co-operatives and the relevant
producer and communal confederations which they and the other syndicates are
members of, who would, in turn, inform their members of the problems (the
relevant confederations could include local and regional communal
confederations, the general cross-industry confederation, its own
industrial/communal confederation and the confederation of the syndicate not
pulling its weight). In today's society, a similar process of "word of mouth"
warnings and recommendations goes on, along with consumer groups and media.
Our suggestions here are an extension of this common practice (that this
process exists suggests that the price mechanism does not, in fact, provide
consumers with all the relevant information they need to make decisions, but
this is an aside).

If the syndicate in question, after a certain number of complaints had been
lodged against it, still did not change its ways, then it would suffer non-
violent direct action. This would involve the boycotting of the syndicate and
(perhaps) its local commune (such as denying it products and investment), so
resulting in the syndicate being excluded from the benefits of association.
The syndicate would face the fact that no one else wanted to associate with it
and suffer a drop in the goods coming its way, including consumption products
for its members. In effect, a similar process would occur to that of a firm
under capitalism that looses its customers and so its income. However, we
doubt that a free society would subject any person to the evils of destitution
or starvation (as capitalism does). Rather, a bare minimum of goods required
for survival would still be available.

In the unlikely event this general boycott did not result in a change of
heart, then two options are left available. These are either the break-up of
the syndicate and the finding of its members new work places or the
giving/selling of the syndicate to its current users (i.e. to exclude them
from the society they obviously do not want to be part off). The decision of
which option to go for would depend on the importance of the workplace in
question and the desires of the syndicates' members. If the syndicate refused
to disband, then option two would be the most logical choice (unless the
syndicate controlled a scare resource). The second option would, perhaps, be
best as this would drive home the benefits of association as the expelled
syndicate would have to survive on its own, subject to survival by selling the
product of its labour and would soon return to the fold.

Kropotkin argued in these terms over 100 years ago:

> _"When a railway company, federated with other companies, fails to fulfil
its engagements, when its trains are late and goods lie neglected at the
stations, the other companies threaten to cancel the contract, and that threat
usually suffices. _

> _"It is generally believed . . . that commerce only keeps to its engagements
from fear of lawsuits. Nothing of the sort; nine times in ten the trader who
has not kept his word will not appear before a judge . . . the sole fact of
having driven a creditor to bring a lawsuit suffices for the vast majority of
merchants to refuse for good to have any dealings with a man who has compelled
one of them to go to law. _

> _"This being so, why should means that are used today among . . . traders in
the trade, and railway companies in the organisation of transport, not be made
use of in a society based on voluntary work?"_ [**The Conquest of Bread**, p.
153]

Thus, to ensure producer accountability of production to consumption, no
bureaucratic body is required in libertarian communism (or any other form of
anarchism). Rather, communication and direct action by those affected by
unresponsive producers would be an effective and efficient means of ensuring
the accountability of production to consumption.

## I.4.8 What about investment decisions?

Obviously, a given society needs to take into account changes in consumption
and so invest in new means of production. An anarchist society is no
different. As Guild Socialist G.D.H Cole points out, _"it is essential at all
times, and in accordance with considerations which vary from time to time, for
a community to preserve a balance between production for ultimate use and
production for use in further production. And this balance is a matter which
ought to be determined by and on behalf of the whole community."_ [**Guild
Socialism Restated**, p. 144]

How this balance is determined varies according to the school of anarchist
thought considered. All agree, however, that such an important task should be
under effective community control.

The mutualists see the solution to the problems of investment as creating a
system of mutual banks, which reduce interest rates to zero. This would be
achieved by _"the organisation of credit, on the principle of reciprocity or
mutualism . . . In such an organisation credit is raised to the dignity of a
social function, managed by the community; and, as society never speculates
upon its members, it will lend its credit . . . at the actual cost of
transaction."_ [Charles A. Dana, **Proudhon and his _"Bank of the People"_**,
p. 36] Loans would be allocated to projects which the mutual banks considered
likely to succeed and repay the original loan. In this way, the increase in
the money supply implied by these acts of credit providing does not generate
inflation for money is **not** created wantonly but rather is aimed at
projects which are considered likely to **increase** the supply of goods and
services in the economy (see [section G.3.6](secG3.html#secg36)). Another key
source of investment would be internal funds (i.e., retained savings) as is
the case with co-operatives today: _"Worker-managers finance their new
investments partly out of internal funds and partly from external loans . . .
Entrepreneurial activity of worker-managers . . . generates profits and
losses, i.e., higher or lower income per worker."_ [Branko Horvat, _"The
Theory of the Worker-Managed Firm Revisited"_, pp. 9-25, **Journal of
Comparative Economics**, vol. 10, no. 1, p. 21] As discussed in [section
I.1.1](secI1.html#seci11), eliminating the stock market will not harm
investment (almost all investment funds are from other sources) and will
remove an important negative influence in economic activity.

Collectivist and communist anarchists recognise that credit is based on human
activity, which is represented as money. As Cole pointed out, the
_"understanding of this point [on investment] depends on a clear appreciation
of the fact that all real additions to capital take the form of directing a
part of the productive power of labour and using certain materials not for the
manufacture of products and the rendering of services incidental to such
manufacture for purposes of purposes of further production."_ [**Op. Cit.**,
p. 143] So collectivist and communist anarchists agree with their Mutualist
cousins when they state that _"[a]ll credit presupposes labour, and, if labour
were to cease, credit would be impossible"_ and that the _"legitimate source
of credit"_ was _"the labouring classes"_ who _"ought to control it"_ and for
_"whose benefit [it should] be used"_. [Dana, **Op. Cit.**, p. 35]

Therefore, in collectivism, investment funds would exist for syndicates,
communes and their in community (_"People's"_) banks. These would be used to
store depreciation funds and as well as other funds agreed to by the
syndicates for investment projects (for example, confederations of syndicates
may agree to allocate a certain percentage of their labour notes to a common
account in order to have the necessary funds available for major investment
projects). Similarly, individual syndicates and communes would also create a
store of funds for their own investment projects. Moreover, the confederations
of syndicates to which these _"People's Banks"_ would be linked would also
have a defined role in investment decisions to ensure that production meets
demand by being the forum which decides which investment plans should be given
funding (this, we stress, is hardly "central planning" as capitalist firms
also plan future investments to meet expected demand). In this, collectivist
anarchism is like mutualism and so we would also expect interest-free credit
being arranged to facilitate investment.

In a communist-anarchist society, things would be slightly different as this
would not have the labour notes used in mutualism and collectivism. This means
that the productive syndicates would agree that a certain part of their total
output and activity will be directed to investment projects. In effect, each
syndicate is able to draw upon the resources approved of by the co-operative
commonwealth in the form of an agreed claim on the labour power of society
(investment _"is essentially an allocation of material and labour, and
fundamentally, an allocation of human productive power."_ [Cole, **Op. Cit.**,
pp. 144-5]). In this way, mutual aid ensures a suitable pool of resources for
the future from which all benefit.

It should be remembered that savings are not required before credit can be
issued. Under capitalism, for example, banks regularly issue credit in excess
of their actual reserves of cash (if they did not then, one, they would not be
very good capitalists and, two, the economy would grind to a halt). Nor does
the interest rate reflect a preference for future goods (as discussed in
[section C.2.6](secC2.html#secc26) interest rates reflect market power, the
degree of monopoly in the credit industry, the social and class position of
individuals and a host of other factors). Moreover, a developed economy
replaces a process in time with a process in space. In peasant and tribal
societies, individuals usually did have to spend time and energy making their
own tools (the hunter had to stop hunting in order to create a new improved
bow or spear). However, with a reasonably developed division of work then
different people produce the tools others use and can do so at the same time
as the others produce. If workers producing investment goods had to wait until
sufficient savings had been gathered before starting work then it is doubtful
that any developed economy could function. Thus the notion that "investment"
needs saving is somewhat inappropriate, as different workplaces produce
consumption goods and others produce investment goods. The issue becomes one
of ensuring that enough people and resources go towards both activities.

How would this work? Obviously investment decisions have implications for
society as a whole. The implementation of these decisions require the use of
**existing** capacity and so must be the responsibility of the appropriate
level of the confederation in question. Investment decisions taken at levels
above the production unit become effective in the form of demand for the
current output of the syndicates which have the capacity to produce the goods
required. This would require each syndicate to _"prepare a budget, showing its
estimate of requirements both of goods or services for immediate use, and of
extensions and improvements."_ [Cole, **Op. Cit.**, p. 145] These budgets and
investment projects would be discussed at the appropriate level of the
confederation (in this, communist-anarchism would be similar to collectivist
anarchism).

The confederation of syndicates/communes would be the ideal forum to discuss
(communicate) the various investment plans required -- and to allocate scarce
resources between different ends. This would involve, possibly, dividing
investment into two groups -- necessary and optional -- and using statistical
techniques to consider the impact of an investment decision (for example, the
use of input-output tables could be used to see if a given investment decision
in, say, the steel industry would require investment in energy production). In
this way social needs **and** social costs would be taken into account and
ensure that investment decisions are not taken in isolation from one another,
so causing bottle-necks and insufficient production due to lack of inputs from
other industries.

Necessary investments are those which have been agreed upon by the appropriate
confederation. It means that resources and productive capacity are prioritised
towards them, as indicated in the agreed investment project. It will not be
required to determine precisely **which** syndicates will provide the
necessary goods for a given investment project, just that it has priority over
other requests. Under capitalism, when a bank gives a company credit, it
rarely asks exactly which companies will be contracted with when the money is
spent but, rather, it gives the company the power to command the labour of
other workers by supplying them with credit/money. Similarly in an anarcho-
communist society, except that the other workers have agreed to supply their
labour for the project in question by designating it a **_"necessary
investment"_**. This means when a request arrives at a syndicate for a
**_"necessary investment"_** a syndicate must try and meet it (i.e. it must
place the request into its production schedule before _"optional"_ requests,
assuming that it has the capacity to meet it). A list of necessary investment
projects, including what they require and if they have been ordered, will be
available to all syndicates to ensure such a request is a real one.

Optional investment is simply investment projects which have not been agreed
to by a confederation. This means that when a syndicate or commune places
orders with a syndicate they may not be met or take longer to arrive. The
project may go ahead, but it depends on whether the syndicate or commune can
find workers willing to do that work. This would be applicable for small scale
investment decisions or those which other communes/syndicates do not think of
as essential.

Thus we have two inter-related investment strategies. A communist-anarchist
society would prioritise certain forms of investment by the use of
**_"necessary"_** and **_"optional"_** investment projects. This socialisation
of investment will allow a free society to ensure that social needs are meet
while maintaining a decentralised and dynamic economy. Major projects to meet
social needs will be organised effectively, but with diversity for minor
projects. The tasks of ensuring investment production, making orders for
specific goods and so forth, would be as decentralised as other aspects of a
free economy and so anarchism _"proposes . . . [t]hat usufruct of instruments
of production -- land included -- should be free to all workers, or groups of
workers"_, that _"workers should group themselves, and arrange their work as
their reason and inclination prompt"_ and that _"the necessary connections
between the various industries . . . should be managed on the same voluntary
principle."_ [Charlotte M. Wilson, **Anarchist Essays**, p. 21]

As for when investment is needed, it is clear that this will be based on the
changes in demand for goods in both collectivist and communist anarchism. As
Guilliaume put it: _"By means of statistics gathered from all the communes in
a region, it will be possible to scientifically balance production and
consumption. In line with these statistics, it will also be possible to add
more help in industries where production is insufficient and reduce the number
of men where there is a surplus of production."_ [_"On Building the New Social
Order"_, pp. 356-79, **Bakunin on Anarchism**, p. 370] Obviously, investment
in branches of production with a high demand would be essential and this would
be easily seen from the statistics generated by the collectives and communes.
Tom Brown made this obvious point:

> _"Goods, as now, will be produced in greater variety, for workers like
producing different kinds, and new models, of goods. Now if some goods are
unpopular, they will be left on the shelves . . . Of other goods more popular,
the shops will be emptied. Surely it is obvious that the [shop] assistant will
decrease his order of the unpopular line and increase his order of the
popular."_ [**Syndicalism**, p. 55]

As a rule of thumb, syndicates that produce investment goods would be inclined
to supply other syndicates who are experiencing excess demand before others,
all other things being equal. Because of such guidelines and communication
between producers, investment would go to those industries that actually
required them. In other words, customer choice (as indicated by individuals
choosing between the output of different syndicates) would generate
information that is relevant to investment decisions.

As production would be decentralised as far as it is sensible and rational to
do so, each locality/region would be able to understand its own requirements
and apply them as it sees fit. This means that large-scale planning would not
be conducted (assuming that it could work in practice, of course) simply
because it would not be needed. This, combined with an extensive
communications network, would ensure that investment not only did not
duplicate unused plant within the economy but that investments take into
account the specific problems and opportunities each locality has. Of course,
collectives would experiment with new lines and technology as well as existing
lines and so invest in new technologies and products. As occurs under
capitalism, extensive consumer testing would occur before dedicating major
investment decisions to new products.

In addition, investment decisions would also require information which showed
the different outcomes of different options. By this we simply mean an
analysis of how different investment projects relate to each other in terms of
inputs and outputs, compared to the existing techniques. This would be in the
form of cost-benefit analysis (as outlined in [section
I.4.4](secI4.html#seci44)) and would show when it would make economic, social
and ecological sense to switch industrial techniques to more efficient and/or
more empowering and/or more ecologically sound methods. Such an evaluation
would indicate levels of inputs and compare them to the likely outputs. For
example, if a new production technique reduced the number of hours worked in
total (comparing the hours worked to produce the machinery with that reduced
in using it) as well as reducing waste products for a similar output, then
such a technique would be implemented.

Similarly with communities. A commune will obviously have to decide upon and
plan civic investment (e.g. new parks, housing and so forth). They will also
have the deciding say in industrial developments in their area as it would be
unfair for syndicate to just decide to build a cement factory next to a
housing co-operative if they did not want it. There is a case for arguing that
the local commune will decide on investment decisions for syndicates in its
area (for example, a syndicate may produce X plans which will be discussed in
the local commune and one plan finalised from the debate). Regional decisions
(for example, a new hospital) could be decided at the appropriate level, with
information fed from the health syndicate and consumer co-operatives. The
actual location for investment decisions will be worked out by those involved.
However, local syndicates must be the focal point for developing new products
and investment plans in order to encourage innovation.

Therefore, under anarchism no capital market is required to determine whether
investment is required and what form it would take. The work that apologists
for capitalism claim currently is done by the stock market can be replaced by
co-operation and communication between workplaces in a decentralised,
confederated network. The relative needs of different consumers of a product
can be evaluated by the producers and an informed decision reached on where it
would best be used. Without private property, housing, schools, hospitals,
workplaces and so on will no longer be cramped into the smallest space
possible. Instead, they will be built within a "green" environment. This means
that human constructions will be placed within a natural setting and no longer
stand apart from nature. In this way human life can be enriched and the evils
of cramping as many humans and things into a small a space as is "economical"
can be overcome.

Only by taking investment decisions away from "experts" and placing it in the
hands of ordinary people will current generations be able to invest according
to their, and future generations', benefit. It is hardly in our best interests
to have a system whose aim is to make the wealthy even wealthier and on whose
whims are dependent the lives of millions of people.

## I.4.9 Should technological advance be seen as anti-anarchistic?

Not necessarily. This is because technology can allow us to "do more with
less," technological progress can improve standards of living for all people,
and technologies can be used to increase personal freedom: medical technology,
for instance, can free people from the scourges of pain, illness, and a
"naturally" short life span; technology can be used to free labour from
mundane chores associated with production; advanced communications technology
can enhance our ability to freely associate. The list is endless. So the vast
majority of anarchists agree with Kropotkin's comment that the _"development
of [the industrial] technique at last gives man [sic!] the opportunity to free
himself from slavish toil."_ [**Ethics**, p. 2]

For example, increased productivity under capitalism usually leads to further
exploitation and domination, displaced workers, economic crisis, etc. However,
it does not have to so in an anarchist world. By way of example, consider a
commune in which 5 people desire to be bakers (or 5 people are needed to work
the communal bakery) and 20 hours of production per person, per week is spent
on baking bread. Now, what happens if the introduction of automation, **as
desired, planned and organised by the workers themselves**, reduces the amount
of labour required for bread production to 15 person-hours per week? Clearly,
no one stands to lose -- even if someone's work is "displaced" that person
will continue to receive the same access to the means of life as before -- and
they might even gain. This last is due to the fact that 5 person-hours have
been freed up from the task of bread production, and those person-hours may
now be used elsewhere or converted to leisure, either way increasing each
person's standard of living.

Obviously, this happy outcome derives not only from the technology used, but
also (and critically) from its use in an equitable economic and social system:
in the end, there is no reason why the use of technology cannot be used to
empower people and increase their freedom!

Of course technology can be used for oppressive ends. Human knowledge, like
all things, can be used to increase freedom or to decrease it, to promote
inequality or reduce it, to aid the worker or to subjugate them, and so on.
Technology, as we argued in [section D.10](secD10.html), cannot be considered
in isolation from the society it is created and used in. Most anarchists are
aware that, to quote expert David Noble, _"Capital invested in machines that
would re-enforce the system of domination [within the capitalist workplace],
and this decision to invest, which might in the long run render the chosen
technology economical, was not itself an economical decision but a political
one, with cultural sanction."_ [**Progress Without People**, p. 6] In a
hierarchical society, technology will be introduced that serves the interests
of the powerful and helps marginalise and disempower the majority
(_"technology is political,"_ to use Noble's expression). It does not evolve
in isolation from human beings and the social relationships and power
structures between them.

It is for these reasons that anarchists have held a wide range of opinions
concerning the relationship between human knowledge and anarchism. Some, such
as Peter Kropotkin, were themselves scientists and saw great potential for the
use of advanced technology to expand human freedom. Others have held
technology at arm's length, concerned about its oppressive uses, and a few
have rejected science and technology completely. All of these are, of course,
possible anarchist positions. But most anarchists support Kropotkin's
viewpoint, but with a healthy dose of practical Luddism when viewing how
technology is (ab)used in capitalism (_"The worker will only respect machinery
**in the day** when it becomes his friend, shortening his work, rather than as
**today,** his enemy, taking away jobs, killing workers."_ [Emile Pouget
quoted by Noble, **Op. Cit.**, p. 15]). Vernon Richards stated the obvious:

> _"We maintain that the term 'productivity' has meaning, or is socially
important, only when all production serves a public need . . . _

> _"Productivity has meaning if it results both in a raising of living
standards and an increase of leisure for all._

> _"'Productivity' in the society we live in, because it is not a means to a
social end, but is the means whereby industrialists hope to make greater
profits for themselves and their shareholders, should be resolutely resisted
by the working people, for it brings them neither greater leisure nor
liberation from wage-slavery. Indeed for many it means unemployment . . . _

> _"The attempts by managers and the technocrats to streamline industry are
resisted intuitively by most work people even if they haven't two political
ideas in their heads to knock together, not because they are resistant to
change **per se** but because they cannot see that 'change' will do them any
good. And of course they are right! Such an attitude is nevertheless a
negative one, and the task of anarchist propagandists should be to make them
aware of this and point to the only alternative, which, in broad terms, is
that the producers of wealth must control it for the benefit of all."_ [**Why
Work?**, Vernon Richards (ed.), p. 206]

This means that in an anarchist society, technology would have to be
transformed and/or developed which empowered those who used it, so reducing
any oppressive aspects associated with it. As Kropotkin argued, we are
(potentially) in a good position, because _"[f]or the first time in the
history of civilisation, mankind has reached a point where the means of
satisfying its needs are in excess of the needs themselves. To impose,
therefore, as hitherto been done, the curse of misery and degradation upon
vast divisions of mankind, in order to secure well-being and further
development for the few, is needed no more: well-being can be secured for all,
without placing on anyone the burden of oppressive, degrading toil and
humanity can at last build its entire social life on the basis of justice."_
[**Op. Cit.**, p. 2] The question is, for most anarchists, how can we humanise
and modify this technology and make it socially and individually liberatory,
rather than destroying it (where applicable, of course, certain forms of
technology and industry will be eliminated due to their inherently destructive
nature).

For Kropotkin, like most anarchists, the way to humanise technology and
industry was for _"the workers [to] lay hands on factories, houses and banks"_
and so _"present production would be completely revolutionised by this simple
fact."_ This would be the start of a process which would **integrate**
industry and agriculture, as it was _"essential that work-shops, foundries and
factories develop within the reach of the fields."_ [**The Conquest of
Bread**, p. 190] Such a process would obviously involve the transformation of
both the structure and technology of capitalism rather than its simple and
unthinking application. As discussed in [section A.3.9](secA3.html#seca39),
while a few anarchists do seek to eliminate all forms of technology, most
would agree with Bakunin when he argued that _"to destroy . . . all the
instruments of labour . . . would be to condemn all humanity -- which is
infinitely too numerous today to exist . . . on the simple gifts of nature . .
. -- to . . . death by starvation."_ His solution to the question of
technology was, like Kropotkin's, to place it at the service of those who use
it, to create _"the intimate and complete union of capital and labour"_ so
that it would _"not . . . remain concentrated in the hands of a separate,
exploiting class."_ Only this could _"smash the tyranny of capital."_ [**The
Basic Bakunin**, pp. 90-1] So most anarchists seek to transform rather then
eliminate technology and to do that we need to be in possession of the means
of production before we can decide what to keep, what to change and what to
throw away as inhuman. In other words, it is not enough to get rid of the
boss, although this is a necessary first step!

Anarchists of all types recognise the importance of critically evaluating
technology, industry and so on. The first step of any revolution will be the
seizing of the means of production. The second **immediate** step will be the
start of their radical transformation by those who use them and are affected
by them (i.e. communities, those who use the products they produce and so on).
Few, if any, anarchists seek to maintain the current industrial set-up or
apply, unchanged, capitalist technology. We doubt that many of the workers who
use that technology and work in industry will leave either unchanged. Rather,
they will seek to liberate the technology they use from the influences of
capitalism, just as they liberated themselves.

This will, of course, involve the shutting down (perhaps instantly or over a
period of time) of many branches of industry and the abandonment of such
technology which cannot be transformed into something more suitable for use by
free individuals. And, of course, many workplaces will be transformed to
produce new goods required to meet the needs of the revolutionary people or
close due to necessity as a social revolution will disrupt the market for
their goods -- such as producers of luxury export goods or suppliers of
repressive equipment for state security forces. Altogether, a social
revolution implies the transformation of technology and industry, just as it
implies the transformation of society.

This process of transforming work can be seen from the Spanish Revolution.
Immediately after taking over the means of production, the Spanish workers
started to transform it. They eliminated unsafe and unhygienic working
conditions and workplaces and created new workplaces based on safe and
hygienic working conditions. Working practices were transformed as those who
did the work (and so understood it) managed it. Many workplaces were
transformed to create products required by the war effort (such as weapons,
ammunition, tanks and so on) and to produce consumer goods to meet the needs
of the local population as the normal sources of such goods, as Kropotkin
predicted, were unavailable due to economic disruption and isolation. Needless
to say, these were only the beginnings of the process but they clearly point
the way any libertarian social revolution would progress, namely the total
transformation of work, industry and technology. Technological change would
develop along new lines, ones which will take into account human and
ecological needs rather the power and profits of a minority.

Explicit in anarchism is the belief that capitalist and statist methods cannot
be used for socialist and libertarian ends. In our struggle for workers' and
community self-management is the awareness that workplaces are not merely
sites of production -- they are also sites of **re**production, the
reproduction of certain social relationships based on specific relations of
authority between those who give orders and those who take them. The battle to
democratise the workplace, to place the collective initiative of the direct
producers at the centre of any productive activity, is clearly a battle to
transform the workplace, the nature of work and, by necessity, technology as
well. As Kropotkin argued:

> _"revolution is more than a mere change of the prevailing political system.
It implies the awakening of human intelligence, the increasing of the
inventive spirit tenfold, a hundredfold; it is the dawn of a new science . . .
It is a revolution in the minds of men, as deep, and deeper still, than in
their institutions . . . the sole fact of having laid hands on middle-class
property will imply the necessity of completely re-organising the whole of
economic life in the workplaces, the dockyards, the factories."_ [**Op.
Cit.**, p. 192]

And some think that industry and technology will remain unchanged by such a
process and that workers will continue doing the same sort of work, in the
same way, using the same methods!

For Kropotkin _"all production has taken a wrong direction, as it is not
carried on with a view to securing well-being for all"_ under capitalism.
[**Op. Cit.**, p. 101] Well-being for all obviously includes those who do the
producing and so covers the structure of industry and the technological
processes used. Similarly, well-being also includes a person's environment and
surroundings and so technology and industry must be evaluated on an ecological
basis. Technological progress in an anarchist society, needless to say, will
have to take into account these factors as well as others people think are
relevant, otherwise the ideal of _"well-being for all"_ is rejected (see
[section I.4.15](secI4.html#seci415) for a discussion of what the workplace of
the future could look like).

So, technology always partakes of and expresses the basic values of the social
system in which it is embedded. If you have a system (capitalism) that
alienates everything, it will naturally produce alienated forms of technology
and it will orient those technologies so as to reinforce itself. Capitalists
will select technology which re-enforces their power and profits and skew
technological change in that direction rather than in those which empower
individuals and make the workplace more egalitarian.

All this suggests that technological progress is not neutral but dependent on
who makes the decisions. As David Noble argues, _"[t]echnological determinism,
the view that machines make history rather than people, is not correct . . .
If social changes now upon us seem necessary, it is because they follow not
from any disembodied technological logic, but form a social logic."_
Technology conforms to _"the interests of power"_ but as _"technological
process is a social process"_ then _"it is, like all social processes, marked
by conflict and struggle, and the outcome, therefore, is always ultimately
indeterminate."_ Viewing technological development _"as a social process
rather than as an autonomous, transcendent, and deterministic force can be
liberating . . . because it opens up a realm of freedom too long denied. It
restores people once again to their proper role as subjects of the story,
rather than mere pawns of technology . . . And technological development
itself, now seen as a social construct, becomes a new variable rather than a
first cause, consisting of a range of possibilities and promising a
multiplicity of futures."_ [**Forces of Production**, pp. 324-5]

This does not mean that we have to reject all technology and industry because
it has been shaped by, or developed within, class society. Certain
technologies are, of course, so insanely dangerous that they will no doubt be
brought to a prompt halt in any sane society. Similarly, certain forms of
technology and industrial process will be impossible to transform as they are
inherently designed for oppressive ends. Many other industries which produce
absurd, obsolete or superfluous commodities will, of course, cease
automatically with the disappearance of their commercial or social rationales.
But many technologies, however they may presently be misused, have few if any
inherent drawbacks. They could be easily adapted to other uses. When people
free themselves from domination, they will have no trouble rejecting those
technologies that are harmful while adapting others to beneficial uses.

Change society and the technology introduced and utilised will likewise
change. By viewing technological progress as a new variable, dependent on
those who make the decisions and the type of society they live in, allows us
to see that technological development is not inherently anti-anarchist. A non-
oppressive, non-exploitative, ecological society will develop non-oppressive,
non-exploitative, ecological technology just as capitalism has developed
technology which facilitates exploitation, oppression and environmental
destruction. Thus an anarchist questions technology: The best technology? Best
for whom? Best for what? Best according to what criteria, what visions,
according to whose criteria and whose visions?

Needless to say, different communities and different regions would choose
different priorities and different lifestyles. As the CNT's Zaragoza
resolution on libertarian communism made clear, _"those communes which reject
industrialisation . . . may agree upon a different model of co-existence."_
Using the example of _"naturists and nudists,"_ it argued that they _"will be
entitled to an autonomous administration released from the general
commitments"_ agreed by the communes and their federations and _"their
delegates to congresses of the . . . Confederation of Autonomous Libertarian
Communes will be empowered to enter into economic contacts with other
agricultural and industrial Communes."_ [quoted by Jose Peirats, **The CNT in
the Spanish Revolution**, vol. 1, p. 106]

For most anarchists, though, technological advancement is important in a free
society in order to maximise the free time available for everyone and replace
mindless toil with meaningful work. The means of doing so is the use of
**appropriate** technology (and **not** the worship of technology as such).
Only by critically evaluating technology and introducing such forms which
empower, are understandable and are controllable by individuals and
communities as well as minimising ecological distribution can this be
achieved. Only this critical approach to technology can do justice to the
power of the human mind and reflect the creative powers which developed the
technology in the first place. Unquestioning acceptance of technological
progress is just as bad as being unquestioningly anti-technology.

## I.4.10 What would be the advantage of a wide basis of surplus distribution?

We noted earlier (in [section I.3.1](secI3.html#seci31)) that competition
between syndicates could lead to _"co-operative egotism"_ (to use Kropotkin's
term) and that to eliminate this problem, the basis of collectivisation needs
to be widened so that production is based on need and, as a result, surpluses
are distributed society-wide. The advantage of a wide surplus distribution is
that it allows all to have a decent life and stop market forces making people
work harder and longer to survive in the economy (see [section
I.1.3](secI1.html#seci13)). The consolidation of syndicates that would
otherwise compete will, it is hoped, lead to a more efficient allocation of
resources and technical improvements so allowing the transformation of work
and reduction of the time we need to spend in production. We will back up this
claim with illustrations from the Spanish Revolution as well as from today's
system.

Collectivisation in Catalonia embraced not only major industries like
municipal transportation and utilities, but smaller establishments as well:
small factories, artisan workshops, service and repair shops, etc. Augustin
Souchy describes the process as follows:

> _"The artisans and small workshop owners, together with their employees and
apprentices, often joined the union of their trade. By consolidating their
efforts and pooling their resources on a fraternal basis, the shops were able
to undertake very big projects and provide services on a much wider scale . .
. The collectivisation of the hairdressing shops provides an excellent example
of how the transition of a small-scale manufacturing and service industry from
capitalism to socialism was achieved . . ._

> _"Before July 19th, 1936 [the date of the Revolution], there were 1,100
hairdressing parlours in Barcelona, most of them owned by poor wretches living
from hand to mouth. The shops were often dirty and ill-maintained. The 5,000
hairdressing assistants were among the most poorly paid workers . . . Both
owners and assistants therefore voluntarily decided to socialise all their
shops._

> _"How was this done? All the shops simply joined the union. At a general
meeting they decided to shut down all the unprofitable shops. The 1,100 shops
were reduced to 235 establishments, a saving of 135,000 pesetas per month in
rent, lighting, and taxes. The remaining 235 shops were modernised and
elegantly outfitted. From the money saved, wages were increased by 40%.
Everyone having the right to work and everyone received the same wages. The
former owners were not adversely affected by socialisation. They were employed
at a steady income. All worked together under equal conditions and equal pay.
The distinction between employers and employees was obliterated and they were
transformed into a working community of equals -- socialism from the bottom
up."_ [**The Anarchist Collectives**, Sam Dolgoff (ed.), pp. 93-94]

The collectives, as well as improving working conditions, also ensured access
to other goods and services which market forces had previously denied working
class people. Across Republican Spain collectives in towns and villages
organised health care. For example, in the village of Magdalena de Pulpis
housing _"was free and completely socialised, as was medical care . . .
Medicines, supplies, transfer to hospitals in Barcelona or Castellon, surgery,
services of specialists -- all was paid for by the collective."_ This was also
done for education, with collectives forming and running schools, colleges and
universities. For example, Regional Peasant Federation of Levant saw each
collective organise _"one or two free schools for the children"_ and _"almost
wiped out illiteracy"_ (over 70% of rural Spain was illiterate before the
Civil War). It also organised a _"University of Moncada"_ which _"gave courses
in animal husbandry, poultry raising. animal breeding, agriculture, tree
science, etc."_ [Gaston Leval, **Op. Cit.**, p. 156 and p. 125]

These examples, social anarchists argue, show that co-operation ensures that
resources are efficiently allocated and waste is minimised by cutting down
needless competition. It also ensures that necessary goods and services which
meet vital areas for human well-being and development are available for all
rather than the few. Rather than reduce choice, such co-operation increased it
by making such things available to all (and as consumers have choices in which
syndicate to consume from as well as having direct communication between
consumer co-operatives and productive units, there is little danger that
rationalisation in production will hurt the interests of the consumer).

Another way in which wide distribution of surplus can be advantageous is in
Research and Development (R&amp;D). By creating a fund for research and
development which is independent of the fortunes of individual syndicates,
society as a whole can be improved by access to useful new technologies and
processes. Therefore, in a libertarian socialist society, people (both within
the workplace and in communities) are likely to decide to allocate significant
amounts of resources for basic research from the available social output. This
is because the results of this research would be freely available to all and
so would aid everyone in the long term. In addition, because workers directly
control their workplace and the local community effectively "owns" it, all
affected would have an interest in exploring research which would reduce
labour, pollution, waste and so on or increase output with little or no social
impact.

It should also be mentioned here that research would be pursued more and more
as people take an increased interest in both their own work and education. As
people become liberated from the grind of everyday life, they will explore
possibilities as their interests take them and so research will take place on
many levels within society - in the workplace, in the community, in education
and so on.

This means that research and innovation would be in the direct interests of
everyone involved and that all would have the means to do it. Under
capitalism, this is not the case. Most research is conducted in order to get
an edge in the market by increasing productivity or expanding production into
new (previously unwanted) areas. Any increased productivity often leads to
unemployment, deskilling and other negative effects for those involved.
Libertarian socialism will not face this problem. Moreover, it should be
stressed that basic research is not something which free-market capitalism
does well. As Doug Henwood notes, basic science research _"is heavily funded
by the public sector and non-profit institutions like universities."_ The
internet and computer, for example, were both projects for the Pentagon and
_"the government picked up the basic R&amp;D tab for decades, when neither
Wall Street nor private industry showed any interest. In fact, capital only
became interested when the start-up costs had all been borne by the public
sector and there were finally profits to be made . . . good American
individualists don't like to talk about the public sector, since their hero is
the plucky entrepreneur."_ [**After the New Economy**, p. 196 and p. 6] The
rise of such systems across the world indicates that basic research often
needs public support in order to be done. Even such a leading neo-classical
economist as Kenneth Arrow had to admit in the 1960s that market forces are
insufficient:

> _"basic research, the output of which is only used as an informational input
into other inventive activities, is especially unlikely to be rewarded. In
fact, it is likely to be of commercial value to the firm undertaking it only
if other firms are prevented from using the information. But such restriction
reduces the efficiency of inventive activity in general, and will therefore
reduce its quantity also."_ [quoted by David Schweickart, **Against
capitalism**, p. 132]

Nothing has changed since. Would modern society have produced so many
innovations if it had not been for the Pentagon system, the space race and so
on? Take the Internet, for example -- it is unlikely that this would have got
off the ground if it had not been for public funding. Needless to say, of
course, much of this technology has been developed for evil reasons and
purposes and would be in need of drastic change (or in some cases abolition)
before it could be used in a libertarian society. However, the fact remains
that it is unlikely that a pure market based system could have generated most
of the technology we take for granted. As Noam Chomsky argues:

> _"[Alan] Greenspan [then head of the US Federal Reserve] gave a talk to
newspaper editors in the US. He spoke passionately about the miracles of the
market, the wonders brought by consumer choice, and so on. He also gave
examples: the Internet, computers, information processing, lasers, satellites,
transistors. It's an interesting list: these are textbook examples of
creativity and production in the public sector. In the case of the Internet,
for 30 years it was designed, developed and funded primarily in the public
sector, mostly the Pentagon, then the National Science Foundation -- that's
most of the hardware, the software, new ideas, technology, and so on. In just
the last couple of years it has been handed over to people like Bill Gates . .
. In the case of the Internet, consumer choice was close to zero, and during
the crucial development stages that same was true of computers, information
processing, and all the rest . . . _

> _"In fact, of all the examples that Greenspan gives, the only one that maybe
rises above the level of a joke is transistors, and they are an interesting
case. Transistors, in fact, were developed in a private laboratory -- Bell
Telephone Laboratories of AT&amp;T -- which also made major contributions to
solar cells, radio astronomy, information theory, and lots of other important
things. But what is the role of markets and consumer choice in that? Well,
again, it turns out, zero. AT&amp;T was a government supported monopoly, so
there was no consumer choice, and as a monopoly they could charge high prices:
in effect a tax on the public which they could use for institutions like Bell
Laboratories . . . So again, it's publicly subsidised. As if to demonstrate
the point, as soon as the industry was deregulated, Bell Labs went out of
existence, because the public wasn't paying for it any more . . . But that's
only the beginning of the story. True, Bell invented transistors, but they
used wartime technology, which, again, was publicly subsidised and state-
initiated. Furthermore, there was nobody to buy transistors at that time,
because they were very expensive to produce. So, for ten years the government
was the major procurer . . . Government procurement provided entrepreneurial
initiatives and guided the development of the technology, which could then be
disseminated to industry."_ [**Rogue States**, pp. 192-3]

The free market can also have a negative impact on innovation. This is
because, in order to please shareholders with higher share prices, companies
may reduce funds available for real investment as well as R&amp;D which would
also depress growth and employment in the long term. What shareholders might
condemn as "uneconomic" (investment projects and R&amp;D) can, and does, make
society as a whole better off. However, these gains are over the long term
and, within capitalism, it is short-term gains which count. Higher share
prices in the here and now are essential in order to survive and so see the
long-run.

A socialised economy with a wide-scale sharing of surpluses and resources
could easily allocate resources for R&amp;D, long term investment, innovation
and so on. Via the use of mutual banks or confederations of syndicates and
communes, resources could be allocated which take into account the importance
of long-term priorities, as well as social costs, which are not taken into
account (indeed, are beneficial to ignore) under capitalism. Rather than
penalise long term investment and research and development, a socialised
economy would ensure that adequate resources are available, something which
would benefit everyone in society in some way.

If we look at vocational training and education, a wide basis of surplus
distribution would aid this no end. Under free market capitalism, vocational
training suffers for profit seeking firms will not incur costs that will be
enjoyed by others. This means that firms will be reluctant to spend money on
training if they fear that the trained workers will soon be poached by other
firms which can offer more money because they had not incurred the cost of
providing training. As a result few firms will provide the required training
as they could not be sure that the trained workers will not leave for their
competitors (and, of course, a trained work force also, due to their skill,
have more workplace power and are less replaceable). So as well as
technological developments, a wide basis of surplus distribution would help
improve the skills and knowledge of the members of a community. As Keynesian
economist Michael Stewart points out, _"[t]here are both theoretical and
empirical reasons to suppose that market forces under-provide research and
development expenditures, as well as both education and training."_ [**Keynes
in the 1990s**, p. 77]

By socialising training via confederations of workplaces, syndicates could
increase productivity via increasing the skill levels of their members. Higher
skill levels will also tend to increase innovation and enjoyment at "work"
when combined with workers' self-management. This is because an educated
workforce in control of their own time will be unlikely to tolerate mundane,
boring, machine-like work and seek ways to eliminate it, improve the working
environment and increase productivity to give them more free time.

In addition to work conducted by syndicates, education establishments,
communes and so on, it would be essential to provide resources for individuals
and small groups to pursue "pet projects." Of course, syndicates and
confederations will have their own research institutions but the innovatory
role of the interested "amateur" cannot be over-rated. As Kropotkin argued:

> _"What is needed to promote the spirit of innovation is . . . the awakening
of thought, the boldness of conception, which our entire education causes to
languish; it is the spreading of a scientific education, which would increase
the numbers of inquirers a hundred-fold; it is faith that humanity is going to
take a step forward, because it is enthusiasm, the hope of doing good, that
has inspired all the great inventors. The Social Revolution alone can give
this impulse to thought, this boldness, this knowledge, this conviction of
working for all._

> _"Then we shall have vast institutes . . . immense industrial laboratories
open to all inquirers, where men will be able to work out their dreams, after
having acquitted themselves of their duty towards society; . . . where they
will make their experiments; where they will find other comrades, experts in
other branches of industry, likewise coming to study some difficult problem,
and therefore able to help and enlighten each other -- the encounter of their
ideas and experiences causing the longed-for solution to be found."_ [**The
Conquest of Bread**, p. 117]

The example of free software (operating systems, programming languages,
specific packages and code) today shows the potential of this. Thus
socialisation would aid innovation and scientific development by providing the
necessary resources (including free time) for such work. Moreover, it would
also provide the community spirit required to push the boundaries of science
forward. As John O'Neil argues:

> _"There is, in a competitive market economy, a disincentive to communicate
information. The market encourages secrecy, which is inimical to openness in
science. It presupposes a view of property in which the owner has rights to
exclude others. In the sphere of science, such rights of exclusion place
limits on the communication of information and theories which are incompatible
with the growth of knowledge . . . science tends to grow when communication is
open. . . [In addition a] necessary condition for the acceptability of a
theory or experimental result is that it pass the public, critical scrutiny of
competent scientific judges. A private theory or result is one that is
shielded from the criteria of scientific acceptability."_ [**The Market**, p.
153]

Today inventors often _"carefully hide their inventions from each other, as
they are hampered by patents and Capitalism -- that bane of present society,
that stumbling-block in the path of intellectual and moral progress."_ In a
free society, socialisation would ensure that inventors will be able to build
upon the knowledge of everyone, including past generations. Rather than hide
knowledge from others, in case they get a competitive advantage, knowledge
would be shared, enriching all involved as well as the rest of society. Thus
the _"spreading of a scientific education, which would increase the number of
inquirers"_, _"faith that humanity is going to take a step forward"_ and the
_"enthusiasm, the hope of doing good, that has inspired all the great
inventors"_ will be maximised and innovation increased. [Kropotkin, **Op.
Cit.**, p. 117 and pp. 116-7]

Social anarchists would also suggest that socialisation would produce more
benefits by looking at existing societies. The evidence from the UK, USA,
Australia, New Zealand and China shows that privatisation of nationalised
industries associated with neo-liberalism failed in its stated aims of cheaper
and better services while more than succeeding in their unstated aim of
redistributing wealth upwards (for details see **In Government we Trust:
Market Failure and the delusions of privatisation** by Warrick Funnell, Robert
Jupe and Jane Andrew). The examples of railway and utility privatisation, the
energy crisis in California (with companies like Enron reaping huge
speculative profits while consumers faced blackouts) and the Sydney water
treatment scandal in Australia are sadly all too typical. Ironically, in the
UK after 30 years of Thatcherite policies (first under the Tories and then New
Labour) the readers of the right-wing press who supported it are subjected to
article after article complaining about _"Rip off Britain"_ and yet more
increases in the prices charged for privatised utilities, services and goods.
This, it must be stressed, is not to suggest that anarchists aim for
nationalisation (we do not, we aim for socialisation and workers' self-
management) but rather to indicate that privatising resources does not benefit
the majority of people in a given society.

It should also be noted that more unequal societies are bad for almost
everyone within them. Richard Wilkinson and Kate Pickett in their book **The
Spirit Level: Why More Equal Societies Almost Always Do Better** show that
almost every modern social and environmental problem (including ill-health,
lack of community life, violence, drugs, obesity, mental illness, long working
hours, big prison populations) is more likely to occur in an unequal society
than a more equal one. Based on thirty years of research, it shows that
inequality, as anarchists have long argued, is bad for us. As such,
socialisation of wealth would benefit us all.

Lastly, there is the issue of those who cannot work and the general provision
of public goods. With a wide distribution to surplus, communal hospitals,
schools, universities and so on can be created. The simple fact is that any
society has members who cannot (indeed, should not) work unless they want to,
such as the young, the old and the sick. In an Individualist Anarchist
society, there is no real provision for these individuals unless someone (a
family member, friend or charity) provides them with the money required for
hospital fees and so on. For most anarchists, such a situation seems far too
much like the system we are currently fighting against to be appealing. As
such, social anarchists argue that everyone deserves an education, health care
and so on as a right and so be able live a fully human life as a right, rather
than a privilege to be paid for. A communal basis for distribution would
ensure that every member of the commune can receive such things automatically,
as and when required. The removal of the worry that, for example, privatised
health care produces can be seen as a benefit of socialisation which cannot be
reflected in, say, GDP or similar economic measures (not to mention the
ethical statement it makes).

Significantly, though, non-privatised systems of health care are more
efficient. Competition as well as denying people treatment also leads to
inefficiencies as prices are inflated to pay for advertising, competition
related administration costs, paying dividends to share-holders and so on.
This drives up the cost for those lucky enough to be covered, not to mention
the stress produced by the constant fear of losing insurance or being denied
payment due to the insurance company deciding against the patient and their
doctor. For example, in 1993, Canada's health plans devoted 0.9% of spending
to overhead, compared to U.S. figures of 3.2% for Medicare and 12% for private
insurers. In addition, when Canada adopted its publicly financed system in
1971, it and the U.S. both spent just over 7% of GDP on health care. By 1990,
the U.S. was up to 12.3%, verses Canada's 9%. Since then costs have continued
to rise and rise, making health-care reform of key interest to the public who
are suffering under it (assuming they are lucky enough to have private
insurance, of course).

The madness of private health-care shows the benefits of a society-wide
distribution of surpluses. Competition harms health-care provision and, as a
result, people. According to Alfie Kohn:

> _"More hospitals and clinics are being run by for-profit corporations; many
institutions, forced to battle for 'customers,' seem to value a skilled
director of marketing more highly than a skilled caregiver. As in any other
economic sector, the race for profits translates into pressure to reduce
costs, and the easiest way to do it here is to cut back on services to
unprofitable patients, that is, those who are more sick than rich . . . The
result: hospital costs are actually **higher** in areas where there is more
competition for patients."_ [**No Contest**, p. 240]

American Liberal Robert Kuttner concurs:

> _"The American health-care system is a tangle of inequity and inefficiency
-- and getting worse as private-market forces seek to rationalise it. A shift
to a universal system of health coverage would cut this Gordian knot at a
stroke. It would not only deliver the explicitly medical aspects of health
more efficiently and fairly, but, by socialising costs of poor health, it
would also create a powerful financial incentive for society as a whole to
stress primary prevention. . . every nation with a universal system spends
less of its GDP on health care than the United States . . . And nearly every
other nation with a universal system has longer life spans from birth (though
roughly equivalent life spans from adulthood) . . . most nations with
universal systems also have greater patient satisfaction._

> _"The reasons . . . should be obvious. By their nature, universal systems
spend less money on wasteful overhead, and more on primary prevention. Health-
insurance overhead in the United States alone consumes about 1 percent of the
GDP, compared to 0.1 percent in Canada. Though medical inflation is a problem
everywhere, the universal systems have had far lower rates of cost inflation .
. . In the years between 1980 and 1987, total health costs in the United
States increased by 2.4 times the rate of GDP growth. In nations with
universal systems, they increased far more slowly. The figures for Sweden,
France, West Germany, and Britain were 1.2, 1.6, 1.8, and 1.7 percent,
respectively . . ._

> _"Remarkably enough, the United States spends most money on health care, but
has the fewest beds per thousand in population, the lowest admission rate, and
the lowest occupancy rate -- coupled with the highest daily cost, highest
technology-intensiveness, and greatest number of employees per bed."_
[**Everything for Sale**, pp. 155-6]

In 1993, the US paid 13.4% of its GDP towards health care, compared to 10% for
Canada, 8.6% for Sweden and Germany, 6.6% for Britain and 6.8% for Japan. Only
40% of the US population was covered by public health care and over 35 million
people, 14% of the population, went without health insurance for all of 1991,
and about twice that many were uninsured for some period during the year. In
terms of health indicators, the US people are not getting value for money.
Life expectancy is higher in Canada, Sweden, Germany, Japan and Britain. The
USA has the highest levels of infant mortality and is last in basic health
indicators as well as having fewer doctors per 1,000 people than the OECD
average. All in all, the US system is miles behind the universal systems of
other countries.

Of course, it will be argued that the USA is not a pure "free market" and so
comparisons are pointless. However, it seems strange that the more competitive
system, the more privatised system, is less efficient and less fair than the
universal systems. It also seems strange that defenders of competition happily
use examples from "actually existing" capitalism to illustrate their politics
but reject negative examples as being a product of an "impure" system. They
want to have their cake and eat it too.

Significantly, we should note that the use of surplus for communal services
(such as hospitals and education) can be seen from the Spanish Revolution.
Many collectives funded new hospitals and colleges for their members,
providing hundreds of thousands with services they could never have afforded
by their own labour. This is a classic example of co-operation helping the co-
operators achieve far more than they could by their own isolated activities.
How this libertarian health system was run and how other public services would
be organised in a free society are discussed in [section
I.5.12](secI5.html#seci512).

So we can generalise from our experiences of different kinds of capitalism. If
you want to live in a society of well-educated people, working today as equals
in pleasant surroundings with more than ample leisure time to pursue your own
projects and activities, then a wide sharing of the social surplus is
required. Otherwise, you could live in a society where people work long and
hard to survive on the market, without the time or opportunity for education
and leisure, and be bossed about for most of your waking hours to enrich the
wealthy few so that they can live a life of leisure (which, in turn, will
apparently inspire you to work harder in spite of the fact that such high
inequality produces low social mobility). The first society, according to
some, would be one of self-sacrificing altruism and "collectivism" while the
latter is, apparently, one based on "individualism" and self-interest...

## I.4.11 If socialism eliminates the profit motive, won't performance suffer?

Firstly, just to be totally clear, by the profit motive we mean money profit.
As anarchists consider co-operation to be in our self-interest -- i.e. we will
"profit" from it in the widest sense possible -- we are **not** dismissing the
fact people usually act to improve their own situation. However, money profit
is a **very** narrow form of "self-interest," indeed so narrow as to be
positively harmful to the individual in many ways (in terms of personal
development, interpersonal relationships, economic and social well-being, and
so on). In other words, do not take our discussion here on the "profit motive"
to imply a denial of self-interest, quite the reverse. Anarchists simply
reject the _"narrow concept of life which consist[s] in thinking that
**profits** are the only leading motive of human society."_ [Peter Kropotkin,
**Fields, Factories and Workshops Tomorrow**, p. 25]

Secondly, we cannot hope to deal fully with the harmful effects of competition
and the profit motive. For more information, we recommend Alfie Kohn's **No
Contest: The Case Against Competition** and **Punished by Rewards: The Trouble
with Gold Stars, Incentive Plans, A's, Praise and Other Bribes**. He documents
the extensive evidence accumulated that disproves the "common sense" of
capitalism that competition and profits are the best way to organise a
society.

According to Kohn, a growing body of psychological research suggests that
rewards can lower performance levels, especially when the performance involves
creativity. His books summarise the related series of studies which show that
intrinsic interest in a task -- the sense that something is worth doing for
its own sake -- typically declines when someone is rewarded for doing it. Much
of the research on creativity and motivation has been performed by Theresa
Amabile, associate professor of psychology at Brandeis University. She has
consistently found that those promised rewards did the least creative work:
_"rewards killed creativity, and this was true regardless of the type of task,
the type of reward, the timing of the reward or the age of the people
involved."_ [**Punished by Rewards**, p. 45] Such research casts doubt on the
claim that financial reward is the only effective way -- or even the best way
-- to motivate people. They challenge the behaviourist assumption that any
activity is more likely to occur or be better in terms of outcome if it is
rewarded.

These findings re-enforce the findings of other scientific fields. Biology,
social psychology, ethnology and anthropology all present evidence that
support co-operation as the natural basis for human interaction. For example,
ethnological studies indicate that virtually all indigenous cultures operate
on the basis of highly co-operative relationships and anthropologists have
presented evidence to show that the predominant force driving early human
evolution was co-operative social interaction, leading to the capacity of
hominids to develop culture. This is even sinking into capitalism, with
industrial psychology now promoting "worker participation" and team
functioning because it is decisively more productive than hierarchical
management. More importantly, the evidence shows that co-operative workplaces
are more productive than those organised on other principles. All other things
equal, producers' co-operatives will be more efficient than capitalist or
state enterprises, on average. Co-operatives can often achieve higher
productivity even when their equipment and conditions are worse. Furthermore,
the better the organisation approximates the co-operative ideal, the better
the productivity.

All this is unsurprising to social anarchists (and it should make
individualist anarchists reconsider their position). Peter Kropotkin argued
that, _"[i]f we . . . ask Nature: 'Who are the fittest: those who are
continually at war with each other, or those who support one another?' we at
once see that those animals which acquire habits of mutual aid are undoubtedly
the fittest. They have more chances to survive, and they attain, in their
respective classes, the highest development of intelligence and bodily
organisation."_ [**Mutual Aid**, p. 24]

It should be noted that, as one biologist points out, _"Kropotkin's ideas,
though unorthodox, were scientifically respectable, and indeed the contention
that mutual aid can be a means of increasing fitness had become a standard
part of modern sociobiology."_ [Douglas H. Boucher, _"The Idea of Mutualism,
Past and Future"_, pp. 1-28, **The Biology of Mutualism: Biology and
Evolution**, Douglas H. Boucher (ed.), p. 17] Frans de Waal (a leading
primatologist) and Jessica C. Flack argue that Kropotkin is part of a wider
tradition _"in which the view has been that animals assist each other
precisely because by doing so they achieve long term, collective benefits of
greater value than the short term benefits derived from straightforward
competition."_ They summarise that the _"basic tenet of [Kropotkin's] ideas
was on the mark. Almost seventy years later, in an article entitled 'The
Evolution of Reciprocal Altruism', [Robert] Trivers refined the concepts
Kropotkin advanced and explained how co-operation and, more importantly, a
system of reciprocity (called 'reciprocal altruism' by Trivers) could have
evolved."_ [_"'Any Animal Whatever': Darwinian Building Blocks of Morality in
Monkeys and Apes"_, pp. 1-29, **Journal of Consciousness Studies**, Vol. 7,
No. 1-2, p. 4]

So modern research has reinforced Kropotkin's argument. This applies to both
human and non-human animals. For the former, the evidence is strong that we
have intrinsic abilities and needs to co-operate as well as an intrinsic
senses of fairness and ethics. This suggests that co-operation is part of
"human nature" and so studies which show that such behaviour is more
productive than competition should come as no surprise -- and the evidence is
impressive. As noted, Alfie Kohn is also the author of **No Contest: The Case
Against Competition** and he spent seven years reviewing more than 400
research studies dealing with competition and co-operation. According to Kohn,
there are three principle consequences of competition:

Firstly, it has a negative effect on productivity and excellence. This is due
to increased anxiety, inefficiency (as compared to co-operative sharing of
resources and knowledge), and the undermining of inner motivation. Competition
shifts the focus to victory over others, and away from intrinsic motivators
such as curiosity, interest, excellence, and social interaction. Studies show
that co-operative behaviour, by contrast, consistently produces good
performance -- a finding which holds true under a wide range of subject
variables. Interestingly, the positive benefits of co-operation become more
significant as tasks become more complex, or where greater creativity and
problem-solving ability is required.

Secondly, competition lowers self-esteem and hampers the development of sound,
self-directed individuals. A strong sense of self is difficult to attain when
self-evaluation is dependent on seeing how we measure up to others. On the
other hand, those whose identity is formed in relation to how they contribute
to group efforts generally possess greater self-confidence and higher self-
esteem.

Thirdly, competition undermines human relationships. Humans are social beings;
we best express our humanness in interaction with others. By creating winners
and losers, competition is destructive to human unity and prevents close
social feeling.

Social Anarchists have long argued these points. In the competitive mode,
people work at cross purposes, or purely for (material) personal gain. This
leads to an impoverishment of society as well as hierarchy, with a lack of
communal relations that result in an impoverishment of all the individuals
involved (mentally, spiritually, ethically and, ultimately, materially). This
not only leads to a weakening of individuality and social disruption, but also
to economic inefficiency as energy is wasted in class conflict and invested in
building bigger and better cages to protect the haves from the have-nots.
Instead of creating useful things, human activity is spent in useless toil
reproducing an injust and authoritarian system.

All in all, the results of competition (as documented by a host of scientific
disciplines) show its poverty as well as indicating that co-operation is the
means by which the fittest survive.

Moreover, the notion that material rewards result in better work is simply not
true. Basing itself on simple behaviourist psychology, such arguments fail to
meet the test of long-term success (and, in fact, can be counter-productive).
Indeed, it means treating human beings as little better than pets or other
animals (Kohn argues that it is _"not an accident that the theory behind 'Do
this and you'll get that' derives from work with other species, or that
behaviour management is frequently described in words better suited to
animals."_) In other words, it _"is by its very nature dehumanising."_ Rather
than simply being motivated by outside stimuli like mindless robots, people
are not passive. We are _"beings who possess natural curiosity about ourselves
and our environment, who search for and overcome challenges, who try and
master skills and attain competence, and who seek new levels of complexity in
what we learn and do . . . in general we act on the environment as much as we
are acted on by it, and we do not do so simply in order to receive a reward."_
[**Punished by Rewards**, p. 24 and p. 25]

Kohn presents extensive evidence to back upon his case that rewards harm
activity and individuals. We cannot do justice to it here so we will present a
few examples. One study with college students showed that those paid to work
on a puzzle _"spent less time on it than those who hadn't been paid"_ when
they were given a choice of whether to work on it or not. _"It appeared that
working for a reward made people less interested in the task."_ Another study
with children showed that _"extrinsic rewards reduce intrinsic motivation."_
[**Op. Cit.**, p. 70 and p. 71] Scores of other studies confirmed this. This
is because a reward is effectively saying that a given activity is not worth
doing for its own sake -- and why would anyone wish to do something they have
to be bribed to do?

In the workplace, a similar process goes on. Kohn presents extensive evidence
to show that extrinsic motivation also fails even there. Indeed, he argues
that _"economists have it wrong if they think of work as a 'disutility' --
something unpleasant we must do in order to be able to buy what we need,
merely a means to an end."_ Kohn stresses that _"to assume that money is what
drives people is to adopt an impoverished understanding of human motivation."_
Moreover, _"the risk of **any** incentive or pay-for-performance system is
that it will make people less interested in their work and therefore less
likely to approach it with enthusiasm and a commitment to excellence.
Furthermore, **the more closely we tie compensation (or other rewards) to
performance, the most damage we do.**"_ [**Op. Cit.**, p. 131, p. 134 and p.
140]

Kohn argues that the idea that humans will only work for profit or rewards
_"can be fairly described as dehumanising"_ if _"the capacity for responsible
action, the natural love of learning, and the desire to do good work are
already part of who we are."_ Also, it is _"a way of trying to control
people"_ and so to _"anyone who is troubled by a model of human relationships
founded principally on the idea of one person controlling another must ponder
whether rewards are as innocuous as they are sometimes made out to be"_. So
_"there is no getting around the fact that 'the basic purpose of merit pay is
manipulative.' One observer more bluntly characterises incentives as
'demeaning' since the message they really convey is, 'Please big daddy boss
and you will receive the rewards that the boss deems appropriate.'"_ [**Op.
Cit.**, p. 26]

Given that much work is controlled by others and can be a hateful experience
under capitalism does not mean that it has to be that way. Clearly, even under
wage slavery most workers can and do find work interesting and seek to do it
well -- not because of possible rewards or punishment but because we seek
meaning in our activities and try and do them well. Given that research shows
that reward orientated work structures harm productivity and excellence,
social anarchists have more than just hope to base their ideas. Such research
confirms Kropotkin's comments:

> _"Wage-work is serf-work; it cannot, it must not, produce all it could
produce. And it is high time to disbelieve the legend which presents wagedom
as the best incentive to productive work. If industry nowadays brings in a
hundred times more than it did in the days of our grandfathers, it is due to
the sudden awakening of physical and chemical sciences towards the end of the
[18th] century; not to the capitalist organisation of wagedom, but **in
spite** of that organisation."_ [**The Conquest of Bread**, p. 150]

For these reasons, social anarchists are confident that the elimination of the
profit motive within the context of self-management will not harm productivity
and creativity, but rather **enhance** them (within an authoritarian system in
which workers enhance the power and income of bureaucrats, we can expect
different results). With the control of their own work and workplaces ensured,
all working people can express their abilities to the full. This will see an
explosion of creativity and initiative, not a reduction.

## I.4.12 Won't there be a tendency for capitalist enterprise to reappear?

This is a common right-wing "libertarian" objection. Robert Nozick, for
example, imagined the following scenario:

> _"small factories would spring up in a socialist society, unless forbidden.
I melt some of my personal possessions and build a machine out of the
material. I offer you and others a philosophy lecture once a week in exchange
for yet other things, and so on . . . some persons might even want to leave
their jobs in socialist industry and work full time in this private sector . .
. [This is] how private property even in means of production would occur in a
socialist society . . . [and so] the socialist society will have to forbid
capitalist acts between consenting adults."_ [**Anarchy, State and Utopia**,
pp. 162-3]

There are numerous flawed assumptions in this argument and we will discuss
them here. The key flaws are the confusion of exchange with capitalism and the
typically impoverished propertarian vision that freedom is, essentially, the
freedom to sell your liberty, to become a wage slave and so unfree. Looking at
history, we can say that both these assumptions are wrong. Firstly, while
markets and exchange have existed for thousands of years capitalism has not.
Wage-labour is a relatively recent development and has been the dominant mode
of production for, at best, a couple of hundred years. Secondly, few people
(when given the choice) have freely become wage-slaves. Just as the children
of slaves often viewed slavery as the "natural" order, so do current workers.
Yet, as with chattel slavery, substantial state coercion was required to
achieve such a "natural" system.

As discussed in [section F.8](secF8.html), actually existing capitalism was
**not** created by Nozick's process -- it required substantial state
intervention to separate workers from the means of production they used and to
ensure, eventually, that the situation in which they sold their liberty to the
property owner was considered "natural." Without that coercion, people do
**not** seek to sell their liberty to others. Murray Bookchin summarised the
historical record by noting that in _"every precapitalist society,
countervailing forces . . . existed to restrict the market economy. No less
significantly, many precapitalist societies raised what they thought were
insuperable obstacles to the penetration of the State into social life."_ He
pointed to _"the power of village communities to resist the invasion of trade
and despotic political forms into society's abiding communal substrate."
_[**The Ecology of Freedom**, pp. 207-8] Anarchist anthropologist David
Graeber notes that in the ancient Mediterranean world _"[w]hile one does
periodically run into evidence of arrangements which to the modern eye look
like wage-labour contracts, on closer examination they almost always actually
turn out to be contracts to rent slaves . . . Free men and women thus avoided
anything remotely like wage-labour, seeing it as a matter, effectively, of
slavery, renting themselves out."_ This means that wage labour _"(as opposed
to, say, receiving fees for professional services) involves a degree of
subordination: a labourer has to be to some degree at the command of his or
her employer. This is exactly why, through most of history, free men and women
tended to avoid wage-labour, and why, for most of history, capitalism . . .
never emerged."_ [**Possibilities**, p. 92]

Thus while the idea that people will happily become wage slaves may be
somewhat common place today (particularly with supporters of capitalism) the
evidence of history is that people, given a choice, will prefer self-
employment and **resist** wage labour (often to the death). As E. P. Thompson
noted, for workers at the end of the 18th and beginning of the 19th centuries,
the _"gap in status between a 'servant,' a hired wage-labourer subject to the
orders and discipline of the master, and an artisan, who might 'come and go'
as he pleased, was wide enough for men to shed blood rather than allow
themselves to be pushed from one side to the other. And, in the value system
of the community, those who resisted degradation were in the right."_ [**The
Making of the English Working Class**, p. 599] Over one hundred years later,
the rural working class of Aragon showed the same dislike of wage slavery.
After Communist troops destroyed their self-managed collectives, the
_"[d]ispossessed peasants, intransigent collectivists, refused to work in a
system of private property, and were even less willing to rent out their
labour."_ [Jose Peirats, **Anarchists in the Spanish Revolution**, p. 258] The
rural economy collapsed as the former collectivists refused to be the servants
of the few.

People who have tasted freedom are unlikely to go back to oppression.
Therefore, any perception that people will become wage-slaves through choice
in a free society is based on the assumption what people accept through
necessity under capitalism will pass over, without change, into a free one.
This assumption is unfounded and anarchists expect that once people struggle
for freedom and taste the pleasures of freedom they will not freely accept a
degradation back to having a master -- and as history shows, we have some
evidence to support our argument. It seems a strangely debased perspective on
freedom to ponder whether people will be "free" to alienate their freedom --
it is a bit like proclaiming it a restriction of freedom to _"forbid"_ owning
slaves (and, as noted in [section F.2.2](secF2.html#secf22), Nozick did
support voluntary slave contracts).

So anarchists think Nozick's vision of unfreedom developing from freedom is
unlikely. As anarcho-syndicalist Jeff Stein points out _"the only reason
workers want to be employed by capitalists is because they have no other means
for making a living, no access to the means of production other than by
selling themselves. For a capitalist sector to exist there must be some form
of private ownership of productive resources, and a scarcity of alternatives.
The workers must be in a condition of economic desperation for them to be
willing to give up an equal voice in the management of their daily affairs and
accept a boss."_ [_"Market Anarchism? Caveat Emptor!"_, **Libertarian Labour
Review**, no. 13]

In an anarchist society, there is no need for anyone to _"forbid"_ capitalist
acts. All people have to do is **refrain** from helping would-be capitalists
set up monopolies of productive assets. This is because, as we have noted in
[section B.3.2](secB3.html#secb32), capitalism cannot exist without some form
of state to protect such monopolies. In a libertarian-socialist society, of
course, there would be no state to begin with, and so there would be no
question of it "refraining" people from doing anything, including protecting
would-be capitalists' monopolies of the means of production. In other words,
would-be capitalists would face stiff competition for workers in an anarchist
society. This is because self-managed workplaces would be able to offer
workers more benefits (such as self-government, better working conditions,
etc.) than the would-be capitalist ones. The would-be capitalists would have
to offer not only excellent wages and conditions but also, in all likelihood,
workers' control and hire-purchase on capital used. The chances of making a
profit once the various monopolies associated with capitalism are abolished
are slim.

Thus the would-be capitalist would _"not [be] able to obtain assistance or
people to exploit"_ and _"would find none because nobody, having a right to
the means of production and being free to work on his own or as an equal with
others in the large organisations of production would want to be exploited by
a small employer"_. [Malatesta, **Errico Malatesta: His Life and Ideas**, pp.
102-103] So where would the capitalist wannabe find people to work for him? As
Kropotkin argued:

> _"Everywhere you will find that the wealth of the wealthy springs from the
poverty of the poor. That is why an anarchist society need not fear the advent
of a [millionaire] who would settle in its midst. If every member of the
community knows that after a few hours of productive toil he [or she] will
have a right to all the pleasures that civilisation procures, and to those
deeper sources of enjoyment which art and science offer to all who seek them,
he [or she] will not sell his strength . . . No one will volunteer to work for
the enrichment of your [millionaire]."_ [**Conquest of Bread**, p. 61]

However, let us suppose there is a self-employed inventor, Ferguson, who comes
up with a new innovation without the help of the socialised sector. Would
anarchists steal his idea? Not at all. The syndicates, which by hypothesis
have been organised by people who believe in giving producers the full value
of their product, would pay Ferguson an equitable amount for his idea, which
would then become common across society. However, if he refused to sell his
invention and instead tried to claim a patent monopoly on it in order to
gather a group of wage slaves to exploit, no one would agree to work for him
unless they got the full control over both the product of their labour and the
labour process itself. And, assuming that he did find someone willing to work
for him (and so be governed by him), the would-be capitalist would have to
provide such excellent conditions and pay such good wages as to reduce his
profits to near zero. Moreover, he would have to face workers whose neighbours
would be encouraging them to form a union and strike for even **better**
conditions and pay, including workers' control and so on. Such a militant
workforce would be the last thing a capitalist would desire. In addition, we
would imagine they would also refuse to work for someone unless they also got
the capital they used at the end of their contract (i.e. a system of "hire-
purchase" on the means of production used). In other words, by removing the
statist supports of capitalism, would-be capitalists would find it hard to
"compete" with the co-operative sector and would not be in a position to
exploit others' labour.

With a system of communal production (in social anarchism) and mutual banks
(in individualist anarchism), **usury** \-- i.e. charging a use-fee for a
monopolised item, of which patents are an instance -- would no longer be
possible and the inventor would be like any other worker, exchanging the
product of his or her labour. As Benjamin Tucker argued, _"the patent monopoly
. . . consists in protecting inventors and authors against competition for a
period of time long enough for them to extort from the people a reward
enormously in excess of the labour measure of their services -- in other
words, in giving certain people a right of property for a term of years in
laws and facts of nature, and the power to extract tribute from others for the
use of this natural wealth, which should be open to all. The abolition of this
monopoly would fill its beneficiaries with a wholesome fear of competition
which should cause them to be satisfied with pay for their services equal to
that which other labourers get for theirs, and secure it by placing their
products and works on the market at the outset at prices so low that their
lines of business would be no more tempting to competitors than any other
lines."_ [**The Anarchist Reader**, pp. 150-1]

So, if someone has labour to sell then they deserve a free society to do it in
-- as Tucker once pointed out. Such an environment would make the numbers
seeking employment so low as to ensure that the rate of exploitation would be
zero. Little wonder that, when faced with a self-employed, artisan workforce,
capitalists have continually turned to the state to create the "correct"
market forces. So without statism to back up various class-based monopolies of
capitalist privilege, capitalism would not have become dominant.

It should also be noted that Nozick makes a serious error in his case. He
assumes that the "use rights" associated with an anarchist (i.e. socialist)
society are identical to the "property rights" of a capitalist one. This is
**not** the case, and so his argument is weakened and loses its force. Simply
put, there is no such thing as an absolute or _"natural"_ law of property. As
John Stuart Mill pointed out, _"powers of exclusive use and control are very
various, and differ greatly in different countries and in different states of
society."_ Therefore, Nozick slips an ideological ringer into his example by
erroneously interpreting socialism (or any other society for that matter) as
specifying a distribution of capitalist property rights along with the wealth.
As Mill argued: _"One of the mistakes oftenest committed, and which are the
sources of the greatest practical errors in human affairs, is that of
supposing that the same name always stands for the same aggregation of ideas.
No word has been subject of more of this kind of misunderstanding that the
word property."_ [_"Chapters on Socialism,"_ **Principles of Political
Economy**, p. 432]

In other words, Nozick assumes that in **all** societies capitalist property
rights are distributed along with consumption **and** production goods. As
Cheyney C. Ryan comments _"[d]ifferent conceptions of justice differ not only
in how they would apportion society's holdings but in what rights individuals
have over their holdings once they have been apportioned."_ [_"Property Rights
and Individual Liberty"_, pp. 323-43, **Reading Nozick**, Jeffrey Paul (Ed.),
p. 331] This means that when goods are distributed in a libertarian socialist
society the people who receive or take them have specific (use) rights to
them. As long as an individual remained a member of a commune and abided by
the rules they helped create in that commune then they would have full use of
the resources of that commune and could use their possessions as they saw fit
(even _"melt them down"_ to create a new machine, or whatever). If they used
those goods to create an enterprise to employ (i.e., exploit and oppress)
others then they have, in effect, announced their withdrawal from civilised
society and, as a result, would be denied the benefits of co-operation. They
would, in effect, place themselves in the same situation as someone who does
not wish to join a syndicate (see [section I.3.7](secI3.html#seci37)). If an
individual did desire to use resources to employ wage labour then they would
have effectively removed themselves from _"socialist society"_ and so that
society would bar them from using **its** resources (i.e. they would have to
buy access to all the resources they currently took for granted).

Would this be a restriction of freedom? While it may be considered so by the
impoverished definitions of capitalism, it is not. In fact, it mirrors the
situation within capitalism as what possessions someone holds are **not** his
or her property (in the capitalist sense) any more than a company car is
currently the property of the employee under capitalism. While the employee
can use the car outside of work, they lack the "freedom" to sell it or melt it
down and turn it into machines. Such lack of **absolute** "ownership" in a
free society does not reduce liberty any more than in this case.

This point highlights another flaw in Nozick's argument. If his argument were
true, then it applies equally to capitalist society. For 40 hours plus a week,
workers are employed by a boss. In that time they are given resources to use
and they are most definitely **not** allowed to melt down these resources to
create a machine or use the resources they have been given access to further
their own plans. This can apply equally to rented accommodation as well, for
example when landlords ban working from home or selling off the furniture that
is provided. Thus, ironically, _"capitalist society will have to forbid
capitalist acts between consenting adults"_ \-- and does so all the time.

Moreover, it must be stressed that as well as banning capitalist acts between
consenting adults, capitalism involves the continual banning of socialist acts
between consenting adults. For example, if workers agree to form a union, then
the boss can fire them. If they decide to control their own work, the boss can
fire them for not obeying orders. Thus capitalism forbids such elemental
freedoms as association and speech -- at least for the majority, for the wage
slaves. Why would people seek such "freedom" in a free society?

Of course, Nozick's reply to this point would be that the individuals involved
have "consented" to these rules when they signed their contract. Yet the same
can be said of an anarchist society -- it is freely joined and freely left. To
join a communist-anarchist society it would simply be a case of agreeing to
"exchange" the product of ones labour freely with the other members of that
society and not to create oppressive or exploitative social relationships
within it. If this is "authoritarian" then so is capitalism -- and we must
stress that at least anarchist associations are based on self-management and
so the individuals involved have an equal say in the obligations they live
under.

Notice also that Nozick confused exchange with capitalism (_"I offer you a
lecture once a week in exchange for other things"_). This is a telling mistake
by someone who claims to be an expert on capitalism, because the defining
feature of capitalism is not exchange (which obviously took place long before
capitalism existed) but labour contracts involving wage labour. Nozick's
example is merely a direct labour contract between the producer and the
consumer. It does not involve wage labour, what makes capitalism capitalism.
It is only this latter type of transaction that libertarian socialism prevents
-- and not by "forbidding" it but simply by refusing to maintain the
conditions necessary for it to occur, i.e. protection of capitalist property.

In addition, we must note that Nozick also confused _"private property in the
means of production"_ with capitalism. Liberation socialism can be easily
compatible with _"private property in the means of production"_ when that
_"private property"_ is limited to what a self-employed worker uses rather
than capitalistic property (see [section G.2.1](secG2.html#secg21)). Nozick,
in other words, confused pre-capitalist forms of production with capitalist
ones (see [section G.1.2](secG1.html#secg12)). Thus possession of the means of
production by people outside of the free commune is perfectly acceptable to
social anarchists (see [section I.6.2](secI6.html#seci62)).

Thus an anarchist society would have a flexible approach to Nozick's (flawed)
argument. Individuals, in their free time, could _"exchange"_ their time and
possessions as they saw fit. These are **not** _"capitalist acts"_ regardless
of Nozick's claims. However, the moment an individual employs wage labour
then, by this act, they have broken their agreements with their fellows and
are, therefore, no longer part of _"socialist society."_ This would involve
them no longer having access to the benefits of communal life and to communal
possessions. They have, in effect, placed themselves outside of their
community and must fend for themselves. After all, if they desire to create
_"private property"_ (in the capitalist sense) then they have no right of
access to communal possessions without paying for that right. For those who
become wage slaves, a socialist society would, probably, be less strict. As
Bakunin argued:

> _"Since the freedom of every individual is inalienable, society shall never
allow any individual whatsoever legally to alienate his [or her] freedom or
engage upon any contract with another on any footing but the utmost equality
and reciprocity. It shall not, however, have the power to disbar a man or
woman so devoid of any sense of personal dignity as to contract a relationship
of voluntary servitude with another individual, but it will consider them as
living off private charity and therefore unfit to enjoy political rights
**throughout the duration of that servitude.**"_ [**Michael Bakunin: Selected
Writings**, pp. 68-9]

Lastly, we must also note that Nozick also ignored the fact that acquisition
**must** come before transfer, meaning that before "consenting" capitalist
acts occur, individual ones must precede it. As argued in [section
B.3.4](secB3.html#secb34), Nozick provided no convincing arguments why natural
resources held in common can be appropriated by individuals. This means that
his defence of transferring absolute capitalist property rights in goods is
without foundations. Moreover, his argument in favour of such appropriations
ignore that liberties are very definitely restricted by private property (and
it should be keep in mind that the destruction of commonly held resources,
such as village commons, was imposed by the state -- see [section
F.8.3](secF8.html#secf83)). As pointed out in [section F.2](secF2.html),
right-wing "libertarians" would better be termed _"Propertarians"_ (why is
liberty accorded a primary importance when arguing against socialism but not
when private property restricts liberty?). As Cheyney C. Ryan points out,
Nozick _"invoke[s] personal liberty as the decisive ground for rejecting
patterned principles of justice [such as socialism] and restrictions on the
ownership of capital . . . [b]ut where the rights of private property
admittedly restrict the liberties of the average person, he seems perfectly
happy to **trade off** such liberties against material gain for society as a
whole."_ [**Op. Cit.**, p. 339] This can be seen by his lack of comment on how
capitalism forbids socialist acts between consenting adults, not to mention
quite a few numerous capitalist acts for good measure.

Thus Nozick's acquisition of resources is based on the would-be capitalist
stealing communally owned resources and barring others from using them. This
obviously would restrict the liberty of those who currently used them and so
be hotly opposed by members of a community. As Murray Bookchin noted, a free
society is based on _"the practice of **usufruct**, the freedom of individuals
in a community to appropriate resources merely by virtue of the fact that they
are using them. Such resources belong to the user as long as they are being
used."_ [**The Ecology of Freedom**, p. 116] As the would-be capitalist is not
actually using the machines they have created, they would be in constant worry
that their wage-slaves would simply expropriate them -- with the full backing
of the local commune and its federations.

So, to conclude, this question involves some strange logic (and many question
begging assumptions) and ultimately fails in its attempt to prove libertarian
socialism must _"forbid capitalistic acts between individuals."_ In addition,
Nozick cannot support the creation of private property out of communal
property in the first place. It also undermines capitalism because that system
must forbid socialistic acts by and between individuals. Thus Nozick's society
would forbid squatting unused property or trespassing on private property as
well as, say, the formation of unions against the wishes of the property owner
(who is sovereign over their property and those who use it) or the use of
workplace resources to meet the needs of the producer rather than the owner.
As such, Nozick exposes how capitalism's hierarchical nature means that
capitalist society _"forbids socialist acts between consenting adults."_

## I.4.13 Who will do the dirty or unpleasant work?

This problem affects every society, including capitalism of course. Under
capitalism, this problem is "solved" by ensuring that such jobs are done by
those at the bottom of the social pile. In other words, it does not really
solve the problem at all -- it just ensures that some people are subject to
this work the bulk of their working lives. Most anarchists reject this flawed
solution in favour of something better, one that shares the good with the bad
and so ensure everyone's life is better. How this would be done depends on the
kind of libertarian community you are a member of.

Obviously, few would argue against the idea that individuals will voluntarily
work at things they enjoyed doing. However there are some jobs that few, if
any, would enjoy (for example, collecting rubbish, processing sewage,
dangerous work, etc.). So how would an anarchist society deal with it?

It is obvious that not all "jobs" are equal in interest or enjoyment. It is
sometimes argued that people would start to join or form syndicates which are
involved in more fun activities. By this process excess workers would be found
in the more enjoyable "jobs" while the boring and dangerous ones would suffer
from a scarcity of willing workers. Hence, so the argument goes, a socialist
society would have to force people to do certain jobs and that requires a
state. Obviously, this argument ignores the fact that under capitalism usually
it is the boring, dangerous work which is the least well paid with the worst
working conditions. In addition, this argument ignores the fact that under
workers self-management boring, dangerous work would be minimised and
transformed as much as possible. Only under capitalist hierarchy are people in
no position to improve the quality of their work and working environment. As
George Barrett argued:

> _"Now things are so strangely organised at present that it is just the dirty
and disagreeable work that men will do cheaply, and consequently there is no
great rush to invent machines to take their place. In a free society, on the
other hand, it is clear that the disagreeable work will be one of the first
things that machinery will be called upon to eliminate. It is quite fair to
argue, therefore, that the disagreeable work will, to a large extent,
disappear in a state of anarchism."_ [**Objections to Anarchism**, p. 361]

Moreover, most anarchists would think that the argument that there would be a
flood of workers taking up "easy" work placements is abstract and ignores the
dynamics of a real society. While many individuals would try to create new
productive syndicates in order to express themselves in innovative work
outwith the existing research and development going on within existing
syndicates, the idea that the majority of individuals would leave their
current work at a drop of a hat is crazy. A workplace is a community and part
of a community and people would value the links they have with their fellow
workers. As such they would be aware of the impacts of their decisions on both
themselves and society as a whole. So, while we would expect a turnover of
workers between syndicates, the mass transfers claimed in this argument are
unlikely. Most workers who did want to try their hand at new work would apply
for work places at syndicates that required new people, not create their own
ones. Because of this, work transfers would be moderate and easily handled.

However, the possibility of mass desertions does exist and so must be
addressed. So how would a libertarian socialist society deal with a majority
of its workers deciding to all do interesting work, leaving the boring and/or
dangerous work undone? It, of course, depends on the type of anarchism in
question and each offers alternative ways to ensure that individual preference
for certain types of work matches the requirements of social demand for
labour.

Under individualist anarchism and mutualism, those who desired a certain form
of work done would reach an agreement with workers or a co-operative and pay
them to do the work in question. Within a co-operative, as Proudhon argued, a
person's _"education, instruction, and apprenticeship should . . . be so
directed that, while permitting him to do his share of unpleasant and
disagreeable tasks, they may also give variety of work and knowledge, and may
assure him . . . an encyclopaedic attitude and a sufficient income."_
[**Property is Theft!**, pp.585-6] In terms of unpleasant tasks for other
people (for example, collecting and processing a community's rubbish) then
individuals would form co-operatives which would have to find their place on
the market and this would ensure that such work was done as they would
contract with others to provide the appropriate services. However, this could
lead to some people doing unpleasant work all the time and so is hardly a
solution. As in capitalism, we may see some people doing terrible work because
it is better than no work at all. This is a solution few anarchists would
support.

In a collectivist or communist anarchist society, such an outcome would be
avoided as far as possible. Noam Chomsky points to two possible alternatives,
one _"in which the undesired work, after the best efforts to make it
meaningful, is shared"_ and another one _"where the undesired work receives
high extra pay, so that individuals voluntarily choose to do it."_ Such
schemes are _"consistent with . . . anarchist principles"_ unlike the current
situation where _"the undesired work is given to wage-slaves."_ [**Radical
Priorities**, p. 220] Another way, somewhat complementary to these two, would
be to take a leaf from _"peasant attitudes toward labour"_ and their _"most
striking feature"_, the extent _"to which any kind of communal toil, however
onerous, can be transformed by the workers themselves into festive occasions
that serve to reinforce community ties."_ [Murray Bookchin, **The Ecology of
Freedom**, p. 342]

It would be easy to imagine a free community sharing such tasks as fairly as
possible between a community's members by, for example, allocating a few days
a month to all fit members of a community to do work which no one volunteers
to do. This would soon ensure that it would be done, particularly if it were
part of a festival or before a party. In this way, every one shares in the
unpleasant as well as pleasant tasks (and, of course, minimises the time any
one individual has to spend on it). Or, for tasks which are very popular,
individuals would also have to do unpleasant tasks as well. In this way,
popular and unpopular tasks could balance each other out. Or such tasks could
be rotated randomly by lottery. The possibilities are many and, undoubtedly, a
free people will try many different ones in different areas.

Another possible solution could be to follow the ideas of Josiah Warren and
take into account the undesirability of the work when considering the level of
labour notes received or communal hours worked. In other words, in a
collectivist society the individuals who do unpleasant work may be "rewarded"
(along with social esteem) with a slightly higher pay -- the number of labour
notes, for example, for such work would be a multiple of the standard amount,
the actual figure being related to how much supply exceeds demand (in a
communist society, a similar solution could be possible, with the number of
necessary hours required by an individual being reduced by an amount that
corresponds to the undesirability of the work involved). The actual levels of
"reward" would be determined by agreements between the syndicates. For
example, if a given type of work has 50% more people wanting to do it than
actually required, then the labour value for one hours work in this industry
would correspondingly be less than one hour. If fewer people applied than
required, then the labour value would increase, as would holiday time, etc.
For "work" placements in which supply exceeded demand, it would be easy to
arrange a work share scheme to ensure that most people get a chance to do that
kind of work (along with such methods as increasing the value of an hour's
labour, reducing holiday allocations and such like).

In this way, "supply and demand" for workers would soon approximate each
other. In addition, a collectivist society would be better placed than the
current system to ensure work-sharing and other methods to spread unpleasant
and pleasant tasks equally around society due to its organs of self-management
and the rising social awareness via participation and debate within those
organs.

A communist-anarchist society's solution would be similar to the collectivist
one. There would still be basic agreements between its members for work done
and so for work placements with excess supply of workers the amount of hours
necessary to meet the agreed minimum would correspondingly increase. For
example, an industry with 100% excess supply of volunteers would see its
minimum requirement increase from (say) 20 hours a week to 30 hours. An
industry with less applicants than required would see the number of required
hours decrease, plus increases in holiday time and so on. As G.D.H. Cole
argued in respect of this point:

> _"Let us first by the fullest application of machinery and scientific
methods eliminate or reduce . . . 'dirty work' that admit to such treatment.
This has never been tried . . . under capitalism . . . It is cheaper to
exploit and ruin human beings . . . Secondly, let us see what forms of 'dirty
work' we can do without . . . [and] if any form of work is not only unpleasant
but degrading, we will do without it, whatever the cost. No human being ought
to be allowed or compelled to do work that degrades. Thirdly, for what dull or
unpleasant work remains, let us offer whatever special conditions are required
to attract the necessary workers, not in higher pay, but in shorter hours,
holidays extending over six months in the year, conditions attractive enough
to men who have other uses for their time or attention to being the requisite
number to undertake it voluntarily."_ [**Guild Socialism Restated**, p. 76]

By these methods a balance between industrial sectors would be achieved as
individuals would balance their desire for interesting work with their desires
for free time. Over time, by using the power of appropriate technology, even
such time keeping would be minimised or even got eliminated as society
developed freely. Until such time as it can be automated away, a free society
will have to encourage people to volunteer for "work" placements they do not
particularly want to do by these and other methods.

It will be clear what is considered unpleasant work in any society -- few
people (if any) will volunteer to do it. As in any advanced society,
communities and syndicates who required extra help would inform others of
their need by the various form of media that existed. In addition, it would be
likely that each community would have a "division of activity" syndicate whose
work would be to distribute information about these posts and to which members
of a community would go to discover what placements existed for the line of
"work" they were interested in. So we have a means by which syndicates and
communes can ask for new associates and the means by which individuals can
discover these placements. Obviously, some tasks will still require
qualifications and that will be taken into account when syndicates and
communes "advertise" for help.

And it is important to remember that the means of production required by new
syndicates do not fall from the sky. Other members of society will have to
work to produce the required goods. Therefore it is likely that the syndicates
and communes would agree that only a certain (maximum) percentage of
production would be allocated to start-up syndicates (as opposed to increasing
the resources of existing confederations). Such a figure would obviously be
revised periodically in order to take into account changing circumstances.
Members of the community who decide to form syndicates for new productive
tasks or syndicates which do the same work but are independent of existing
confederations would have to get the agreement of other workers to supply them
with the necessary means of production (just as today they have to get the
agreement of a bank to receive the necessary credit to start a new business).
By budgeting the amounts available, a free society can ensure that individual
desires for specific kinds of work can be matched with the requirements of
society for useful production.

And we must point out (just to make sure we are not misunderstood) that there
will be no group of "planners" deciding which applications for resources get
accepted. Instead, individuals and associations would apply to different
production units for resources, whose workers in turn decide whether to
produce the goods requested. If it is within the syndicate's agreed budget
then it is likely that they will produce the required materials. In this way,
a communist-anarchist society will ensure the maximum amount of economic
freedom to start new syndicates and join existing ones plus ensure that social
production does not suffer in the process.

Of course, no system is perfect -- we are sure that not everyone will be able
to do the work they enjoy the most (this is also the case under capitalism, we
may add). In an anarchist society every method of ensuring that individuals
pursue the work they are interested in would be investigated. If a possible
solution can be found, we are sure that it will. What a free society would
make sure of was that neither the capitalist market redeveloped (which ensures
that the majority are marginalised into wage slavery) or a state socialist
"labour army" type allocation process developed (which would ensure that free
socialism did not remain free or socialist for long).

In this manner, anarchism will be able to ensure the principle of voluntary
labour and free association as well as making sure that unpleasant and
unwanted "work" is done. Moreover, most anarchists are sure that in a free
society such requirements to encourage people to volunteer for unpleasant work
will disappear over time as feelings of mutual aid and solidarity become more
and more common place. Indeed, it is likely that people will gain respect for
doing jobs that others might find unpleasant and so it might become
"glamorous" to do such activity. Showing off to friends can be a powerful
stimulus in doing any activity. So anarchists would agree with Albert and
Hahnel when they say that:

> _"In a society that makes every effort to depreciate the esteem that derives
from anything other than conspicuous consumption, it is not surprising that
great income differentials are seen as necessary to induce effort. But to
assume that only conspicuous consumption can motivate people because under
capitalism we have strained to make it so is unwarranted. There is plenty of
evidence that people can be moved to great sacrifices for reasons other than a
desire for personal wealth . . . there is good reason to believe that for
nonpathological people wealth is generally coveted only as a **means** of
attaining other ends such as economic security, comfort, social esteem,
respect, status, or power."_ [**The Political Economy of Participatory
Economics**, p. 52]

We should note here that the education syndicates would obviously take into
account the trends in "work" placement requirements when deciding upon the
structure of their classes. In this way, education would respond to the needs
of society as well as the needs of the individual (as would any productive
syndicate).

## I.4.14 What about the person who will not work?

Anarchism is based on voluntary labour. If people do not desire to work then
they cannot (must not) be forced to by means of physical coercion. This makes
some wonder what happens if someone refuses to work in a libertarian society.

In terms of a mutualist or collectivist anarchy, this question is easy to
answer for goods are distributed according to work done and so if people do
not work then they are left dependent on the charity of those who do
(exceptions for the young, old and ill would apply, of course).

So this question is directed towards communist-anarchists, with many people
arguing that communism is impossible because people simply would not work
unless they get paid. This ignores the many people who do volunteer work
(often in addition to their "real jobs"). It also ignores those who spend
their time contributing to projects they are interested in (such as fan
journals) which would be considered work in other contexts. A classic example
of this is the internet, particularly webpages like Wikipedia and software
projects like php. Then there is the activity of the pro-capitalists
themselves, often fanatical anti-communists (which they almost always equate
to Stalinism), who spend their free time working on wikipedia, newsgroups,
webpages and journals explaining how communism could not work because people
would never voluntarily contribute to society! It is one of the great ironies
of life that those who hate communism the most often, by their actions, prove
its viability.

So, communist-anarchists argue, in a society based on self-managed work in
pleasant surroundings and a reduction of the working week to a minimum, there
would be few people who refuse to do any kind of productive activity. The
question arises of what to do with those (a small minority, to be sure) who
refuse to work.

On this question there is some disagreement. Some anarchists argue that the
lazy should not be deprived of the means of life. Social pressure, they argue,
would ensure those who take from, but do not contribute, to the community
listen to their conscience and start producing for the community that supports
them. If this did not happen, then the person who refused to contribute would
be asked to leave (freedom of association means the freedom **not** to
associate). As Kropotkin argued;

> _"First of all, is it not evident that if a society, founded on the
principle of free work, were really menaced by loafers, it could protect
itself without the authoritarian organisation we have nowadays, and without
having recourse to wagedom [i.e., payment by deeds]? _

> _"Let us take a group of volunteers, combining for some particular
enterprise. Having its success at heart, they all work with a will, save one
of the associates, who is frequently absent from his post . . . some day the
comrade who imperils their enterprise will be told: 'Friend, we should like to
work with you; but as you are often absent from your post, and you do your
work negligently, we must part. Go and find other comrades who will put up
with your indifference!' _

> _"This is so natural that it is practised everywhere, even nowadays, in all
industries . . . [I]f [a worker] does his work badly, if he hinders his
comrades by his laziness or other defects, if he is quarrelsome, there is an
end of it; he is compelled to leave the workshop. _

> _"Authoritarians pretend that it is the almighty employer and his overseers
who maintain regularity and quality of work in factories. In reality . . . it
is the factory itself, the workmen [and women] who see to the good quality of
the work."_ [**The Conquest of Bread**, pp. 152-3]

Most anarchists agree with Camillo Berneri when he argued that anarchism
should be based upon _"no compulsion to work, but no duty towards those who do
not want to work."_ [_"The Problem of Work"_, pp. 59-82, **Why Work?**, Vernon
Richards (ed.), p. 74] This means that an anarchist society will not continue
to feed, clothe, house someone who can produce but refuses to. Anarchists have
had enough of the wealthy under capitalism consuming but not producing and do
not see why they should support a new group of parasites after the revolution.

Obviously, there is a difference between not wanting to work and being unable
to work. The sick, children, the old, pregnant women and so on will be looked
after in libertarian communism. As child rearing would be considered "work"
along with other more obviously economic tasks, mothers and fathers will not
have to leave their children unattended and work to make ends meet. Instead,
consideration will be given to the needs of both parents and children as well
as the creation of community nurseries and child care centres.

We have to stress here that an anarchist society will not deny anyone the
means of life. This would violate the voluntary labour which is at the heart
of all schools of anarchism. Unlike capitalism, the means of life will not be
monopolised by any group -- including the commune. This means that someone who
does not wish to join a commune or who does not pull their weight within a
commune and are expelled or choose to leave will have access to the means of
making a living.

We stated that we stress this fact as many supporters of capitalism seem to be
unable to understand this point (or prefer to ignore it and so misrepresent
the anarchist position). In an anarchist society, no one will be forced to
join a commune simply because they do not have access to the means of
production and/or land required to work alone. Unlike capitalism, where access
to these essentials of life is dependent on buying access to them from the
capitalist class (and so, effectively, denied to the vast majority), an
anarchist society will ensure that all have access and have a real choice
between living in a commune and working independently. This access is based on
the fundamental difference between possession and property -- the commune
possesses as much land as it needs, as do non-members. The resources used by
them are subject to the usual possession rationale -- they possess it only as
long as they use it and cannot bar others using it if they do not (i.e., it is
not property).

Thus an anarchist commune remains a voluntary association and ensures the end
of all forms of domination. The member of the commune has the choice of
working as part of a community, giving according to their abilities and taking
according to their needs (or some other means of organising production and
consumption such as equal income or receiving labour notes, and so on), or
working independently and so free of communal benefits as well as any
commitments (bar those associated with using communal resources such as roads
and so on).

So, in most, if not all, anarchist communities, individuals have two options,
either they can join a commune and work together as equals, or they can work
as an individual or independent co-operative and exchange the product of their
labour with others. If an individual joins a commune and does not carry their
weight, even after their fellow workers ask them to, then that person will
possibly be expelled and given enough land, tools or means of production to
work alone. Of course, if a person is depressed, run down or otherwise finding
it hard to join in communal responsibilities then their friends and fellow
workers would do everything in their power to help and be flexible in their
approach to the problem. What method a community would use would depend on
what people in that community thought was best.

However, most social anarchists think that the problem of people trying not to
work would be a very minor one in a free society. This is because productive
activity is part of human life and an essential way to express oneself. With
work being voluntary and self-managed, it will become like current day hobbies
and many people work harder at their hobbies than they do at "real" work (this
FAQ can be considered as an example of this!). How long this takes to organise
fully is, of course, unknown but one of the most important tasks of a free
society will be to ensure work is transformed and the burden of what remains
is shared in order to reduce toil to a minimum.

It is the nature of employment under capitalism, the hierarchical nature of
its workplace, that makes it "work" instead of pleasure. Work need not be a
part of the day that we wish would end. It is **not** work that people hate.
Rather it is **over**-work, in unpleasant circumstances and under the control
of others that people hate. Reduce the hours of labour, improve the working
conditions and place the work under self-management and work will stop being a
hated thing. All these will help ensure that only an idiot would desire to
work alone for, as Malatesta argued, the _"individual who wished to supply his
own material needs by working alone would be the slave of his labours."_
[**The Anarchist Revolution**, p. 15]

So, enlightened self-interest would secure the voluntary labour and
egalitarian distribution anarchists favour in the vast majority of the
population. The parasitism associated with capitalism would be a thing of the
past. Thus the problem of the "lazy" person fails to understand the nature of
humanity or the revolutionising effects of freedom on the nature and content
of work.

## I.4.15 What will the workplace of tomorrow look like?

Given the anarchist desire to liberate the artist in all of us, we can easily
imagine that a free society would totally transform the working environment.
No longer would workers be indifferent to their workplaces, but they would
express themselves in transforming them into pleasant places, integrated into
both the life of the local community and into the local environment. After
all, _"no movement that raises the demand for workers' councils can be
regarded as revolutionary unless it tries to promote sweeping transformations
in the environment of the work place."_ [Murray Bookchin, **Post-Scarcity
Anarchism**, p. 88]

A glimpse of the future workplace can been seen from the actual class
struggle. In the 40 day sit-down strike at Fisher Body plant #1 in Flint,
Michigan in 1936, _"there was a community of two thousand strikers . . .
Committees organised recreation, information, classes, a postal service,
sanitation . . . There were classes in parliamentary procedure, public
speaking, history of the labour movement. Graduate students at the University
of Michigan gave courses in journalism and creative writing."_ [Howard Zinn,
**A People's History of the United States**, p. 391] In the same year, during
the Spanish Revolution, collectivised workplaces also created libraries and
education facilities as well as funding schools, health care and other social
necessities (a practice, we must note, that had started before the revolution
when anarchist unions had funded schools, social centres, libraries and so
on).

The future workplace would be expanded to include education and classes in
individual development. This follows Proudhon's suggestion made during the
1848 revolution that we should _"[o]rganise association, and by the same
token, every workshop becoming a school, every worker becomes a master, every
student an apprentice."_ [**Property is Theft!**, p. 378] This means that in a
free society _"Workers' associations have a very important role to play . . .
Linked to the system of public education, they will become both centres of
production and centres for education . . . The working masses will be in daily
contact with the youthful army of agricultural and industrial workers. Labour
and study, which have for so long and so foolishly been kept apart, will
finally emerge side by side in their natural state of union. Instead of being
confined to narrow, specialised fields, vocational education will include a
variety of different types of work which, taken as a whole, will insure that
each student becomes an all-round worker."_ [Proudhon, **Selected Writings of
Pierre-Joseph Proudhon**, p. 87]

This would allow work to become part of a wider community, drawing in people
from different areas to share their knowledge and learn new insights and
ideas. In addition, children would have part of their school studies with
workplaces, getting them aware of the practicalities of many different forms
of work and so allowing them to make informed decisions in what sort of
activity they would be interested in pursuing when they were older.

Obviously, a workplace managed by its workers would also take care to make the
working environment as pleasant as possible. No more "sick building syndrome"
or unhealthy and stressful work areas for _"can we doubt that work will become
a pleasure and a relaxation in a society of equals, in which 'hands' will not
be compelled to sell themselves to toil, and to accept work under any
conditions Repugnant tasks will disappear, because it is evident that these
unhealthy conditions are harmful to society as a whole. Slaves can submit to
them, but free men [and women] will create new conditions, and their work will
be pleasant and infinitely more productive."_ [Kropotkin, **The Conquest of
Bread**, p. 123] Workplaces would be designed to maximise space and allow
individual expression within them. We can imagine such places surrounded by
gardens and allotments which were tended by workers themselves, giving a
pleasant surrounding to the workplace. There would, in effect, be a break down
of the city/rural divide -- workplaces would be placed next to fields and
integrated into the surroundings:

> _"Have the factory and the workshop at the gates of your fields and gardens,
and work in them. Not those large establishments, of course, in which huge
masses of metals have to be dealt with and which are better placed at certain
spots indicated by Nature, but the countless variety of workshops and
factories which are required to satisfy the infinite diversity of tastes among
civilised men [and women] . . . factories and workshops which men, women and
children will not be driven by hunger, but will be attracted by the desire of
finding an activity suited to their tastes, and where, aided by the motor and
the machine, they will choose the branch of activity which best suits their
inclinations."_ [Kropotkin, **Fields, Factories and Workshops Tomorrow**, p.
197]

This vision of rural and urban integration is just part of the future
anarchists see for the workplace. As Kropotkin argued, _"[w]e proclaim
**integration**. . . a society of integrated, combined labour. A society where
each individual is a producer of both manual and intellectual work; where each
able-bodied human being is a worker, and where each worker works both in the
field and the industrial workshop; where every aggregation of individuals,
large enough to dispose of a certain variety of natural resources -- it may be
a nation, or rather a region -- produces and itself consumes most of its own
agricultural and manufactured produce."_ [**Op. Cit.**, p. 26]

The future workplace would be an expression of the desires of those who worked
there. It would be based around a pleasant working environment, within gardens
and with an extensive library, resources for education classes and other
leisure activities. All this, and more, will be possible in a society based
upon self-realisation and self-expression and one in which individuality is
not crushed by authority and capitalism. To quote Kropotkin, the future
workplace would be _"airy and hygienic, and consequently economical, factories
in which human life is of more account than machinery and the making of extra
profits."_ [**Op. Cit.**, p. 197] For, obviously, _"if most of the workshops
we know are foul and unhealthy, it is because the workers are of no account in
the organisation of factories"_. [**The Conquest of Bread**, p. 121]

_"So in brief,"_ argued William Morris, _"our buildings will be beautiful with
their own beauty of simplicity as workshops"_ and _"besides the mere
workshops, our factory will have other buildings which may carry ornament
further than that, for it will need dinning-hall, library, school, places for
study of different kinds, and other such structures."_ [**A Factory as It
Might Be**, p. 9] This is possible and is only held back by capitalism which
denounces such visions of freedom as "uneconomic." Yet such claims ignore the
distribution of income in class society:

> _"Impossible I hear an anti-Socialist say. My friend, please to remember
that most factories sustain today large and handsome gardens, and not seldom
parks . . . **only** the said gardens, etc. are twenty miles away from the
factory, **out of the smoke,** and are kept up for **one member of the factory
only,** the sleeping partner to wit."_ [Morris, **Op. Cit.**, pp. 7-8]

Pleasant working conditions based upon the self-management of work can produce
a workplace within which economic "efficiency" can be achieved without
disrupting and destroying individuality and the environment (also see [section
I.4.9](secI4.html#seci49) for a fuller discussion of anarchism and
technology).

## I.4.16 Won't a libertarian communist society be inefficient?

It is often argued that anarcho-communism and other forms of non-market
libertarian-socialism would promote inefficiency and unproductive work. The
basis of this argument is that without market forces to discipline workers and
the profit motive to reward them, workers would have no incentive to work in a
way which minimises time or resources. The net effect of this would be
inefficient use of recourses, particularly an individual's time.

This is a valid point in some ways; for example, a society can (potentially)
benefit from increasing productivity as the less time and resources it takes
to produce a certain good, the more of both it gains for other activities
(although, of course, in a class society the benefits of increased
productivity generally accrue to, first and foremost, those at the top and,
for the rest, the "other activities" mean more work). Indeed, for an
individual, a decent society depends on people having time available for them
to do what they want, to develop themselves in whatever way they want, to
enjoy themselves. In addition, doing more with less can have a positive
environment impact as well. It is for these reasons that an anarchist society
would be interested in promoting efficiency and productiveness during
production.

A free society will undoubtedly create new criteria for what counts as an
efficient use of resources and time. What passes for "efficient" use under
capitalism often means what is efficient in increasing the power and profits
of the few, without regard to the wasteful use of individual time, energy and
potential as well as environmental and social costs. Such a narrow criteria
for decision making or evaluating efficient production will not exist in an
anarchist society (see our discussion of the irrational nature of the price
mechanism in [section I.1.2](secI1.html#seci12), for example). When we use the
term efficiency we mean the dictionary definition of efficiency (i.e. reducing
waste, maximising use of resources) rather than what the capitalist market
distorts this into (i.e. what creates most profits for the boss).

While capitalism has turned improvements in productivity as a means of
increasing work, enriching the few and generally proletarianising the working
class, a free society would take a different approach to the problem. As
argued in [section I.4.3](secI4.html#seci43), a communist-anarchist society
would be based upon the principle of _"**for some much per day** (in money
today, in labour tomorrow) **you are entitled to satisfy -- luxury excepted --
this or the other of your wants**."_ [Peter Kropotkin, **Small Communal
Experiments and why the fail**, p. 8] Building upon this, we can imagine a
situation where the average output for a given industry in a given amount of
time is used to encourage efficiency and productivity. If a given syndicate
can produce this average output with at least average quality in less time
than the agreed average/minimum (and without causing ecological or social
externalities, of course) then the members of that syndicate can and should
have that time off.

This would be a powerful incentive to innovate, improve productivity,
introduce new machinery and processes as well as work efficiently without
reintroducing the profit motive and material inequality. With the possibility
of having more time available for themselves and their own projects, people
involved in productive activities would have a strong interest in being
efficient. Of course, if the work in question is something they enjoy then any
increases in efficiency would **enhance** what makes their work enjoyable and
not eliminate it.

Rewarding efficiency with free time would also be an important means to ensure
efficient use of resources as well as a means of reducing time spent in
productive activity which was considered as boring or otherwise undesirable.
The incentive of getting unpleasant tasks over with as quickly as possible
would ensure that the tasks were done efficiently and that innovation was
directed towards them. Moreover, when it came to major investment decisions, a
syndicate would be more likely to get others to agree to its plans if the
syndicate had a reputation of excellence. This, again, would encourage
efficiency as people would know that they could gain resources for their
communities and workplaces (i.e. themselves) more easily if their work is
efficient and reliable. This would be a key means of encouraging efficient and
effective use of resources.

Similarly, an inefficient or wasteful syndicate would have negative reactions
from their fellow workers. As we argued in [section I.4.7](secI4.html#seci47),
a libertarian communist economy would be based on free association. If a
syndicate or community got a reputation for being inefficient with resources
then others would not associate with them (i.e. they would not supply them
with materials, or place them at the end of the queue when deciding which
production requests to supply, and so on). As with a syndicate which produced
shoddy goods, the inefficient syndicate would also face the judgement of its
peers. This will produce an environment which will encourage efficient use of
resources and time.

All these factors, the possibility of increased free time, the respect and
resources gained for efficient and excellent work and the possibility of a
lack of co-operation with others for inefficient use of resources, would
ensure that an anarchist-communist or anarchist-collectivist society would
have no need to fear inefficiency. Indeed, by placing the benefits of
increased efficiency into the hands of those who do the work, efficiency will
no doubt increase.

With self-management, we can soon see time and resources being used
efficiently and productively simply because those doing the work would have a
direct and real interest in it. Rather than alienate their liberty, as under
capitalism, they would apply their creativity and minds to transforming their
productive activity in such a way as to make it enjoyable and not a waste of
their time.

Little wonder Kropotkin argued that modern knowledge could be applied to a
society in which people, _"with the work of their own hands and intelligence,
and by the aid of the machinery already invented and to be invented, should
themselves create all imaginable riches. Technics and science will not be
lagging behind if production takes such a direction. Guided by observation,
analysis and experiment, they will answer all possible demands. They will
reduce the time required for producing wealth to any desired amount, so as to
leave to everyone as much leisure as he or she may ask for . . . they
guarantee . . . the happiness that can be found in the full and varied
exercise of the different capacities of the human being, in work that need not
be overwork."_ [**Fields, Factories and Workshops Tomorrow**, pp. 198-9]

[‹ I.3 What could the economic structure of anarchy look
like?](/afaq/secI3.html "Go to previous page" ) [up](/afaq/secIcon.html "Go to
parent page" ) [I.5 What could the social structure of anarchy look like?
›](/afaq/secI5.html "Go to next page" )

