%define	name		anjuta
%define	version		0.1.9
%define	release		1
%define	serial		1
%define	prefix		/usr

Summary:	Linux IDE for C and C++
Name:		%{name}
Version:	%{version}
Release:	%{release}
Serial:		%{serial}
Copyright:	GPL2
Group:		Development/Tools
URL:		http://anjuta.sourceforge.net/
Vendor:		Naba Kumar <kh_naba@users.sourceforge.net>
Source:		%{name}-%{version}.tar.gz
BuildRoot:	/var/tmp/%{name}-%{version}
Docdir:		%{_docdir}
Requires:	glib >= 1.2.8, gtk+ >= 1.2.8, gnome-libs >= 1.2.8, scrollkeeper >= 0.1.4

Distribution:	Any
Packager:	Naba kumar <kh_naba@yahoo.com>

%description
Anjuta is a versatile Integrated Development Environment (IDE) for C and C++ 
on GNU/Linux. It has been written for GTK/GNOME, and features a number of 
advanced programming features. It is basically a GUI interface for the 
collection of command line programming utilities and tools available for Linux. 
These are usually run via a text console, and can be unfriendly to use.

%prep
%setup

%build
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%prefix

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{prefix} install

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%post
scrollkeeper-update

%files
%doc AUTHORS COPYING ChangeLog INSTALL NEWS README THANKS TODO

%defattr(-,root,root)
%{prefix}/bin/anjuta
%{prefix}/bin/anjuta_launcher
%{prefix}/bin/anjuta_import.sh
%{prefix}/lib/anjuta
%{prefix}/share/gnome/apps/Development/anjuta.desktop
%{prefix}/share/anjuta
%{prefix}/share/gnome/help/anjuta
%{prefix}/share/pixmaps/anjuta
%{prefix}/share/omf/anjuta
%{prefix}/share/locale/*/LC_MESSAGES/anjuta.mo
