//#include <stdio.h>
#include <rechecks.h>

#define LOCAL_DEBUG
#include "debug.h"

#include "acfg.h" 

rechecks::rechecks() {
	//printf("%s\n%s\n", a, b);
    int rc;
    rc=regcomp(&rePfiles, acfg::pfilepat.c_str(), REG_EXTENDED);
    ASSERT(!rc);
    rc=regcomp(&reIfiles, acfg::vfilepat.c_str(), REG_EXTENDED);
    ASSERT(!rc);
    //ldbg("reIfiles: " << rc);
    //rc=regcomp(&rePoison, "[^a-zA-Z0-9\\-+_~./]", REG_EXTENDED);
    //rc=regcomp(&rePoison, "[^a-zA-Z0-9._~+/-]", REG_EXTENDED);
    //ldbg("rePoison: " << rc);
    ASSERT(!rc);
}

rechecks::~rechecks() {
    //regfree(&rePoison);
    regfree(&reIfiles);
    regfree(&rePfiles);
}

rechecks::eFileKind rechecks::getFiletype(const char *in) {
    dbgline;
    if(!regexec(&rePfiles, in, 0, NULL, 0))
        return FILE_PKG;
    dbgline;
    if(!regexec(&reIfiles, in, 0, NULL, 0))
        return FILE_INDEX;
    dbgline;
    return FILE_INVALID;
}

/*
int main(int argc, char **argv) {
    rechecks checka;
    printf("re: typ von %s ist %d\n", argv[1], checka.getFiletype(argv[1]));
}
*/
