#include "main.h"

void GetOpt_Free(void);

char *MANUAL_VAL;
char *DISTRO_VAL;
char *FILE_VAL;
char *SAVE_VAL;
char *TOP_VAL;

FILE *FILE_FILE;
FILE *SAVE_FILE;

int option_flags=0;
int EARLY_FINISH=0;
int STATUS_WHEEL=1;


#define Case(apple, banana) \
	case apple: \
	if(!(banana & option_flags))
//		if ( !(digit_optind != 0 && digit_optind != this_option_optind) ) \


void usage()
{
	printf("\nUsage: apt-spy v%1.2f [GNU long option] [option]\n", MY_VERSION);
}


void help_menu(void);

void GetOpt(int argc, char **argv)
{
	int ch, digit_optind = 0;


	while(1)
	{
		int this_option_optind = optind ? optind : 1;
		int option_index = 0;

		static struct option long_options[] =
		    {
			    { "manual-add"  , required_argument, 0, 'a'
			    },
			    { "early-finish", required_argument, 0, 'e' },
			    { "distribution", required_argument, 0, 'd' },
			    { "use-file"    , required_argument, 0, 'f' },
			    { "save-list"   , required_argument, 0, 'l' },
			    { "save-top"    , required_argument, 0, 's' },
			    { "help"        , no_argument      , 0, 'h' },
			    { "wheel"       , no_argument      , 0, 'w' },
			    { 0             , 0                , 0,  0  }
		    };

		ch = getopt_long(argc, argv, "a:e:d:f:s:l:hw", long_options, &option_index);
		if(ch == -1)
			break;

		switch(ch)
		{
			Case('d', DISTRO_FLAG)
			{
				option_flags |= DISTRO_FLAG;
				DISTRO_VAL = (char*)malloc(sizeof(char) * (strlen(optarg)+1));
				strcpy(DISTRO_VAL, optarg);
			}
			break;

			Case('a', MANUAL_FLAG)
			{
				option_flags |= MANUAL_FLAG;
				MANUAL_VAL = (char*)malloc(sizeof(char) * (strlen(optarg)+1));
				strcpy(MANUAL_VAL, optarg);
			}
			break;

			Case('l', SAVE_FLAG)
			{
				option_flags |= SAVE_FLAG;
				SAVE_VAL = (char*)malloc(sizeof(char) * (strlen(optarg)+1));
				strcpy(SAVE_VAL, optarg);
				post_message("Will save sources.list file as %s.\n", SAVE_VAL);
			}
			break;

			Case('s', TOP_FLAG)
			{
				option_flags |= TOP_FLAG;
				TOP_VAL = (char*)malloc(sizeof(char) * (strlen(optarg)+1));
				strcpy(TOP_VAL, optarg);
				post_message("Will save top sites to %s.\n", TOP_VAL);
			}
			break;

			Case('f', FILE_FLAG)
			{
				option_flags |= FILE_FLAG;
				FILE_VAL = (char*)malloc(sizeof(char) * (strlen(optarg)+1));
				strcpy(FILE_VAL, optarg);
				post_message("Will use list from %s.\n", FILE_VAL);
			}
			break;

			Case('h', HELP_FLAG)
			{
				option_flags |= HELP_FLAG;
				help_menu();
				GetOpt_Free();
				exit(0);
			}
			break;

			Case('w', WHEEL_FLAG)
			{
				option_flags |= WHEEL_FLAG;
				post_message("Wheel flag toggled on.");
				STATUS_WHEEL = 0;
			}
			break;

			Case('e', EARLY_FLAG)
			{
				option_flags |= EARLY_FLAG;
				EARLY_FINISH = atoi(optarg);
				if(EARLY_FINISH < 0)
				{
					post_message("EARLY_FINISH can't be a negative value. Value unset.");
					EARLY_FINISH = 0;
				}
				post_message("Early Finish toggled to %d\n", EARLY_FINISH);
			}
			break;
		};
	}
	if(optind < argc)
	{
		post_message("The following were NON-OPTIONS elements: ");
		post_message("[");
		while (optind < argc)
			printf ("%s ", argv[optind++]);
		printf ("]\n");
	}
	printf("\n\n");
}

void GetOpt_Free(void)
{
	if(option_flags & DISTRO_FLAG)
		free(DISTRO_VAL);
	if(option_flags & MANUAL_FLAG)
		free(MANUAL_VAL);
	if(option_flags & FILE_FLAG)
	{
		free(FILE_VAL);
		if(FILE_FILE != NULL)
			fclose(FILE_FILE);
	}
	if(option_flags & SAVE_FLAG)
	{
		if(SAVE_FILE != NULL)
			fclose(SAVE_FILE);
		free(SAVE_VAL);
	}
	if(option_flags & TOP_FLAG)
	{
		free(TOP_VAL);
	}
}

void Make_Files(void)
{
	if(option_flags & FILE_FLAG)
	{
		if(NULL == (FILE_FILE = fopen(FILE_VAL, "r")))
		{
			post_message("Unable to open %s for reading. Fix error and re-run.\n");
			usage();
			GetOpt_Free();
			exit(-1);
		}
	}
	if(option_flags & SAVE_FLAG)
	{
		if(NULL == (SAVE_FILE = fopen(SAVE_VAL, "w")))
		{
			post_message("Unable to open %s for writing. Fix error and re-run.\n");
			usage();
			GetOpt_Free();
			exit(-1);
		}
	}
}

int Copy_File(FILE *in, char *outname)
{
	int c;
	FILE *out;
	if(NULL == (out = fopen(outname, "w")))
	{
		post_message("Unable to open %s for writing, skipping.\n");
		return 0;
	}
	fseek(in, 0L, SEEK_SET);

	while(!feof(in))
	{
		c = fgetc(in);
		if(isascii(c))
			fputc(c, out);
		update_status;
		fflush(stdout);
	}

	fclose(out);
	fseek(in, 0L, SEEK_SET);

	return 1;
}


void help_menu(void)
{
	usage();
	printf("Option         Long Option              Definition\n");
	printf(" -a [STRING]   --manual-add=[STRING]    Manually append STRING to end of sources.list\n");
	printf(" -d [DIST]     --distribution=[DIST]    Use distribution STABLE, TESTING or UNSTABLE\n");
	printf(" -e [#]        --early-finish=[#]       Finish after # of benchmarked sites are done\n");
	printf(" -f [FILE]     --use-file=[FILE]        Use FILE as server list instead of debian.org\n");
	printf(" -l [FILE]     --save-list=[FILE]       List to save instead of /etc/apt/sources.list\n");
	printf("                                        Note: File gets backed up\n");
	printf(" -s [FILE]     --save-top=[FILE]        Save TOP scorers to FILE\n");
	printf(" -h            --help                   This help menu\n");
	printf(" -w            --wheel                  This toggles off the status wheel\n");
	fflush(stdout);
}

int if_flag(int option)
{
	return(option & option_flags);
}

/*
 
main(int argc, char **argv)
{
	GetOpt(argc, argv);
	GetOpt_Free();
	return 0;
}
 
*/

