# 
# valid-patch-level-name.sh - validate a patch level name
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "*validate a patch level directory name\\n"
		printf "usage: valid-patch-level-name [options] [--] patch-level\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf " -e --errname name             use ERRNAME for error messages\\n"
		printf "\\n"
		printf "Check the validity of the name of a patch level directory.  Exit with\\n"
		printf "status 0 if it is ok, 1 otherwise.\\n"
		printf "\\n"
		printf "A valid patch level directory name matches this regexp (ERE syntax)\\n"
		printf "\\n"
		printf "    ^base-0|patch-[0-9]+|version-[0-9]+\$\\n"
		printf "\\n"
		printf "If the id string is invalid, and an error name is provided\\n"
 		printf "(-e or --errname) print an error message before exiting.\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

errname=

while test $# -ne 0 ; do

  case "$1" in 

    --)			shift
    			break
			;;
			
    -e|--errname)	shift
    			if test $# -eq 0 ; then
			  printf "valid-patch-level-name: -e and --errname require an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			errname="$1"
			shift
			;;

    -*)			printf "valid-patch-level-name: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;

  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -ne 1 ; then
  printf "usage: valid-patch-level-name [options] [--] id-string\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

patchlvl="$1"

################################################################
# Check the Id String
# 

patchlvlre="base-0|patch-[0-9]+|version-0|versionfix-[0-9]+"

set +e
filtered="`printf \"%s\\n\" \"$patchlvl\" | grep -E \"^($patchlvlre)\$\"`"
set -e

if test "x$filtered" = x ; then
  if test "x$errname" != x ; then
    printf "%s: invalid patch level directory name (%s)\\n" "$errname" "$patchlvl" 1>&2
  fi
  exit 1
fi

exit 0

