# compute-renamed.awk:
#
################################################################
# Copyright (C) 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 


# ARGV[1] 	orig-dir-index
# ARGV[2]	mod-dir-index
# ARGV[3]	orig-X-index
# ARGV[4]	mod-X-index


BEGIN {
        orig_dir_index = ARGV[1];
	mod_dir_index = ARGV[2];
	orig_X_index = ARGV[3];

	ARGV[1] = "";
	ARGV[2] = "";
	ARGV[3] = "";

	orig_dir_tag["."] = "?_.";
	while (getline < orig_dir_index)
	  { 
            # name	tag
            #  $1      $2
            #
            orig_dir_tag[$1] = $2;
          }

	close(orig_dir_index);

        mod_dir_tag["."] = "?_.";
        while (getline < mod_dir_index)
          { 
            # name	tag
            #  $1      $2
            #
            mod_dir_tag[$1] = $2;
          }
      
	close(mod_dir_index);

        while (getline < orig_X_index)
          {
            # name	tag
            #  $1      $2
            #
            tag_orig_X[$2] = $1;
      
            container = $1;
            sub("/[^/]*$", "", container);
      
            tag_orig_container[$2] = container;
            tag_orig_container_tag[$2] = orig_dir_tag[container];
          }

	close(orig_X_index);

      }


# process mod-X-index
# 
{
  # name	tag
  #  $1		$2

  container = $1;
  sub("/[^/]*$", "", container);

  tail = $1;
  sub("^.*/", "", tail);

  tag = $2;

  orig = tag_orig_X[tag];

  orig_tail = orig;
  sub("^.*/", "", orig_tail);

  if (orig && ( (orig_tail != tail) || (mod_dir_tag[container] != tag_orig_container_tag[tag]) ))
    {
      print tag_orig_X[tag] " " $1 " " tag;
    }
}

# tag: Tom Lord Tue Jan 22 04:54:00 2002 (patch-sets/compute-renamed.awk)
#
