# notify-browser.sh: add new revisions to the browser
# 
################################################################
# Copyright (C) 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

command_line="$*"

################################################################
# special options
# 
# Some options are special:
# 
#       --version | -V
#       --help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
                printf "add new revisions to the browser\\n"
                printf "usage: notify-browser [options] recipient archive/version revision ..."
                printf "\\n"
                printf " -V --version                  print version info\\n"
                printf " -h --help                     display help\\n"
                printf "\\n"
		printf "Invoke:\\n"
		printf "\\n"
		printf "	larch make-library-browser \`cat =browser-dir\` ARCHIVE/VERSION\\n"
		printf "\\n"
		printf "Then send email to RECIPIENT indicating that the library has been updated.\\n"
		printf "\\n"
                exit 0
                ;;

      *)
                ;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

while test $# -ne 0 ; do

  case "$1" in 

    --)			shift
    			break
			;;

    -*)                 printf "notify-browser: unrecognized option (%s)\\n" "$1" 1>&2
                        printf "try --help\\n" 1>&2
                        exit 1
                        ;;

    *)                  break
                        ;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -lt 3 ; then
  printf "usage: notify-browser [options] recipient version branch ..." 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

recipient="$1"
shift

version="$1"
shift

################################################################
# Sanity Check and Process Defaults
# 

larch valid-package-name --archive --vsn -e notify-browser "$version"


################################################################
# Update Library
#


larch make-library-browser `cat =browser-opts \
			   | larch file-syntax-filter --sh-comments --blank-lines --trailing-spaces ` \
			  "$version--$1"

( \
  printf "notify-browser invoked for new revisions in the library.\\n" ; \
  printf "\\n" ; \
  printf "For version %s\\n" "$version" ; \
  printf "these revisions were added:\\n" ; \
  printf "%s\\n" "$*" \
  | sed -e 's/ /\
    /g' \
) \
| $ARCH_MAILER -s "Revisions added to browser" "$recipient" 


# tag: Tom Lord Wed Jan 30 03:06:04 2002 (notify/notify-browser.sh)
#
