/* set-file-metadata.c
 *
 ****************************************************************
 * Copyright (C) 2001  Tom Lord
 * 
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "config-options.h"
#include "hackerlab/cmd/main.h"



static t_uchar * program_name = "set-file-metadata";
static t_uchar * usage = "set-file-metadata [options] file...";
static t_uchar * version_string = (cfg__std__package " from regexps.com\n"
				   "\n"
				   "Copyright 2001, 2002 Tom Lord\n"
				   "\n"
				   "This is free software; see the source for copying conditions.\n"
				   "There is NO warranty; not even for MERCHANTABILITY or FITNESS FOR A\n"
				   "PARTICULAR PURPOSE.\n"
				   "\n"
				   "Report bugs to <lord@regexps.com>.\n"
				   "\n");

#define OPTS(OP, OP2) \
  OP (opt_help_msg, "h", "help", 0, \
      "Display a help message and exit.") \
  OP (opt_long_help, "H", 0, 0, \
      "Display a verbose help message and exit.") \
  OP (opt_version, "V", "version", 0, \
      "Display a release identifier string") \
  OP2 (opt_version, 0, 0, 0, "and exit.") \
  OP (opt_permissions, 0, "permissions", 1, \
      "Set file permissions.")

static t_uchar long_help[] = ("Set file attributes.\n"
			      "Set file attributes, such as file permissions.  See also\n"
			      "`file-metadata'\n");

enum options
{
  OPTS (OPT_ENUM, OPT_IGN)  
};

struct opt_desc opts[] = 
{
  OPTS (OPT_DESC, OPT_DESC)
    {-1, 0, 0, 0, 0}
};



int
main (int argc, char * argv[])
{
  int errn;
  int o;
  struct opt_parsed * option;
  int permissions;
  int set_permissions;

  safe_buffer_fd (1, 0, O_WRONLY, 0);


  permissions = 0;
  set_permissions = 0;

  option = 0;

  while (1)
    {
      o = opt_standard (lim_use_must_malloc, &option, opts, &argc, argv, program_name, usage, version_string, long_help, opt_help_msg, opt_long_help, opt_version);
      if (o == opt_none)
	break;
      switch (o)
	{
	default:
	  safe_printfmt (2, "unhandled option `%s'\n", option->opt_string);
	  panic ("internal error parsing arguments");

	usage_error:
	  opt_usage (2, argv[0], program_name, usage, 1);
	  exit (1);

	bogus_arg:
	  safe_printfmt (2, "ill-formed argument for `%s' (`%s')\n", option->opt_string, option->arg_string);
	  goto usage_error;

	case opt_permissions:
	  if (0 > cvt_octal_to_int (&errn, &permissions, option->arg_string, str_length (option->arg_string)))
	    goto bogus_arg;
	  set_permissions = 1;
	  break;

	}
    }


  {
    int arg;

    for (arg = 1; arg < argc; ++arg)
      {
	struct stat stat_buf;

	safe_lstat (argv[arg], &stat_buf);

	if (set_permissions && !S_ISLNK (stat_buf.st_mode))
	  {
	    safe_chmod (argv[arg], permissions);
	  }
      }
  }
  return 0;
}

/* tag: Tom Lord Tue Dec  4 18:51:14 2001 (set-file-metadata.c)
 */
