/* tag: Tom Lord Tue Dec  4 14:41:25 2001 (protocol.h)
 */
/* protocol.h -
 *
 ****************************************************************
 * Copyright (C) 2001 Tom Lord
 * 
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__FTP_PROTOCOL__PROTOCOL_H
#define INCLUDE__FTP_PROTOCOL__PROTOCOL_H

#include "hackerlab/machine/types.h"
#include "hackerlab/os/stdarg.h"
#include "hackerlab/mem/alloc-limits.h"


/* automatically generated __STDC__ prototypes */
extern int ftp_client_connect_and_login (int * in_fd,
					 int * out_fd,
					 alloc_limits limits,
					 int * errn,
					 int * code,
					 t_uchar ** text,
					 long * text_len,
					 t_uchar * host);
extern int ftp_client_greet (alloc_limits limits,
			     int * errn,
			     int * code,
			     t_uchar ** text,
			     long * len,
			     int in_fd,
			     int out_fd);
extern int ftp_client_login (alloc_limits limits,
			     int * errn,
			     int * code,
			     t_uchar ** text,
			     long * text_len,
			     int in_fd,
			     int out_fd,
			     t_uchar * name,
			     t_uchar * passwd);
extern int ftp_client_cwd (alloc_limits limits,
			   int * errn,
			   int * code,
			   t_uchar ** text,
			   long * text_len,
			   int in_fd,
			   int out_fd,
			   t_uchar * path);
extern int ftp_client_cdup (alloc_limits limits,
			    int * errn,
			    int * code,
			    t_uchar ** text,
			    long * text_len,
			    int in_fd,
			    int out_fd);
extern int ftp_client_quit (alloc_limits limits,
			    int * errn,
			    int * code,
			    t_uchar ** text,
			    long * text_len,
			    int in_fd,
			    int out_fd);
extern int ftp_client_port (alloc_limits limits,
			    int * errn,
			    int * code,
			    t_uchar ** text,
			    long * text_len,
			    int in_fd,
			    int out_fd,
			    t_ulong host,
			    t_uint16 port);
extern int ftp_client_pasv (alloc_limits limits,
			    int * errn,
			    int * code,
			    t_ulong * host,
			    t_uint16 * port,
			    t_uchar ** text,
			    long * text_len,
			    int in_fd,
			    int out_fd);
extern int ftp_client_type_image (alloc_limits limits,
				  int * errn,
				  int * code,
				  t_uchar ** text,
				  long * text_len,
				  int in_fd,
				  int out_fd);
extern int ftp_client_type_ascii (alloc_limits limits,
				  int * errn,
				  int * code,
				  t_uchar ** text,
				  long * text_len,
				  int in_fd,
				  int out_fd);
extern int ftp_client_stream_mode (alloc_limits limits,
				   int * errn,
				   int * code,
				   t_uchar ** text,
				   long * text_len,
				   int in_fd,
				   int out_fd);
extern int ftp_client_begin_retr (alloc_limits limits,
				  int * errn,
				  int * code,
				  t_uchar ** text,
				  long * text_len,
				  int in_fd,
				  int out_fd,
				  t_uchar * path);
extern int ftp_client_end_retr (alloc_limits limits,
				int * errn,
				int * code,
				t_uchar ** text,
				long * text_len,
				int in_fd,
				int out_fd);
extern int ftp_client_begin_stor (alloc_limits limits,
				  int * errn,
				  int * code,
				  t_uchar ** text,
				  long * text_len,
				  int in_fd,
				  int out_fd,
				  t_uchar * path);
extern int ftp_client_end_stor (alloc_limits limits,
				int * errn,
				int * code,
				t_uchar ** text,
				long * text_len,
				int in_fd,
				int out_fd);
extern int ftp_client_rename (alloc_limits limits,
			      int * errn,
			      int * code,
			      t_uchar ** text,
			      long * text_len,
			      int in_fd,
			      int out_fd,
			      t_uchar * from,
			      t_uchar * to);
extern int ftp_client_dele (alloc_limits limits,
			    int * errn,
			    int * code,
			    t_uchar ** text,
			    long * text_len,
			    int in_fd,
			    int out_fd,
			    t_uchar * path);
extern int ftp_client_rmd (alloc_limits limits,
			   int * errn,
			   int * code,
			   t_uchar ** text,
			   long * text_len,
			   int in_fd,
			   int out_fd,
			   t_uchar * path);
extern int ftp_client_mkd (alloc_limits limits,
			   int * errn,
			   int * code,
			   t_uchar ** text,
			   long * text_len,
			   int in_fd,
			   int out_fd,
			   t_uchar * path);
extern int ftp_client_pwd (alloc_limits limits,
			   int * errn,
			   int * code,
			   t_uchar ** path,
			   long * path_len,
			   t_uchar ** text,
			   long * text_len,
			   int in_fd,
			   int out_fd);
extern int ftp_client_begin_list (alloc_limits limits,
				  int * errn,
				  int * code,
				  t_uchar ** text,
				  long * text_len,
				  int in_fd,
				  int out_fd,
				  t_uchar * path);
extern int ftp_client_end_list (alloc_limits limits,
				int * errn,
				int * code,
				t_uchar ** text,
				long * text_len,
				int in_fd,
				int out_fd);
extern int ftp_client_begin_nlst (alloc_limits limits,
				  int * errn,
				  int * code,
				  t_uchar ** text,
				  long * text_len,
				  int in_fd,
				  int out_fd,
				  t_uchar * path);
extern int ftp_client_end_nlst (alloc_limits limits,
				int * errn,
				int * code,
				t_uchar ** text,
				long * text_len,
				int in_fd,
				int out_fd);
extern int ftp_client_noop (alloc_limits limits,
			    int * errn,
			    int * code,
			    t_uchar ** text,
			    long * text_len,
			    int in_fd,
			    int out_fd);
#endif  /* INCLUDE__FTP_PROTOCOL__PROTOCOL_H */
