#include <stdio.h>
#include "IDSLog.h"

class CSnortLog : public CIDSLog {
public:
  CSnortLog();
  virtual ~CSnortLog();
  void printStats();

private:
  enum log_type { SNORT_LOG_NONE, SNORT_LOG_FAST, SNORT_LOG_FULL, SNORT_LOG_SYSLOG };
  FILE *m_pLogfile;
  FILE *m_pPortScanFile;
  bool OpenLog(const char *filename);
  bool LastIncident();
  bool ReadIncident();
  void CloseLog();
  void SeekLog(double nDate);
  void IDSVersion(char *sIDSProduct, int &nIDSID, int &nIDSMajor, int &nIDSMinor, char *sIDRev) const;
  double GetLastDate();
  double do_date();
  int guessYear(int, int);
  void clearports();
  void addport(int port);
  char *dumpports();
  void cleanID(char *);
  bool parseAddresses(const char *addresses, char *srcIP, int &srcPort, char *dstIP, int &dstPort, char *proto);
  log_type identifyLog(const char *logLine);
  bool ProcessLogFull(char *line);
  bool ProcessLogFast(char *line);
  bool ProcessLogSyslog(char *line);
  bool DoPortScanLog();
  bool DoAlertLog();
  bool isportset(int port);
  int m_nMonth, m_nDay, m_nHour, m_nMinute, m_nSecond, m_nFract;
  int m_nYear;
  int m_nPortScanLines, m_nAlertLines, m_nPortScanEvents, m_nAlertEvents, m_nPortScanSkipped, m_nAlertSkipped;
  char m_pPortArray[8192];
  double m_savedTime;
  double m_lastTime;

  int m_nSpp;
  double m_nSppDateTime;
};


