dnl Available from the GNU Autoconf Macro Archive at:
dnl http://www.gnu.org/software/ac-archive/htmldoc/ac_config_pkgconfig_in.html
dnl
## AC_CONFIG_PKGCONFIG_IN(LIBRARY, DESCRIPTION, DESTINATION)
## ---------------------------------------------------------
## Create a custom pkg-config script for LIBRARY.  Include a one-line
## DESCRIPTION.  The script will be created in a DESTINATION
## directory.
AC_DEFUN([AC_CONFIG_PKGCONFIG_IN],
[# create a custom pkg-config file ($1.pc.in)
m4_pushdef([PKGCONFIG_DIR], [m4_if([$3], , , [$3/])])
PKGCONFIG_FILE="PKGCONFIG_DIR[]$1.pc.in"
AC_SUBST(target)dnl
AC_SUBST(host)dnl
AC_SUBST(build)dnl
dnl create directory if it does not preexist
m4_if([$3], , , [AS_MKDIR_P([$3])])
AC_MSG_NOTICE([creating $PKGCONFIG_FILE])
dnl we're going to need uppercase, lowercase and user-friendly versions of the
dnl string `MODULE'
m4_pushdef([MODULE_UP], m4_translit([$1], [a-z], [A-Z]))dnl
m4_pushdef([MODULE_DOWN], m4_translit([$1], [A-Z], [a-z]))dnl
if test -z "$MODULE_DOWN[]_cflags" ; then
  if test -n "$MODULE_UP[]_CFLAGS" ; then
      MODULE_DOWN[]_cflags="$MODULE_UP[]_CFLAGS"
  else
dnl    AC_MSG_WARN([variable `MODULE_DOWN[]_cflags' undefined])
    MODULE_DOWN[]_cflags=''
  fi
fi
AC_SUBST(MODULE_DOWN[]_cflags)dnl
if test -z "$MODULE_DOWN[]_libs" ; then
  if test -n "$MODULE_UP[]_LIBS" ; then
    MODULE_DOWN[]_libs="$MODULE_UP[]_LIBS"
  else
    AC_MSG_WARN([variable `MODULE_DOWN[]_libs' and `MODULE_UP[]_LIBS' undefined])
    MODULE_DOWN[]_libs='-l$1'
  fi
  if test -n "$MODULE_UP[]_LIBDEPS" ; then
    MODULE_DOWN[]_libs="$MODULE_DOWN[]_libs $MODULE_UP[]_LIBDEPS"
  fi
fi
AC_SUBST(MODULE_DOWN[]_libs)dnl
AC_SUBST(MODULE_UP[]_REQUIRES)
AC_SUBST(MODULE_UP[]_CONFLICTS)
if test -z "$MODULE_UP[]_VERSION" ; then
  AC_MSG_WARN([variable `MODULE_UP[]_VERSION' undefined])
  MODULE_UP[]_VERSION="$VERSION"
fi
AC_SUBST(MODULE_UP[]_VERSION)dnl
echo 'prefix=@prefix@' >$PKGCONFIG_FILE
echo 'exec_prefix=@exec_prefix@' >>$PKGCONFIG_FILE
echo 'libdir=@libdir@' >>$PKGCONFIG_FILE
echo 'includedir=@includedir@' >>$PKGCONFIG_FILE
echo '' >>$PKGCONFIG_FILE
echo 'Name: @PACKAGE@' >>$PKGCONFIG_FILE
echo 'Description: $2' >>$PKGCONFIG_FILE
if test -n "$MODULE_UP[]_REQUIRES" ; then
  echo 'Requires: @MODULE_UP[]_REQUIRES@' >>$PKGCONFIG_FILE
fi
if test -n "$MODULE_UP[]_CONFLICTS" ; then
  echo 'Conflicts: @MODULE_UP[]_CONFLICTS@' >>$PKGCONFIG_FILE
fi
echo 'Version: @VERSION@' >>$PKGCONFIG_FILE
echo 'Libs: -L${libdir} @MODULE_DOWN[]_libs@' >>$PKGCONFIG_FILE
echo 'Cflags: -I${includedir} @MODULE_DOWN[]_cflags@' >>$PKGCONFIG_FILE
m4_pushdef([PKGCONFIG_UP], [m4_translit([$1], [a-z], [A-Z])])dnl
PKGCONFIG_UP[]_PKGCONFIG="PKGCONFIG_DIR[]$1-config"
AC_SUBST(PKGCONFIG_UP[]_PKGCONFIG)
dnl AC_CONFIG_FILES(PKGCONFIG_DIR[]$1[-config], [chmod +x ]PKGCONFIG_DIR[]$1[-config])
m4_popdef([PKGCONFIG_UP])
m4_popdef([MODULE_DOWN])dnl
m4_popdef([MODULE_UP])dnl
m4_popdef([PKGCONFIG_DIR])dnl
])
