/* dg-prefs.c generated by valac, the Vala compiler
 * generated from dg-prefs.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Author : Michal Hruby <michal.mhr@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libdesktop-agnostic/config.h>
#include <libawn/libawn.h>
#include <gtk/gtk.h>
#include <config.h>


#define TYPE_DIGITAL_CLOCK_PREFS (digital_clock_prefs_get_type ())
#define DIGITAL_CLOCK_PREFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIGITAL_CLOCK_PREFS, DigitalClockPrefs))
#define DIGITAL_CLOCK_PREFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIGITAL_CLOCK_PREFS, DigitalClockPrefsClass))
#define IS_DIGITAL_CLOCK_PREFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIGITAL_CLOCK_PREFS))
#define IS_DIGITAL_CLOCK_PREFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIGITAL_CLOCK_PREFS))
#define DIGITAL_CLOCK_PREFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIGITAL_CLOCK_PREFS, DigitalClockPrefsClass))

typedef struct _DigitalClockPrefs DigitalClockPrefs;
typedef struct _DigitalClockPrefsClass DigitalClockPrefsClass;
typedef struct _DigitalClockPrefsPrivate DigitalClockPrefsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _DigitalClockPrefs {
	GObject parent_instance;
	DigitalClockPrefsPrivate * priv;
};

struct _DigitalClockPrefsClass {
	GObjectClass parent_class;
};

struct _DigitalClockPrefsPrivate {
	DesktopAgnosticConfigClient* client;
	AwnApplet* applet;
	gulong pos_changed_id;
	GtkDialog* dialog;
	GtkWidget* hour_12_radio;
	GtkWidget* hour_24_radio;
	GtkWidget* show_date_check;
	GtkWidget* dbt_check;
	GtkWidget* calendar_entry;
	GtkWidget* time_admin_entry;
};


static gpointer digital_clock_prefs_parent_class = NULL;

#define APPLET_NAME "digital-clock"
GType digital_clock_prefs_get_type (void);
#define DIGITAL_CLOCK_PREFS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DIGITAL_CLOCK_PREFS, DigitalClockPrefsPrivate))
enum  {
	DIGITAL_CLOCK_PREFS_DUMMY_PROPERTY,
	DIGITAL_CLOCK_PREFS_IS_12_HOUR,
	DIGITAL_CLOCK_PREFS_DATE_BEFORE_TIME
};
static void digital_clock_prefs_init_components (DigitalClockPrefs* self, GtkBuilder* builder);
static void digital_clock_prefs_on_applet_position_changed (DigitalClockPrefs* self, GtkPositionType new_pos);
static void _digital_clock_prefs_on_applet_position_changed_awn_applet_position_changed (AwnApplet* _sender, GtkPositionType position, gpointer self);
DigitalClockPrefs* digital_clock_prefs_new (AwnApplet* applet);
DigitalClockPrefs* digital_clock_prefs_construct (GType object_type, AwnApplet* applet);
void digital_clock_prefs_set_is_12_hour (DigitalClockPrefs* self, gboolean value);
static void _lambda0_ (GtkToggleButton* w, DigitalClockPrefs* self);
static void __lambda0__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _lambda1_ (GtkToggleButton* w, DigitalClockPrefs* self);
static void __lambda1__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
void digital_clock_prefs_set_date_before_time (DigitalClockPrefs* self, gboolean value);
static void _lambda2_ (GtkToggleButton* w, DigitalClockPrefs* self);
static void __lambda2__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
GtkDialog* digital_clock_prefs_get_dialog (DigitalClockPrefs* self);
gboolean digital_clock_prefs_get_is_12_hour (DigitalClockPrefs* self);
gboolean digital_clock_prefs_get_date_before_time (DigitalClockPrefs* self);
static void digital_clock_prefs_finalize (GObject* obj);
static void digital_clock_prefs_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void digital_clock_prefs_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _digital_clock_prefs_on_applet_position_changed_awn_applet_position_changed (AwnApplet* _sender, GtkPositionType position, gpointer self) {
	digital_clock_prefs_on_applet_position_changed (self, position);
}


DigitalClockPrefs* digital_clock_prefs_construct (GType object_type, AwnApplet* applet) {
	GError * _inner_error_;
	DigitalClockPrefs * self;
	AwnApplet* _tmp0_;
	char* ui_path;
	GtkBuilder* builder;
	DesktopAgnosticConfigClient* _tmp1_;
	DesktopAgnosticConfigClient* _tmp2_;
	g_return_val_if_fail (applet != NULL, NULL);
	_inner_error_ = NULL;
	self = (DigitalClockPrefs*) g_object_new (object_type, NULL);
	self->priv->applet = (_tmp0_ = _g_object_ref0 (applet), _g_object_unref0 (self->priv->applet), _tmp0_);
	ui_path = g_build_filename (APPLETSDIR, APPLET_NAME, "dg-prefs.ui", NULL);
	builder = gtk_builder_new ();
	gtk_builder_add_from_file (builder, ui_path, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (ui_path);
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	digital_clock_prefs_init_components (self, builder);
	self->priv->pos_changed_id = g_signal_connect_object (self->priv->applet, "position-changed", (GCallback) _digital_clock_prefs_on_applet_position_changed_awn_applet_position_changed, self, 0);
	digital_clock_prefs_on_applet_position_changed (self, awn_applet_get_pos_type (applet));
	_tmp1_ = awn_config_get_default_for_applet (applet, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (ui_path);
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->priv->client = (_tmp2_ = _g_object_ref0 (_tmp1_), _g_object_unref0 (self->priv->client), _tmp2_);
	desktop_agnostic_config_client_bind (self->priv->client, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT, "hour12", (GObject*) self, "is_12_hour", FALSE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (ui_path);
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	desktop_agnostic_config_client_bind (self->priv->client, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT, "show_date", (GObject*) self->priv->show_date_check, "active", FALSE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (ui_path);
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	desktop_agnostic_config_client_bind (self->priv->client, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT, "dbt", (GObject*) self, "date-before-time", FALSE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (ui_path);
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	desktop_agnostic_config_client_bind (self->priv->client, "commands", "calendar", (GObject*) self->priv->calendar_entry, "text", FALSE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (ui_path);
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	desktop_agnostic_config_client_bind (self->priv->client, "commands", "adjust_datetime", (GObject*) self->priv->time_admin_entry, "text", FALSE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (ui_path);
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (ui_path);
	_g_object_unref0 (builder);
	return self;
}


DigitalClockPrefs* digital_clock_prefs_new (AwnApplet* applet) {
	return digital_clock_prefs_construct (TYPE_DIGITAL_CLOCK_PREFS, applet);
}


static void digital_clock_prefs_on_applet_position_changed (DigitalClockPrefs* self, GtkPositionType new_pos) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (new_pos == GTK_POS_TOP) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = new_pos == GTK_POS_BOTTOM;
	}
	if (_tmp0_) {
		gtk_widget_set_sensitive (self->priv->dbt_check, TRUE);
	} else {
		gtk_widget_set_sensitive (self->priv->dbt_check, FALSE);
	}
}


static void _lambda0_ (GtkToggleButton* w, DigitalClockPrefs* self) {
	g_return_if_fail (w != NULL);
	if (gtk_toggle_button_get_active (w)) {
		digital_clock_prefs_set_is_12_hour (self, TRUE);
	}
}


static void __lambda0__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda0_ (_sender, self);
}


static void _lambda1_ (GtkToggleButton* w, DigitalClockPrefs* self) {
	g_return_if_fail (w != NULL);
	if (gtk_toggle_button_get_active (w)) {
		digital_clock_prefs_set_is_12_hour (self, FALSE);
	}
}


static void __lambda1__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda1_ (_sender, self);
}


static void _lambda2_ (GtkToggleButton* w, DigitalClockPrefs* self) {
	g_return_if_fail (w != NULL);
	digital_clock_prefs_set_date_before_time (self, !gtk_toggle_button_get_active (w));
}


static void __lambda2__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda2_ (_sender, self);
}


static void digital_clock_prefs_init_components (DigitalClockPrefs* self, GtkBuilder* builder) {
	GtkToggleButton* toggle;
	GtkDialog* _tmp1_;
	GObject* _tmp0_;
	GObject* _tmp2_;
	GtkToggleButton* _tmp4_;
	GtkWidget* _tmp3_;
	GObject* _tmp5_;
	GtkToggleButton* _tmp7_;
	GtkWidget* _tmp6_;
	GObject* _tmp8_;
	GtkToggleButton* _tmp10_;
	GtkWidget* _tmp9_;
	GObject* _tmp11_;
	GObject* _tmp12_;
	GObject* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	toggle = NULL;
	self->priv->dialog = (_tmp1_ = _g_object_ref0 ((_tmp0_ = gtk_builder_get_object (builder, "dialog1"), GTK_IS_DIALOG (_tmp0_) ? ((GtkDialog*) _tmp0_) : NULL)), _g_object_unref0 (self->priv->dialog), _tmp1_);
	self->priv->hour_12_radio = (_tmp2_ = gtk_builder_get_object (builder, "12_hour_radio"), GTK_IS_WIDGET (_tmp2_) ? ((GtkWidget*) _tmp2_) : NULL);
	toggle = (_tmp4_ = _g_object_ref0 ((_tmp3_ = self->priv->hour_12_radio, GTK_IS_TOGGLE_BUTTON (_tmp3_) ? ((GtkToggleButton*) _tmp3_) : NULL)), _g_object_unref0 (toggle), _tmp4_);
	g_signal_connect_object (toggle, "toggled", (GCallback) __lambda0__gtk_toggle_button_toggled, self, 0);
	self->priv->hour_24_radio = (_tmp5_ = gtk_builder_get_object (builder, "24_hour_radio"), GTK_IS_WIDGET (_tmp5_) ? ((GtkWidget*) _tmp5_) : NULL);
	toggle = (_tmp7_ = _g_object_ref0 ((_tmp6_ = self->priv->hour_24_radio, GTK_IS_TOGGLE_BUTTON (_tmp6_) ? ((GtkToggleButton*) _tmp6_) : NULL)), _g_object_unref0 (toggle), _tmp7_);
	g_signal_connect_object (toggle, "toggled", (GCallback) __lambda1__gtk_toggle_button_toggled, self, 0);
	self->priv->dbt_check = (_tmp8_ = gtk_builder_get_object (builder, "date_below_check"), GTK_IS_WIDGET (_tmp8_) ? ((GtkWidget*) _tmp8_) : NULL);
	toggle = (_tmp10_ = _g_object_ref0 ((_tmp9_ = self->priv->dbt_check, GTK_IS_TOGGLE_BUTTON (_tmp9_) ? ((GtkToggleButton*) _tmp9_) : NULL)), _g_object_unref0 (toggle), _tmp10_);
	g_signal_connect_object (toggle, "toggled", (GCallback) __lambda2__gtk_toggle_button_toggled, self, 0);
	self->priv->show_date_check = (_tmp11_ = gtk_builder_get_object (builder, "show_date_check"), GTK_IS_WIDGET (_tmp11_) ? ((GtkWidget*) _tmp11_) : NULL);
	self->priv->calendar_entry = (_tmp12_ = gtk_builder_get_object (builder, "calendar_entry"), GTK_IS_WIDGET (_tmp12_) ? ((GtkWidget*) _tmp12_) : NULL);
	self->priv->time_admin_entry = (_tmp13_ = gtk_builder_get_object (builder, "time_admin_entry"), GTK_IS_WIDGET (_tmp13_) ? ((GtkWidget*) _tmp13_) : NULL);
	_g_object_unref0 (toggle);
}


GtkDialog* digital_clock_prefs_get_dialog (DigitalClockPrefs* self) {
	GtkDialog* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->dialog;
	return result;
}


gboolean digital_clock_prefs_get_is_12_hour (DigitalClockPrefs* self) {
	gboolean result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	result = gtk_toggle_button_get_active ((_tmp0_ = self->priv->hour_12_radio, GTK_IS_TOGGLE_BUTTON (_tmp0_) ? ((GtkToggleButton*) _tmp0_) : NULL));
	return result;
}


void digital_clock_prefs_set_is_12_hour (DigitalClockPrefs* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (value) {
		GtkWidget* _tmp1_;
		gtk_toggle_button_set_active ((_tmp1_ = self->priv->hour_12_radio, GTK_IS_TOGGLE_BUTTON (_tmp1_) ? ((GtkToggleButton*) _tmp1_) : NULL), TRUE);
	} else {
		GtkWidget* _tmp2_;
		gtk_toggle_button_set_active ((_tmp2_ = self->priv->hour_24_radio, GTK_IS_TOGGLE_BUTTON (_tmp2_) ? ((GtkToggleButton*) _tmp2_) : NULL), TRUE);
	}
	g_object_notify ((GObject *) self, "is-12-hour");
}


gboolean digital_clock_prefs_get_date_before_time (DigitalClockPrefs* self) {
	gboolean result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	result = !gtk_toggle_button_get_active ((_tmp0_ = self->priv->dbt_check, GTK_IS_TOGGLE_BUTTON (_tmp0_) ? ((GtkToggleButton*) _tmp0_) : NULL));
	return result;
}


void digital_clock_prefs_set_date_before_time (DigitalClockPrefs* self, gboolean value) {
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	gtk_toggle_button_set_active ((_tmp1_ = self->priv->dbt_check, GTK_IS_TOGGLE_BUTTON (_tmp1_) ? ((GtkToggleButton*) _tmp1_) : NULL), !value);
	g_object_notify ((GObject *) self, "date-before-time");
}


static void digital_clock_prefs_class_init (DigitalClockPrefsClass * klass) {
	digital_clock_prefs_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DigitalClockPrefsPrivate));
	G_OBJECT_CLASS (klass)->get_property = digital_clock_prefs_get_property;
	G_OBJECT_CLASS (klass)->set_property = digital_clock_prefs_set_property;
	G_OBJECT_CLASS (klass)->finalize = digital_clock_prefs_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DIGITAL_CLOCK_PREFS_IS_12_HOUR, g_param_spec_boolean ("is-12-hour", "is-12-hour", "is-12-hour", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DIGITAL_CLOCK_PREFS_DATE_BEFORE_TIME, g_param_spec_boolean ("date-before-time", "date-before-time", "date-before-time", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void digital_clock_prefs_instance_init (DigitalClockPrefs * self) {
	self->priv = DIGITAL_CLOCK_PREFS_GET_PRIVATE (self);
}


static void digital_clock_prefs_finalize (GObject* obj) {
	DigitalClockPrefs * self;
	GError * _inner_error_;
	self = DIGITAL_CLOCK_PREFS (obj);
	_inner_error_ = NULL;
	{
		g_signal_handler_disconnect (self->priv->applet, self->priv->pos_changed_id);
		desktop_agnostic_config_client_unbind_all_for_object (self->priv->client, (GObject*) self, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	_g_object_unref0 (self->priv->client);
	_g_object_unref0 (self->priv->applet);
	_g_object_unref0 (self->priv->dialog);
	G_OBJECT_CLASS (digital_clock_prefs_parent_class)->finalize (obj);
}


GType digital_clock_prefs_get_type (void) {
	static volatile gsize digital_clock_prefs_type_id__volatile = 0;
	if (g_once_init_enter (&digital_clock_prefs_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DigitalClockPrefsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) digital_clock_prefs_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DigitalClockPrefs), 0, (GInstanceInitFunc) digital_clock_prefs_instance_init, NULL };
		GType digital_clock_prefs_type_id;
		digital_clock_prefs_type_id = g_type_register_static (G_TYPE_OBJECT, "DigitalClockPrefs", &g_define_type_info, 0);
		g_once_init_leave (&digital_clock_prefs_type_id__volatile, digital_clock_prefs_type_id);
	}
	return digital_clock_prefs_type_id__volatile;
}


static void digital_clock_prefs_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DigitalClockPrefs * self;
	self = DIGITAL_CLOCK_PREFS (object);
	switch (property_id) {
		case DIGITAL_CLOCK_PREFS_IS_12_HOUR:
		g_value_set_boolean (value, digital_clock_prefs_get_is_12_hour (self));
		break;
		case DIGITAL_CLOCK_PREFS_DATE_BEFORE_TIME:
		g_value_set_boolean (value, digital_clock_prefs_get_date_before_time (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void digital_clock_prefs_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DigitalClockPrefs * self;
	self = DIGITAL_CLOCK_PREFS (object);
	switch (property_id) {
		case DIGITAL_CLOCK_PREFS_IS_12_HOUR:
		digital_clock_prefs_set_is_12_hour (self, g_value_get_boolean (value));
		break;
		case DIGITAL_CLOCK_PREFS_DATE_BEFORE_TIME:
		digital_clock_prefs_set_date_before_time (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




