/* notification-area.c generated by valac, the Vala compiler
 * generated from notification-area.vala, do not modify */

/*
 * Copyright (C) 2009 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Author : Michal Hruby <michal.mhr@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <eggtraymanager.h>
#include <libawn/libawn.h>
#include <egg-tray-child.h>
#include <gtk/gtk.h>
#include <libdesktop-agnostic/config.h>
#include <libdesktop-agnostic/desktop-agnostic.h>
#include <gdk/gdk.h>
#include <libawn/awn-utils.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_NOTIFICATION_AREA (notification_area_get_type ())
#define NOTIFICATION_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_AREA, NotificationArea))
#define NOTIFICATION_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_AREA, NotificationAreaClass))
#define IS_NOTIFICATION_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_AREA))
#define IS_NOTIFICATION_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_AREA))
#define NOTIFICATION_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_AREA, NotificationAreaClass))

typedef struct _NotificationArea NotificationArea;
typedef struct _NotificationAreaClass NotificationAreaClass;
typedef struct _NotificationAreaPrivate NotificationAreaPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define TYPE_NOTIFICATION_AREA_PREFS (notification_area_prefs_get_type ())
#define NOTIFICATION_AREA_PREFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_AREA_PREFS, NotificationAreaPrefs))
#define NOTIFICATION_AREA_PREFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_AREA_PREFS, NotificationAreaPrefsClass))
#define IS_NOTIFICATION_AREA_PREFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_AREA_PREFS))
#define IS_NOTIFICATION_AREA_PREFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_AREA_PREFS))
#define NOTIFICATION_AREA_PREFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_AREA_PREFS, NotificationAreaPrefsClass))

typedef struct _NotificationAreaPrefs NotificationAreaPrefs;
typedef struct _NotificationAreaPrefsClass NotificationAreaPrefsClass;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _NotificationArea {
	GObject parent_instance;
	NotificationAreaPrivate * priv;
};

struct _NotificationAreaClass {
	GObjectClass parent_class;
};

struct _NotificationAreaPrivate {
	EggTrayManager* manager;
	AwnApplet* applet;
	GList* tray_icons;
	gint max_rows;
	gint max_cols;
	gint redraw_timer;
	GQuark addition_quark;
	GQuark deletion_quark;
	GtkEventBox* eb;
	AwnAlignment* align;
	GtkAlignment* inner_align;
	GtkEventBox* icon_painter;
	GtkTable* table;
	DesktopAgnosticConfigClient* client;
	gint _icon_size;
	gint _extra_offset;
	DesktopAgnosticColor* _background_color;
	DesktopAgnosticColor* _border_color;
};


extern gboolean gpm_workaround_done;
gboolean gpm_workaround_done = FALSE;
static NotificationAreaPrefs* notification_area_prefs_window;
static NotificationAreaPrefs* notification_area_prefs_window = NULL;
static gpointer notification_area_parent_class = NULL;

GType notification_area_get_type (void);
#define NOTIFICATION_AREA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFICATION_AREA, NotificationAreaPrivate))
enum  {
	NOTIFICATION_AREA_DUMMY_PROPERTY,
	NOTIFICATION_AREA_ICONS_PER_CELL,
	NOTIFICATION_AREA_ICON_SIZE,
	NOTIFICATION_AREA_EXTRA_OFFSET,
	NOTIFICATION_AREA_BACKGROUND_COLOR,
	NOTIFICATION_AREA_BORDER_COLOR
};
GType notification_area_prefs_get_type (void);
#define NOTIFICATION_AREA_BORDER 2
static void notification_area_on_icon_added (NotificationArea* self, GtkWidget* widget);
static void _notification_area_on_icon_added_egg_tray_manager_tray_icon_added (EggTrayManager* _sender, GtkWidget* object, gpointer self);
static void notification_area_on_icon_removed (NotificationArea* self, GtkWidget* widget);
static void _notification_area_on_icon_removed_egg_tray_manager_tray_icon_removed (EggTrayManager* _sender, GtkWidget* object, gpointer self);
static void notification_area_update_icon_sizes (NotificationArea* self);
static void notification_area_table_refresh (NotificationArea* self);
static void _lambda9_ (GtkPositionType new_pos, NotificationArea* self);
static void __lambda9__awn_applet_position_changed (AwnApplet* _sender, GtkPositionType position, gpointer self);
static void _lambda10_ (gint new_size, NotificationArea* self);
static void __lambda10__awn_applet_size_changed (AwnApplet* _sender, gint size, gpointer self);
static gboolean notification_area_on_applet_expose (NotificationArea* self, GdkEventExpose* event);
static gboolean _notification_area_on_applet_expose_gtk_widget_expose_event (GtkWidget* _sender, GdkEventExpose* event, gpointer self);
static gboolean notification_area_button_press (NotificationArea* self, GdkEventButton* event);
static gboolean _notification_area_button_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean notification_area_on_painter_expose (NotificationArea* self, GdkEvent* event, GtkBin* eb);
NotificationArea* notification_area_new (AwnApplet* applet);
NotificationArea* notification_area_construct (GType object_type, AwnApplet* applet);
static void notification_area_tray_icon_expose (GtkWidget* widget, cairo_t* cr);
NotificationAreaPrefs* notification_area_prefs_new (AwnApplet* applet);
NotificationAreaPrefs* notification_area_prefs_construct (GType object_type, AwnApplet* applet);
GtkDialog* notification_area_prefs_get_dialog (NotificationAreaPrefs* self);
static gint notification_area_get_tray_icon_size (NotificationArea* self);
gboolean workaround_gpm_bug (void);
static gboolean _workaround_gpm_bug_gsource_func (gpointer self);
static gboolean notification_area_redraw_scheduler (NotificationArea* self);
static gboolean _notification_area_redraw_scheduler_gsource_func (gpointer self);
gboolean notification_area_on_visibility_change (NotificationArea* self, GdkEvent* event, GtkWidget* applet);
gint notification_area_get_icons_per_cell (NotificationArea* self);
void notification_area_set_icons_per_cell (NotificationArea* self, gint value);
gint notification_area_get_icon_size (NotificationArea* self);
void notification_area_set_icon_size (NotificationArea* self, gint value);
gint notification_area_get_extra_offset (NotificationArea* self);
void notification_area_set_extra_offset (NotificationArea* self, gint value);
DesktopAgnosticColor* notification_area_get_background_color (NotificationArea* self);
void notification_area_set_background_color (NotificationArea* self, DesktopAgnosticColor* value);
DesktopAgnosticColor* notification_area_get_border_color (NotificationArea* self);
void notification_area_set_border_color (NotificationArea* self, DesktopAgnosticColor* value);
static void notification_area_finalize (GObject* obj);
static void notification_area_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void notification_area_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
AwnApplet* awn_applet_factory_initp (const char* canonical_name, const char* uid, gint panel_id);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _notification_area_on_icon_added_egg_tray_manager_tray_icon_added (EggTrayManager* _sender, GtkWidget* object, gpointer self) {
	notification_area_on_icon_added (self, object);
}


static void _notification_area_on_icon_removed_egg_tray_manager_tray_icon_removed (EggTrayManager* _sender, GtkWidget* object, gpointer self) {
	notification_area_on_icon_removed (self, object);
}


static void _lambda9_ (GtkPositionType new_pos, NotificationArea* self) {
	notification_area_update_icon_sizes (self);
	notification_area_table_refresh (self);
}


static void __lambda9__awn_applet_position_changed (AwnApplet* _sender, GtkPositionType position, gpointer self) {
	_lambda9_ (position, self);
}


static void _lambda10_ (gint new_size, NotificationArea* self) {
	notification_area_update_icon_sizes (self);
}


static void __lambda10__awn_applet_size_changed (AwnApplet* _sender, gint size, gpointer self) {
	_lambda10_ (size, self);
}


static gboolean _notification_area_on_applet_expose_gtk_widget_expose_event (GtkWidget* _sender, GdkEventExpose* event, gpointer self) {
	return notification_area_on_applet_expose (self, event);
}


static gboolean _notification_area_button_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	return notification_area_button_press (self, event);
}


NotificationArea* notification_area_construct (GType object_type, AwnApplet* applet) {
	GError * _inner_error_;
	NotificationArea * self;
	AwnApplet* _tmp0_;
	EggTrayManager* _tmp1_;
	GList* _tmp2_;
	GdkScreen* screen;
	GtkEventBox* _tmp3_;
	AwnAlignment* _tmp4_;
	GtkAlignment* _tmp5_;
	GtkEventBox* _tmp6_;
	GtkTable* _tmp7_;
	DesktopAgnosticConfigClient* _tmp8_;
	DesktopAgnosticConfigClient* _tmp9_;
	g_return_val_if_fail (applet != NULL, NULL);
	_inner_error_ = NULL;
	self = (NotificationArea*) g_object_new (object_type, NULL);
	self->priv->applet = (_tmp0_ = _g_object_ref0 (applet), _g_object_unref0 (self->priv->applet), _tmp0_);
	self->priv->manager = (_tmp1_ = egg_tray_manager_new (), _g_object_unref0 (self->priv->manager), _tmp1_);
	self->priv->tray_icons = (_tmp2_ = NULL, _g_list_free0 (self->priv->tray_icons), _tmp2_);
	self->priv->max_rows = 2;
	self->priv->max_cols = 2;
	self->priv->redraw_timer = 0;
	self->priv->addition_quark = g_quark_from_string ("na-tray-icon-added");
	self->priv->deletion_quark = g_quark_from_string ("na-tray-icon-deleted");
	screen = gtk_window_get_screen ((GtkWindow*) applet);
	if (egg_tray_manager_manage_screen (self->priv->manager, screen) == FALSE) {
		g_error ("notification-area.vala:148: Unable to manage the screen!");
	}
	g_signal_connect_object (self->priv->manager, "tray-icon-added", (GCallback) _notification_area_on_icon_added_egg_tray_manager_tray_icon_added, self, 0);
	g_signal_connect_object (self->priv->manager, "tray-icon-removed", (GCallback) _notification_area_on_icon_removed_egg_tray_manager_tray_icon_removed, self, 0);
	g_signal_connect_object (self->priv->applet, "position-changed", (GCallback) __lambda9__awn_applet_position_changed, self, 0);
	g_signal_connect_object (self->priv->applet, "size-changed", (GCallback) __lambda10__awn_applet_size_changed, self, 0);
	self->priv->eb = (_tmp3_ = g_object_ref_sink ((GtkEventBox*) gtk_event_box_new ()), _g_object_unref0 (self->priv->eb), _tmp3_);
	awn_utils_ensure_transparent_bg ((GtkWidget*) self->priv->eb);
	self->priv->align = (_tmp4_ = g_object_ref_sink ((AwnAlignment*) awn_alignment_new_for_applet (applet)), _g_object_unref0 (self->priv->align), _tmp4_);
	awn_alignment_set_offset_modifier (self->priv->align, -NOTIFICATION_AREA_BORDER);
	self->priv->inner_align = (_tmp5_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.f, 0.f, 1.f, 1.f)), _g_object_unref0 (self->priv->inner_align), _tmp5_);
	gtk_alignment_set_padding (self->priv->inner_align, (guint) NOTIFICATION_AREA_BORDER, (guint) NOTIFICATION_AREA_BORDER, (guint) NOTIFICATION_AREA_BORDER, (guint) NOTIFICATION_AREA_BORDER);
	self->priv->icon_painter = (_tmp6_ = g_object_ref_sink ((GtkEventBox*) gtk_event_box_new ()), _g_object_unref0 (self->priv->icon_painter), _tmp6_);
	awn_utils_ensure_transparent_bg ((GtkWidget*) self->priv->icon_painter);
	self->priv->table = (_tmp7_ = g_object_ref_sink ((GtkTable*) gtk_table_new ((guint) 1, (guint) 1, FALSE)), _g_object_unref0 (self->priv->table), _tmp7_);
	gtk_table_set_row_spacings (self->priv->table, (guint) 1);
	gtk_table_set_col_spacings (self->priv->table, (guint) 1);
	gtk_container_add ((GtkContainer*) applet, (GtkWidget*) self->priv->eb);
	gtk_container_add ((GtkContainer*) self->priv->eb, (GtkWidget*) self->priv->align);
	gtk_container_add ((GtkContainer*) self->priv->align, (GtkWidget*) self->priv->inner_align);
	gtk_container_add ((GtkContainer*) self->priv->inner_align, (GtkWidget*) self->priv->icon_painter);
	if (gdk_screen_get_rgba_colormap (screen) != NULL) {
		gtk_widget_set_colormap ((GtkWidget*) self->priv->eb, gdk_screen_get_rgba_colormap (screen));
		gtk_widget_set_colormap ((GtkWidget*) self->priv->icon_painter, gdk_screen_get_rgba_colormap (screen));
	}
	gtk_container_add ((GtkContainer*) self->priv->icon_painter, (GtkWidget*) self->priv->table);
	g_signal_connect_object ((GtkWidget*) self->priv->eb, "expose-event", (GCallback) _notification_area_on_applet_expose_gtk_widget_expose_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self->priv->eb, "button-press-event", (GCallback) _notification_area_button_press_gtk_widget_button_press_event, self, 0);
	g_signal_connect_swapped (self->priv->icon_painter, "expose-event", (GCallback) notification_area_on_painter_expose, self);
	g_signal_connect_swapped (self->priv->icon_painter, "size-allocate", (GCallback) gtk_widget_queue_draw, self->priv->eb);
	_tmp8_ = awn_config_get_default_for_applet (applet, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->priv->client = (_tmp9_ = _g_object_ref0 (_tmp8_), _g_object_unref0 (self->priv->client), _tmp9_);
	desktop_agnostic_config_client_bind (self->priv->client, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT, "icons_per_cell", (GObject*) self, "icons-per-cell", TRUE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	desktop_agnostic_config_client_bind (self->priv->client, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT, "icon_size", (GObject*) self, "icon-size", TRUE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	desktop_agnostic_config_client_bind (self->priv->client, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT, "extra_offset", (GObject*) self, "extra-offset", TRUE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	desktop_agnostic_config_client_bind (self->priv->client, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT, "background_color", (GObject*) self, "background-color", TRUE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	desktop_agnostic_config_client_bind (self->priv->client, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT, "border_color", (GObject*) self, "border-color", TRUE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


NotificationArea* notification_area_new (AwnApplet* applet) {
	return notification_area_construct (TYPE_NOTIFICATION_AREA, applet);
}


static void notification_area_tray_icon_expose (GtkWidget* widget, cairo_t* cr) {
	EggTrayChild* child;
	g_return_if_fail (widget != NULL);
	g_return_if_fail (cr != NULL);
	child = EGG_TRAY_CHILD (widget);
	if (egg_tray_child_is_alpha_capable (child)) {
		GdkRectangle _tmp0_;
		double x1 = 0.0;
		double x2 = 0.0;
		double y1 = 0.0;
		double y2 = 0.0;
		gboolean _tmp1_ = FALSE;
		cairo_save (cr);
		gdk_cairo_rectangle (cr, (_tmp0_ = (GdkRectangle) widget->allocation, &_tmp0_));
		cairo_clip (cr);
		cairo_clip_extents (cr, &x1, &y1, &x2, &y2);
		if ((x2 - x1) <= 0.0) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = (y2 - y1) <= 0.0;
		}
		if (_tmp1_) {
			cairo_restore (cr);
			return;
		}
		gdk_error_trap_push ();
		if (child->fake_transparency != 0) {
			cairo_surface_t* img_srfc;
			img_srfc = egg_tray_child_get_image_surface (child);
			if (img_srfc != NULL) {
				cairo_set_operator (cr, CAIRO_OPERATOR_OVER);
				cairo_set_source_surface (cr, img_srfc, (double) ((GtkWidget*) child)->allocation.x, (double) ((GtkWidget*) child)->allocation.y);
				cairo_paint (cr);
				cairo_surface_flush (cairo_get_target (cr));
			}
			_cairo_surface_destroy0 (img_srfc);
		} else {
			gdk_cairo_set_source_pixmap (cr, (GdkPixmap*) widget->window, (double) widget->allocation.x, (double) widget->allocation.y);
			cairo_paint (cr);
		}
		cairo_restore (cr);
		gdk_flush ();
		if (gdk_error_trap_pop () != 0) {
		}
	}
}


static gboolean notification_area_on_painter_expose (NotificationArea* self, GdkEvent* event, GtkBin* eb) {
	gboolean result = FALSE;
	cairo_t* cr;
	GtkWidget* child;
	cairo_t* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	g_return_val_if_fail (eb != NULL, FALSE);
	cr = gdk_cairo_create ((GdkDrawable*) ((GtkWidget*) eb)->window);
	gdk_cairo_region (cr, event->expose.region);
	cairo_clip (cr);
	cairo_set_operator (cr, CAIRO_OPERATOR_CLEAR);
	cairo_paint (cr);
	cairo_set_operator (cr, CAIRO_OPERATOR_OVER);
	if (self->priv->_background_color != NULL) {
		awn_cairo_set_source_color (cr, self->priv->_background_color);
		cairo_paint (cr);
	} else {
		GdkColor _tmp0_;
		DesktopAgnosticColor* da_color;
		da_color = desktop_agnostic_color_new ((_tmp0_ = gtk_widget_get_style ((GtkWidget*) eb)->bg[GTK_STATE_ACTIVE], &_tmp0_), (gushort) 65535);
		if (gtk_widget_is_composited ((GtkWidget*) eb)) {
			desktop_agnostic_color_set_alpha (da_color, (guint) (65535 / 5));
		}
		awn_cairo_set_source_color (cr, da_color);
		cairo_paint (cr);
		_g_object_unref0 (da_color);
	}
	child = gtk_bin_get_child (eb);
	if (child != NULL) {
		GtkContainer* container;
		container = GTK_CONTAINER (child);
		{
			GList* w_collection;
			GList* w_it;
			w_collection = gtk_container_get_children (container);
			for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
				GtkWidget* w;
				w = (GtkWidget*) w_it->data;
				{
					notification_area_tray_icon_expose (w, cr);
				}
			}
			_g_list_free0 (w_collection);
		}
	}
	cr = (_tmp1_ = NULL, _cairo_destroy0 (cr), _tmp1_);
	if (child != NULL) {
		gtk_container_propagate_expose ((GtkContainer*) eb, child, &event->expose);
	}
	result = TRUE;
	_cairo_destroy0 (cr);
	return result;
}


static gboolean notification_area_on_applet_expose (NotificationArea* self, GdkEventExpose* event) {
	gboolean result = FALSE;
	cairo_t* cr;
	gint x;
	gint y;
	gint w;
	gint h;
	g_return_val_if_fail (self != NULL, FALSE);
	cr = gdk_cairo_create ((GdkDrawable*) ((GtkWidget*) self->priv->eb)->window);
	if (cr == NULL) {
		result = FALSE;
		_cairo_destroy0 (cr);
		return result;
	}
	x = ((GtkWidget*) self->priv->inner_align)->allocation.x;
	y = ((GtkWidget*) self->priv->inner_align)->allocation.y;
	w = ((GtkWidget*) self->priv->inner_align)->allocation.width;
	h = ((GtkWidget*) self->priv->inner_align)->allocation.height;
	gdk_cairo_region (cr, (*event).region);
	cairo_clip (cr);
	cairo_set_operator (cr, CAIRO_OPERATOR_OVER);
	if (self->priv->_background_color != NULL) {
		awn_cairo_set_source_color (cr, self->priv->_background_color);
	} else {
		GdkColor _tmp0_;
		DesktopAgnosticColor* da_color;
		da_color = desktop_agnostic_color_new ((_tmp0_ = gtk_widget_get_style ((GtkWidget*) self->priv->eb)->bg[GTK_STATE_ACTIVE], &_tmp0_), (gushort) 65535);
		if (gtk_widget_is_composited ((GtkWidget*) self->priv->applet)) {
			desktop_agnostic_color_set_alpha (da_color, (guint) (65535 / 5));
		}
		awn_cairo_set_source_color (cr, da_color);
		_g_object_unref0 (da_color);
	}
	cairo_set_line_width (cr, 1.0);
	awn_cairo_rounded_rect (cr, x + 0.5, y + 0.5, w - 1.0, h - 1.0, 2.0 * NOTIFICATION_AREA_BORDER, ROUND_ALL);
	if (self->priv->_border_color == NULL) {
		cairo_fill (cr);
	} else {
		cairo_fill_preserve (cr);
	}
	if (self->priv->_border_color != NULL) {
		awn_cairo_set_source_color (cr, self->priv->_border_color);
		cairo_set_operator (cr, CAIRO_OPERATOR_DEST_OUT);
		cairo_set_line_width (cr, 1.5);
		cairo_stroke_preserve (cr);
		cairo_set_operator (cr, CAIRO_OPERATOR_OVER);
		cairo_set_line_width (cr, 1.0);
		cairo_stroke (cr);
	}
	result = TRUE;
	_cairo_destroy0 (cr);
	return result;
}


static gboolean notification_area_button_press (NotificationArea* self, GdkEventButton* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((*event).button == 3) {
		if (notification_area_prefs_window == NULL) {
			NotificationAreaPrefs* _tmp0_;
			GtkDialog* dialog;
			NotificationAreaPrefs* _tmp1_;
			notification_area_prefs_window = (_tmp0_ = notification_area_prefs_new (self->priv->applet), _g_object_unref0 (notification_area_prefs_window), _tmp0_);
			dialog = notification_area_prefs_get_dialog (notification_area_prefs_window);
			gtk_dialog_run (dialog);
			gtk_object_destroy ((GtkObject*) dialog);
			notification_area_prefs_window = (_tmp1_ = NULL, _g_object_unref0 (notification_area_prefs_window), _tmp1_);
		} else {
			GtkDialog* dialog;
			dialog = _g_object_ref0 (notification_area_prefs_get_dialog (notification_area_prefs_window));
			gtk_window_present_with_time ((GtkWindow*) dialog, (*event).time);
			_g_object_unref0 (dialog);
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void notification_area_table_refresh (NotificationArea* self) {
	gboolean _tmp0_ = FALSE;
	gint row;
	gint col;
	GtkPositionType position;
	guint elements;
	guint num_rows = 0U;
	guint num_cols = 0U;
	guint rows;
	guint cols;
	gboolean _tmp3_ = FALSE;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	g_return_if_fail (self != NULL);
	if (self->priv->applet == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->table == NULL;
	}
	if (_tmp0_) {
		return;
	}
	row = 0;
	col = 0;
	position = awn_applet_get_pos_type (self->priv->applet);
	{
		GList* icon_collection;
		GList* icon_it;
		icon_collection = gtk_container_get_children ((GtkContainer*) self->priv->table);
		for (icon_it = icon_collection; icon_it != NULL; icon_it = icon_it->next) {
			GtkWidget* icon;
			icon = (GtkWidget*) icon_it->data;
			{
				void* del;
				del = g_object_get_qdata ((GObject*) icon, self->priv->deletion_quark);
				if (del != NULL) {
					gtk_container_remove ((GtkContainer*) self->priv->table, icon);
				} else {
					gboolean _tmp1_ = FALSE;
					gtk_container_child_set ((GtkContainer*) self->priv->table, icon, "left-attach", col, "right-attach", col + 1, "top-attach", row, "bottom-attach", row + 1, NULL);
					if (position == GTK_POS_TOP) {
						_tmp1_ = TRUE;
					} else {
						_tmp1_ = position == GTK_POS_BOTTOM;
					}
					if (_tmp1_) {
						row++;
						if (row == self->priv->max_rows) {
							row = 0;
							col++;
						}
					} else {
						col++;
						if (col == self->priv->max_cols) {
							col = 0;
							row++;
						}
					}
				}
			}
		}
		_g_list_free0 (icon_collection);
	}
	{
		GList* icon_collection;
		GList* icon_it;
		icon_collection = self->priv->tray_icons;
		for (icon_it = icon_collection; icon_it != NULL; icon_it = icon_it->next) {
			EggTrayChild* icon;
			icon = (EggTrayChild*) icon_it->data;
			{
				void* added;
				gboolean _tmp2_ = FALSE;
				added = g_object_get_qdata ((GObject*) icon, self->priv->addition_quark);
				if (added == NULL) {
					continue;
				}
				g_object_set_qdata_full ((GObject*) icon, self->priv->addition_quark, GINT_TO_POINTER (0), NULL);
				gtk_table_attach_defaults (self->priv->table, (GtkWidget*) icon, (guint) col, (guint) (col + 1), (guint) row, (guint) (row + 1));
				if (position == GTK_POS_TOP) {
					_tmp2_ = TRUE;
				} else {
					_tmp2_ = position == GTK_POS_BOTTOM;
				}
				if (_tmp2_) {
					row++;
					if (row == self->priv->max_rows) {
						row = 0;
						col++;
					}
				} else {
					col++;
					if (col == self->priv->max_cols) {
						col = 0;
						row++;
					}
				}
			}
		}
	}
	elements = g_list_length (self->priv->tray_icons);
	rows = (guint) self->priv->max_rows;
	cols = (guint) self->priv->max_cols;
	if (position == GTK_POS_TOP) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = position == GTK_POS_BOTTOM;
	}
	if (_tmp3_) {
		guint _tmp4_;
		guint _tmp5_ = 0U;
		num_cols = (g_object_get (self->priv->table, "n-columns", &_tmp4_, NULL), _tmp4_);
		if ((elements % self->priv->max_rows) == 0) {
			_tmp5_ = num_cols / self->priv->max_rows;
		} else {
			_tmp5_ = (num_cols / self->priv->max_rows) + 1;
		}
		cols = _tmp5_;
	} else {
		guint _tmp6_;
		guint _tmp7_ = 0U;
		num_rows = (g_object_get (self->priv->table, "n-rows", &_tmp6_, NULL), _tmp6_);
		if ((elements % self->priv->max_cols) == 0) {
			_tmp7_ = num_rows / self->priv->max_cols;
		} else {
			_tmp7_ = (num_rows / self->priv->max_cols) + 1;
		}
		rows = _tmp7_;
	}
	if (rows > 0) {
		_tmp8_ = rows;
	} else {
		_tmp8_ = (guint) 1;
	}
	if (cols > 0) {
		_tmp9_ = cols;
	} else {
		_tmp9_ = (guint) 1;
	}
	gtk_table_resize (self->priv->table, _tmp8_, _tmp9_);
	gtk_widget_queue_draw ((GtkWidget*) self->priv->table);
}


static gint notification_area_get_tray_icon_size (NotificationArea* self) {
	gint result = 0;
	gint size;
	gint icon_size;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	size = (gint) awn_applet_get_size (self->priv->applet);
	icon_size = (size - (self->priv->max_rows - 1)) / self->priv->max_rows;
	icon_size = (icon_size * self->priv->_icon_size) / 100;
	if (self->priv->max_rows == 2) {
		GtkPositionType position;
		gint extra_space;
		gboolean _tmp0_ = FALSE;
		if ((icon_size % 2) != 0) {
			icon_size--;
		}
		position = awn_applet_get_pos_type (self->priv->applet);
		extra_space = MAX (size - (icon_size * self->priv->max_rows), 1);
		if (position == GTK_POS_TOP) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = position == GTK_POS_BOTTOM;
		}
		if (_tmp0_) {
			gtk_table_set_row_spacings (self->priv->table, (guint) extra_space);
			gtk_table_set_col_spacings (self->priv->table, (guint) 1);
		} else {
			gtk_table_set_row_spacings (self->priv->table, (guint) 1);
			gtk_table_set_col_spacings (self->priv->table, (guint) extra_space);
		}
	} else {
		gtk_table_set_row_spacings (self->priv->table, (guint) 1);
		gtk_table_set_col_spacings (self->priv->table, (guint) 1);
	}
	if (icon_size < 1) {
		_tmp1_ = 1;
	} else {
		_tmp1_ = icon_size;
	}
	result = _tmp1_;
	return result;
}


static void notification_area_update_icon_sizes (NotificationArea* self) {
	gint icon_size;
	g_return_if_fail (self != NULL);
	icon_size = notification_area_get_tray_icon_size (self);
	{
		GList* icon_collection;
		GList* icon_it;
		icon_collection = self->priv->tray_icons;
		for (icon_it = icon_collection; icon_it != NULL; icon_it = icon_it->next) {
			EggTrayChild* icon;
			icon = (EggTrayChild*) icon_it->data;
			{
				gtk_widget_set_size_request ((GtkWidget*) icon, icon_size, icon_size);
			}
		}
	}
}


static gboolean _workaround_gpm_bug_gsource_func (gpointer self) {
	return workaround_gpm_bug ();
}


static void notification_area_on_icon_added (NotificationArea* self, GtkWidget* widget) {
	EggTrayChild* icon;
	gboolean _tmp0_ = FALSE;
	gint icon_size;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	icon = EGG_TRAY_CHILD (widget);
	if (!gpm_workaround_done) {
		char* _tmp1_;
		_tmp0_ = _vala_strcmp0 (_tmp1_ = egg_tray_child_get_title (icon), "gnome-power-manager") == 0;
		_g_free0 (_tmp1_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 2000, _workaround_gpm_bug_gsource_func, NULL, NULL);
		gpm_workaround_done = TRUE;
	}
	g_object_set_qdata_full ((GObject*) icon, self->priv->addition_quark, GINT_TO_POINTER (1), NULL);
	g_object_set_qdata_full ((GObject*) icon, self->priv->deletion_quark, GINT_TO_POINTER (0), NULL);
	self->priv->tray_icons = g_list_append (self->priv->tray_icons, icon);
	icon_size = notification_area_get_tray_icon_size (self);
	gtk_widget_set_size_request ((GtkWidget*) icon, icon_size, icon_size);
	notification_area_table_refresh (self);
}


static void notification_area_on_icon_removed (NotificationArea* self, GtkWidget* widget) {
	EggTrayChild* icon;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	icon = EGG_TRAY_CHILD (widget);
	g_object_set_qdata_full ((GObject*) icon, self->priv->deletion_quark, GINT_TO_POINTER (1), NULL);
	self->priv->tray_icons = g_list_remove (self->priv->tray_icons, icon);
	notification_area_table_refresh (self);
}


static gboolean _notification_area_redraw_scheduler_gsource_func (gpointer self) {
	return notification_area_redraw_scheduler (self);
}


static gboolean notification_area_redraw_scheduler (NotificationArea* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_widget_queue_draw ((GtkWidget*) self->priv->eb);
	switch (self->priv->redraw_timer) {
		case 50:
		{
			self->priv->redraw_timer = 150;
			break;
		}
		case 150:
		{
			self->priv->redraw_timer = 350;
			break;
		}
		case 350:
		{
			self->priv->redraw_timer = 850;
			break;
		}
		default:
		{
			self->priv->redraw_timer = 0;
			break;
		}
	}
	if (self->priv->redraw_timer != 0) {
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) self->priv->redraw_timer, _notification_area_redraw_scheduler_gsource_func, g_object_ref (self), g_object_unref);
	}
	result = FALSE;
	return result;
}


gboolean notification_area_on_visibility_change (NotificationArea* self, GdkEvent* event, GtkWidget* applet) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	g_return_val_if_fail (applet != NULL, FALSE);
	if (event->visibility.state == GDK_VISIBILITY_UNOBSCURED) {
		gboolean _tmp0_ = FALSE;
		if (gtk_widget_is_composited (applet)) {
			_tmp0_ = self->priv->redraw_timer == 0;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			self->priv->redraw_timer = 50;
			g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) self->priv->redraw_timer, _notification_area_redraw_scheduler_gsource_func, g_object_ref (self), g_object_unref);
		}
	}
	result = FALSE;
	return result;
}


gint notification_area_get_icons_per_cell (NotificationArea* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->max_rows;
	return result;
}


void notification_area_set_icons_per_cell (NotificationArea* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->max_rows = value;
	self->priv->max_cols = value;
	notification_area_update_icon_sizes (self);
	notification_area_table_refresh (self);
	g_object_notify ((GObject *) self, "icons-per-cell");
}


gint notification_area_get_icon_size (NotificationArea* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_icon_size;
	return result;
}


void notification_area_set_icon_size (NotificationArea* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_icon_size = value;
	notification_area_update_icon_sizes (self);
	g_object_notify ((GObject *) self, "icon-size");
}


gint notification_area_get_extra_offset (NotificationArea* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_extra_offset;
	return result;
}


void notification_area_set_extra_offset (NotificationArea* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_extra_offset = value;
	awn_alignment_set_offset_modifier (self->priv->align, self->priv->_extra_offset - NOTIFICATION_AREA_BORDER);
	g_object_notify ((GObject *) self, "extra-offset");
}


DesktopAgnosticColor* notification_area_get_background_color (NotificationArea* self) {
	DesktopAgnosticColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_background_color;
	return result;
}


void notification_area_set_background_color (NotificationArea* self, DesktopAgnosticColor* value) {
	DesktopAgnosticColor* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_background_color = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_background_color), _tmp0_);
	gtk_widget_queue_draw ((GtkWidget*) self->priv->eb);
	gtk_widget_queue_draw ((GtkWidget*) self->priv->icon_painter);
	g_object_notify ((GObject *) self, "background-color");
}


DesktopAgnosticColor* notification_area_get_border_color (NotificationArea* self) {
	DesktopAgnosticColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_border_color;
	return result;
}


void notification_area_set_border_color (NotificationArea* self, DesktopAgnosticColor* value) {
	DesktopAgnosticColor* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_border_color = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_border_color), _tmp0_);
	gtk_widget_queue_draw ((GtkWidget*) self->priv->eb);
	g_object_notify ((GObject *) self, "border-color");
}


static void notification_area_class_init (NotificationAreaClass * klass) {
	notification_area_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NotificationAreaPrivate));
	G_OBJECT_CLASS (klass)->get_property = notification_area_get_property;
	G_OBJECT_CLASS (klass)->set_property = notification_area_set_property;
	G_OBJECT_CLASS (klass)->finalize = notification_area_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATION_AREA_ICONS_PER_CELL, g_param_spec_int ("icons-per-cell", "icons-per-cell", "icons-per-cell", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATION_AREA_ICON_SIZE, g_param_spec_int ("icon-size", "icon-size", "icon-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATION_AREA_EXTRA_OFFSET, g_param_spec_int ("extra-offset", "extra-offset", "extra-offset", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATION_AREA_BACKGROUND_COLOR, g_param_spec_object ("background-color", "Background color", "Background color", DESKTOP_AGNOSTIC_TYPE_COLOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATION_AREA_BORDER_COLOR, g_param_spec_object ("border-color", "Border color", "Border color", DESKTOP_AGNOSTIC_TYPE_COLOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void notification_area_instance_init (NotificationArea * self) {
	self->priv = NOTIFICATION_AREA_GET_PRIVATE (self);
}


static void notification_area_finalize (GObject* obj) {
	NotificationArea * self;
	self = NOTIFICATION_AREA (obj);
	_g_object_unref0 (self->priv->manager);
	_g_object_unref0 (self->priv->applet);
	_g_list_free0 (self->priv->tray_icons);
	_g_object_unref0 (self->priv->eb);
	_g_object_unref0 (self->priv->align);
	_g_object_unref0 (self->priv->inner_align);
	_g_object_unref0 (self->priv->icon_painter);
	_g_object_unref0 (self->priv->table);
	_g_object_unref0 (self->priv->client);
	_g_object_unref0 (self->priv->_background_color);
	_g_object_unref0 (self->priv->_border_color);
	G_OBJECT_CLASS (notification_area_parent_class)->finalize (obj);
}


GType notification_area_get_type (void) {
	static volatile gsize notification_area_type_id__volatile = 0;
	if (g_once_init_enter (&notification_area_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotificationAreaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notification_area_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotificationArea), 0, (GInstanceInitFunc) notification_area_instance_init, NULL };
		GType notification_area_type_id;
		notification_area_type_id = g_type_register_static (G_TYPE_OBJECT, "NotificationArea", &g_define_type_info, 0);
		g_once_init_leave (&notification_area_type_id__volatile, notification_area_type_id);
	}
	return notification_area_type_id__volatile;
}


static void notification_area_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NotificationArea * self;
	self = NOTIFICATION_AREA (object);
	switch (property_id) {
		case NOTIFICATION_AREA_ICONS_PER_CELL:
		g_value_set_int (value, notification_area_get_icons_per_cell (self));
		break;
		case NOTIFICATION_AREA_ICON_SIZE:
		g_value_set_int (value, notification_area_get_icon_size (self));
		break;
		case NOTIFICATION_AREA_EXTRA_OFFSET:
		g_value_set_int (value, notification_area_get_extra_offset (self));
		break;
		case NOTIFICATION_AREA_BACKGROUND_COLOR:
		g_value_set_object (value, notification_area_get_background_color (self));
		break;
		case NOTIFICATION_AREA_BORDER_COLOR:
		g_value_set_object (value, notification_area_get_border_color (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void notification_area_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NotificationArea * self;
	self = NOTIFICATION_AREA (object);
	switch (property_id) {
		case NOTIFICATION_AREA_ICONS_PER_CELL:
		notification_area_set_icons_per_cell (self, g_value_get_int (value));
		break;
		case NOTIFICATION_AREA_ICON_SIZE:
		notification_area_set_icon_size (self, g_value_get_int (value));
		break;
		case NOTIFICATION_AREA_EXTRA_OFFSET:
		notification_area_set_extra_offset (self, g_value_get_int (value));
		break;
		case NOTIFICATION_AREA_BACKGROUND_COLOR:
		notification_area_set_background_color (self, g_value_get_object (value));
		break;
		case NOTIFICATION_AREA_BORDER_COLOR:
		notification_area_set_border_color (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


gboolean workaround_gpm_bug (void) {
	gboolean result = FALSE;
	GError * _inner_error_;
	char* command;
	_inner_error_ = NULL;
	command = g_strdup ("python -c \"" "import gconf;" "c = gconf.Client();" "key = '/apps/gnome-power-manager/ui/icon_policy';" "pol = c.get_string(key);" "c.set_string(key, 'always');" "c.set_string(key, pol);" "\"");
	g_spawn_command_line_async (command, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (command);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	_g_free0 (command);
	return result;
}


AwnApplet* awn_applet_factory_initp (const char* canonical_name, const char* uid, gint panel_id) {
	AwnApplet* result = NULL;
	AwnApplet* applet;
	NotificationArea* na;
	g_return_val_if_fail (canonical_name != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	if (egg_tray_manager_check_running (gdk_screen_get_default ())) {
		char* msg;
		GtkMessageDialog* d;
		msg = g_strdup ("There is already another notification area running" " on this screen!");
		d = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", msg));
		gtk_message_dialog_format_secondary_text (d, "Please remove the existing notification area" " and then restart the applet.", NULL);
		gtk_dialog_run ((GtkDialog*) d);
		g_error ("notification-area.vala:644: %s", msg);
		result = NULL;
		_g_free0 (msg);
		_g_object_unref0 (d);
		return result;
	}
	applet = g_object_ref_sink (awn_applet_new (canonical_name, uid, panel_id));
	na = notification_area_new (applet);
	g_object_set_data_full ((GObject*) applet, "notification-area", _g_object_ref0 (g_object_ref ((GObject*) na)), g_object_unref);
	gtk_widget_add_events ((GtkWidget*) applet, (gint) GDK_VISIBILITY_NOTIFY_MASK);
	g_signal_connect_swapped (applet, "visibility-notify-event", (GCallback) notification_area_on_visibility_change, na);
	result = applet;
	_g_object_unref0 (na);
	return result;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




