# Arch Perl library, Copyright (C) 2005 Mikhael Goikhman
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.005;
use strict;

package AXP::Command::magic::wget;
use base 'AXP::Command::magic';

use Arch::LiteWeb;
use Arch::Util qw(save_file);

sub optusage {
	"[options] url"
}

sub infoline {
	"fetch url using Arch::LiteWeb class"
}

sub options {
	(
		output => { sh => 'o', type => "=s", arg => 'FILE', desc => "write to FILE rather than stdout" },
		timeout => { sh => 't', type => "=s", desc => "network timeout (20)" },
		use_proxy => { sh => 'p', desc => 'use proxy defined in env $http_proxy' },
		max_redirect_depth => { sh => 'r', type => "=s", arg => 'NUM', desc => "number of redirections allowed (5)" },
		user_agent => { sh => 'u', type => "=s", desc => "User-Agent string (Arch::LiteWeb/0.1)" },
		nocache => { sh => 'C', desc => 'set "Pragma: no-cache" header' },
		noredirect => { sh => 'R', desc => "do not follow redirection 301/302 pages" },
	)
}

sub helptext {
	q{
		Try to fetch url using HTTP GET.  See 'axp man Arch::LiteWeb'
		for more information.

		The command name is inspired by the popular unix utility
		with similar functionality.
	}
}

sub execute {
	my $self = shift;
	my %opt = %{$self->{options}};

	my $url = shift @ARGV || die "Please specify url to fetch\n";
	my $web = Arch::LiteWeb->new;
	my $content = $web->get($url, %opt);
	die $web->error_with_url unless $content;

	my $file = $opt{output} || "-";
	save_file($file, $content);
}

1;
