/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.server;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nz.net.catalyst.Log;
import nz.net.catalyst.StringPair;
import nz.net.catalyst.lucene.server.Application;
import nz.net.catalyst.lucene.server.Constants;
import nz.net.catalyst.lucene.server.ECommand;
import nz.net.catalyst.lucene.server.IPackage;
import nz.net.catalyst.lucene.server.Transmission;

public class ApplicationMessage
implements IPackage,
Constants {
    private final Transmission input;
    private static final Map VALID = new HashMap();

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Yes".toUpperCase(), "Yes");
        map.put("No".toUpperCase(), "No");
        VALID.put("Field-Indexed".toUpperCase(), map);
        VALID.put("Field-Stored".toUpperCase(), map);
        map = new HashMap();
        map.put("Id".toUpperCase(), "Id");
        map.put("Date".toUpperCase(), "Date");
        map.put("Text".toUpperCase(), "Text");
        VALID.put("Field-Type".toUpperCase(), map);
    }

    ApplicationMessage(Transmission transmission) {
        this.input = transmission;
    }

    private Transmission error(String message) {
        Transmission response = new Transmission(ECommand.CONTROL_RESPONSE);
        response.setSerial(this.input.getSerial());
        response.add("Error", message);
        return response;
    }

    Transmission execute() {
        List headers = this.input.getHeadersView();
        String appName = this.input.get("Application", Constants.NO_APP);
        if (appName == null) {
            return this.error("\"Application\" header required for \"APPLICATION\" sub-command");
        }
        if ((appName = appName.trim()).length() == 0) {
            return this.error("\"Application\" header must not have blank value in \"APPLICATION\" sub-command");
        }
        Application app = Application.get(appName);
        if (app == null) {
            app = new Application(appName);
        }
        Field field = null;
        Log.debug("Processing Application " + appName);
        Iterator it = headers.iterator();
        while (it.hasNext()) {
            StringPair header = (StringPair)it.next();
            String key = header.getKeyString();
            String value = header.getValueString();
            if (key.equalsIgnoreCase("Application") || key.equalsIgnoreCase("Sub-Command") || key.equalsIgnoreCase("Content-Length") || key.equalsIgnoreCase("Body") || key.equalsIgnoreCase("Id")) continue;
            if (key.equalsIgnoreCase("Field-Name")) {
                if (value.length() == 0) {
                    field = null;
                    app.remove("Field-Definitions");
                    continue;
                }
                if (field != null) {
                    app.appendProperty("Field-Definitions", field.toString(), ", ");
                    Log.debug("Field-Definitions: " + app.getProperty("Field-Definitions"));
                }
                field = new Field(value);
                continue;
            }
            if (key.equalsIgnoreCase("Field-Type") || key.equalsIgnoreCase("Field-Indexed") || key.equalsIgnoreCase("Field-Stored")) {
                String goodValue;
                Map map = (Map)VALID.get(key.toUpperCase());
                if (field == null || map == null || (goodValue = (String)map.get(value.toUpperCase())) == null) continue;
                if (key.equalsIgnoreCase("Field-Type")) {
                    field.type = goodValue;
                    continue;
                }
                if (key.equalsIgnoreCase("Field-Indexed")) {
                    field.indexed = goodValue;
                    continue;
                }
                if (!key.equalsIgnoreCase("Field-Stored")) continue;
                field.stored = goodValue;
                continue;
            }
            if (value.length() == 0) {
                app.remove(key);
                continue;
            }
            app.appendProperty(key, value);
            Log.debug(String.valueOf(key) + ": " + app.getProperty(key.toLowerCase()));
        }
        if (field != null) {
            app.appendProperty("Field-Definitions", field.toString(), ", ");
            Log.debug("Field-Definitions: " + app.getProperty("Field-Definitions"));
        }
        app.store();
        Transmission response = new Transmission(ECommand.CONTROL_RESPONSE);
        response.setSerial(this.input.getSerial());
        return response;
    }

    private static class Field {
        final String name;
        String type = "Text";
        String indexed = "Yes";
        String stored = "No";

        Field(String name) {
            this.name = name;
        }

        public String toString() {
            return String.valueOf(this.name) + ' ' + this.type + ' ' + this.indexed + ' ' + this.stored;
        }
    }
}

