/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_BIBLE_H
#define INCLUDED_BIBLE_H


#include "libraries.h"


void sort_references (vector <ustring> &references);
void decode_reference (const ustring & reference, ustring & book,
                       ustring & chapter, ustring & verse);
bool reference_discover (const ustring& oldbook, const ustring& oldchapter, 
                         const ustring& oldverse, const ustring& reference,
                         ustring& newbook, ustring& newchapter, ustring& newverse);
ustring book_find_valid (const ustring & rawbook);
unsigned int reference_to_numerical_equivalent (const ustring& book, const ustring& chapter, const ustring& verse);
ustring book_chapter_verse_to_reference (const ustring& book, int chapter, const ustring& verse);
ustring book_selection_information (const ustring& project);
bool looks_like_verse (const ustring& text);
vector<int> verses_encode (const ustring& verse);
bool chapter_span_discover (const ustring& reference, ustring& chapter1, ustring& verse1, ustring& chapter2, ustring& verse2);


#endif
