/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "utilities.h"
#include "usfm.h"
#include "chapter2.h"
#include "bible.h"
#include "usfmtools.h"
#include "directories.h"
#include "gwrappers.h"
#include "shell.h"


Chapter2::Chapter2 (vector <ustring>& input)
/*
It reads the raw lines of a chapter, and outputs each proper line of that, 
with verse information aligned to each line.
*/
{
  ustring inputfile = gw_build_filename (directories_get_temp(), "chapter2.input");
  ustring outputfile  = gw_build_filename (directories_get_temp(), "chapter2.output");
  write_lines (inputfile, input);
  ustring command = "sc-input-usfm" + shell_quote_space (inputfile) + ">" + shell_quote_space (outputfile);
  system (command.c_str());
  // Error and parse variables.
  GError *gerror = NULL;
  GMarkupParseContext *context = NULL;
  try {
    // Read the xml file.
    gchar *contents;
    gsize  length;
    if (!g_file_get_contents (outputfile.c_str(), &contents, &length, &gerror)) {
      throw runtime_error (gerror->message);
    }
    // If length is (about) zero, don't parse it, because it does not have data,
    // and parsing an empty file gives a segmentation error.
    if (length < 10)
      throw runtime_error ("File too short");  
    // Set up parser.
    GMarkupParser parser = {
      start_element_handler,
      NULL,
      text_handler,
      NULL,
      error_handler
    };
    // Parse xml file.
    context = g_markup_parse_context_new (&parser, GMarkupParseFlags (0), gpointer (this), NULL);
    if (!g_markup_parse_context_parse (context, contents, length, NULL)) {
      throw runtime_error (gerror->message);
    }
    if (!g_markup_parse_context_end_parse (context, NULL)) {
      throw runtime_error (gerror->message);
    }
    g_markup_parse_context_free (context);
  }
  catch (exception & ex) {
    gw_critical (ex.what ());
    if (gerror)
      g_error_free (gerror);
    if (context)
      g_markup_parse_context_free (context);
  }
  // Clean temporary files away.
  unlink (inputfile.c_str());
  unlink (outputfile.c_str());
}


Chapter2::~Chapter2 ()
{
}


void Chapter2::start_element_handler (GMarkupParseContext *context,
                                   const gchar         *element_name,
                                   const gchar        **attribute_names,
                                   const gchar        **attribute_values,
                                   gpointer             user_data,
                                   GError             **error)
{
  ((Chapter2 *) user_data)->start_element_handler (element_name, attribute_values);
}


void Chapter2::text_handler (GMarkupParseContext *context,
                          const gchar         *text,
                          gsize                text_len,
                          gpointer             user_data,
                          GError             **error)
{
  ((Chapter2 *) user_data)->text_handler (text);
}


void Chapter2::error_handler (GMarkupParseContext *context,
                              GError              *error,
                              gpointer             user_data)
{
  gw_critical (error->message);
}


void Chapter2::start_element_handler (const gchar  *element_name,
                                      const gchar **attribute_values)
{
  ustring currentelement = element_name;
  if (currentelement == "verse") {
    verse = attribute_values[0];
  }
}


void Chapter2::text_handler (const gchar *text)
{
  ustring utext (text);
  utext = trim (utext);
  if (!utext.empty()) {
    versenumbers.push_back (verse);
    versetext.push_back (utext);
  }
}
