#include <iostream>
#include <type_traits>
using namespace std;

//struct Out
//{
//    ostream &d_out;
//    Out(ostream &out)
//    :
//        d_out(out)
//    {
//        cout << "constructor\n";
//    }
//
//    Out(Out const &other)
//    :
//        d_out(other.d_out)
//    {
//        cout << "copy constructor\n";
//    }
//};
//
//template <typename Type>
//Out &operator<<(Out &out, Type &rhs)
//{
//    out.d_out << rhs;
//    return out;
//}

template <typename First, typename ...Pack>
First fun(First first, Pack ...args)
{
    return (first + ... + args);
}

template <typename ...Pack>
void gun(Pack ...args)
{
    double x =  (0 + ... + args);
    cout << x << '\n';
}

void fun2()
{
    cout << "hello\n";
}


template <typename ...Pack>
void unary(Pack &&...args)
{
    cout << (... + (2 *args)) << '\n';
};


struct Functor
{
    Functor()
    {
        cout << "Functor default\n";
    }
    Functor(Functor const &other)
    {
        cout << "Functor CC\n";
    }
    void operator()()
    {
        cout << "Functor() called\n";
    }
};

template <typename ...Pack>
void out(Pack &&...args)
{
//    return (cout << ... << args);
    (... , args());
};

//template <typename ...Pack>
//void out2(Out &out, Pack &&...args)
//{
//    (out << ... << args);
//};

template <typename ...Pack>
ostream &out2(ostream &out, Pack &&...args)
{
    return (out << ... << args);
};

template <typename Type>
concept bool Float = is_floating_point<Type>::value;

template <Float ...Pack>
void unary2(Pack &&...args)
{
    cout << (... + args) << '\n';
};


int main()
{
    unary(1,2,3);
    unary2(double{}, float{});

    cout << fun(1, 1.2) << '\n';
    gun(1, 1.2);

//    fun(Demo{1}, Demo{2}, Demo{3});

//    Out xout(cout);

//    out2(xout, "hello", ' ', 2, ' ', "worlds", '\n');
      out2(cout, "hello", ' ', 2, ' ', "worlds", '\n') << "...done\n";

    out(fun2);

    Functor f1;
    out(f1, fun2, f1,
        []()
        {
            cout << "lambda\n";
        }
    );
}
