template <typename T1, typename T2>
concept bool Concept = true;


// // OK: auto is invented to be an int
// template <typename T1, int N>
// struct Array{};
//
//
// template <int N> void function(Array<auto, N>);
//
// int main()
// {
//     Array<int, 4> arr;
//
//     function(arr);
// }

// // OK: Same: in this case typename is explicitly mentioned in the
// //      template header, instead of implicitly using auto
// template <typename T1, int N>
// struct Array{};
//
//
// template <int N, typename T> void function(Array<T, N>);
//
// int main()
// {
//     Array<int, 4> arr;
//
//     function(arr);
// }


#include <type_traits>

using namespace std;

template <typename T, typename U>
concept bool C3()
{
    return is_integral<T>::value && is_floating_point<U>::value;
}

template < C3<double> C3I>      // types specified here are the trailing
struct Vec {};                  // types, not the initial types.

template <C3<double> C3I>
void g5( Vec< C3I > );

int main()
{
    Vec<int> vid;           // types specified here PRECEDE the
                            // predefined Types in the declaration
    g5(vid);
}
