#include <vector>
#include <list>

    // defining a concept using a variable template:
template <typename Iter>
concept bool InputIterator =
        requires(Iter type)             // two conjoint requires expressions,
        {                               // each defining its own Iter params
            {++type} -> Iter &;         // This cannot be defined by one
            {type++} -> Iter;           // specifying two nested requires
            *type;                      // expressions, or comparable
            type.operator->();
        }
        &&
        requires(Iter lhs, Iter rhs)
        {
            {lhs == rhs} -> bool;
            {lhs != rhs} -> bool;
        };

template <typename Iter>
concept bool RandomAccessIterator()
{
    return requires(Iter type, int step)
    {
        requires (InputIterator<Iter>); // the variable concept is evaluated
                                        // a nested requires-expression, using
                                        // a parenthesized (nested) expression
        {type + step} -> Iter;
        {type += step} -> Iter &;
    };
}

template <RandomAccessIterator RAI>
void fun(RAI iter)
{};

template <InputIterator Iter>
void inputFun(Iter iter)
{};


struct MyIter
{
    int operator*() const;
    int const *operator->() const;
    MyIter &operator++();
    MyIter operator++(int);
    MyIter &operator+=(int step);
};

MyIter operator+(MyIter lhs, int rhs);
bool operator==(MyIter lhs, MyIter rhs);
bool operator!=(MyIter lhs, MyIter rhs);

using namespace std;

int main()
{
    MyIter myIter;
    inputFun(myIter);

    fun(myIter);

    vector<int> vi;
    fun(vi.begin());

    list<int> li;
//    fun(li.begin());      // constraint not satisfied.
}

// De specificatie met InputIterator<Type> is fout: Type is niet 't data type,
// maar het iteratortype. Wat dat is is irrelevant: als maar aan de eisen
// wordt voldaan die bij InputIterator voor 'Type' zijn gespecificeerd.

// template <typename Type, typename Iter>
//     requires InputIterator<Iter>()           //waarom moet Type hier
// Iter find(Iter begin,      // worden gespecificeerd
//                     Iter end,
//                    Type const &init)
// {
//     return std::find(begin, end, init);
// }

//template <typename Type, InputIterator Iter>    // en hier niet?
//Iter xfind(Iter begin, Iter end,
//                   Type const &init)
//{
//    return std::find(begin, end, init);
//}
//
//int main()
//{
//    std::vector<int> vi;
//    xfind(vi.begin(), vi.end(), 0);
//}
//
