/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef MANAGER_MANAGERFACTORY_H
#define MANAGER_MANAGERFACTORY_H

#include "MMLAPI.h"
#include "manager/MonitoringManager.h"
#include "manager/InteractiveMonitoringManager.h"
#include "manager/NonInteractiveMonitoringManager.h"
/**
 * @ingroup group_cepmodeling_libraries_mml
 * 
 * @brief
 * A factory to create MonitoringManager
 *  
 **/
class MML_API MonitoringManagerFactory {
  public:
    /// destructor
    ~MonitoringManagerFactory();
    
    /**
     * create an interactive or noninteractive manager according to simulator type
     */
    static MonitoringManager* createManager(const char* mml);
  
  private:
    /// constructor
    MonitoringManagerFactory();
    
};

#endif // MANAGER_MANAGERFACTORY_H
