/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2012 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

// Include .h file
#include "ActionClassificationWidget.h"

// Local files
#include "ActionTagWidget.h"
#include "DefaultGUIText.h"
// Qt files
#include <QMessageBox>

/**  Constructor */
ActionClassificationWidget::ActionClassificationWidget(QWidget * parent) : QWidget(parent)
{
    ui.setupUi(this);
    setToDefault();
}
/**  Destructor */
ActionClassificationWidget::~ActionClassificationWidget() {}

void ActionClassificationWidget::setToDefault()
{
    ui.actionFamilyItself->setText(defaultFamily);
    ui.actionFamilyStar->setStyleSheet(normalStyle);
    ui.requiredLabel->setStyleSheet(normalStyle);

    // Empty Tags
    foreach (ActionTagWidget * tag, list)
    {
        ui.actionTagsLayout->removeWidget(tag);
        if (tag != NULL)
        {
            delete tag;
        }
    }
    list.clear();
}

void ActionClassificationWidget::nextButtonClicked()
{
    QString family = ui.actionFamilyItself->text();
    if (family.toUtf8() != family.toAscii())
    {
        ui.actionFamilyStar->setStyleSheet(enhancedStyle);
        ui.requiredLabel->setStyleSheet(enhancedStyle);
        QMessageBox::warning(this, defaultBeforeGoingFurther, defaultAscii);
    }
    else if (isOneNonAsciiTag())
    {
        ui.actionFamilyStar->setStyleSheet(normalStyle);
        ui.requiredLabel->setStyleSheet(enhancedStyle);
        QMessageBox::warning(this, defaultBeforeGoingFurther, defaultAscii);
    }
    else if ((family.isEmpty()) || (family == defaultFamily))
    {
        ui.actionFamilyStar->setStyleSheet(enhancedStyle);
        ui.requiredLabel->setStyleSheet(enhancedStyle);
        QMessageBox::warning(this, defaultBeforeGoingFurther, defaultRealFamily);
    }
    else
    {
        ui.actionFamilyStar->setStyleSheet(normalStyle);
        ui.requiredLabel->setStyleSheet(normalStyle);
        emit next();
    }
}

void ActionClassificationWidget::previousButtonClicked()
{
    emit previous();
}


void ActionClassificationWidget::cancelButtonClicked()
{
    emit cancel();
}

bool ActionClassificationWidget::isOneNonAsciiTag()
{
    bool oneNonAscii = false;
    QList<ActionTagWidget *>::const_iterator it  = list.begin();
    
    while ((it != list.end()) && (! oneNonAscii))
    {
        QString tag = (*it)->getTag();
        if (tag.toUtf8() != tag.toAscii())
        {
            oneNonAscii = true;
        }
        it++;
    }
    return oneNonAscii;
}

void ActionClassificationWidget::addTagClicked()
{
    // QMessageBox::warning(NULL, "Add a Tag", "Add a Tag");
    ActionTagWidget * tag = new ActionTagWidget(this);
    ui.actionTagsLayout->addWidget(tag);
    list.append(tag);
}

QString ActionClassificationWidget::getFamily()
{
    return ui.actionFamilyItself->text();
}

void ActionClassificationWidget::removeTag(ActionTagWidget * widget)
{
    ui.actionTagsLayout->removeWidget(widget);
    list.removeAt(list.indexOf(widget));
    if (widget != NULL) {
        delete widget;
    }
}

QList<ActionTagWidget *> ActionClassificationWidget::getTagWidgets() {
    return list;
}
