/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "StlExtension.h"

// include generated components headers
#include "StlComponent.h"
#include <vtkSTLWriter.h>

using namespace camitk;

// --------------- Extension Declaration -------------------
Q_EXPORT_PLUGIN2(componentextensionexample, StlExtension);

// --------------- getName -------------------
QString StlExtension::getName() const {
  return "STL Component";
}

// --------------- getDescription -------------------
QString StlExtension::getDescription() const {
  return "Manage STL format, see <a href=\"https://en.wikipedia.org/wiki/STL_%28file_format%29\">https://en.wikipedia.org/wiki/STL_%28file_format%29</a>";
}


// --------------- GetFileExtensions -------------------
QStringList StlExtension::getFileExtensions() const {
    QStringList ext;
    ext << "stl" << "STL";

    return ext;
}

// --------------- Open -------------------
Component * StlExtension::open(const QString & fileName) throw (AbortException) {
    return new StlComponent(fileName);
}

// --------------- Save --------------------
bool StlExtension::save(Component * component) const {
    // depending on the components managed by StlExtension, use
    // component->getPointSet() (for a MeshComponent derived class)
    // or component->getImageData() (for a ImageComponent derived class)
    // and save the data in the managed format in the file component->getFileName()
    bool saveOk = true;
    component->refresh();
    component->getFileName();

    vtkSmartPointer<vtkSTLWriter> exporter = vtkSmartPointer<vtkSTLWriter>::New();
    exporter->SetFileName(component->getFileName().toUtf8().constData());
    exporter->SetInputConnection(component->getDataPort());
    saveOk=exporter->Write();

    return saveOk;
}

