(* $Id: client.ml 182 2004-05-25 16:49:11Z gerd $
 * ----------------------------------------------------------------------
 *
 *)


let uri = "http://localhost/~gerd/cgifwd.cgi";;  (* Customize this! *)

let response gw res =
  let n' = res() in
  print_endline("Result: " ^ string_of_int n');
  flush stdout;
  Rpc_over_http_client.close gw
;;


let main() =
  let n = int_of_string(Sys.argv.(1)) in

  (* Prepare RPC infrastructure: *)
  let esys = Unixqueue.create_unix_event_system () in
  let gw = Rpc_over_http_client.create esys uri in
  (Rpc_over_http_client.http_pipeline gw) # set_proxy_from_environment();
  (* gw: This is the internal HTTP gateway *)
  let connector = Rpc_over_http_client.rpc_client_connector gw in
  (* connector: This is a normal RPC connector. It is connected with the
   * gateway, and not directly with the server.
   *)
  let client = Sample_clnt.P.V1.create_client ~esys connector Rpc.Tcp in
  (* client: This is the RPC client. *)

  (* Rpc_client.verbose true; *)
  (* Rpc_over_http_client.verbose true; *)

  (* Register an RPC call: let n' = n + 1.
   * When the call is replied, the function [response] is called.
   *)
  let _ = Sample_clnt.P.V1.plus1'async client n (response gw) in

  (* Now do the registered call: *)
  Unixqueue.run esys
;;


main();
exit 0
;;
